<?php
/**
 * The action module English file of ZenTaoPMS.
 *
 * @copyright   Copyright 2009-2023 禅道软件（青岛）有限公司(ZenTao Software (Qingdao) Co., Ltd. www.cnezsoft.com)
 * @license     ZPL(http://zpl.pub/page/zplv12.html) or AGPL(https://www.gnu.org/licenses/agpl-3.0.en.html)
 * @author      Chunsheng Wang <chunsheng@cnezsoft.com>
 * @package     action
 * @version     $Id: en.php 4729 2013-05-03 07:53:55Z chencongzhi520@gmail.com $
 * @link        https://www.zentao.net
 */
global $config;

$lang->action->common        = 'Log';
$lang->action->id            = 'ID';
$lang->action->product       = $lang->productCommon;
$lang->action->project       = $lang->projectCommon;
$lang->action->execution     = $lang->execution->common;
$lang->action->objectType    = "Type d'objet";
$lang->action->objectID      = 'ID';
$lang->action->objectName    = "Nom de l'object";
$lang->action->actor         = 'User';
$lang->action->action        = 'Action';
$lang->action->actionID      = 'Action ID';
$lang->action->date          = 'Date';
$lang->action->dateAB        = 'Action Date';
$lang->action->extra         = 'Extra';
$lang->action->system        = 'System';
$lang->action->url           = 'URL';
$lang->action->contentType   = 'Content Type';
$lang->action->data          = 'Data';
$lang->action->result        = 'Result';
$lang->action->modified      = 'Modified';
$lang->action->old           = 'Old';
$lang->action->new           = 'New';
$lang->action->to            = 'To';
$lang->action->superReviewer = 'Super Reviewer';
$lang->action->byRule        = '(Triggered by Rule %s)';

$lang->action->trash         = 'Corbeille';
$lang->action->undelete      = 'Restaurer';
$lang->action->hideOne       = 'Masquer';
$lang->action->hideAll       = 'Masquer Tout';
$lang->action->editComment   = 'Editer commentaire';
$lang->action->create        = 'Ajouter commentaire';
$lang->action->comment       = 'Commentaire';
$lang->action->actioncomment = 'Commentaire';
$lang->action->lastComment   = 'Commentaire';
$lang->action->byQuery       = 'Search';
$lang->action->noLimit       = 'No Limit';

$lang->action->trashAction    = 'Recycle List';
$lang->action->undeleteAction = 'Reset Data';
$lang->action->hideOneAction  = 'Hide Data';

$lang->action->refusecase   = 'Before restoring the use case, please restore the scene to which the use case belongs';
$lang->action->refusescene  = 'Before restoring the scene, please restore the parent scene of this scene ';
$lang->action->refusemodule = 'Before restoring the module, please restore the parent module of this module ';
$lang->action->refusekanban = 'Before restoring the Kanban board, make sure to restore the space it belongs to';

$lang->action->trashTips          = 'Note: Les suppressions dans ZenTao sont purement logiques.';
$lang->action->textDiff           = 'Text Format';
$lang->action->original           = 'Original Format';
$lang->action->confirmHideAll     = 'Voulez-vous masquer tous les enregistrements ?';
$lang->action->needEdit           = '%s que vous voulez restaurer. SVP éditez la.';
$lang->action->historyEdit        = "l'historique Edité Par ne peut pas être vide.";
$lang->action->noDynamic          = "Pas d'historique.";
$lang->action->undeletedTips      = 'This data did not participate in the merging process during the version upgrade process, so restore is not supported.';
$lang->action->executionNoProject = "The execution does not belong to a {$lang->projectCommon},please restore the {$lang->projectCommon} first";
$lang->action->repoNoServer       = 'The repo does not belong to a server,please restore the server first';
$lang->action->hasCreatedTask     = 'Tasks have been created in this parent phase and cannot be restored!';
$lang->action->hasDeletedParent   = 'Restoring this phase requires restoring the deleted parent phase %s at the same time.';
$lang->action->hasChangedAttr     = "After recovery, the phase type will be adjusted to '%s' according to the parent phase type.";
$lang->action->whetherToRestore   = 'Confirm to restore?';
$lang->action->undeleteModuleTip  = 'Once the subdirectory has been restored, its parent directory will also be automatically recovered and synchronized, would you like to proceed with restoring the directory?';
$lang->action->undeleteTaskTip    = 'The execution associated with this task has been removed. If you choose to restore it, the task will no longer be visible. Would you like to proceed with restoring the task?';
$lang->action->undeleteBoardTip   = 'Before restoring the board, please restore its affiliated space first.';

$lang->action->hasOtherType = array();
$lang->action->hasOtherType['stage']  = "Only subtypes of {$lang->executionCommon} / Kanban types can be created at this parent stage, so the current stage cannot be restored.";
$lang->action->hasOtherType['sprint'] = "Only subtypes of Stage types can be created at this parent stage, so the current {$lang->executionCommon} cannot be restored.";
$lang->action->hasOtherType['kanban'] = "Only subtypes of Stage types can be created at this parent stage, so the current Kanban cannot be restored.";

$lang->action->repeatChange     = '%s with the same name and code already exists in the system, After recovery, the name are \"%s\",the code are \"%s\".';
$lang->action->nameRepeatChange = '%s with the same name already exists in the system, After recovery, the name are \"%s\".';
$lang->action->codeRepeatChange = '%s with the same code already exists in the system, After recovery, the code are \"%s\".';

$lang->action->history = new stdclass();
$lang->action->history->action = 'Lien';
$lang->action->history->field  = 'Champ';
$lang->action->history->old    = 'Ancienne valeur';
$lang->action->history->new    = 'Nouvelle valeur';
$lang->action->history->diff   = 'Comparer';

$lang->action->dynamic = new stdclass();
$lang->action->dynamic->today      = "Aujourd'hui";
$lang->action->dynamic->yesterday  = 'Hier';
$lang->action->dynamic->twoDaysAgo = 'Il y a 2 jours';
$lang->action->dynamic->thisWeek   = 'Cette semaine';
$lang->action->dynamic->lastWeek   = 'La semaine dernière';
$lang->action->dynamic->thisMonth  = 'Ce mois';
$lang->action->dynamic->lastMonth  = 'Le mois dernier';
$lang->action->dynamic->all        = 'Tout';
$lang->action->dynamic->hidden     = 'Caché';
$lang->action->dynamic->search     = 'Rechercher';

$lang->action->objectTypes['product']          = $lang->productCommon;
$lang->action->objectTypes['branch']           = 'Branche';
$lang->action->objectTypes['epic']             = $lang->ERCommon;
$lang->action->objectTypes['story']            = $lang->SRCommon;
$lang->action->objectTypes['requirement']      = $lang->URCommon;
$lang->action->objectTypes['design']           = 'Design';
$lang->action->objectTypes['productplan']      = 'Plan';
$lang->action->objectTypes['release']          = 'Release';
$lang->action->objectTypes['program']          = 'Program';
$lang->action->objectTypes['project']          = $lang->projectCommon;
$lang->action->objectTypes['execution']        = $lang->executionCommon;
$lang->action->objectTypes['task']             = 'Tâche';
$lang->action->objectTypes['build']            = 'Build';
$lang->action->objectTypes['projectbuild']     = 'Project Build';
$lang->action->objectTypes['job']              = 'Pipeline';
$lang->action->objectTypes['bug']              = 'Bug';
$lang->action->objectTypes['case']             = 'CasTest';
$lang->action->objectTypes['caseresult']       = 'CasTest Result';
$lang->action->objectTypes['stepresult']       = 'CasTest Steps';
$lang->action->objectTypes['caselib']          = 'Library';
$lang->action->objectTypes['testsuite']        = 'Cahier recette';
$lang->action->objectTypes['testtask']         = 'Recette';
$lang->action->objectTypes['testreport']       = 'Edition';
$lang->action->objectTypes['zahost']           = 'Host';
$lang->action->objectTypes['zanode']           = 'ZA Node';
$lang->action->objectTypes['doc']              = 'Document';
$lang->action->objectTypes['api']              = 'Interface';
$lang->action->objectTypes['doclib']           = 'Répertoire Documents';
$lang->action->objectTypes['docspace']         = 'Répertoire Space';
$lang->action->objectTypes['apistruct']        = 'API struct';
$lang->action->objectTypes['todo']             = 'Todo';
$lang->action->objectTypes['risk']             = 'Risk';
$lang->action->objectTypes['issue']            = 'Issue';
$lang->action->objectTypes['module']           = 'Module';
$lang->action->objectTypes['user']             = 'Utilisateur';
$lang->action->objectTypes['stakeholder']      = 'Stakeholder';
$lang->action->objectTypes['budget']           = 'Cost Estimate';
$lang->action->objectTypes['entry']            = 'Entrée';
$lang->action->objectTypes['webhook']          = 'Webhook';
$lang->action->objectTypes['team']             = 'Team';
$lang->action->objectTypes['whitelist']        = 'Whitelist';
$lang->action->objectTypes['pipeline']         = 'GitLib';
$lang->action->objectTypes['gitlab']           = 'GitLab Server';
$lang->action->objectTypes['gitea']            = 'Gitea Server';
$lang->action->objectTypes['gogs']             = 'Gogs Server';
$lang->action->objectTypes['jenkins']          = 'Jenkins';
$lang->action->objectTypes['nexus']            = 'Nexus';
$lang->action->objectTypes['mr']               = 'Merge Requests';
$lang->action->objectTypes['gitlabproject']    = 'GitLab Project';
$lang->action->objectTypes['gitlabuser']       = 'GitLab User';
$lang->action->objectTypes['gitlabgroup']      = 'GitLab Group';
$lang->action->objectTypes['gitlabbranch']     = 'GitLab Branch';
$lang->action->objectTypes['gitlabbranchpriv'] = 'GitLab Protected Branches';
$lang->action->objectTypes['gitlabtag']        = 'GitLab Tag';
$lang->action->objectTypes['gitlabtagpriv']    = 'GitLab Tag Protected';
$lang->action->objectTypes['giteauser']        = 'Gitea User';
$lang->action->objectTypes['gogsuser']         = 'Gogs User';
$lang->action->objectTypes['kanbanspace']      = 'Kanban Space';
$lang->action->objectTypes['kanban']           = 'Kanban';
$lang->action->objectTypes['kanbanregion']     = 'Kanban Region';
$lang->action->objectTypes['kanbanlane']       = 'Kanban Lane';
$lang->action->objectTypes['kanbancolumn']     = 'Kanban Column';
$lang->action->objectTypes['kanbancard']       = 'Kanban Card';
$lang->action->objectTypes['sonarqube']        = 'SonarQube Server';
$lang->action->objectTypes['sonarqubeproject'] = 'SonarQube Project';
$lang->action->objectTypes['stage']            = 'Stage';
$lang->action->objectTypes['patch']            = 'Patch';
$lang->action->objectTypes['repo']             = 'Repo';
$lang->action->objectTypes['dataview']         = 'Data View';
$lang->action->objectTypes['privlang']         = 'Priv';
$lang->action->objectTypes['scene']            = 'Scene';
$lang->action->objectTypes['pivot']            = 'Pivot';
$lang->action->objectTypes['privpackage']      = 'Priv Package';
$lang->action->objectTypes['serverroom']       = 'IDC';
$lang->action->objectTypes['account']          = 'Account';
$lang->action->objectTypes['host']             = 'Host';
$lang->action->objectTypes['deploy']           = 'Deploy';
$lang->action->objectTypes['service']          = 'Service';
$lang->action->objectTypes['domain']           = 'Domain';
$lang->action->objectTypes['prompt']           = 'Prompt';
$lang->action->objectTypes['miniprogram']      = 'Mini Program';
$lang->action->objectTypes['metric']           = 'Metric';
$lang->action->objectTypes['projectbuild']     = 'Build';
$lang->action->objectTypes['board']            = 'Board';
$lang->action->objectTypes['boardspace']       = 'Board Space';
$lang->action->objectTypes['productline']      = 'Product Line';
$lang->action->objectTypes['system']           = $lang->product->system;

/* Used to describe operation history. */
$lang->action->desc = new stdclass();
$lang->action->desc->common               = '$date, <strong>$action</strong> par <strong>$actor</strong>.' . "\n";
$lang->action->desc->extra                = '$date, <strong>$action</strong> en tant que <strong>$extra</strong> par <strong>$actor</strong>.' . "\n";
$lang->action->desc->opened               = '$date, initié par <strong>$actor</strong> .' . "\n";
$lang->action->desc->openedbysystem       = '$date, opened by system.' . "\n";
$lang->action->desc->created              = '$date, créé par <strong>$actor</strong> .' . "\n";
$lang->action->desc->added                = '$date, ajouter par  <strong>$actor</strong> .' . "\n";
$lang->action->desc->changed              = '$date, modifié par <strong>$actor</strong> .' . "\n";
$lang->action->desc->edited               = '$date, édité par <strong>$actor</strong> .' . "\n";
$lang->action->desc->assigned             = '$date, <strong>$actor</strong> affecté à <strong>$extra</strong>.' . "\n";
$lang->action->desc->closed               = '$date, fermé par <strong>$actor</strong> .' . "\n";
$lang->action->desc->closedbysystem       = '$date, closed by system.' . "\n";
$lang->action->desc->closedbyparent       = '$date, closed by system.' . "\n";
$lang->action->desc->deleted              = '$date, supprimé par <strong>$actor</strong> .' . "\n";
$lang->action->desc->deletedfile          = '$date, <strong>$actor</strong> a supprimé <strong><i>$extra</i></strong>.' . "\n";
$lang->action->desc->editfile             = '$date, <strong>$actor</strong> a édité <strong><i>$extra</i></strong>.' . "\n";
$lang->action->desc->erased               = '$date, supprimé par <strong>$actor</strong> .' . "\n";
$lang->action->desc->undeleted            = '$date, restauré par <strong>$actor</strong> .' . "\n";
$lang->action->desc->hidden               = '$date, masqué par <strong>$actor</strong> .' . "\n";
$lang->action->desc->commented            = '$date, ajouté par <strong>$actor</strong>.' . "\n";
$lang->action->desc->activated            = '$date, activé par <strong>$actor</strong> .' . "\n";
$lang->action->desc->blocked              = '$date, bloqué par <strong>$actor</strong> .' . "\n";
$lang->action->desc->moved                = '$date, déplacé par <strong>$actor</strong> , qui était "$extra".' . "\n";
$lang->action->desc->confirmed            = '$date, <strong>$actor</strong> a confirmé la modification de la story. Le dernier build est <strong>#$extra</strong>.' . "\n";
$lang->action->desc->caseconfirmed        = '$date, <strong>$actor</strong> a confirmé la modification du CasTest. Le dernier build est <strong>#$extra</strong>' . "\n";
$lang->action->desc->bugconfirmed         = '$date, <strong>$actor</strong> a confirmé le Bug.' . "\n";
$lang->action->desc->frombug              = '$date, converti par <strong>$actor</strong>. Son ID était <strong>$extra</strong>.';
$lang->action->desc->started              = '$date, commencé par <strong>$actor</strong>.' . "\n";
$lang->action->desc->restarted            = '$date, reprise par <strong>$actor</strong>.' . "\n";
$lang->action->desc->delayed              = '$date, ajourné par <strong>$actor</strong>.' . "\n";
$lang->action->desc->suspended            = '$date, suspendu par <strong>$actor</strong>.' . "\n";
$lang->action->desc->recordworkhour       = '$date, enregistré par <strong>$actor</strong> et son coût est de <strong>$extra</strong> heures.';
$lang->action->desc->recordestimate       = '$date, enregistré par <strong>$actor</strong> et son coût est de <strong>$extra</strong> heures.';
$lang->action->desc->editestimate         = '$date, <strong>$actor</strong> a édité son temps estimé.';
$lang->action->desc->editeffort           = '$date, <strong>$actor</strong> a édité son temps estimé.';
$lang->action->desc->deleteestimate       = '$date, <strong>$actor</strong> a supprimé son estimation de temps.';
$lang->action->desc->canceled             = '$date, annulé par <strong>$actor</strong>.' . "\n";
$lang->action->desc->svncommited          = '$date, <strong>$actor</strong> a validé, le build est <strong>#$extra</strong>.' . "\n";
$lang->action->desc->gitcommited          = '$date, <strong>$actor</strong> a validé, le build est <strong>#$extra</strong>.' . "\n";
$lang->action->desc->finished             = '$date, terminé par <strong>$actor</strong>.' . "\n";
$lang->action->desc->paused               = '$date, mis en pause par <strong>$actor</strong>.' . "\n";
$lang->action->desc->verified             = '$date, verifié par <strong>$actor</strong>.' . "\n";
$lang->action->desc->diff1                = '<strong><i>%s</i></strong> a changé. Il est passé de "%s" à "%s".<br />' . "\n";
$lang->action->desc->diff2                = '<strong><i>%s</i></strong> a changé. La différence est ' . "\n" . "<blockquote class='textdiff'>%s</blockquote>" . "\n<blockquote class='original'>%s</blockquote>";
$lang->action->desc->diff3                = 'Le nom du fichier %s a changé pour %s .' . "\n";
$lang->action->desc->addDiff              = 'Added <strong><i>%s</i></strong>"%s"。' . "\n";
$lang->action->desc->removeDiff           = 'Removed <strong><i>%s</i></strong>"%s"。' . "\n";
$lang->action->desc->linked2bug           = '$date, affecté à <strong>$extra</strong> par <strong>$actor</strong>';
$lang->action->desc->linked2testtask      = '$date, linked to <strong>$extra</strong> by <strong>$actor</strong>';
$lang->action->desc->unlinkedfromtesttask = '$date, unlinked from <strong>$extra</strong> by <strong>$actor</strong>';
$lang->action->desc->resolved             = '$date, resolved by <strong>$actor</strong> ' . "\n";
$lang->action->desc->managed              = '$date, managed by <strong>$actor</strong>.' . "\n";
$lang->action->desc->estimated            = '$date, estimated by <strong>$actor</strong>.' . "\n";
$lang->action->desc->run                  = '$date, executed by <strong>$actor</strong>.' . "\n";
$lang->action->desc->runresult            = '$date, executed by <strong>$actor</strong>%s, the results is <span class="status-%s font-bold">%s</span>.' . "\n";
$lang->action->desc->syncprogram          = '$date, started by <strong>$actor</strong>(starting the project sets the program status as Ongoing).' . "\n";
$lang->action->desc->syncproject          = '$date, starting the execution sets the ' . $lang->projectCommon . ' status as Ongoing.' . "\n";
$lang->action->desc->syncmultipleproject  = '$date, starting the task sets the ' . $lang->projectCommon . ' status as Ongoing.' . "\n";
$lang->action->desc->syncexecution        = '$date, starting the task sets the execution status as Ongoing.' . "\n";
$lang->action->desc->syncexecutionbychild = '$date, starting the sub stage sets the execution status as Ongoing.' . "\n";
$lang->action->desc->importfromgitlab     = '$date, Issue associate created from gitlab by <strong>$actor</strong>.' . "\n";
$lang->action->desc->archived             = '$date, archived by <strong>$actor</strong>.' . "\n";
$lang->action->desc->restore              = '$date, restore by <strong>$actor</strong>.' . "\n";
$lang->action->desc->importedcard         = '$date, imported to <strong>$extra</strong> by <strong>$actor</strong>.' . "\n";
$lang->action->desc->importedproductplan  = '$date, imported to <strong>$extra</strong> by <strong>$actor</strong>.' . "\n";
$lang->action->desc->importedrelease      = '$date, imported to <strong>$extra</strong> by <strong>$actor</strong>.' . "\n";
$lang->action->desc->importedexecution    = '$date, imported to <strong>$extra</strong> by <strong>$actor</strong>.' . "\n";
$lang->action->desc->importedbuild        = '$date, imported to <strong>$extra</strong> by <strong>$actor</strong>.' . "\n";
$lang->action->desc->importedticket       = '$date, imported to <strong>$extra</strong> by <strong>$actor</strong>.' . "\n";
$lang->action->desc->fromsonarqube        = '$date, created by <strong>$actor</strong> from <strong>SonarQube Issue</strong>.' . "\n";
$lang->action->desc->tolib                = '$date, Importé par <strong>$actor</strong> .' . "\n";
$lang->action->desc->updatetolib          = '$date, MàJ de ' . $lang->testcase->common . ' par  <strong>$actor</strong>.' . "\n";
$lang->action->desc->adjusttasktowait     = '$date, System Reminder: The task status will be set to Not Started as the consumed work hour is adjusted to 0. ' . "\n";
$lang->action->desc->reopen               = '$date, reopened by <strong>$actor</strong> .' . "\n";
$lang->action->desc->merged               = '$date, merged by <strong>$actor</strong> .' . "\n";
$lang->action->desc->submitreview         = '$date, submitted for review by <strong>$actor</strong>.' . "\n";
$lang->action->desc->ganttmove            = '$date, sort by <strong>$actor</strong> .' . "\n";
$lang->action->desc->suspend              = '$date, the ZenAgent Node is suspended by <strong>$actor</strong> .' . "\n";
$lang->action->desc->resume               = '$date, the ZenAgent Node is resumed by <strong>$actor</strong> .' . "\n";
$lang->action->desc->reboot               = '$date, the ZenAgent Node is reboot by <strong>$actor</strong> .' . "\n";
$lang->action->desc->destroy              = '$date, the ZenAgent Node is destroyed by <strong>$actor</strong> .' . "\n";
$lang->action->desc->boot                 = '$date, the ZenAgent Node is boot by <strong>$actor</strong> .' . "\n";
$lang->action->desc->relieved             = '$date, relieved by <strong>$actor</strong> .' . "\n";
$lang->action->desc->switchtolight        = '$date, Switch from ALM mode to light mode by <strong>'. $lang->admin->system .'</strong>.' . "\n";
$lang->action->desc->getvnc               = '$date, Remote control <strong>$extra</strong> by <strong>$actor</strong> .' . "\n";
$lang->action->desc->unlinkproduct        = '$date, the ' . $lang->projectCommon . ' is disassociated from the $extra, synchronization disassociates the ' . $lang->executionCommon . 's of the ' . $lang->projectCommon . ' from the $extra.' . "\n";
$lang->action->desc->createdsnapshot      = '$date, <strong>$actor</strong> creates a snapshot <strong>$extra</strong>。' . "\n";
$lang->action->desc->restoredsnapshot     = '$date, <strong>$actor</strong> restored a snapshot <strong>$extra</strong>。' . "\n";
$lang->action->desc->editsnapshot         = '$date, <strong>$actor</strong> edited the snapshot <strong>$extra</strong>。' . "\n";
$lang->action->desc->deletesnapshot       = '$date, <strong>$actor</strong> deleted snapshot <strong>$extra</strong>。' . "\n";
$lang->action->desc->online               = '$date, set online by <strong>$actor</strong> .' . "\n";
$lang->action->desc->offline              = '$date, set offline by <strong>$actor</strong> .' . "\n";
$lang->action->desc->linkhost             = '$date, the host is linked by <strong>$actor</strong> .' . "\n";
$lang->action->desc->createrepobranch     = '$date, <strong>$actor</strong> created code branch <strong>$extra</strong>.' . "\n";
$lang->action->desc->unlinkrepobranch     = '$date, <strong>$actor</strong> unlinked code branch <strong>$extra</strong>.' . "\n";
$lang->action->desc->changedprogram       = '$date, <strong>$actor</strong> adjust the program <strong>$extra</strong>.' . "\n";
$lang->action->desc->managedteam          = '$date, by <strong>$actor</strong> managed team.' . "\n";
$lang->action->desc->syncexecutionteam    = '$date, synchronise members when execution adds members.' . "\n";
$lang->action->desc->syncprojectteam      = '$date, synchronise members when project removes members' . "\n";
$lang->action->desc->syncbycase           = '$date, running the testcase sets the request status as Doing.' . "\n";

/* Used to describe the history of operations related to parent-child tasks. */
$lang->action->desc->createchildren        = '$date, <strong>$actor</strong> a créé un sous-tâche <strong>$extra</strong>。' . "\n";
$lang->action->desc->linkchildtask         = '$date, <strong>$actor</strong> a raccroché une sous-tâche <strong>$extra</strong>。' . "\n";
$lang->action->desc->unlinkchildrentask    = '$date, <strong>$actor</strong> a décroché une sous-tâche <strong>$extra</strong>。' . "\n";
$lang->action->desc->linkparenttask        = '$date, <strong>$actor</strong> a accroché une tâche parent <strong>$extra</strong>。' . "\n";
$lang->action->desc->unlinkparenttask      = '$date, <strong>$actor</strong> a décroché une tâche parent <strong>$extra</strong>。' . "\n";
$lang->action->desc->deletechildrentask    = '$date, <strong>$actor</strong> a supprimé une sous-tâche <strong>$extra</strong>。' . "\n";
$lang->action->desc->syncstorybyparenttask = "\$date, as the parent task updates its {$lang->SRCommon}, the child tasks are updated simultaneously.\n";

/* Used to describe the history of operations related to parent-child requirements. */
$lang->action->desc->createchildrenstory = '$date, <strong>$actor</strong> a créé une sous-tory <strong>$extra</strong>。' . "\n";
$lang->action->desc->linkchildstory      = '$date, <strong>$actor</strong> a raccroché une sous-story <strong>$extra</strong>。' . "\n";
$lang->action->desc->unlinkchildrenstory = '$date, <strong>$actor</strong> a décroché une sous-story <strong>$extra</strong>。' . "\n";
$lang->action->desc->linkparentstory     = '$date, <strong>$actor</strong> a raccroché à une story parent <strong>$extra</strong>。' . "\n";
$lang->action->desc->unlinkparentstory   = '$date, <strong>$actor</strong> a décroché de la story parent <strong>$extra</strong>。' . "\n";
$lang->action->desc->deletechildrenstory = '$date, <strong>$actor</strong> a supprimé une sous-story <strong>$extra</strong>。' . "\n";

/* Historical record of actions when associating and removing cases. */
$lang->action->desc->linkrelatedcase   = '$date, <strong>$actor</strong> a fait le lien avec un CasTest <strong>$extra</strong>.' . "\n";
$lang->action->desc->unlinkrelatedcase = '$date, <strong>$actor</strong> a délié le CasTest <strong>$extra</strong>.' . "\n";

/* Used to describe the history of operations link story and bug to productplan. */
$lang->action->desc->linkstory   = '$date, <strong>$actor</strong> link stories <strong>$extra</strong>.' . "\n";
$lang->action->desc->linkbug     = '$date, <strong>$actor</strong> link bugs <strong>$extra</strong>.' . "\n";
$lang->action->desc->unlinkstory = '$date, <strong>$actor</strong> remove stories <strong>$extra</strong> from plan.' . "\n";
$lang->action->desc->unlinkbug   = '$date, <strong>$actor</strong> remove bugs <strong>$extra</strong> from plan.' . "\n";

/* Describes the history of operations when a document is saved as a draft or released. */
$lang->action->desc->saveddraft  = '$date, <strong>$actor</strong> save draft <strong>$extra</strong>.' . "\n";
$lang->action->desc->releaseddoc = '$date, <strong>$actor</strong> released <strong>$extra</strong>.' . "\n";

/* Describe the operation records of document conversion.。*/
$lang->action->desc->convertdoc = '$date, <strong>$actor</strong> complete document conversion <strong>$extra</strong>.' . "\n";

/* This parameter describes historical operations that are performed when a document is collected or uncollected. */
$lang->action->desc->collected   = '$date, <strong>$actor</strong> collected <strong>$extra</strong>.' . "\n";
$lang->action->desc->uncollected = '$date, <strong>$actor</strong> uncollected <strong>$extra</strong>.' . "\n";

/* AI prompts related actions. */
$lang->action->desc->published   = '$date, published by <strong>$actor</strong>.' . "\n";
$lang->action->desc->unpublished = '$date, unpublished by <strong>$actor</strong>.' . "\n";

/* 用来描述应用的历史操作记录。*/
$lang->action->desc->install                 = '$date, installed by <strong>$actor</strong>.' . "\n";
$lang->action->desc->uninstall               = '$date, uninstalled by <strong>$actor</strong>.' . "\n";
$lang->action->desc->start                   = '$date, started by <strong>$actor</strong>.' . "\n";
$lang->action->desc->stop                    = '$date, closed by <strong>$actor</strong>.' . "\n";
$lang->action->desc->editname                = '$date, updated from <strong>$oldname</strong> to <strong>$newName</strong> by <strong>$actor</strong>.' . "\n";
$lang->action->desc->upgrade                 = '$date, upgraded from <strong>$oldVersion</strong> to <strong>$newVersion</strong> by <strong>$actor</strong>.' . "\n";
$lang->action->desc->backup                  = '$date, backuped by <strong>$actor</strong>.' . "\n";
$lang->action->desc->adjustmemory            = '$date, resized to <strong>$newValue</strong> memory by <strong>$actor</strong>.' . "\n";
$lang->action->desc->adjustcpu               = '$date, resized to <strong>$newValue</strong> CPU by <strong>$actor</strong>.' . "\n";
$lang->action->desc->adjustvol               = '$date, resized to <strong>$newValue</strong> GB disk space by <strong>$actor</strong>.' . "\n";
$lang->action->desc->adjustmemorychange      = '$date, modify the memory from <strong>$oldValue</strong> to <strong>$newValue</strong> by <strong>$actor</strong>.' . "\n";
$lang->action->desc->adjustcpuchange         = '$date, modify CPU from <strong>$oldValue</strong>-core to <strong>$newValue</strong>-core by <strong>$actor</strong>.' . "\n";
$lang->action->desc->adjustvolchange         = '$date, modify this disk space from <strong>oldValue</strong>GB to <strong>newValue</strong>GB。' . "\n";
$lang->action->desc->enableldap              = '$date, enabled by <strong>$actor</strong> of LDAP。' . "\n";
$lang->action->desc->disableldap             = '$date, disabled by <strong>$actor</strong> of LDAP。' . "\n";
$lang->action->desc->enablesmtp              = '$date, enabled by <strong>$actor</strong> of SMTP。' . "\n";
$lang->action->desc->disablesmtp             = '$date, disabled by <strong>$actor</strong> of SMTP。' . "\n";
$lang->action->desc->updatecustom            = '$date, updated by <strong>$actor</strong> of custom settings.' . "\n";

$lang->action->desc->delist  = '$date, delist by <strong>$actor</strong>.' . "\n";
$lang->action->desc->publish = '$date, publish by <strong>$actor</strong>.' . "\n";

$lang->action->desc->manualbackup        = '$date, Manually backed up by <strong>$actor</strong>.' . "\n";
$lang->action->desc->autobackup          = '$date, Automatic backup by <strong>$actor</strong>.' . "\n";
$lang->action->desc->openautobackup      = '$date, Enable automatic backup by <strong>$actor</strong>.' . "\n";
$lang->action->desc->closeautobackup     = '$date, Disable automatic backup by <strong>$actor</strong>.' . "\n";
$lang->action->desc->autodeletebackups   = '$date, Automatically clean up backups by <strong>$actor</strong>.' . "\n";
$lang->action->desc->savebackupsettings  = '$date, Save backup settings backups by <strong>$actor</strong>.' . "\n";
$lang->action->desc->deleteexpiredbackup = '$date, Clean up expired backups by <strong>$actor</strong>.' . "\n";
$lang->action->desc->manualdeletebackup  = '$date, Manually clean up backup by <strong>$actor</strong>.' . "\n";

/* Used to display dynamic information. */
$lang->action->label = new stdclass();
$lang->action->label->install                 = 'install ';
$lang->action->label->uninstall               = 'uninstall ';
$lang->action->label->upgrade                 = 'upgrade ';
$lang->action->label->start                   = 'start ';
$lang->action->label->stop                    = 'stop ';
$lang->action->label->editname                = 'edit name ';
$lang->action->label->backup                  = 'backup ';
$lang->action->label->adjustmemory            = 'adjust memory ';
$lang->action->label->adjustcpu               = 'adjust CPU';
$lang->action->label->adjustVol               = 'adjust volume';
$lang->action->label->enableldap              = 'enable LDAP ';
$lang->action->label->disableldap             = 'disable LDAP ';
$lang->action->label->enablesmtp              = 'enable SMTP ';
$lang->action->label->disablesmtp             = 'disable SMTP ';
$lang->action->label->revert                  = 'revert ';
$lang->action->label->created                 = 'a créé ';
$lang->action->label->opened                  = 'a ouvert ';
$lang->action->label->openedbysystem          = 'Opened by system ';
$lang->action->label->closedbysystem          = 'Closed by system ';
$lang->action->label->added                   = 'ajouter';
$lang->action->label->changed                 = 'a changé ';
$lang->action->label->edited                  = 'a édité ';
$lang->action->label->assigned                = 'a affecté ';
$lang->action->label->closed                  = 'a fermé ';
$lang->action->label->deleted                 = 'a supprimé ';
$lang->action->label->deletedfile             = 'a supprimé ';
$lang->action->label->editfile                = 'a édité ';
$lang->action->label->erased                  = 'a détruit ';
$lang->action->label->undeleted               = 'a restauré ';
$lang->action->label->hidden                  = 'a masqué ';
$lang->action->label->commented               = 'a commenté ';
$lang->action->label->communicated            = 'communicated';
$lang->action->label->activated               = 'a activé ';
$lang->action->label->blocked                 = 'a bloqué ';
$lang->action->label->resolved                = 'a résolu ';
$lang->action->label->reviewed                = 'a revu ';
$lang->action->label->recalled                = 'recalled';
$lang->action->label->recalledchange          = 'undo changes';
$lang->action->label->moved                   = 'a déplacé ';
$lang->action->label->confirmed               = 'a confirmé Story ';
$lang->action->label->bugconfirmed            = 'a confirmé le Bug ';
$lang->action->label->tostory                 = 'a converti en Story ';
$lang->action->label->frombug                 = 'a converti du Bug ';
$lang->action->label->fromlib                 = 'a importé de la Library ';
$lang->action->label->totask                  = 'a converti en Tâche ';
$lang->action->label->converttotask           = 'converted to Task ';
$lang->action->label->svncommited             = 'a committé SVN ';
$lang->action->label->gitcommited             = 'a committé GIT ';
$lang->action->label->linked2plan             = 'a raccordé au Plan ';
$lang->action->label->unlinkedfromplan        = 'a extrait du plan ';
$lang->action->label->changestatus            = 'a changé le statut ';
$lang->action->label->marked                  = 'a marqué';
$lang->action->label->linked2execution        = "a ajouté à {$lang->executionCommon}";
$lang->action->label->unlinkedfromexecution   = "a enlevé de {$lang->executionCommon}";
$lang->action->label->linked2kanban           = 'linked to kanban';
$lang->action->label->linked2project          = "linked to {$lang->projectCommon}";
$lang->action->label->unlinkedfromproject     = "unlinked from {$lang->projectCommon}";
$lang->action->label->unlinkedfrombuild       = "a enlevé du Build ";
$lang->action->label->linked2release          = "a ajouté à une Release ";
$lang->action->label->unlinkedfromrelease     = "a enlevé de la Release ";
$lang->action->label->linked2revision         = "Link Revision";
$lang->action->label->unlinkedfromrevision    = "Unlink Revision";
$lang->action->label->linkrelatedbug          = "a lié à un Bug ";
$lang->action->label->unlinkrelatedbug        = "a délié du Bug ";
$lang->action->label->linkrelatedcase         = "a mis en relation avec un CasTest ";
$lang->action->label->unlinkrelatedcase       = "a libéré du CasTest ";
$lang->action->label->linkrelatedstory        = "a lié à une Story ";
$lang->action->label->unlinkrelatedstory      = "a dégagé de la Story ";
$lang->action->label->subdividestory          = "a décomposé la Story ";
$lang->action->label->unlinkchildstory        = "a dissocié de la Story fille ";
$lang->action->label->started                 = 'a commencé ';
$lang->action->label->restarted               = 'a continué ';
$lang->action->label->recordworkhour          = 'a estimé ';
$lang->action->label->recordestimate          = 'a estimé ';
$lang->action->label->editestimate            = 'a réestimé ';
$lang->action->label->editeffort              = 'a réestimé ';
$lang->action->label->canceled                = 'a annulé ';
$lang->action->label->finished                = 'a fini ';
$lang->action->label->paused                  = 'a stoppé ';
$lang->action->label->verified                = 'a vérifié ';
$lang->action->label->delayed                 = 'a ajourné ';
$lang->action->label->suspended               = 'a suspendu ';
$lang->action->label->login                   = "s'est Connecté";
$lang->action->label->logout                  = "s'est Déconnecté";
$lang->action->label->notified                = "Notified";
$lang->action->label->deleteestimate          = "a remis à zéro ";
$lang->action->label->linked2build            = "a ajouté au Build ";
$lang->action->label->linked2bug              = "a lié au Bug ";
$lang->action->label->linked2testtask         = "linked";
$lang->action->label->unlinkedfromtesttask    = "unlinked";
$lang->action->label->linkchildtask           = "a raccroché à une sous-tâche";
$lang->action->label->unlinkchildrentask      = "a décroché la sous-tâche";
$lang->action->label->linkparenttask          = "a raccroché à une tâche parent";
$lang->action->label->unlinkparenttask        = "a décroché de la tâche parent";
$lang->action->label->batchcreate             = "a créé tâches par lot";
$lang->action->label->createchildren          = "a créé sous-tâches par lot";
$lang->action->label->managed                 = "a managé";
$lang->action->label->managedteam             = "managed";
$lang->action->label->managedwhitelist        = "managed";
$lang->action->label->deletechildrentask      = "a supprimé une sous-tâche";
$lang->action->label->createchildrenstory     = "a créé une sous-story";
$lang->action->label->linkchildstory          = "a raccroché à une sous-story";
$lang->action->label->unlinkchildrenstory     = "a décroché de la sous-story";
$lang->action->label->linkparentstory         = "a raccroché à une story parent";
$lang->action->label->unlinkparentstory       = "a décroché de la story parent";
$lang->action->label->deletechildrenstory     = "a supprimé la sous-story";
$lang->action->label->syncgrade               = 'synced grade';
$lang->action->label->tracked                 = 'tracked';
$lang->action->label->hangup                  = 'hangup';
$lang->action->label->run                     = 'run';
$lang->action->label->estimated               = 'estimated';
$lang->action->label->reviewpassed            = 'Pass';
$lang->action->label->reviewrejected          = 'Reject';
$lang->action->label->reviewclarified         = 'Clarify';
$lang->action->label->reviewreverted          = 'Revert';
$lang->action->label->commitsummary           = 'Commit Summary';
$lang->action->label->updatetrainee           = 'Update Trainee';
$lang->action->label->setdefaultbranch        = 'Set default branch';
$lang->action->label->syncprogram             = 'start';
$lang->action->label->syncproject             = 'start';
$lang->action->label->syncexecution           = 'start';
$lang->action->label->syncexecutionbychild    = 'start';
$lang->action->label->syncmultipleproject     = 'start';
$lang->action->label->startProgram            = '(The start of the project sets the status of the program as Ongoing)';
$lang->action->label->createmr                = 'Linked';
$lang->action->label->deletemr                = 'Unlinked';
$lang->action->label->mergedmr                = 'Merged';
$lang->action->label->compilepass             = 'Compile Success';
$lang->action->label->compilefail             = 'Compile Fail';
$lang->action->label->reopen                  = 'Reopen';
$lang->action->label->approve                 = 'Passed';
$lang->action->label->reject                  = 'Rejected';
$lang->action->label->importfromgitlab        = 'Issue associate created';
$lang->action->label->archived                = 'Archived';
$lang->action->label->restore                 = 'Restore';
$lang->action->label->mergedbranch            = 'Merge Branch';
$lang->action->label->startedbychild          = 'started';
$lang->action->label->finishedbychild         = 'finished';
$lang->action->label->closedbychild           = 'closed';
$lang->action->label->activatedbychild        = 'activated';
$lang->action->label->createchild             = 'activated';
$lang->action->label->executed                = 'executed';
$lang->action->label->importedcard            = 'imported';
$lang->action->label->importedproductplan     = 'imported';
$lang->action->label->importedrelease         = 'imported';
$lang->action->label->importedexecution       = 'imported';
$lang->action->label->importedbuild           = 'imported';
$lang->action->label->importedticket          = 'imported';
$lang->action->label->fromsonarqube           = 'created a bug from SonarQube Issue named:';
$lang->action->label->bind                    = 'bound';
$lang->action->label->unbind                  = 'unbound';
$lang->action->label->linkstory               = 'link stories to';
$lang->action->label->linkbug                 = 'link bugs to';
$lang->action->label->unlinkstory             = 'unlink stories from';
$lang->action->label->unlinkbug               = 'unlink bugs from';
$lang->action->label->tolib                   = 'Importé';
$lang->action->label->updatetolib             = 'MàJ';
$lang->action->label->ganttmove               = 'sorted';
$lang->action->label->submitreview            = 'submitted';
$lang->action->label->suspend                 = 'suspended';
$lang->action->label->resume                  = 'resumed';
$lang->action->label->reboot                  = 'reboot';
$lang->action->label->boot                    = 'boot';
$lang->action->label->destroy                 = 'destroyed';
$lang->action->label->getvnc                  = 'remote control';
$lang->action->label->synctwins               = 'synchronized changes';
$lang->action->label->closedbyparent          = 'synchronized closed';
$lang->action->label->relieved                = 'relieved';
$lang->action->label->switchtolight           = 'switch from ALM mode to light mode';
$lang->action->label->linkedrepo              = 'Linked Code Repo';
$lang->action->label->unlinkedrepo            = 'Unlinked Code Repo';
$lang->action->label->unlinkproduct           = "Unlinked {$lang->productCommon}";
$lang->action->label->createdsnapshot         = 'create snapshot';
$lang->action->label->restoredsnapshot        = 'create snapshot';
$lang->action->label->editsnapshot            = 'edit snapshot';
$lang->action->label->deletesnapshot          = 'deleted snapshot';
$lang->action->label->saveddraft              = 'save draft';
$lang->action->label->releaseddoc             = 'released';
$lang->action->label->convertdoc              = 'Convert doc';
$lang->action->label->collected               = 'collected';
$lang->action->label->uncollected             = 'uncollected';
$lang->action->label->online                  = 'online';
$lang->action->label->offline                 = 'offline';
$lang->action->label->linkhost                = 'link hosts to';
$lang->action->label->delist                  = 'delist';
$lang->action->label->createrepobranch        = 'Created branch from';
$lang->action->label->unlinkrepobranch        = 'Unlinked branch from';
$lang->action->label->communicate             = 'Communicate';
$lang->action->label->changedprogram          = 'Changed program';
$lang->action->label->published               = 'publié';
$lang->action->label->unpublished             = 'inédit';
$lang->action->label->aiassistant             = 'AI Assistant';
$lang->action->label->synced                  = 'synced';
$lang->action->label->imported                = 'imported';
$lang->action->label->createbackup            = 'Created system backup';
$lang->action->label->deletebackup            = 'Deleted system backup';
$lang->action->label->restorebackup           = 'Restored system backup';
$lang->action->label->upgradesystem           = 'Executed system upgrade';
$lang->action->label->system                  = $lang->product->system;
$lang->action->label->manualbackup            = 'Manual backup';
$lang->action->label->autobackup              = 'Automatic backup';
$lang->action->label->openautobackup          = 'Enable automatic backup';
$lang->action->label->closeautobackup         = 'Disable automatic backup';
$lang->action->label->autodeletebackups       = 'Automatically clean up backups';
$lang->action->label->savebackupsettings      = 'Save backup settings';
$lang->action->label->deleteexpiredbackup     = 'Clean up expired backups';
$lang->action->label->manualdeletebackup      = 'Manually clean up backup';
$lang->action->label->syncexecutionteam       = 'synchronized';
$lang->action->label->syncprojectteam         = 'synchronized';
$lang->action->label->syncbycase              = 'start';

/* Dynamic information is grouped by object. */
$lang->action->dynamicAction                    = new stdclass();
$lang->action->dynamicAction->todo['opened']    = 'Créer Todo';
$lang->action->dynamicAction->todo['edited']    = 'Edit Todo';
$lang->action->dynamicAction->todo['erased']    = 'Détruire Todo';
$lang->action->dynamicAction->todo['finished']  = 'Finir Todo';
$lang->action->dynamicAction->todo['activated'] = 'Activer Todo';
$lang->action->dynamicAction->todo['closed']    = 'Fermer Todo';
$lang->action->dynamicAction->todo['assigned']  = 'Assigner Todo';
$lang->action->dynamicAction->todo['undeleted'] = 'Restaurer Todo';
$lang->action->dynamicAction->todo['hidden']    = 'Masquer Todo';

$lang->action->dynamicAction->program['opened']    = 'Create Program';
$lang->action->dynamicAction->program['edited']    = 'Edit Program';
$lang->action->dynamicAction->program['activated'] = 'Activate Program';
$lang->action->dynamicAction->program['deleted']   = 'Delete Program';
$lang->action->dynamicAction->program['closed']    = 'Close Program';

$lang->action->dynamicAction->project['opened']        = "Create {$lang->projectCommon}";
$lang->action->dynamicAction->project['edited']        = "Edit {$lang->projectCommon}";
$lang->action->dynamicAction->project['started']       = "Start {$lang->projectCommon}";
$lang->action->dynamicAction->project['suspended']     = "Suspend {$lang->projectCommon}";
$lang->action->dynamicAction->project['activated']     = "Activate {$lang->projectCommon}";
$lang->action->dynamicAction->project['closed']        = "Close {$lang->projectCommon}";
$lang->action->dynamicAction->project['switchtolight'] = 'Switch Mode';

$lang->action->dynamicAction->product['opened']    = 'Créer ' . $lang->productCommon;
$lang->action->dynamicAction->product['edited']    = 'Editer ' . $lang->productCommon;
$lang->action->dynamicAction->product['deleted']   = 'Supprimer ' . $lang->productCommon;
$lang->action->dynamicAction->product['closed']    = 'Fermer ' . $lang->productCommon;
$lang->action->dynamicAction->product['undeleted'] = 'Restaurer ' . $lang->productCommon;
$lang->action->dynamicAction->product['hidden']    = 'Masquer ' . $lang->productCommon;

$lang->action->dynamicAction->branch['opened']           = 'Create Branch';
$lang->action->dynamicAction->branch['edited']           = 'Edit Branch';
$lang->action->dynamicAction->branch['closed']           = 'Close Branch';
$lang->action->dynamicAction->branch['activated']        = 'Activate Branch';
$lang->action->dynamicAction->branch['setdefaultbranch'] = 'Set Default Branch';
$lang->action->dynamicAction->branch['mergebranch']      = 'Merge Branch';

$lang->action->dynamicAction->productplan['opened']      = 'Créer Plan';
$lang->action->dynamicAction->productplan['edited']      = 'Editer Plan';
$lang->action->dynamicAction->productplan['started']     = "Start Plan";
$lang->action->dynamicAction->productplan['finished']    = "Finish Plan";
$lang->action->dynamicAction->productplan['closed']      = "Close Plan";
$lang->action->dynamicAction->productplan['activated']   = "Activate Plan";
$lang->action->dynamicAction->productplan['linkstory']   = "Link Story";
$lang->action->dynamicAction->productplan['unlinkstory'] = "Unlink Story";
$lang->action->dynamicAction->productplan['linkbug']     = "Link Bug";
$lang->action->dynamicAction->productplan['unlinkbug']   = "Unlink Bug";

$lang->action->dynamicAction->release['opened']       = 'Créer Release';
$lang->action->dynamicAction->release['edited']       = 'Editer Release';
$lang->action->dynamicAction->release['changestatus'] = 'Changer Statut Release';
$lang->action->dynamicAction->release['undeleted']    = 'Restaurer Release';
$lang->action->dynamicAction->release['notified']     = 'Notify Release';
$lang->action->dynamicAction->release['hidden']       = 'Masquer Release';

$lang->action->dynamicAction->story['opened']                = 'Créer Story';
$lang->action->dynamicAction->story['importfromgitlab']      = "Issue associate create story";
$lang->action->dynamicAction->story['edited']                = 'Editer Story';
$lang->action->dynamicAction->story['activated']             = 'Activer Story';
$lang->action->dynamicAction->story['reviewed']              = 'Consulter Story';
$lang->action->dynamicAction->story['recalled']              = 'Revoke';
$lang->action->dynamicAction->story['closed']                = 'Fermer Story';
$lang->action->dynamicAction->story['assigned']              = 'Assigner Story';
$lang->action->dynamicAction->story['changed']               = 'Changer Story';
$lang->action->dynamicAction->story['linked2plan']           = 'Inclure Story au Plan';
$lang->action->dynamicAction->story['unlinkedfromplan']      = 'Enlever Story du Plan';
$lang->action->dynamicAction->story['linked2release']        = 'Inclure Story à la Release';
$lang->action->dynamicAction->story['unlinkedfromrelease']   = 'Unlink Story from Plan';
$lang->action->dynamicAction->story['linked2revision']       = 'Inclure Story à la Revision';
$lang->action->dynamicAction->story['unlinkedfromrevision']  = 'Unlink Story from Revision';
$lang->action->dynamicAction->story['linked2build']          = 'Ajouter Story au Build';
$lang->action->dynamicAction->story['unlinkedfrombuild']     = 'Détacher Story du Build';
$lang->action->dynamicAction->story['unlinkedfromproject']   = "Unlink {$lang->projectCommon}";
$lang->action->dynamicAction->story['undeleted']             = 'Restaurer Story';
$lang->action->dynamicAction->story['hidden']                = 'Masquer Story';
$lang->action->dynamicAction->story['linked2execution']      = "Link Story";
$lang->action->dynamicAction->story['unlinkedfromexecution'] = "Unlink Story";
$lang->action->dynamicAction->story['linked2kanban']         = "Link Story";
$lang->action->dynamicAction->story['estimated']             = "Estimate $lang->SRCommon";

$lang->action->dynamicAction->execution['opened']    = 'Create ' . $lang->executionCommon;
$lang->action->dynamicAction->execution['edited']    = 'Edit ' . $lang->executionCommon;
$lang->action->dynamicAction->execution['deleted']   = 'Delete ' . $lang->executionCommon;
$lang->action->dynamicAction->execution['started']   = 'Start ' . $lang->executionCommon;
$lang->action->dynamicAction->execution['delayed']   = 'Delay ' . $lang->executionCommon;
$lang->action->dynamicAction->execution['suspended'] = 'Suspend ' . $lang->executionCommon;
$lang->action->dynamicAction->execution['activated'] = 'Activate ' . $lang->executionCommon;
$lang->action->dynamicAction->execution['closed']    = 'Close ' . $lang->executionCommon;
$lang->action->dynamicAction->execution['managed']   = 'Manage ' . $lang->executionCommon;
$lang->action->dynamicAction->execution['undeleted'] = 'Restore ' . $lang->executionCommon;
$lang->action->dynamicAction->execution['hidden']    = 'Hide ' . $lang->executionCommon;
$lang->action->dynamicAction->execution['moved']     = 'Improt Task';

$lang->action->dynamicAction->kanban['created'] = 'Create Kanban';
$lang->action->dynamicAction->kanban['edited']  = 'Kanban Settings';
$lang->action->dynamicAction->kanban['closed']  = 'Close Kanban';
$lang->action->dynamicAction->kanban['deleted'] = 'Delete Kanban';

$lang->action->dynamicAction->kanbanspace['created'] = 'Create Space';
$lang->action->dynamicAction->kanbanspace['edited']  = 'Space Settings';
$lang->action->dynamicAction->kanbanspace['closed']  = 'Close Space';
$lang->action->dynamicAction->kanbanspace['deleted'] = 'Deleted Space';

$lang->action->dynamicAction->kanbanregion['created'] = 'Create Region';
$lang->action->dynamicAction->kanbanregion['edited']  = 'Edit Region';
$lang->action->dynamicAction->kanbanregion['deleted'] = 'Delete Region';

$lang->action->dynamicAction->kanbancolumn['created']  = 'Create Column';
$lang->action->dynamicAction->kanbancolumn['edited']   = 'Column Settings';
$lang->action->dynamicAction->kanbancolumn['archived'] = 'Archive Column';
$lang->action->dynamicAction->kanbancolumn['restore']  = 'Restore Column';
$lang->action->dynamicAction->kanbancolumn['deleted']  = 'Delete Column';

$lang->action->dynamicAction->kanbanlane['created'] = 'Create Lane';
$lang->action->dynamicAction->kanbanlane['edited']  = 'Lane Settings';
$lang->action->dynamicAction->kanbanlane['moved']   = 'Move Lane';
$lang->action->dynamicAction->kanbanlane['deleted'] = 'Delete Lane';

$lang->action->dynamicAction->kanbancard['created']   = 'Create Card';
$lang->action->dynamicAction->kanbancard['edited']    = 'Edit Card';
$lang->action->dynamicAction->kanbancard['commented'] = 'Comment Card';
$lang->action->dynamicAction->kanbancard['archived']  = 'Archive Card';
$lang->action->dynamicAction->kanbancard['restore']   = 'Restore Card';
$lang->action->dynamicAction->kanbancard['deleted']   = 'Delete Card';

$lang->action->dynamicAction->team['managedTeam'] = 'Manage Team';

$lang->action->dynamicAction->task['opened']               = 'Créer Tâche';
$lang->action->dynamicAction->task['importfromgitlab']     = "Issue associate create task";
$lang->action->dynamicAction->task['edited']               = 'Editer Tâche';
$lang->action->dynamicAction->task['commented']            = 'Commenter Tâche';
$lang->action->dynamicAction->task['assigned']             = 'Assigner Tâche';
$lang->action->dynamicAction->task['confirmed']            = 'Confirmer Tâche';
$lang->action->dynamicAction->task['started']              = 'Commencer Tâche';
$lang->action->dynamicAction->task['finished']             = 'Terminer Tâche';
$lang->action->dynamicAction->task['recordworkhour']       = 'Ajouter Estimation';
$lang->action->dynamicAction->task['recordestimate']       = 'Ajouter Estimation';
$lang->action->dynamicAction->task['editestimate']         = 'Editer Estimation';
$lang->action->dynamicAction->task['deleteestimate']       = 'RAZ Estimation';
$lang->action->dynamicAction->task['paused']               = 'Stopper Tâche';
$lang->action->dynamicAction->task['closed']               = 'Fermer Tâche';
$lang->action->dynamicAction->task['canceled']             = 'Supprimer Tâche';
$lang->action->dynamicAction->task['activated']            = 'Activer Tâche';
$lang->action->dynamicAction->task['createchildren']       = 'Créer Sous-Tâche';
$lang->action->dynamicAction->task['unlinkparenttask']     = 'Délier Tâche Parent';
$lang->action->dynamicAction->task['deletechildrentask']   = 'Delete children task';
$lang->action->dynamicAction->task['linkparenttask']       = 'Lier Tâche Parent';
$lang->action->dynamicAction->task['linkchildtask']        = 'Lier sous-tâche';
$lang->action->dynamicAction->task['createchildrenstory']  = 'Créer sous-story';
$lang->action->dynamicAction->task['unlinkparentstory']    = 'Délier Story Parent';
$lang->action->dynamicAction->task['deletechildrenstory']  = 'Supprimer sous-story';
$lang->action->dynamicAction->task['linkparentstory']      = 'Lier Story Parent';
$lang->action->dynamicAction->task['linkchildstory']       = 'Lier sous-Story';
$lang->action->dynamicAction->task['undeleted']            = 'Restaurer Tâche';
$lang->action->dynamicAction->task['hidden']               = 'Masquer Tâche';
$lang->action->dynamicAction->task['svncommited']          = 'Committer SVN';
$lang->action->dynamicAction->task['gitcommited']          = 'Committer GIT';
$lang->action->dynamicAction->task['ganttmove']            = 'Order';
$lang->action->dynamicAction->task['linked2revision']      = 'Link Task to Revision';
$lang->action->dynamicAction->task['unlinkedfromrevision'] = 'Unlink Task from Revision';

$lang->action->dynamicAction->build['opened']  = 'Créer Build';
$lang->action->dynamicAction->build['edited']  = 'Editer Build';
$lang->action->dynamicAction->build['deleted'] = 'Delete Build';

$lang->action->dynamicAction->bug['opened']               = 'Remonter Bug';
$lang->action->dynamicAction->bug['importfromgitlab']     = "Issue associate create bug";
$lang->action->dynamicAction->bug['edited']               = 'Editer Bug';
$lang->action->dynamicAction->bug['activated']            = 'Activer Bug';
$lang->action->dynamicAction->bug['assigned']             = 'Assigner Bug';
$lang->action->dynamicAction->bug['closed']               = 'Fermer Bug';
$lang->action->dynamicAction->bug['bugconfirmed']         = 'Confirmer Bug';
$lang->action->dynamicAction->bug['resolved']             = 'Resolu Bug';
$lang->action->dynamicAction->bug['undeleted']            = 'Restaurer Bug';
$lang->action->dynamicAction->bug['hidden']               = 'Masquer Bug';
$lang->action->dynamicAction->bug['deleted']              = 'Supprimé Bug';
$lang->action->dynamicAction->bug['confirmed']            = 'Confirme Chang.Story';
$lang->action->dynamicAction->bug['tostory']              = 'Converti en Story';
$lang->action->dynamicAction->bug['totask']               = 'Converti en Tâche';
$lang->action->dynamicAction->bug['linked2plan']          = 'Lié au Plan';
$lang->action->dynamicAction->bug['unlinkedfromplan']     = 'Enlevé du Plan';
$lang->action->dynamicAction->bug['linked2release']       = 'Ajouté à la Release';
$lang->action->dynamicAction->bug['unlinkedfromrelease']  = 'Enlevé de la Release';
$lang->action->dynamicAction->bug['linked2revision']      = 'Ajouté à la Revision';
$lang->action->dynamicAction->bug['unlinkedfromrevision'] = 'Unlink Bug from Revision';
$lang->action->dynamicAction->bug['linked2bug']           = 'Lié au Build';
$lang->action->dynamicAction->bug['unlinkedfrombuild']    = 'Retiré du Build';
$lang->action->dynamicAction->bug['fromsonarqube']        = 'Create Bug from SonarQube Issue';

$lang->action->dynamicAction->testtask['opened']    = 'Créé Recette';
$lang->action->dynamicAction->testtask['edited']    = 'Edité Recette';
$lang->action->dynamicAction->testtask['started']   = 'Commencé Recette';
$lang->action->dynamicAction->testtask['activated'] = 'Activé Recette';
$lang->action->dynamicAction->testtask['closed']    = 'Fermé Recette';
$lang->action->dynamicAction->testtask['blocked']   = 'Bloqué Recette';

$lang->action->dynamicAction->case['opened']      = 'Créé CasTest';
$lang->action->dynamicAction->case['edited']      = 'Edité CasTest';
$lang->action->dynamicAction->case['deleted']     = 'Supprimé CasTest';
$lang->action->dynamicAction->case['undeleted']   = 'Restauré CasTest';
$lang->action->dynamicAction->case['hidden']      = 'Masqué CasTest';
$lang->action->dynamicAction->case['reviewed']    = 'Ajouté Revue Résultats';
$lang->action->dynamicAction->case['confirmed']   = 'Confirmé CasTest';
$lang->action->dynamicAction->case['fromlib']     = 'Importé de CasTest Lib';
$lang->action->dynamicAction->case['tolib']       = 'Importé Case';
$lang->action->dynamicAction->case['updatetolib'] = 'MàJ Case';

$lang->action->dynamicAction->testreport['opened']    = 'Créé Test Report';
$lang->action->dynamicAction->testreport['edited']    = 'Edité Test Report';
$lang->action->dynamicAction->testreport['deleted']   = 'Supprimé Test Report';
$lang->action->dynamicAction->testreport['undeleted'] = 'Restauré Test Report';
$lang->action->dynamicAction->testreport['hidden']    = 'Masqué Test Report';

$lang->action->dynamicAction->testsuite['opened']    = 'Créé Test Suite';
$lang->action->dynamicAction->testsuite['edited']    = 'Edité Test Suite';
$lang->action->dynamicAction->testsuite['deleted']   = 'Supprimé Test Suite';
$lang->action->dynamicAction->testsuite['undeleted'] = 'Restauré Test Suite';
$lang->action->dynamicAction->testsuite['hidden']    = 'Masqué Test Suite';

$lang->action->dynamicAction->caselib['opened']    = 'Créé CasTest Lib';
$lang->action->dynamicAction->caselib['edited']    = 'Edité CasTest Lib';
$lang->action->dynamicAction->caselib['deleted']   = 'Supprimé CasTest Lib';
$lang->action->dynamicAction->caselib['undeleted'] = 'Restauré CasTest Lib';
$lang->action->dynamicAction->caselib['hidden']    = 'Masqué CasTest Lib';

$lang->action->dynamicAction->zahost['created'] = 'Create Host';

$lang->action->dynamicAction->zanode['created'] = 'Create Zagent Node';
$lang->action->dynamicAction->zanode['suspend'] = 'Suspend Zagent Node';
$lang->action->dynamicAction->zanode['resume']  = 'Resume Zagent Node';
$lang->action->dynamicAction->zanode['reboot']  = 'Reboot Zagent Node';
$lang->action->dynamicAction->zanode['boot']    = 'Boot Zagent Node';
$lang->action->dynamicAction->zanode['destroy'] = 'Destory Zagent Node';

$lang->action->dynamicAction->doclib['created'] = 'Créer Doc Library';
$lang->action->dynamicAction->doclib['edited']  = 'Editer Doc Library';
$lang->action->dynamicAction->doclib['deleted'] = 'Delete Doc Library';

$lang->action->dynamicAction->doc['created']   = 'Créer Document';
$lang->action->dynamicAction->doc['edited']    = 'Editer Document';
$lang->action->dynamicAction->doc['commented'] = 'Commenter Document';
$lang->action->dynamicAction->doc['deleted']   = 'Supprimer Document';
$lang->action->dynamicAction->doc['undeleted'] = 'Restaurer Document';
$lang->action->dynamicAction->doc['hidden']    = 'Masquer Document';

$lang->action->dynamicAction->api['created'] = 'Create Interface';
$lang->action->dynamicAction->api['edited']  = 'Edit Interface';
$lang->action->dynamicAction->api['deleted'] = 'Delete Interface';

$lang->action->dynamicAction->user['created']       = 'Créer User';
$lang->action->dynamicAction->user['edited']        = 'Editer User';
$lang->action->dynamicAction->user['deleted']       = 'Delete User';
$lang->action->dynamicAction->user['login']         = 'Connexion';
$lang->action->dynamicAction->user['logout']        = 'Déconnexion';
$lang->action->dynamicAction->user['undeleted']     = 'Restaure User';
$lang->action->dynamicAction->user['hidden']        = 'Masquer User';
$lang->action->dynamicAction->user['loginxuanxuan'] = 'Connexion Desktop';

$lang->action->dynamicAction->entry['created'] = 'Ajouter Application';
$lang->action->dynamicAction->entry['edited']  = 'Editer Application';

$lang->action->dynamicAction->job['created']   = 'Create Job';
$lang->action->dynamicAction->job['edited']    = 'Edit Job';
$lang->action->dynamicAction->job['executed']  = 'Execute Job';
$lang->action->dynamicAction->job['deleted']   = 'Delete Job';
$lang->action->dynamicAction->job['undeleted'] = 'Undelete Job';

$lang->action->dynamicAction->sonarqube['created']   = 'Create SonarQube Server';
$lang->action->dynamicAction->sonarqube['edited']    = 'Edit SonarQube Server';
$lang->action->dynamicAction->sonarqube['deleted']   = 'Delete SonarQube Server';
$lang->action->dynamicAction->sonarqube['undeleted'] = 'Undelete SonarQube Server';

$lang->action->dynamicAction->sonarqubeproject['deleted'] = 'Delete SonarQube Project';

$lang->action->dynamicAction->gitlab['created']   = 'Create GitLab Server';
$lang->action->dynamicAction->gitlab['edited']    = 'Edit GitLab Server';
$lang->action->dynamicAction->gitlab['deleted']   = 'Delete GitLab Server';
$lang->action->dynamicAction->gitlab['undeleted'] = 'Undelete GitLab Server';

$lang->action->dynamicAction->gitea['created']   = 'Create Gitea Server';
$lang->action->dynamicAction->gitea['edited']    = 'Edit Gitea Server';
$lang->action->dynamicAction->gitea['deleted']   = 'Delete Gitea Server';
$lang->action->dynamicAction->gitea['undeleted'] = 'Undelete Gitea Server';

$lang->action->dynamicAction->gogs['created']   = 'Create Gogs Server';
$lang->action->dynamicAction->gogs['edited']    = 'Edit Gogs Server';
$lang->action->dynamicAction->gogs['deleted']   = 'Delete Gogs Server';
$lang->action->dynamicAction->gogs['undeleted'] = 'Undelete Gogs Server';

$lang->action->dynamicAction->nexus['created']   = 'Create Nexus Server';
$lang->action->dynamicAction->nexus['edited']    = 'Edit Nexus Server';
$lang->action->dynamicAction->nexus['deleted']   = 'Delete Nexus Server';
$lang->action->dynamicAction->nexus['undeleted'] = 'Undelete Nexus Server';

$lang->action->dynamicAction->repo['created']   = 'Create Repo';
$lang->action->dynamicAction->repo['edited']    = 'Edit Repo';
$lang->action->dynamicAction->repo['deleted']   = 'Delete Repo';
$lang->action->dynamicAction->repo['undeleted'] = 'Undelete Repo';

$lang->action->dynamicAction->metric['created']   = 'Create Metric';
$lang->action->dynamicAction->metric['edited']    = 'Edit Metric';
$lang->action->dynamicAction->metric['deleted']   = 'Delete Metric';
$lang->action->dynamicAction->metric['undeleted'] = 'Undelete Metric';
$lang->action->dynamicAction->metric['delist']    = 'Delist Metric';
$lang->action->dynamicAction->metric['publish']   = 'Publish Metric';

/* Generate the corresponding object link. */
$lang->action->label->product     = $lang->productCommon . '|product|view|productID=%s';
$lang->action->label->productplan = 'Plan|productplan|view|productID=%s';
$lang->action->label->release     = 'Release|release|view|productID=%s';
$lang->action->label->story       = 'Story|story|storyView|storyID=%s';
$lang->action->label->program     = "Program|program|pgmproduct|programID=%s";
$lang->action->label->project     = "{$lang->projectCommon}|project|index|projectID=%s";
$lang->action->label->execution   = "Execution|execution|task|executionID=%s";

$lang->action->label->task         = 'Tâche|task|view|taskID=%s';
$lang->action->label->build        = 'Build|build|view|buildID=%s';
$lang->action->label->bug          = 'Bug|bug|view|bugID=%s';
$lang->action->label->case         = 'CasTest|testcase|view|caseID=%s';
$lang->action->label->testtask     = 'Recette|testtask|view|caseID=%s';
$lang->action->label->testsuite    = 'Cahier Recette|testsuite|view|suiteID=%s';
$lang->action->label->caselib      = 'Library Recette|testsuite|libview|libID=%s';
$lang->action->label->todo         = 'Agenda|todo|view|todoID=%s';
$lang->action->label->doclib       = 'Bibliothèque|doc|teamspace|objectID=%s&libID=%s';
$lang->action->label->docspace     = 'Doc Space';
$lang->action->label->doc          = 'Document|doc|view|docID=%s';
$lang->action->label->user         = 'Utilisateur|user|view|account=%s';
$lang->action->label->testreport   = 'Rapport|testreport|view|report=%s';
$lang->action->label->entry        = 'Application|entry|browse|';
$lang->action->label->webhook      = 'Webhook|webhook|browse|';
$lang->action->label->space        = ' ';
$lang->action->label->risk         = 'Risk|risk|view|riskID=%s';
$lang->action->label->issue        = 'Issue|issue|view|issueID=%s';
$lang->action->label->design       = 'Design|design|view|designID=%s';
$lang->action->label->stakeholder  = 'Stakeholder|stakeholder|view|userID=%s';
$lang->action->label->api          = 'Interface|api|view|libID=%s&apiID=%s&moduleID=%s';
$lang->action->label->kanbanspace  = 'Kanban Space|kanban|space|browseType=%s';
$lang->action->label->kanbanregion = 'Kanban Region|kanban|view|kanbanID=%s';
$lang->action->label->kanban       = 'Kanban|kanban|view|kanbanID=%s';
$lang->action->label->kanbancolumn = 'Kanban Column|execution|kanban|execution=%s';
$lang->action->label->kanbanlane   = 'Kanban Lane|execution|kanban|execution=%s&type=all';
$lang->action->label->kanbancard   = 'Kanban Card|kanban|view|kanbanID=%s';
$lang->action->label->stage        = 'Stage|stage|browse|';
$lang->action->label->module       = 'Module|tree|browse|productid=%s&view=story&currentModuleID=0&branch=all';
$lang->action->label->ticket       = 'Ticket|ticket|view|id=%s';
$lang->action->label->chartgroup   = 'Group';
$lang->action->label->serverroom   = 'IDC|serverroom|browse|';
$lang->action->label->host         = 'Host|host|view|id=%s';
$lang->action->label->account      = "Account|account|view|id=%s";
$lang->action->label->instance     = 'Application|instance|view|id=%s';
$lang->action->label->prompt       = 'Prompt|ai|promptview|id=%s';
$lang->action->label->miniprogram  = 'Mini Program|aiapp|browseminiprogram|id=%s';
$lang->action->label->holiday      = 'Holiday|holiday|browse|';

/* Object type. */
$lang->action->search = new stdclass();
$lang->action->search->objectTypeList['']            = '';
$lang->action->search->objectTypeList['product']     = $lang->productCommon;
$lang->action->search->objectTypeList['program']     = 'Program';
$lang->action->search->objectTypeList['project']     = $lang->projectCommon;
$lang->action->search->objectTypeList['execution']   = 'Execution';
$lang->action->search->objectTypeList['bug']         = 'Bug';
$lang->action->search->objectTypeList['case']        = 'CasTest';
$lang->action->search->objectTypeList['caseresult']  = 'CasTest Result';
$lang->action->search->objectTypeList['stepresult']  = 'CasTest Steps';
$lang->action->search->objectTypeList['story']       = "$lang->SRCommon/$lang->URCommon";
$lang->action->search->objectTypeList['task']        = 'Tâche';
$lang->action->search->objectTypeList['testtask']    = 'Recette';
$lang->action->search->objectTypeList['user']        = 'Utilisateur';
$lang->action->search->objectTypeList['doc']         = 'Doc';
$lang->action->search->objectTypeList['doclib']      = 'Doc Lib';
$lang->action->search->objectTypeList['todo']        = 'Todo';
$lang->action->search->objectTypeList['build']       = 'Build';
$lang->action->search->objectTypeList['release']     = 'Release';
$lang->action->search->objectTypeList['productplan'] = 'Plan';
$lang->action->search->objectTypeList['branch']      = 'Branche';
$lang->action->search->objectTypeList['testsuite']   = 'Cahier Recette';
$lang->action->search->objectTypeList['caselib']     = 'Library';
$lang->action->search->objectTypeList['testreport']  = 'Etat';

/* Used to display actions in dynamic method. */
$lang->action->search->label['']                      = '';
$lang->action->search->label['created']               = $lang->action->label->created;
$lang->action->search->label['opened']                = $lang->action->label->opened;
$lang->action->search->label['changed']               = $lang->action->label->changed;
$lang->action->search->label['edited']                = $lang->action->label->edited;
$lang->action->search->label['assigned']              = $lang->action->label->assigned;
$lang->action->search->label['closed']                = $lang->action->label->closed;
$lang->action->search->label['deleted']               = $lang->action->label->deleted;
$lang->action->search->label['deletedfile']           = $lang->action->label->deletedfile;
$lang->action->search->label['editfile']              = $lang->action->label->editfile;
$lang->action->search->label['erased']                = $lang->action->label->erased;
$lang->action->search->label['undeleted']             = $lang->action->label->undeleted;
$lang->action->search->label['hidden']                = $lang->action->label->hidden;
$lang->action->search->label['commented']             = $lang->action->label->commented;
$lang->action->search->label['activated']             = $lang->action->label->activated;
$lang->action->search->label['blocked']               = $lang->action->label->blocked;
$lang->action->search->label['resolved']              = $lang->action->label->resolved;
$lang->action->search->label['reviewed']              = $lang->action->label->reviewed;
$lang->action->search->label['moved']                 = $lang->action->label->moved;
$lang->action->search->label['confirmed']             = $lang->action->label->confirmed;
$lang->action->search->label['bugconfirmed']          = $lang->action->label->bugconfirmed;
$lang->action->search->label['tostory']               = $lang->action->label->tostory;
$lang->action->search->label['frombug']               = $lang->action->label->frombug;
$lang->action->search->label['totask']                = $lang->action->label->totask;
$lang->action->search->label['svncommited']           = $lang->action->label->svncommited;
$lang->action->search->label['gitcommited']           = $lang->action->label->gitcommited;
$lang->action->search->label['linked2plan']           = $lang->action->label->linked2plan;
$lang->action->search->label['unlinkedfromplan']      = $lang->action->label->unlinkedfromplan;
$lang->action->search->label['changestatus']          = $lang->action->label->changestatus;
$lang->action->search->label['marked']                = $lang->action->label->marked;
$lang->action->search->label['linked2project']        = $lang->action->label->linked2project;
$lang->action->search->label['unlinkedfromproject']   = $lang->action->label->unlinkedfromproject;
$lang->action->search->label['linked2execution']      = $lang->action->label->linked2execution;
$lang->action->search->label['unlinkedfromexecution'] = $lang->action->label->unlinkedfromexecution;
$lang->action->search->label['linked2kanban']         = $lang->action->label->linked2kanban;
$lang->action->search->label['started']               = $lang->action->label->started;
$lang->action->search->label['restarted']             = $lang->action->label->restarted;
$lang->action->search->label['recordworkhour']        = $lang->action->label->recordworkhour;
$lang->action->search->label['recordestimate']        = $lang->action->label->recordworkhour;
$lang->action->search->label['editestimate']          = $lang->action->label->editestimate;
$lang->action->search->label['canceled']              = $lang->action->label->canceled;
$lang->action->search->label['finished']              = $lang->action->label->finished;
$lang->action->search->label['paused']                = $lang->action->label->paused;
$lang->action->search->label['verified']              = $lang->action->label->verified;
$lang->action->search->label['importfromgitlab']      = $lang->action->label->importfromgitlab;
$lang->action->search->label['login']                 = $lang->action->label->login;
$lang->action->search->label['logout']                = $lang->action->label->logout;

/* Action language config for API(JIHU) */
$lang->action->apiTitle = new stdclass();
$lang->action->apiTitle->opened                = 'Opened.';
$lang->action->apiTitle->created               = 'Created.';
$lang->action->apiTitle->added                 = 'Added.';
$lang->action->apiTitle->changed               = 'Changed.';
$lang->action->apiTitle->edited                = 'Edited.';
$lang->action->apiTitle->assigned              = 'Assigned to <strong>%s</strong>.';
$lang->action->apiTitle->closed                = 'Closed.';
$lang->action->apiTitle->deleted               = 'Deleted.';
$lang->action->apiTitle->deletedfile           = 'Deleted: <strong><i>%s</i></strong>.';
$lang->action->apiTitle->editfile              = 'Edited: <strong><i>%s</i></strong>.';
$lang->action->apiTitle->erased                = 'Erased.';
$lang->action->apiTitle->undeleted             = 'Restored.';
$lang->action->apiTitle->hidden                = 'Hidden.';
$lang->action->apiTitle->commented             = 'Commented';
$lang->action->apiTitle->activated             = 'Activated.';
$lang->action->apiTitle->confirmed             = 'Confirmed.';
$lang->action->apiTitle->caseconfirmed         = '<strong>$actor</strong> confirmed the case change. The latest build is <strong>#$extra</strong>';
$lang->action->apiTitle->bugconfirmed          = '<strong>$actor</strong> confirmed Bug.';
$lang->action->apiTitle->frombug               = 'Converted from <strong>$actor</strong>. Its ID was <strong>$extra</strong>.';
$lang->action->apiTitle->started               = 'Started by <strong>$actor</strong>.';
$lang->action->apiTitle->restarted             = 'Continued by <strong>$actor</strong>.';
$lang->action->apiTitle->delayed               = 'Postponed by <strong>$actor</strong>.';
$lang->action->apiTitle->suspended             = 'Suspended by <strong>$actor</strong>.';
$lang->action->apiTitle->recordworkhour        = 'Recorded by <strong>$actor</strong> and it cost <strong>$extra</strong> hours.';
$lang->action->apiTitle->recordestimate        = 'Recorded by <strong>$actor</strong> and it cost <strong>$extra</strong> hours.';
$lang->action->apiTitle->editestimate          = '<strong>$actor</strong> edited Hour.';
$lang->action->apiTitle->deleteestimate        = '<strong>$actor</strong> deleted Hour.';
$lang->action->apiTitle->canceled              = 'Cancelled by <strong>$actor</strong>.';
$lang->action->apiTitle->svncommited           = '<strong>$actor</strong> committed and the build is <strong>#$extra</strong>.';
$lang->action->apiTitle->gitcommited           = '<strong>$actor</strong> committed and the build is <strong>#$extra</strong>.';
$lang->action->apiTitle->finished              = 'Finished by <strong>$actor</strong>.';
$lang->action->apiTitle->paused                = 'Paused by <strong>$actor</strong>.';
$lang->action->apiTitle->linked2bug            = 'Linked to <strong>$extra</strong> by <strong>$actor</strong>';
$lang->action->apiTitle->linked2testtask       = 'Linked to <strong>$extra</strong> by <strong>$actor</strong>';
$lang->action->apiTitle->resolved              = 'Resolved by <strong>$actor</strong> ';
$lang->action->apiTitle->managed               = 'By <strong>$actor</strong> managed.';
$lang->action->apiTitle->estimated             = 'By <strong>$actor</strong> estimated.';
$lang->action->apiTitle->run                   = 'By <strong>$actor</strong> executed.';
$lang->action->apiTitle->tostory               = "To story: {$lang->SRCommon}";
$lang->action->apiTitle->createchildren        = 'Create children <strong>%s</strong>.';
$lang->action->apiTitle->linkchildtask         = 'Link a child task <strong>%s</strong>.';
$lang->action->apiTitle->unlinkchildrentask    = 'Unlink a child task <strong>%s</strong>.';
$lang->action->apiTitle->linkparenttask        = 'Link a parent task <strong>%s</strong>.';
$lang->action->apiTitle->unlinkparenttask      = 'Unlink a parent task <strong>%s</strong>.';
$lang->action->apiTitle->deletechildrentask    = 'Delete a child task<strong>%s</strong>.';
$lang->action->apiTitle->createchildrenstory   = 'Create a child story <strong>%s</strong>.';
$lang->action->apiTitle->linkchildstory        = 'Link a child story <strong>%s</strong>.';
$lang->action->apiTitle->unlinkchildrenstory   = 'Unlink a child story <strong>%s</strong>.';
$lang->action->apiTitle->linkparentstory       = 'Link parent story <strong>%s</strong>.';
$lang->action->apiTitle->unlinkparentstory     = 'Unlink parent story from <strong>%s</strong>.';
$lang->action->apiTitle->deletechildrenstory   = 'Deleted a child story <strong>%s</strong>.';
$lang->action->apiTitle->linkrelatedcase       = 'Link related case <strong>%s</strong>.';
$lang->action->apiTitle->unlinkrelatedcase     = 'Unlink related case <strong>%s</strong>.';
$lang->action->apiTitle->openedbysystem        = 'Opened by system';
$lang->action->apiTitle->closedbysystem        = 'Closed by system';
$lang->action->apiTitle->communicated          = 'Communicated';
$lang->action->apiTitle->blocked               = 'Blocked';
$lang->action->apiTitle->reviewed              = 'Reviewed';
$lang->action->apiTitle->recalled              = 'Recalled';
$lang->action->apiTitle->moved                 = 'Moved';
$lang->action->apiTitle->fromlib               = 'Import from lib';
$lang->action->apiTitle->totask                = 'To task';
$lang->action->apiTitle->linked2plan           = "Link to plan";
$lang->action->apiTitle->unlinkedfromplan      = "Unlinked from plan";
$lang->action->apiTitle->changestatus          = 'Changed status';
$lang->action->apiTitle->marked                = 'Marked';
$lang->action->apiTitle->linked2execution      = "Linked to {$lang->executionCommon}";
$lang->action->apiTitle->unlinkedfromexecution = "Unlinked from {$lang->executionCommon}";
$lang->action->apiTitle->linked2kanban         = 'Linked to Kanban';
$lang->action->apiTitle->linked2project        = "Linked to {$lang->projectCommon}";
$lang->action->apiTitle->unlinkedfromproject   = "Unlinked from {$lang->projectCommon}";
$lang->action->apiTitle->unlinkedfrombuild     = "Unlinked from build";
$lang->action->apiTitle->linked2release        = "Linked to release";
$lang->action->apiTitle->unlinkedfromrelease   = "Unlinked from release";
$lang->action->apiTitle->linked2revision       = "Linked to revision";
$lang->action->apiTitle->unlinkedfromrevision  = "Unlinked from revision";
$lang->action->apiTitle->linkrelatedbug        = "Linked related Bug";
$lang->action->apiTitle->unlinkrelatedbug      = "Unlinked related Bug";
$lang->action->apiTitle->linkrelatedstory      = "Link related story {$lang->SRCommon}";
$lang->action->apiTitle->unlinkrelatedstory    = "Unlink related story {$lang->SRCommon}";
$lang->action->apiTitle->subdividestory        = "Subdivided story: {$lang->SRCommon}";
$lang->action->apiTitle->unlinkchildstory      = "Unlink child story: {$lang->SRCommon}";
$lang->action->apiTitle->verified              = 'Verified';
$lang->action->apiTitle->login                 = 'Login';
$lang->action->apiTitle->logout                = "Logout";
$lang->action->apiTitle->linked2build          = "Linked to build";
$lang->action->apiTitle->unlinkedfromtesttask  = "Unlinked from test task";
$lang->action->apiTitle->batchcreate           = "Batch create";
$lang->action->apiTitle->managedteam           = "Managed team";
$lang->action->apiTitle->managedwhitelist      = "Managed white list";
$lang->action->apiTitle->tracked               = 'Tracked';
$lang->action->apiTitle->hangup                = 'Hangup';
$lang->action->apiTitle->reviewpassed          = 'Review passed';
$lang->action->apiTitle->reviewrejected        = 'Review rejected';
$lang->action->apiTitle->reviewclarified       = 'Review clarified';
$lang->action->apiTitle->commitsummary         = 'Commit summary';
$lang->action->apiTitle->updatetrainee         = 'Update trainee';

/* Code Review in Repo or Merge Request module. */
$lang->action->desc->repocreated                  = '$date, created and reviewed by <strong>$actor</strong>: $extra.' . "\n";
$lang->action->label->repocreated                 = "create and review";
$lang->action->dynamicAction->task['gitcommited'] = 'Committer GIT';
$lang->action->dynamicAction->bug['repocreated']  = $lang->action->label->repocreated;
$lang->action->desc->createmr                     = '$extra';
$lang->action->desc->deletemr                     = '$date, <strong>$actor</strong> unlink <a href="$extra">merge request</a>。';
$lang->action->desc->mergedmr                     = '$date, <strong>$actor</strong> merged code.';
$lang->action->desc->compilefail                  = '$date, <strong>$actor</strong> compile fail.';
$lang->action->desc->compilepass                  = '$date, <strong>$actor</strong> compile pass';
$lang->action->desc->approve                      = '$date, <strong>$actor</strong> approved.';
$lang->action->desc->reject                       = '$date, <strong>$actor</strong> rejected.';
$lang->action->desc->linkedrepo                   = '$date, <strong>$actor</strong> linked repo $extra';
$lang->action->desc->unlinkedrepo                 = '$date, <strong>$actor</strong> unlinked repo $extra';

$lang->action->reviewStatusList['wait']      = 'Pending approval';
$lang->action->reviewStatusList['doing']     = 'Reviewing';
$lang->action->reviewStatusList['pass']      = 'Pass';
$lang->action->reviewStatusList['reject']    = 'Reject';
$lang->action->reviewStatusList['reverting'] = 'Reverting';

$lang->action->reviewResultList['pass']   = 'Pass';
$lang->action->reviewResultList['reject'] = 'Reject';
