<?php
/*
 * Copyright (c) 2025, Tribal Limited
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of Zenario, Tribal Limited nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL TRIBAL LTD BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
if (!defined('NOT_ACCESSED_DIRECTLY')) exit('This file may not be directly accessed');



//Write buttons to the page for managing the Plugin. CSS is used so that the edit settings button is invisible when the slot is empty

if ($this->eggId && isset($this->parentNest)) {
	
	$organizerLink = 'organizer.php?fromCID='. ze::$cID. '&fromCType='. ze::$cType. '#';
	$tagPath = 'zenario__library/panels/nested_plugins';
	
	switch ($this->parentNest->moduleClassName) {
		case 'zenario_slideshow':
			$isSlideshow = true;
			$buttonName = 'images_in_slideshow';
			$tagPath = 'zenario__library/panels/images_in_slideshow';
			break;
		default:
			$buttonName = 'plugins_in_nest';
			$isSlideshow = false;
			break;
	}
	
	$navPath = 'zenario__library/panels/modules/item//'. (int) $this->parentNest->moduleId. '//item_buttons/'. $buttonName. '//'. (int) $this->instanceId. '//';
	
	
	
	//Show a button to edit eggs in nests
	echo '
		<div id="', $this->containerId, '-control_box" class="zenario_slotAdminControlBox zenario_slotEggControlBox">';
		
		if ($this->eggId === -1) {
			//Special case: add an "edit plugin" button for the breadcrumbs that are auto-added

			$tooltip =
				\ze\admin::phrase('Breadcrumbs generated by the conductor.').
				'<br/>'.
				\ze\admin::phrase('Click to edit conductor settings.');


			echo '
			<a
				href="', $organizerLink, $navPath, '~.plugin_settings~tbreadcrumbs~k', htmlspecialchars(json_encode(['instanceId' => $this->instanceId])), '"
				class="zenario_slotButton zenario_editNestedPlugin"
				id="', $this->containerId, '-egg"
				onclick="if (zenarioA.checkForEdits()) zenarioA.pluginSlotEditSettings(this, \'', $this->slotName, '\'); return false;"
				title="'. htmlspecialchars($tooltip). '"
				data-tooltip-options=\'{"tooltipClass": "zenario_admin_tooltip"}\'
			><span></span></a>';
		
		} elseif ($this->eggId < 0) {
			//If there are any other auto-generated plugins, don't show any controls (for now at least)
			//To do: add something useful here
		
		} else {
			
			$classInfo = $this->getClassInfo();
			
			$tooltip = '<div>'. \ze\admin::phrase('Nested plugin of'). ' <span>'. htmlspecialchars($this->moduleClassName). '</span></div>';
			
			if ($classInfo['mode']) {
				$tooltip .= '<div>'. \ze\admin::phrase('Plugin mode:'). ' <span>'. htmlspecialchars($classInfo['mode']). '</span></div>';
			}
			
			$tooltip .= '<div>'. \ze\admin::phrase('Click to edit its settings'). '</div>';
			
			
			echo '
			<a
				href="', $organizerLink, $navPath, $this->eggId, '~.plugin_settings~k', htmlspecialchars(json_encode(['eggId' => $this->eggId])), '"
				class="zenario_slotButton zenario_editNestedPlugin"
				id="', $this->containerId, '-egg"
				onclick="if (zenarioA.checkForEdits()) zenarioA.pluginSlotEditSettings(this, \'', $this->slotName, '\', false, {eggId: ', (int) $this->eggId, '}); return false;"
				title="'. htmlspecialchars($tooltip). '"
				data-tooltip-options=\'{"tooltipClass": "zenario_admin_tooltip zenario_plugin_info_tooltip"}\'
			><span></span></a>
			<a
				href="', $organizerLink, $navPath, $this->eggId, '"
				class="zenario_slotButton zenario_nestedPluginOptions"
				id="', $this->containerId, '-egg-options"
				onclick="', "
					if (zenarioA.checkForEdits())
						zenarioAT.organizerQuick(
							'", $navPath, $this->eggId, "',
							'zenario__library/panels/nested_plugins',
							false,
							'", ze\escape::js($this->slotName), "',
							false,
							". ze\ring::engToBoolean($this->isVersionControlled). ",
							this
						);
					return false;", '"
			><span></span></a>';
	}
	
} else {
	//Show buttons for normal slots
	echo '
		<div id="', $this->containerId, '-control_box" class="zenario_slotAdminControlBox zenario_slotPluginControlBox">
			<a
				class="zenario_slotButton zenario_openSlotControls"
				id="', $this->containerId, '-options"
				onclick="return zenarioA.openSlotControls(this, this, \'', $this->slotName, '\');"
			><span></span></a>';
	
	if (\ze\priv::check('_PRIV_MANAGE_ITEM_SLOT') || \ze\priv::check('_PRIV_MANAGE_TEMPLATE_SLOT')) {
		echo '
			<a
				class="zenario_slotButton zenario_swapPlugin"
				title="', htmlspecialchars(\ze\admin::phrase('Swap with plugin in slot "[[slotname]]"', ['slotname' => $this->slotName])), '"
				onclick="return zenarioA.doMovePlugin(this, \''. $this->slotName. '\');"
			></a>
			<a
				class="zenario_slotButton zenario_movePlugin"
				title="', htmlspecialchars(\ze\admin::phrase('Move into slot "[[slotname]]"', ['slotname' => $this->slotName])), '"
				onclick="return zenarioA.doMovePlugin(this, \''. $this->slotName. '\');"
			></a>
			<a
				class="zenario_slotButton zenario_copyPluginPlacement"
				title="', htmlspecialchars(\ze\admin::phrase('Copy into slot "[[slotname]]"', ['slotname' => $this->slotName])), '"
				onclick="return zenarioA.doMovePlugin(this, \''. $this->slotName. '\');"
			></a>
			<a
				class="zenario_slotButton zenario_cancelMovePlugin"
				title="', \ze\admin::phrase('Cancel moving'), '"
				onclick="return zenarioA.cancelMovePlugin(this);"
			></a>';
	}
}

echo '
		</div>';

