Створення своєї власної структури додатку
=========================================

> Note: Цей розділ знаходиться в розробці.

У той час, як [базовий](https://github.com/yiisoft/yii2-app-basic) і [розширений](https://github.com/yiisoft/yii2-app-advanced)
шаблони додатків прекрасно підходять для більшості ваших потреб, ви також можете сворити свій власний шаблон додатку, з яким
працюватиме ваш проект.

Шаблони додатку в Yii це простий репозиторій, що міститься у файлі `composer.json` і зареєстрований у якості пакету Composer.
Будь-який репозиторій може бути ідентифікований як Composer пакет, що робить можливим його встановлення
за допомогою команди Composer `create-project`.

Оскільки це потребує дещо більше початкової роботи для створення власного шаблону з нуля, краще використовувати один із 
вбудованих шаблонів в якості основи. Давайте використаємо тут базовий шаблон.

Клонування базового шаблону
---------------------------

Першим кроком буде клонування базового шаблону Yii з Git репозиторія:

```bash
git clone git@github.com:yiisoft/yii2-app-basic.git
```

Тоді, почекайте поки репозиторій завантажеться на ваш комп’ютер. Щоб зміни, які внесені в шаблон не були перезаписані, 
вам необхідно видалити каталог `.git` і весь її зміст після завантаження.

Заміна файлів
-------------

Далі вам потрібно змінити файл `composer.json`, щоб показати ваш шаблон.
Змініть значення `name`, `description`, `keywords`, `homepage`, `license` і `support`, щоб описати ваш новий шаблон.
Також налаштуйте `require`, `require-dev`, `suggest` та інші параметри відповідно до вимог вашого шаблону.

> Note: В файлі `composer.json` використовуйте параметр `writable` в розділі `extra`, щоб
> вказати права доступу до файлів, які необхідно встановити після створення додатку з використанням вашого шаблону.

Далі внесіть зміни у структуру та зміст додатку на той, який ви би хотіли бачити за замовчуванням. 
В кінці, оновіть файл інструкції README для застосування вашого шаблону.

Створення пакету
----------------

З визначенням шаблону, створіть Git репозиторій та завантажте туди свої файли. Якщо ви, збираєтесь використовувати свій шаблон,
як *open source*, то [Github](https://github.com) є кращим місцем для його розташування.
Якщо ви не бажаєте публічно розміщувати свій шаблон, то підійде будь-який сайт сервісу Git.

Далі, вам необхідно зареєструвати свій Composer пакет. Для публічних шаблонів, ваш пакет необхідно зареєструвати 
в [Packagist](https://packagist.org/). Для приватних шаблонів, зареєструвати пакет трішки складніше.
Для цього слідуйте інструкціями у [Документації Composer](https://getcomposer.org/doc/05-repositories.md#hosting-your-own).

Використання шаблону
--------------------

Це все, що потрібно для створення власного шаблону для Yii додатку.
Тепер ви можете створювати проекти, використовуючи свій шаблон:

```
composer global require "fxp/composer-asset-plugin:^1.4.1"
composer create-project --prefer-dist --stability=dev mysoft/yii2-app-coolone new-project
```
