Работа со сторонним кодом
=============================

Иногда необходимо использовать сторонний код в приложениях Yii. Или же есть потребность использовать Yii в качестве библиотеки в сторонних системах. В этом разделе мы рассмотрим, как это происходит.


Использование сторонних библиотек в Yii <span id="using-libs-in-yii"></span>
----------------------------------

Перед тем, как использовать стороннюю библиотеку в приложении Yii, в первую очередь следует убедиться, что в ней либо явно настроена загрузка классов, либо классы могут загружаться автоматически.

### Использование пакетов Composer <span id="using-composer-packages"></span>

Многие сторонние библиотеки поставляются в виде пакетов [Composer](https://getcomposer.org/).
Для установки таких библиотек достаточно проделать два простых шага:

1. Изменить файл `composer.json` своего приложения и указать, какие пакеты Composer нужно устанавливать.
2. Выполнить команду `composer install`, чтобы установить указанные пакеты.

Классы установленных пакетов Composer поддерживают автозагрузку с помощью автозагрузчика Composer. Убедитесь, что во [входном скрипте](structure-entry-scripts.md) приложения присутствуют следующие строки, подключающие автозагрузчик Composer:

```php
// подключение автозагрузчика Composer
require __DIR__ . '/../vendor/autoload.php';

// подключение файла класса Yii
require __DIR__ . '/../vendor/yiisoft/yii2/Yii.php';
```

### Использование отдельных библиотек <span id="using-downloaded-libs"></span>

Если библиотека не поставляется в виде пакета Composer, необходимо установить ее согласно ее руководству по установке.
В большинстве случаев потребуется вручную скачать файл с релизом и распаковать его в директорию `BasePath/vendor`, где `BasePath` соответствует [базовому пути](structure-applications.md#basePath) приложения.

Если библиотека использует собственный автозагрузчик классов, его можно подключить во [входном скрипте](structure-entry-scripts.md) приложения. Желательно подключить его до того, как подключается файл `Yii.php`, чтобы при автоматической загрузке классов у автозагрузчика классов Yii был приоритет.

Если библиотека не поставляется с автозагрузчиком классов, но конвенция именования ее классов соответствует [PSR-4](https://www.php-fig.org/psr/psr-4/), для загрузки ее классов можно использовать автозагрузчик Yii. Для этого достаточно для каждого корневого пространства имен, которые используются в ее классах, объявить [корневой псевдоним](concept-aliases.md#defining-aliases). Предположим, что библиотека установлена в директорию `vendor/foo/bar`, а ее классы объявлены в корневом пространстве имен `xyz`. В конфигурации приложения можно использовать следующий код:

```php
[
    'aliases' => [
        '@xyz' => '@vendor/foo/bar',
    ],
]
```

Если ни один из предыдущих вариантов не подходит, скорее всего для использования библиотеки нужно настроить в конфигурации PHP директиву `include_path`. Настройте ее, следуя инструкциям, которые поставляются с библиотекой.

В наихудшем случае библиотека требует явного подключения всех файлов, содержащих классы. При этом для подключения классов по требованию можно проделать следующее:

* Определить, какие классы входят в состав библиотеки.
* Перечислить классы и пути к соответствующим файлам в `Yii::$classMap` во [входном скрипте](structure-entry-scripts.md) приложения. Например,
```php
Yii::$classMap['Class1'] = 'path/to/Class1.php';
Yii::$classMap['Class2'] = 'path/to/Class2.php';
```


Использование Yii в сторонних системах <span id="using-yii-in-others"></span>
--------------------------------

Поскольку в Yii реализована масса полезных функций, они могут пригодиться при разработке или расширении сторонних систем, таких как WordPress и Joomla, или приложений, разработанных с помощью других PHP-фреймворков. Например, в сторонней системе можно задействовать класс [[yii\helpers\ArrayHelper]] или использовать функционал [Active Record](db-active-record.md). Для этого обычно нужно сделать две вещи: установить Yii и подключить Yii.

Если сторонняя система использует для управления зависимостями Composer, Yii можно просто установить с помощью следующей команды:

```bash
composer require yiisoft/yii2
```

Если вам интересны возможности Yii, например, по работе с базами данных, но вы не планируете использование
[ресурсов](structure-assets.md), вы можете установить специальный пакет, который предотвращает загрузку Bower и NPM
пакетов. Смотрите [cebe/assetfree-yii2](https://github.com/cebe/assetfree-yii2) для деталей.

Первая команда устанавливает [composer asset plugin](https://github.com/fxpio/composer-asset-plugin), который позволяет управлять зависимостями пакетов bower и npm через Composer. Даже если вы хотите воспользоваться слоем абстракции баз данных или другими элементами Yii, не связанными с ресурсами, этот плагин все равно придется установить, так как без него не установится пакет Yii.
В разделе [об установке Yii](start-installation.md#installing-via-composer) более подробно описана работа с Composer и даны решения проблем, которые могут возникнуть при установке.

Также можно [скачать](https://www.yiiframework.com/download/) файл релиза Yii и распаковать его в директорию `BasePath/vendor`.

Далее следует изменить входной скрипт сторонней системы, поместив в его начало следующий код:

```php
require __DIR__ . '/../vendor/yiisoft/yii2/Yii.php';

$yiiConfig = require __DIR__ . '/../config/yii/web.php';
new yii\web\Application($yiiConfig); // НЕ ВЫЗЫВАЙТЕ run() в этом месте
```

Как видите, этот код очень похож на код [входного скрипта](structure-entry-scripts.md) типичного приложения Yii. Единственное отличие заключается в том, что после создания экземпляра приложения не вызывается метод `run()`. Это связано с тем, что при вызове `run()` Yii захватывает контроль над процессом обработки запроса, что в данном случае не требуется, так как эту задачу выполняет существующее приложение.

Как и в случае с приложением Yii, нужно настроить экземпляр приложения исходя из окружения запущенной сторонней системы. Например, чтобы воспользоваться функционалом [Active Record](db-active-record.md), нужно передать в [компонент приложения](structure-application-components.md) `db` настройки для подключения к базе данных, которую использует сторонняя система.

Это позволит задействовать большинство функционала, который предоставляет Yii. Например, можно будет создавать классы типа Active Record, и с их помощью взаимодействовать с базой данных.


Использование Yii 2 в связке с Yii 1 <span id="using-both-yii2-yii1"></span>
----------------------

Если в прошлом вам приходилось использовать Yii 1, не исключено, что у вас до сих пор где-то используются приложения на этой платформе. Вместо того, чтобы переписывать все приложение под Yii 2, может быть целесообразно расширить его используя отдельные функции, которые появились в Yii 2.
Для этого нужно выполнить следующие действия.

> Note: Yii 2 требует PHP 5.4 или выше. Убедитесь, что и сервер, и существующее приложение поддерживают это.

Во-первых, установите Yii 2 в существующем приложении, выполняя действия, описанные в [предыдущем подразделе](#using-yii-in-others).

Во-вторых, внесите следующие изменения во входной скрипт приложения:

```php
// подключение модифицированного класса Yii, описанного ниже
require __DIR__ . '/../components/Yii.php';

// настройка приложения Yii 2
$yii2Config = require __DIR__ . '/../config/yii2/web.php';
new yii\web\Application($yii2Config); // НЕ ВЫЗЫВАЙТЕ run()

// настройка приложения Yii 1
$yii1Config = require __DIR__ . '/../config/yii1/main.php';
Yii::createWebApplication($yii1Config)->run();
```

Так как класс `Yii` используется и в Yii 1, и в Yii 2, нужно будет создать его модифицированную версию, обслуживающую обе версии фреймворка.
В приведенном выше коде подключается модифицированный файл класса `Yii` со следующим содержимым:

```php
$yii2path = '/path/to/yii2';
require $yii2path . '/BaseYii.php'; // Yii 2.x

$yii1path = '/path/to/yii1';
require $yii1path . '/YiiBase.php'; // Yii 1.x

class Yii extends \yii\BaseYii
{
    // скопируйте и вставьте код из YiiBase (1.x)
}

Yii::$classMap = include($yii2path . '/classes.php');
// регистрация автозагрузчика Yii 2 через Yii 1
Yii::registerAutoloader(['Yii', 'autoload']);
// создание контейнера внедрения зависимостей
Yii::$container = new yii\di\Container;
```

Вот и все! Теперь в любом месте кода можно с помощью конструкции `Yii::$app` получить доступ к экземпляру приложения Yii 2, а с помощью конструкции `Yii::app()` - к экземпляру приложения Yii 1:


```php
echo get_class(Yii::app()); // выводит 'CWebApplication'
echo get_class(Yii::$app);  // выводит 'yii\web\Application'
```
