Yii とは何か
============

Yii は現代的なウェブ・アプリケーションを迅速に開発するための、高性能な、コンポーネント・ベースの PHP フレームワークです。
Yii という名前 (`イー` すなわち `[ji:]` と発音します) は、中国語では「易」であり、「シンプルかつ進化的」であることを意味します。
また **Yes It Is** のアクロニム (頭字語) であると考えることも出来ます。


Yii は何に適しているか
----------------------

Yii は汎用的なウェブ・プログラミング・フレームワークです。
つまり、あらゆる種類のウェブ・アプリケーションを PHP を使って開発するときに、Yii を使用することが出来ます。
コンポーネント・ベースのアーキテクチャと洗練されたキャッシュ・サポートを有しているため、Yii は大規模なアプリケーション、
たとえば、ポータル、フォーラム、コンテント・マネージメント・システム (CMS)、電子商取引プロジェクト、RESTful ウェブ・サービス、等々を開発するのに特に適しています。


Yii を他のフレームワークと比べると
----------------------------------

あなたが既に他のフレームワークに親しんでいる場合は、Yii を比較するとどうなのかを知りたいでしょう。

- ほとんどの PHP フレームワーク同様、Yii は MVC (Model-View-Controller) アーキテクチャ・パターンを実装し、
  このパターンに基づいたコードの編成を推進しています。
- Yii は、コードはシンプルかつエレガントに書かれるべきである、という哲学を採用しています。
  何らかのデザイン・パターンの厳密な遵守を主目的とする凝りすぎた設計は、Yii が決して試みようとしないものです。
- Yii はフル装備のフレームワークです。
  クエリ・ビルダ、リレーショナル・データベースと NoSQL データベース双方のためのアクティブ・レコード、RESTful API 開発サポート、多層構成のキャッシュ・サポート、
  等々、検証済みで直ちに使える多数の機能を提供します。
- Yii は極めて拡張性の高いフレームワークです。あなたはコアのコードのほとんど全ての要素をカスタマイズしたり置き換えたりすることが出来ます。
  また、Yii の堅固なエクステンション・アーキテクチャを利用して、再配布可能なエクステンションを使用したり開発したりすることも出来ます。
- 高性能であることは常に Yii の主たる目標です。

Yii はワンマン・ショーではありません。Yii は [強力なコア開発チーム](https://www.yiiframework.com/team/) および
Yii 開発に間断なく貢献してくれるプロフェッショナルの大きなコミュニティーに支えられたプロジェクトです。
Yii 開発チームは、最新のウェブ開発の潮流と、他のフレームワークやプロジェクトに見出される最善のプラクティスと機能を、注意深く見守り続けています。
他のところで見出された最善のプラクティスと機能で最も適切なものは、定期的にコア・フレームワークに組み込まれ、
シンプルかつエレガントなインタフェイスを通じて公開されます。


Yii のバージョン
----------------

Yii は現在、利用可能な二つのメジャー・バージョン、すなわち 1.1 と 2.0 を持っています。バージョン 1.1 は古い世代のもので、現在はメンテナンス・モードにあります。
バージョン 2.0 は、最新のテクノロジーとプロトコル、例えば、Composer、PSR、名前空間、トレイトなどを採用して、Yii を完全に書き直したものです。
バージョン 2.0 がこのフレームワークの現世代を表すものであり、今後数年間にわたって主要な開発努力の対象となるものです。
このガイドは主としてバージョン 2.0 について述べます。


必要条件と前提条件
------------------

Yii 2.0 は PHP 7.3.0 以上を必要とし、PHP の最新バージョンで最高の力を発揮します。
個々の機能に対する詳細な必要条件は、全ての Yii リリースに含まれている必要条件チェッカを走らせることによって知ることが出来ます。

Yii を使うためには、オブジェクト指向プログラミング (OOP) の基本的な知識が必要です。
なぜなら、Yii は純粋な OOP ベースのフレームワークだからです。
また、Yii 2.0 は [名前空間](https://www.php.net/manual/ja/language.namespaces.php) や [トレイト](https://www.php.net/manual/ja/language.oop5.traits.php) のような PHP の最新の機能を利用しています。
これらの概念を理解することは、Yii 2.0 を採用することを一層容易にするでしょう。

