'use strict';

/* {[The file is published on the basis of YetiForce Public License 7.0 that can be found in the following directory: licenses/LicenseEN.txt or yetiforce.com]} */"use strict";/**
 * Mass Edit Modal JS class for Vtiger modules.
 */$.Class("Base_MassEditModal_JS",{/** @property {string} massEditPreSave Event name for pre-save hook */massEditPreSave:"Vtiger.MassEdit.PreSave"},{/**
		 * Registers event for tab click to validate form fields before switching tabs.
		 * @returns {void}
		 */registerEventForTabClick:function registerEventForTabClick(){var _this=this;this.form.find(".massEditTabs").on("click","a[data-toggle=\"tab\"]",function(e){_this.form.validationEngine("validate"),0<_this.form.data("jqv").InvalidFields.length&&e.stopPropagation();});},/**
		 * Handles field validation activation/deactivation and related reference fields on row selection.
		 * @returns {void}
		 */postMassEdit:function postMassEdit(){var _this2=this,editInstance=Vtiger_Edit_Js.getInstance();this.container.find(".selectRow").on("change",function(e){var element=$(e.currentTarget),blockElement=element.closest(".js-form-row-container").find(".fieldValue"),fieldElement=blockElement.find("[data-validation-engine],[data-invalid-validation-engine]"),fieldInfo=fieldElement.data("fieldinfo");if(element.prop("checked")?_this2.activeFieldValidation(fieldElement):_this2.inactiveFieldValidation(fieldElement),void 0!==fieldInfo&&"reference"===fieldInfo.type){var mapFields=editInstance.getMappingRelatedField(fieldInfo.name,editInstance.getReferencedModuleName(blockElement),_this2.container);$.each(mapFields,function(key){var checkboxElement=this.container.find("[id=\"selectRow"+key+"\"]");checkboxElement.length&&checkboxElement.prop("disabled")&&(checkboxElement.prop("disabled",!1),checkboxElement.trigger("click"),checkboxElement.prop("disabled",!0));});}}),this.container.find("form").on("submit",function(e){var form=$(e.currentTarget);if("undefined"!=typeof form.data("submit"))return !1;if(form.validationEngine("validate")){if(e.preventDefault(),!form.find("input[id^=\"selectRow\"]:checked").length)return void app.showNotify({text:app.vtranslate("JS_NONE_FIELD_MARKED_IN_MASS_EDIT"),type:"error"});var invalidFields=form.data("jqv").InvalidFields;if(0==invalidFields.length)form.find("[name=\"saveButton\"]").prop("disabled",!0);else return;_this2.saveForm();}else form.removeData("submit"),app.formAlignmentAfterValidation(form);});},/**
		 * Activates validation for a field.
		 * @param {jQuery} field
		 * @returns {void}
		 */activeFieldValidation:function activeFieldValidation(field){var validationVal=field.attr("data-invalid-validation-engine");"undefined"==typeof validationVal||(field.attr("data-validation-engine",validationVal),field.removeAttr("data-invalid-validation-engine"));},/**
		 * Deactivates validation for a field and removes it from invalid fields.
		 * @param {jQuery} field
		 * @returns {void}
		 */inactiveFieldValidation:function inactiveFieldValidation(field){field.validationEngine("hide");var invalidFields=this.form.data("jqv").InvalidFields,fields=[field.get(0)];if(field.attr("data-invalid-validation-engine",field.attr("data-validation-engine")),field.removeAttr("data-validation-engine"),field.is("select")&&field.hasClass("select2")){var selectElement=app.getSelect2ElementFromSelect(field);selectElement.validationEngine("hide"),fields.push(selectElement.get(0));}for(var i in fields){var response=$.inArray(fields[i],invalidFields);"-1"!=response&&invalidFields.splice(response,1);}},/**
		 * Saves the mass edit form after validation and triggers the mass action save.
		 * @returns {void}
		 */saveForm:function saveForm(){var _this3=this,massEditPreSaveEvent=$.Event(Base_MassEditModal_JS.massEditPreSave);if(this.form.trigger(massEditPreSaveEvent),massEditPreSaveEvent.isDefaultPrevented())return void this.form.find("[name=\"saveButton\"]").removeAttr("disabled");switch(this.form.find("[id^=\"selectRow\"]").each(function(_index,checkbox){checkbox=$(checkbox),checkbox.prop("checked")||checkbox.closest(".js-form-row-container").find(".fieldValue [name]").each(function(_index,element){element=$(element),element.attr("data-element-name",element.attr("name")).removeAttr("name");});}),this.container.data("sourceView")){case"List":var listInstance=Vtiger_List_Js.getInstance();listInstance.massActionSave(this.form).done(function(){listInstance.getListViewRecords(),Vtiger_List_Js.clearList();}).fail(function(error,err){app.errorLog(error,err);});break;case"RelationList":this.baseWindow.Vtiger_RelatedList_Js.relatedListInstance.massActionSave(this.form).done(function(){_this3.baseWindow.Vtiger_Detail_Js.reloadRelatedList();}).fail(function(error,err){app.errorLog(error,err);});break;default:}},/**
		 * Deactivates validation for all fields in the form.
		 * This will remove data-validation-engine attr of all the elements.
		 * @returns {void}
		 */inactiveFieldsValidation:function inactiveFieldsValidation(){var form=this.form;form.find(".fieldValue [data-validation-engine][data-fieldinfo]").each(function(_,e){var fieldElement=$(e),fieldInfo=fieldElement.data("fieldinfo");// Not all the fields will be enabled for mass edit
if("reference"==fieldInfo.type?fieldElement=form.find("[name=\""+fieldInfo.name+"_display\"]"):("multipicklist"==fieldInfo.type||"sharedOwner"==fieldInfo.type)&&(fieldElement=form.find("[name=\""+fieldInfo.name+"[]\"]")),0!=fieldElement.length){// Blank validation by default
var elemData=fieldElement.data(),validationVal="validate[]";"validationEngine"in elemData&&(validationVal=elemData.validationEngine,delete elemData.validationEngine),fieldElement.attr("data-invalid-validation-engine",validationVal),fieldElement.removeAttr("data-validation-engine");}});},/**
		 * Registers all necessary events and initializes components for the mass edit modal.
		 *
		 * @param {jQuery} container - The jQuery object representing the modal container element.
		 * @returns {void}
		 */registerEvents:function registerEvents(container){this.container=container,this.form=container.find("form"),this.form.validationEngine(app.validationEngineOptions),this.registerEventForTabClick(),Vtiger_Edit_Js.getInstance().registerBasicEvents(this.form),this.postMassEdit(),app.showScrollBar($("div[name=\"massEditContent\"]"),{height:app.getScreenHeight(70)+"px"}),this.inactiveFieldsValidation();}});
//# sourceMappingURL=MassEditModal.min.js.map
