'use strict';

/* {[The file is published on the basis of YetiForce Public License 7.0 that can be found in the following directory: licenses/LicenseEN.txt or yetiforce.com]} */"use strict";$.Class("Settings_RecordNumbering_Index_Js",{},{form:!1,clipBoardInstances:[],getForm:function getForm(){return !1==this.form&&(this.form=jQuery("#EditView")),this.form},/**
		 * Function to register change event for source module field
		 */registerOnChangeEventOfSourceModule:function registerOnChangeEventOfSourceModule(){var _this=this,editViewForm=this.getForm(),sequenceBtn=editViewForm.find(".js-adavanced-sequence");editViewForm.find("[name=\"sourceModule\"]").on("change",function(e){$(".saveButton").removeAttr("disabled"),sequenceBtn.addClass("d-none"),AppConnector.request({module:app.getModuleName(),parent:app.getParentModuleName(),view:"CustomRecordNumbering",sourceModule:$(e.currentTarget).val()}).done(function(data){data&&($(".js-container").html(data),_this.form=!1,_this.registerEvents());});});},/**
		 * Function to register event for saving module custom numbering
		 */saveModuleCustomNumbering:function saveModuleCustomNumbering(){if(!$(".saveButton").attr("disabled")){var editViewForm=this.getForm(),sourceModule=editViewForm.find("[name=\"sourceModule\"]").val(),prefix=editViewForm.find("[name=\"prefix\"]"),leadingZeros=editViewForm.find("[name=\"leading_zeros\"]").val(),currentPrefix=$.trim(prefix.val()),postfix=editViewForm.find("[name=\"postfix\"]"),currentPostfix=jQuery.trim(postfix.val()),sequenceNumberElement=editViewForm.find("[name=\"sequenceNumber\"]"),sequenceNumber=sequenceNumberElement.val(),oldSequenceNumber=sequenceNumberElement.data("oldSequenceNumber");return sequenceNumber<oldSequenceNumber&&currentPrefix===prefix.data("oldPrefix")&&currentPostfix===postfix.data("oldPostfix")?void sequenceNumberElement.validationEngine("showPrompt",app.vtranslate("JS_SEQUENCE_NUMBER_MESSAGE")+" "+oldSequenceNumber,"error","topLeft",!0):void(editViewForm.find(".saveButton").attr("disabled","disabled"),AppConnector.request({module:app.getModuleName(),parent:app.getParentModuleName(),action:"SaveAjax",mode:"saveModuleCustomNumberingData",sourceModule:sourceModule,prefix:currentPrefix,leading_zeros:leadingZeros,postfix:currentPostfix,sequenceNumber:sequenceNumber,reset_sequence:editViewForm.find("[name=\"reset_sequence\"]").val()}).done(function(data){!0===data.success?Settings_Vtiger_Index_Js.showMessage({text:app.vtranslate("JS_RECORD_NUMBERING_SAVED_SUCCESSFULLY_FOR")+" "+editViewForm.find("option[value=\""+sourceModule+"\"]").text()}):Settings_Vtiger_Index_Js.showMessage({text:currentPrefix+" "+app.vtranslate(data.error.message),type:"error"});}))}},/**
		 * Function to handle update record with the given sequence number
		 */registerEventToUpdateRecordsWithSequenceNumber:function registerEventToUpdateRecordsWithSequenceNumber(){var editViewForm=this.getForm();$("[name=\"updateRecordWithSequenceNumber\"]").off("click").on("click",function(){var sourceModule=editViewForm.find("[name=\"sourceModule\"]").val();AppConnector.request({module:app.getModuleName(),parent:app.getParentModuleName(),action:"SaveAjax",mode:"updateRecordsWithSequenceNumber",sourceModule:sourceModule}).done(function(data){!0===data.success?Settings_Vtiger_Index_Js.showMessage({text:app.vtranslate("JS_RECORD_NUMBERING_UPDATED_SUCCESSFULLY_FOR")+" "+editViewForm.find("option[value=\""+sourceModule+"\"]").text()}):Settings_Vtiger_Index_Js.showMessage(data.error.message);});});},/**
		 * Function to register change event for prefix,postfix,reset_sequence and sequence number
		 */registerChangeEvent:function registerChangeEvent(){this.getForm().find("[name=\"prefix\"],[name=\"leading_zeros\"],[name=\"sequenceNumber\"],[name=\"postfix\"],[name=\"reset_sequence\"]").on("change",this.checkPrefix.bind(this));},registerCopyClipboard:function registerCopyClipboard(editViewForm){for(var i in this.clipBoardInstances)this.clipBoardInstances[i].destroy();this.clipBoardInstances[0]=new ClipboardJS("#customVariableCopy",{text:function text(){return app.showNotify({text:app.vtranslate("JS_NOTIFY_COPY_TEXT"),type:"success"}),"{{"+editViewForm.find("#customVariables").val()+"}}"}}),this.clipBoardInstances[1]=new ClipboardJS("#picklistVariableCopy",{text:function text(){return app.showNotify({text:app.vtranslate("JS_NOTIFY_COPY_TEXT"),type:"success"}),"{{"+editViewForm.find("#picklistVariables").val()+"}}"}}),this.clipBoardInstances[2]=new ClipboardJS("#referenceVariableCopy",{text:function text(){return app.showNotify({text:app.vtranslate("JS_NOTIFY_COPY_TEXT"),type:"success"}),editViewForm.find("#referenceVariables").val()}});},/**
		 * Check if reset sequence appears in prefix or postfix to prevent duplicate number generation
		 * @returns {boolean}
		 */checkPrefix:function checkPrefix(){var sequenceExists=!1,editViewForm=this.getForm(),value=editViewForm.find("[name=\"reset_sequence\"]").val(),prefix=editViewForm.find("[name=\"prefix\"]").val(),postfix=editViewForm.find("[name=\"postfix\"]").val(),saveBtn=editViewForm.find(".saveButton");switch(value){case"Y":-1===prefix.indexOf("{{YY}}")&&-1===prefix.indexOf("{{YYYY}}")&&-1===postfix.indexOf("{{YY}}")&&-1===postfix.indexOf("{{YYYY}}")?(saveBtn.attr("disabled","disabled"),Vtiger_Helper_Js.showMessage({type:"error",text:app.vtranslate("JS_RS_ADD_YEAR_VARIABLE")})):(saveBtn.removeAttr("disabled"),sequenceExists=!0);break;case"M":-1===prefix.indexOf("{{MM}}")&&-1===prefix.indexOf("{{M}}")&&-1===postfix.indexOf("{{MM}}")&&-1===postfix.indexOf("{{M}}")?(saveBtn.attr("disabled","disabled"),Vtiger_Helper_Js.showMessage({type:"error",text:app.vtranslate("JS_RS_ADD_MONTH_VARIABLE")})):(saveBtn.removeAttr("disabled"),sequenceExists=!0);break;case"D":-1===prefix.indexOf("{{DD}}")&&-1===prefix.indexOf("{{D}}")&&-1===postfix.indexOf("{{DD}}")&&-1===postfix.indexOf("{{D}}")?(saveBtn.attr("disabled","disabled"),Vtiger_Helper_Js.showMessage({type:"error",text:app.vtranslate("JS_RS_ADD_DAY_VARIABLE")})):(saveBtn.removeAttr("disabled"),sequenceExists=!0);break;case"X":default:saveBtn.removeAttr("disabled"),sequenceExists=!0;}if(sequenceExists){var regexResult=(postfix+prefix).match(/{{picklist:([a-z0-9_]+)}}/g);regexResult&&1<regexResult.length?(Vtiger_Helper_Js.showMessage({type:"error",text:app.vtranslate("JS_PICKLIST_TOO_MANY")}),sequenceExists=!1,saveBtn.attr("disabled","disabled")):(saveBtn.removeAttr("disabled"),sequenceExists=!0);}return this.checkAdvancedSequenceBtn(),sequenceExists},/**
		 * Function to enable button if prefix or postfix has picklist value
		 */checkAdvancedSequenceBtn:function checkAdvancedSequenceBtn(){var editViewForm=this.getForm(),sequenceBtn=editViewForm.find(".js-adavanced-sequence"),prefix=editViewForm.find("[name=\"prefix\"]").val(),postfix=editViewForm.find("[name=\"postfix\"]").val(),regexResult=(postfix+prefix).match(/{{picklist:([a-z0-9_]+)}}|\$\(relatedRecord/g);regexResult&&1<regexResult.length||!regexResult?sequenceBtn.addClass("d-none"):sequenceBtn.removeClass("d-none");},/**
		 * Function to register event on button
		 */registerAdavancedSequenceEvent:function registerAdavancedSequenceEvent(){var editViewForm=this.getForm(),sequenceBtn=editViewForm.find(".js-adavanced-sequence");sequenceBtn.on("click",function(){var sourceModule=editViewForm.find("[name=\"sourceModule\"]").val(),picklistName="",prefix=editViewForm.find("[name=\"prefix\"]").val(),postfix=editViewForm.find("[name=\"postfix\"]").val(),regex=/{{picklist:([a-z0-9_]+)}}/g;prefix.match(regex)?picklistName=prefix:postfix.match(regex)&&(picklistName=postfix),AppConnector.request({module:app.getModuleName(),parent:app.getParentModuleName(),view:"Advanced",sourceModule:sourceModule,picklist:picklistName}).done(function(data){data&&app.showModalWindow(data,function(container){var modalForm=container.find("form");modalForm.validationEngine(app.validationEngineOptionsForRecord),container.on("click",".js-modal__save",function(){if(modalForm.validationEngine("validate")){var progressIndicatorElement=$.progressIndicator({position:"html",blockInfo:{enabled:!0}});AppConnector.request({module:app.getModuleName(),parent:app.getParentModuleName(),action:"SaveAjax",mode:"saveModuleCustomNumberingAdvanceData",sourceModule:sourceModule,sequenceNumber:modalForm.find(".js-picklist-sequence").serializeFormData()}).done(function(data){progressIndicatorElement.progressIndicator({mode:"hide"}),!0===data.success&&(Settings_Vtiger_Index_Js.showMessage({text:app.vtranslate("JS_RECORD_NUMBERING_SAVED_SUCCESSFULLY_FOR")+" "+editViewForm.find("option[value=\""+sourceModule+"\"]").text()}),app.hideModalWindow());});}});});});});},/**
		 * Function to register events
		 */registerEvents:function registerEvents(){var thisInstance=this,editViewForm=this.getForm();App.Fields.Picklist.showSelect2ElementView(editViewForm.find("select")),this.registerOnChangeEventOfSourceModule(),this.registerEventToUpdateRecordsWithSequenceNumber(),this.registerChangeEvent(),this.checkAdvancedSequenceBtn(),this.registerAdavancedSequenceEvent();var params=app.validationEngineOptions;params.onValidationComplete=function(editViewForm,valid){return valid&&thisInstance.saveModuleCustomNumbering(),!1},editViewForm.validationEngine("detach"),editViewForm.validationEngine("attach",params),this.registerCopyClipboard(editViewForm);}});
//# sourceMappingURL=Index.min.js.map
