'use strict';

/**
 * Business Hours Edit
 *
 * @package     Edit
 *
 * @description Edit scripts for business hours
 * @license     YetiForce Public License 7.0
 * @author      Rafal Pospiech <r.pospiech@yetiforce.com>
 */"use strict";$.Class("Settings_BusinessHours_Edit_Js",{},{/**
		 * Function to register form for validation
		 * @param {jQuery} container
		 */registerFormForValidation:function registerFormForValidation(container){container.validationEngine(app.validationEngineOptions);},/**
		 * Checks that at least one working day has been marked.
		 * @param {jQuery} container
		 */validationCheckWorkingDays:function validationCheckWorkingDays(container){container.on("submit",function(e){container.find("[name=\"working_days[]\"]").is(":checked")||(app.showNotify({text:app.vtranslate("JS_PLEASE_SELECT_ONE_WORKING_DAYS"),type:"error"}),e.preventDefault());});},/**
		 * Function which will handle the registrations for the elements
		 */registerEvents:function registerEvents(){var container=$("#EditView");this.registerFormForValidation(container),app.registerEventForClockPicker(),App.Fields.TimePeriod.register(container),this.validationCheckWorkingDays(container);}});
//# sourceMappingURL=Edit.min.js.map
