<?php

/**
 * OSSMailView DetailView model class.
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 */
class OSSMailView_DetailView_Model extends Vtiger_DetailView_Model
{
	/** {@inheritdoc} */
	public function getDetailViewLinks(array $linkParams): array
	{
		$recordModel = $this->getRecord();
		$linkModelList = parent::getDetailViewLinks($linkParams);
		unset($linkModelList['DETAIL_VIEW_ADDITIONAL']);

		if (!$recordModel->isReadOnly() && \Config\Main::$isActiveSendingMails) {
			$recordId = $recordModel->getId();
			if ('InternalClient' === \App\Mail::getMailComposer()) {
				$popup = \App\User::getCurrentUserModel()->getDetail('mail_popup');
				$url = OSSMail_Module_Model::getComposeUrl();

				$detailViewLinks[] = [
					'linktype' => 'DETAIL_VIEW_ADDITIONAL',
					'linklabel' => '',
					'linkhint' => 'LBL_REPLY',
					'linkdata' => ['url' => $url . '&mid=' . $recordId . '&type=reply', 'popup' => $popup],
					'linkicon' => 'fas fa-reply',
					'linkclass' => 'btn-light btn-sm sendMailBtn',
				];
				$detailViewLinks[] = [
					'linktype' => 'DETAIL_VIEW_ADDITIONAL',
					'linklabel' => '',
					'linkhint' => 'LBL_REPLYALLL',
					'linkdata' => ['url' => $url . '&mid=' . $recordId . '&type=replyAll', 'popup' => $popup],
					'linkicon' => 'fas fa-reply-all',
					'linkclass' => 'btn-light btn-sm sendMailBtn',
				];
				$detailViewLinks[] = [
					'linktype' => 'DETAIL_VIEW_ADDITIONAL',
					'linklabel' => '',
					'linkhint' => 'LBL_FORWARD',
					'linkdata' => ['url' => $url . '&mid=' . $recordId . '&type=forward', 'popup' => $popup],
					'linkicon' => 'fas fa-share',
					'linkclass' => 'btn-light btn-sm sendMailBtn',
				];
			} else {
				$detailViewLinks[] = [
					'linktype' => 'DETAIL_VIEW_ADDITIONAL',
					'linkhref' => true,
					'linklabel' => '',
					'linkhint' => 'LBL_REPLY',
					'linkurl' => OSSMail_Module_Model::getExternalUrlByRecord($recordModel, 'reply', $recordId, $recordModel->getModuleName()),
					'linkicon' => 'fas fa-reply',
					'linkclass' => 'btn-light btn-sm',
				];
				$detailViewLinks[] = [
					'linktype' => 'DETAIL_VIEW_ADDITIONAL',
					'linkhref' => true,
					'linklabel' => '',
					'linkhint' => 'LBL_REPLYALLL',
					'linkurl' => OSSMail_Module_Model::getExternalUrlByRecord($recordModel, 'replyAll', $recordId, $recordModel->getModuleName()),
					'linkicon' => 'fas fa-reply-all',
					'linkclass' => 'btn-light btn-sm',
				];
				$detailViewLinks[] = [
					'linktype' => 'DETAIL_VIEW_ADDITIONAL',
					'linkhref' => true,
					'linklabel' => '',
					'linkhint' => 'LBL_FORWARD',
					'linkurl' => OSSMail_Module_Model::getExternalUrlByRecord($recordModel, 'forward', $recordId, $recordModel->getModuleName()),
					'linkicon' => 'fas fa-share',
					'linkclass' => 'btn-light btn-sm',
				];
			}

			if (\App\Privilege::isPermitted('OSSMailView', 'PrintMail')) {
				$detailViewLinks[] = [
					'linktype' => 'DETAIL_VIEW_ADDITIONAL',
					'linklabel' => '',
					'linkhint' => 'LBL_PRINT',
					'linkurl' => 'javascript:OSSMailView_Detail_Js.printMail();',
					'linkicon' => 'fas fa-print',
					'linkclass' => 'btn-light btn-sm',
				];
			}
			foreach ($detailViewLinks as $detailViewLink) {
				$linkModelList['DETAIL_VIEW_ADDITIONAL'][] = Vtiger_Link_Model::getInstanceFromValues($detailViewLink);
			}
		}
		$linkModelDetailViewList = $linkModelList['DETAIL_VIEW_BASIC'];
		$countOfList = \count($linkModelDetailViewList);
		for ($i = 0; $i < $countOfList; ++$i) {
			$linkModel = $linkModelDetailViewList[$i];
			if ('LBL_DUPLICATE' == $linkModel->get('linklabel')) {
				unset($linkModelList['DETAIL_VIEW_BASIC'][$i]);
				break;
			}
		}
		return $linkModelList;
	}
}
