<?php
/**
 * Mail account notifications file.
 *
 * @package   Cron
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Radosław Skrzypczak <r.skrzypczak@yetiforce.com>
 * @author    Tomasz Kur <t.kur@yetiforce.com>
 * @author    Mariusz Krzaczkowski <m.krzaczkowski@yetiforce.com>
 */

use App\Config;
use App\Db;
use App\Db\Query;
use App\Language;
use App\Mail;
use App\Mail\ScannerLog;
use App\Mailer;

/**
 * Mail account notifications class.
 */
class OSSMailScanner_Notifications_Cron extends \App\CronHandler
{
	/** {@inheritdoc} */
	public function process()
	{
		$duration = Mail::getConfig('scanner', 'time_for_notification');
		$email = Mail::getConfig('scanner', 'email_for_notification');
		if (!$duration || !$email) {
			return false;
		}
		$dbCommand = Db::getInstance()->createCommand();
		$dataReader = (new Query())->from('vtiger_ossmails_logs')->where(['status' => ScannerLog::STATUS_RUNNING])->createCommand()->query();
		while ($row = $dataReader->read()) {
			$startTime = strtotime($row['start_time']);
			if (strtotime('now') > $startTime + ($duration * 60)
			&& !(new Query())->from('vtiger_ossmailscanner_log_cron')->where(['laststart' => $startTime])->exists()) {
				$dbCommand->insert('vtiger_ossmailscanner_log_cron', ['laststart' => $startTime, 'status' => 0, 'created_time' => date('Y-m-d H:i:s')])->execute();
				$url = Config::main('site_URL');
				$mailStatus = Mailer::addMail([
					'to' => $email,
					'subject' => Language::translate('Email_FromName', 'OSSMailScanner'),
					'content' => Language::translate('Email_Body', 'OSSMailScanner') . "\r\n<br><a href='{$url}'>{$url}</a>",
				]);
				$dbCommand->update('vtiger_ossmailscanner_log_cron', ['status' => (int) $mailStatus], ['laststart' => $startTime])->execute();
			}
		}
		$dataReader->close();
	}
}
