<?php
/**
 * Mail Scanner bind email action.
 *
 * @package Model
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Mariusz Krzaczkowski <m.krzaczkowski@yetiforce.com>
 * @author    Radosław Skrzypczak <r.skrzypczak@yetiforce.com>
 */

/**
 * Mail Scanner bind email action.
 */
class OSSMail_Mail_Model extends \App\Base
{
	/** @var string[] Ignored mail addresses */
	public const IGNORED_MAILS = ['@', 'undisclosed-recipients',  'Undisclosed-recipients', 'undisclosed-recipients@', 'Undisclosed-recipients@', 'Undisclosed recipients@,@', 'undisclosed recipients@,@'];

	/** @var array Mail account. */
	protected $mailAccount = [];

	/** @var string Mail folder. */
	protected $mailFolder = '';

	/** @var bool|int Mail crm id. */
	protected $mailCrmId = false;

	/** @var array Action result. */
	protected $actionResult = [];

	/** @var int Mail type. */
	protected $mailType;

	/**
	 * Set account.
	 *
	 * @param array $account
	 */
	public function setAccount($account)
	{
		$this->mailAccount = $account;
	}

	/**
	 * Set folder.
	 *
	 * @param string $folder
	 */
	public function setFolder($folder)
	{
		$this->mailFolder = $folder;
	}

	/**
	 * Add action result.
	 *
	 * @param string $type
	 * @param string $result
	 */
	public function addActionResult($type, $result)
	{
		$this->actionResult[$type] = $result;
	}

	/**
	 * Get account.
	 *
	 * @return array
	 */
	public function getAccount()
	{
		return $this->mailAccount;
	}

	/**
	 * Get folder.
	 *
	 * @return string
	 */
	public function getFolder()
	{
		return $this->mailFolder;
	}

	/**
	 * Get action result.
	 *
	 * @param string $action
	 *
	 * @return array
	 */
	public function getActionResult($action = false)
	{
		if ($action && isset($this->actionResult[$action])) {
			return $this->actionResult[$action];
		}
		return $this->actionResult;
	}

	/**
	 * Find email user.
	 *
	 * @param string $emails
	 *
	 * @return bool
	 */
	public static function findEmailUser($emails)
	{
		$notFound = null;
		if (!empty($emails)) {
			$notFound = 0;
			foreach (explode(',', $emails) as $email) {
				if (!\Users_Module_Model::checkMailExist($email)) {
					++$notFound;
				}
			}
		}
		return 0 === $notFound;
	}

	/**
	 * Generation crm unique id.
	 *
	 * @return string
	 */
	public function getUniqueId()
	{
		if ($this->has('cid')) {
			return $this->get('cid');
		}
		$uid = hash('sha256', $this->get('from_email') . '|' . $this->get('date') . '|' . $this->get('subject') . '|' . $this->get('message_id'));
		$this->set('cid', $uid);
		return $uid;
	}

	/**
	 * Set mail crm id.
	 *
	 * @param int $id
	 */
	public function setMailCrmId($id)
	{
		$this->mailCrmId = $id;
	}

	/**
	 * Get email.
	 *
	 * @param string $cacheKey
	 *
	 * @return string
	 */
	public function getEmail($cacheKey)
	{
		$header = $this->get('header');
		$text = '';
		if (property_exists($header, $cacheKey)) {
			$text = $header->{$cacheKey};
		}
		$return = '';
		if (\is_array($text)) {
			foreach ($text as $row) {
				if ('' != $return) {
					$return .= ',';
				}
				$return .= $row->mailbox . '@' . $row->host;
			}
		}
		return $return;
	}

	/**
	 * Post process function.
	 */
	public function postProcess()
	{
	}
}
