<?php

/**
 * OSSMail ImportMail action class.
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 */

use App\Mail\Account;
use App\Mail\Account\Repository\AutologinRepository;
use App\Mail\Scanner;
use App\User;

class OSSMail_ImportMail_Action extends \App\Controller\Action
{
	/**
	 * Function to check permission.
	 *
	 * @param \App\Request $request
	 *
	 * @throws \App\Exceptions\NoPermitted
	 */
	public function checkPermission(App\Request $request)
	{
		$usersPrivilegesModel = Users_Privileges_Model::getCurrentUserPrivilegesModel();
		if (!$usersPrivilegesModel->hasModulePermission($request->getModule()) || !$usersPrivilegesModel->hasModuleActionPermission('OSSMailView', 'CreateView')) {
			throw new \App\Exceptions\NoPermitted('LBL_PERMISSION_DENIED', 406);
		}
	}

	/**
	 * Process.
	 *
	 * @param \App\Request $request
	 *
	 * @throws \App\Exceptions\IllegalValue
	 * @throws \App\Exceptions\NoPermitted
	 *
	 * @return bool|void
	 */
	public function process(App\Request $request)
	{
		$userId = User::getCurrentUserId();
		$userRealId = User::getCurrentUserRealId();
		$uid = $request->getInteger('uid');
		$entity = OSSMail_Record_Model::getAccountByHash($request->getForSql('rcId'));
		$repository = new AutologinRepository();
		$record = 0;

		if (!$entity || !(\in_array($userId, $repository->findById($entity->getId())) || ($entity->isPrivate() && $userRealId === $entity->getOwnerId()))) {
			throw new \App\Exceptions\NoPermitted('LBL_PERMISSION_DENIED', 406);
		}
		$folderDecode = \App\Utils::convertCharacterEncoding($request->getRaw('folder'), 'UTF7-IMAP', 'UTF-8');
		$folderDecode = \App\Purifier::purifyByType($folderDecode, 'Text');
		$folderDecode = \App\Purifier::decodeHtml($folderDecode);

		$mailAccount = new Account($entity);
		$imap = $mailAccount->openImap();
		$message = $imap->getMessageByUid($folderDecode, $uid);

		if (null !== $message) {
			$scanner = (new Scanner())->setLimit(1);
			$actions = $mailAccount->getActions() ?: ['CreatedMail'];
			if (!\in_array('CreatedMail', $actions)) {
				array_unshift($actions, 'CreatedMail');
			}
			foreach ($actions as $action) {
				$scanner->getAction($action)->setAccount($mailAccount)->setMessage($message)->process();
			}
			$record = (int) $message->getProcessData('CreatedMail')['mailViewId'] ?? 0;
		} 

		$response = new Vtiger_Response();
		$response->setResult($record);
		$response->emit();
	}
}
