<?php
/**
 * Sanitize report data
 *
 * @package App
 *
 * @copyright YetiForce S.A.
 * @license YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author Leszek Koziatek <l.koziatek@yetiforce.com>
 */
declare(strict_types=1);

namespace App\Report\Sanitizer;

use App\Report\Model\Query;

/** ReportSanitizer interface class */
interface ReportSanitizer
{
	/**
	 * Sanitize data before export
	 *
	 * @return array<string|int|null> sanitized and parsed data
	 */
	public function sanitize(Query $query, array $data = []): array;
}
