<?php

/**
 * Field type interface.
 *
 * @package App
 *
 * @copyright YetiForce S.A.
 * @license YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author Łukasz Krawczyk <l.krawczyk@yetiforce.com>
 */
declare(strict_types=1);

namespace App\Report\Model;

use App\Report\Enums\FieldType;

/** Field interface */
interface Field
{
	/** Get FieldType object */
	public function getType(): ?FieldType;

	/** Get Yetiforce field model */
	public function getNativeModel(): object;

	/** Get UIType field model */
	public function getUITypeModel(): object;
}
