<?php
/**
 * Mail Entity interface file.
 *
 * @package App
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Radosław Skrzypczak <r.skrzypczak@yetiforce.com>
 */
declare(strict_types=1);

namespace App\Mail\Account\Entity;

use App\Mail\Server;

/**
 * Mail Entity interface.
 */
interface EntityInterface
{
	public function get(string $key): mixed;

	public function getId(): ?int;

	public function getLogin(): string;

	public function getServer(): Server;

	public function getPassword(): string;

	public function setPassword(#[\SensitiveParameter] string $token);

	public function setExpireTime(string $expireTime): self;

	public function getRefreshToken(): string;
}
