<?php

/**
 * Plugin file to prevent cleaning of some tags.
 *
 * @package App
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Radosław Skrzypczak <r.skrzypczak@yetiforce.com>
 */

namespace App\Extension\HTMLPurifier;

/**
 * Plugin class to prevent cleaning of some tags.
 */
class TextFilter extends \HTMLPurifier_Filter
{
	/** {@inheritdoc} */
	public $name = 'TextFilter';

	/**
	 * Added to prevent removing some tags like <j.doe@example.com>
	 * {@inheritdoc}
	 */
	public function preFilter($html, $config, $context)
	{
		if (!\is_string($html)) {
			return $html;
		}
		$pattern = '/(<([a-zA-Z0-9\s@._+]+)[^>]*>.*?<\/\2\s*>)|(<([a-zA-Z0-9\s@._+-]+)>)/si';
		return preg_replace_callback($pattern, static function ($matches) {
			$result = $matches[0];
			if (empty($matches[1])) {
				$inner = $matches[4] ?? '';
				if (preg_match('/^[a-zA-Z0-9\s@._+-]+$/', $inner) && '' !== $inner) {
					$result = '&lt;' . $inner . '&gt;';
				}
			}
			return $result;
		}, $html);
	}
}
