<?php

declare(strict_types=1);

namespace App\Cli;

interface CliInterface
{
	/**
	 * Get module name.
	 *
	 * @return string
	 */
	public function getModuleName(): string;

	/**
	 * Is help mode.
	 *
	 * @return bool
	 */
	public function isHelpMode(): bool;

	/**
	 * Set help mode.
	 *
	 * @param bool $helpMode
	 *
	 * @return self
	 */
	public function setHelpMode(bool $helpMode): self;

	/**
	 * Get CLI methods.
	 *
	 * @return array
	 */
	public function getMethods(): array;

	/**
	 * Return to section's action list.
	 * @return void
	 */
	public function returnToActionList(): void;
}
