from urllib.parse import urlparse, ParseResult


def parse(domain: str, scheme: str = 'http') -> str:
    """
    Convert domain name to 'http://www.domain.com' format
    """
    # https://stackoverflow.com/questions/21659044/how-can-i-prepend-http-to-a-url-if-it-doesnt-begin-with-http
    p = urlparse(domain, 'http')
    netloc = p.netloc or p.path
    path = p.path if p.netloc else ''
    p = ParseResult(p.scheme, netloc, path, *p[3:])
    return p.geturl()
