#!/opt/cloudlinux/venv/bin/python3 -bb
# coding=utf-8
#
# Copyright © Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2020 All Rights Reserved
#
# Licensed under CLOUD LINUX LICENSE AGREEMENT
# http://cloudlinux.com/docs/LICENCE.TXT
#
import platform
from wmt.common.exceptions import WmtServiceControlException
from wmt.common.utils import disable_wmt_daemon, enable_wmt_daemon


def set_service_state(service_name, action):
    _is_cl6 = 'el6' in platform.release()
    if not _is_cl6:
        service_name = service_name + '.service'
    try:
        if action == 'start':
            enable_wmt_daemon(service_name, _is_cl6)
        elif action == 'stop':
            disable_wmt_daemon(service_name, _is_cl6)
    except Exception as e:
        raise WmtServiceControlException(service_name, str(e))
