#!/opt/cloudlinux/venv/bin/python3

from clcommon import FormattedException


class WmtServiceControlException(FormattedException):

    def __init__(self, service_name, reason):
        super().__init__({
            'message': 'Error while handling service %(service_name)s: %(reason)s',
            'context': {
                'service_name': service_name,
                'reason': reason
            }
        })


class WmtConfigException(FormattedException):

    def __init__(self, reason):
        super().__init__({
            'message': 'Error while handling config file: %(reason)s',
            'context': {
                'reason': reason
            }
        })


class WmtEmailException(FormattedException):
    def __init__(self, reason):
        super().__init__({
            'message': 'Error managing email notification: %(reason)s',
            'context': {
                'reason': reason
            }
        })
