<?php

/**
 * webtrees: online genealogy
 * Copyright (C) 2025 webtrees development team
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 */

declare(strict_types=1);

namespace Fisharebest\Webtrees\Elements;

use Fisharebest\Webtrees\I18N;

use function is_int;

/**
 * GOV ID, for TYPE_OF_LOCATION
 */
class GovIdType extends AbstractElement
{
    /**
     * A list of controlled values for this element
     *
     * @return array<int|string,string>
     */
    public function values(): array
    {
        $values = [
            ''  => '',
            1   => 'Amt',
            2   => 'Amtsbezirk',
            3   => 'Magistrates’ Court',
            4   => 'Bauerschaft',
            5   => 'district',
            6   => 'diocese',
            7   => 'federal state',
            8   => 'castle',
            9   => 'deanery',
            10  => 'Departement',
            11  => 'diocese',
            12  => 'Dompfarrei',
            13  => 'filial church',
            14  => 'Flecken',
            15  => 'field name',
            16  => 'free state',
            17  => 'building',
            18  => 'municipality',
            19  => 'Gerichtsbezirk',
            20  => 'countship',
            21  => 'manor (building)',
            22  => 'dominion',
            23  => 'duchy',
            24  => 'Farm',
            25  => 'canton',
            26  => 'church',
            27  => 'Kirchenkreis',
            28  => 'Kirchenprovinz',
            29  => 'parish',
            30  => 'monastery (building)',
            31  => 'kingdom',
            32  => 'county (generic)',
            33  => 'electorate',
            34  => 'state',
            35  => 'national church',
            36  => 'rural county (rural)',
            37  => 'Oberamt',
            38  => 'oblast',
            39  => 'place',
            40  => 'part of place',
            41  => 'Pfarr-Rektorat',
            42  => 'parish',
            43  => 'Pfarrkuratie',
            44  => 'Pfarrverband',
            45  => 'province',
            46  => 'administrative district',
            47  => 'historical region',
            48  => 'Samtgemeinde',
            49  => 'sprengel',
            50  => 'country',
            51  => 'town',
            52  => 'borough',
            53  => 'urban county (city)',
            54  => 'part of town',
            55  => 'village',
            56  => 'republic',
            57  => 'Amt',
            58  => 'union republic',
            59  => 'voivodship',
            60  => 'principality',
            61  => 'grand duchy',
            62  => 'margravate',
            63  => 'rayon',
            64  => 'Vorwerk',
            65  => 'Pfarrdorf',
            66  => 'village',
            67  => 'solitude',
            68  => 'Hauptort',
            69  => 'hamlet',
            70  => 'bailiwick',
            71  => 'confederation',
            72  => 'people’s republic',
            73  => 'Landdrostei',
            74  => 'deprecated',
            75  => 'Güterdistrikt',
            76  => 'Adeliges Gut',
            77  => 'Reichskreis',
            78  => 'Amt(administrative division)',
            79  => 'hundred',
            80  => 'Landschaft',
            81  => 'monastery',
            82  => 'Domkapitel',
            83  => 'Hanseatic city',
            84  => 'Kirchspielvogtei',
            85  => 'rural municipality',
            86  => 'part province',
            87  => 'mill',
            88  => 'Judet',
            89  => 'cemetery',
            90  => 'abandoned place',
            91  => 'Bistumsregion',
            92  => 'Kirchengemeinde',
            93  => 'Reichsstadt',
            94  => 'Verwaltungsgemeinschaft',
            95  => 'county - level city',
            96  => 'archbishopric',
            97  => 'Bürgermeisterei',
            98  => 'veraltet',
            99  => 'captaincy',
            100 => 'Kreishauptmannschaft',
            101 => 'Kreisdirektion',
            102 => 'forester’s house',
            103 => 'civil registry',
            104 => 'veraltet',
            105 => 'Landgericht',
            107 => 'island',
            108 => 'Gutsbezirk',
            109 => 'Forstgutsbezirk',
            110 => 'district office',
            111 => 'Schloss',
            112 => 'Gespanschaft',
            113 => 'comitatus',
            114 => 'Vest',
            115 => 'forestry',
            116 => 'Oberförsterei',
            117 => 'Unterförsterei',
            118 => 'train station',
            119 => 'stop station',
            120 => 'settlement',
            121 => 'colony',
            122 => 'Verbandsgemeinde',
            124 => 'Abbey',
            125 => 'imperial abbey',
            126 => 'Syssel',
            127 => 'Verwaltungsverband',
            128 => 'Landgrafschaft',
            129 => 'settlement',
            130 => 'state',
            131 => 'Weichbild',
            133 => 'region',
            134 => 'arrondissement',
            135 => 'canton',
            136 => 'commune',
            137 => 'region',
            138 => 'Oberlandratsbezirk',
            139 => 'Einschicht',
            140 => 'Einheitsgemeinde',
            142 => 'Reichsgau',
            143 => 'kommune',
            144 => 'Ortschaft',
            145 => 'Markt',
            146 => 'Bezirkshauptmannschaft',
            147 => 'veraltet',
            148 => 'Erfüllende Gemeinde',
            149 => 'Landratsamt',
            150 => 'Stadt',
            151 => 'Oberlandesgericht',
            152 => 'Landbürgermeisterei',
            153 => 'Kommissariat',
            154 => 'Honschaft',
            155 => 'region',
            156 => 'Gemeindebezirk',
            157 => 'Guberniya',
            158 => 'Gemeindeteil',
            159 => 'Khutor',
            160 => 'soviet republic',
            161 => 'Verwaltungsbezirk',
            162 => 'Stadt - und Landgemeinde',
            163 => 'Ortsgemeinde',
            164 => 'Ortsbezirk',
            165 => 'Gnotschaft',
            166 => 'ruins',
            167 => 'mandate territory',
            168 => 'Provinz',
            169 => 'Gemeinde',
            170 => 'district',
            171 => 'Stadthauptmannschaft',
            172 => 'Katastralgemeinde',
            173 => 'Reichskommissariat',
            174 => 'general district',
            175 => 'Kreisgebiet',
            176 => 'protectorate',
            177 => 'Reichsritterschaft',
            178 => 'Ritterkanton',
            179 => 'Ritterkreis',
            180 => 'Marktgemeinde',
            181 => 'Rotte',
            182 => 'Erzstift',
            183 => 'Hochstift',
            184 => 'Kammerschreiberei',
            185 => 'Klosteramt',
            186 => 'Rentkammer',
            187 => 'zu überprüfen',
            188 => 'Ritterorden',
            189 => 'Großpriorat',
            190 => 'Ballei',
            191 => 'Kommende',
            192 => 'zone of occupation',
            193 => 'Alm',
            194 => 'Distrikts - Amt',
            195 => 'veraltet',
            196 => 'veraltet',
            197 => '',
            198 => 'veraltet(früher: Bundesverwaltungsgericht)',
            199 => 'veraltet(früher: Landesverwaltungsgericht)',
            200 => 'veraltet(früher: Verwaltungsgericht)',
            201 => 'Landeskommissarbezirk',
            202 => 'Amtsgerichtsbezirk',
            203 => 'Domanialamt',
            204 => 'Ritterschaftliches Amt',
            205 => 'selsoviet',
            206 => 'Regionalkirchenamt',
            207 => 'Oberamtsbezirk',
            210 => 'Kirchenbund',
            211 => 'Landgebiet',
            212 => 'Landherrenschaft',
            213 => 'gorsoviet',
            214 => 'realm',
            215 => 'Reichshälfte',
            216 => 'Landesteil',
            217 => 'Direktionsbezirk',
            218 => 'Stadt',
            219 => 'Expositur',
            221 => 'Fylke',
            222 => 'Kreis',
            223 => 'Landgericht',
            224 => 'Pfleggericht',
            225 => 'Rentamt',
            226 => 'Obmannschaft',
            227 => 'Kirchspielslandgemeinde',
            228 => 'Gerichtsamt',
            229 => 'group of houses',
            230 => 'scattered settlement',
            231 => 'Höfe',
            232 => 'Randort',
            233 => 'Flecken',
            234 => 'borough',
            235 => 'unitary authority',
            236 => 'houses',
            237 => 'Siedlungsrat',
            238 => 'urban - type settlement',
            239 => 'Verwaltungsamt',
            240 => 'uyezd',
            241 => 'Volost',
            242 => 'Katasteramt',
            243 => 'Propstei',
            244 => 'Nebenkirche',
            245 => 'chapel',
            246 => 'Gromada',
            247 => 'Ortsteil',
            248 => 'Schulzenamt',
            249 => 'Erzbischöfliches Amt',
            250 => 'Apostolische Administratur',
            251 => 'autonome Gemeinschaft',
            252 => 'local government',
            253 => 'religious organization',
            254 => 'Okrug',
            255 => 'Stadtgut',
            256 => 'Landesbezirk',
            257 => 'Landgemeinde PL',
            258 => 'Stadtgemeinde',
            259 => 'Landvogteibezirk',
            260 => 'Delegaturbezirk',
            261 => 'Hofschaft',
            262 => 'Stadtteil',
            263 => 'Sprengel',
            264 => 'Mairie',
            265 => 'sultanate',
            266 => 'Landratsbezirk',
            267 => 'sognekommune',
            268 => 'Großgemeinde',
            269 => 'Kleingemeinde',
            270 => 'Bezirk',
            271 => 'Stadt mit Munizipium',
            272 => 'Königliche Freistadt',
            273 => 'Stadt mit geordnetem Magistrate',
            274 => 'unincorporated area',
            275 => 'Stadtgemeinde',
            276 => 'Hardesvogtei',
        ];

        array_walk($values, static function (string &$value, $key): void {
            if (is_int($key)) {
                $value .= ' — ' . I18N::number($key);
            }
        });

        return $values;
    }
}
