<?php

class siteCustomCta2BlockType extends siteBlockType {
    /** @var array Элементы основного блока */
    public array $elements = [
        'main'    => 'site-block-columns',
        'wrapper' => 'site-block-columns-wrapper',
    ];

    /** @var array Элементы колонок */
    public array $column_elements = [
        'main'    => 'site-block-column',
        'wrapper' => 'site-block-column-wrapper',
    ];

    public function __construct(array $options = []) {
        if (!isset($options['columns']) || !wa_is_int($options['columns'])) {
            $options['columns'] = 1;
        }
        $options['type'] = 'site.CustomCta2';
        parent::__construct($options);
    }

    public function getExampleBlockData(): siteBlockData {
        // Создаём основной блок
        $result = $this->getEmptyBlockData();

        // Создаём горизонтальную последовательность
        $hseq = $this->createSequence(true, 'only_columns', true);

        // Добавляем последовательности в основной блок
        foreach ($this->getColumnData() as $item) {
            $hseq->addChild($this->getColumn($item));
        }

        $result->addChild($hseq, '');

        // Настраиваем свойства основного блока
        $result->data = [
            'block_props'   => [
                $this->elements['main']    => [
                    'background' => [
                        'layers' => [
                            [
                                'name' => 'grey shades',
                                'type' => 'palette',
                                'value' => 'bg-bw-7',
                            ],
                        ],
                        'name' => 'grey shades',
                        'type' => 'palette',
                        'value' => 'bg-bw-7',
                    ],
                    'padding-bottom' => 'p-b-20',
                    'padding-left' => 'p-l-blc',
                    'padding-right' => 'p-r-blc',
                    'padding-top' => 'p-t-20',
                ],
                $this->elements['wrapper'] => [
                    'flex-align' => 'y-c',
                    'max-width' => 'cnt',
                ],
            ],
            'wrapper_props' => [
                'justify-align' => 'y-j-cnt',
            ],
            'elements'      => $this->elements,
        ];

        return $result;
    }

    public function render(siteBlockData $data, bool $is_backend, array $tmpl_vars = []) {
        return parent::render($data, $is_backend, $tmpl_vars + [
                'children' => array_reduce($data->getRenderedChildren($is_backend), 'array_merge', []),
            ]);
    }

    public function getRawBlockSettingsFormConfig() {
        return [
                'type_name'    => _w('Block'),
                'type_name_original'    => _w('Banner'),
                'sections'     => [
                    [
                        'type' => 'ColumnsGroup',
                        'name' => _w('Columns'),
                    ],
                    [
                        'type' => 'RowsAlignGroup',
                        'name' => _w('Columns alignment'),
                    ],
                    [
                        'type' => 'RowsWrapGroup',
                        'name' => _w('Wrap line'),
                    ],
                    [
                        'type' => 'TabsWrapperGroup',
                        'name' => _w('Tabs'),
                    ],
                    [   'type' => 'CommonLinkGroup',
                        'name' => _w('Link or action'),
                        'is_hidden' => true,
                    ],
                    [
                        'type' => 'MaxWidthToggleGroup',
                        'name' => _w('Max width'),
                    ],
                    [
                        'type' => 'BackgroundColorGroup',
                        'name' => _w('Background'),
                    ],
                    [   'type' => 'HeightGroup',
                        'name' => _w('Height'),
                    ],
                    [
                        'type' => 'PaddingGroup',
                        'name' => _w('Padding'),
                    ],
                    [
                        'type' => 'MarginGroup',
                        'name' => _w('Margin'),
                    ],
                    [
                        'type' => 'BorderGroup',
                        'name' => _w('Border'),
                    ],
                    [
                        'type' => 'BorderRadiusGroup',
                        'name' => _w('Angle'),
                    ],
                    [
                        'type' => 'ShadowsGroup',
                        'name' => _w('Shadows'),
                    ],
                    [
                        'type' => 'IdGroup',
                        'name' => _w('Identifier (ID)'),
                    ],
                ],
                'elements'     => $this->elements,
                'semi_headers' => [
                    'main'    => _w('Whole block'),
                    'wrapper' => _w('Container'),
                ],
            ] + parent::getRawBlockSettingsFormConfig();
    }


    /**
     * Получает колонку с заголовком
     *
     * @return siteBlockData
     */
    public function getColumn($column_data): siteBlockData {
        $vseq = $this->createSequence();

        $vseq->addChild($this->createRow([
            'block_props' => [
                'padding-top' => 'p-t-8',
            ],
            'wrapper_props' => [
                'justify-align' => 'j-s',
            ],
        ], [$this->getIcon($column_data['icon'], $column_data['mt']), $this->getTitle($column_data['title'])]));

        $vseq->addChild($this->getText($column_data['text']));
        $vseq->addChild($this->getBtn($column_data['btn']));

        $block_props = [
            $this->column_elements['main']    => [
                'padding-bottom' => 'p-b-14',
                'padding-left' => 'p-l-clm',
                'padding-right' => 'p-r-clm',
                'padding-top' => 'p-t-14',
            ],
            $this->column_elements['wrapper'] => [
                'flex-align' => 'y-c',
                'padding-bottom' => 'p-b-12',
                'padding-left' => 'p-l-14',
                'padding-right' => 'p-r-14',
                'padding-top' => 'p-t-12',
                'border-radius' => 'b-r-l',
                'border-radius-corners' => [
                    'type' => 'separate',
                    'value' => '',
                ],
                'background' => [
                    'name' => 'black and white',
                    'type' => 'palette',
                    'value' => 'bg-wh',
                    'layers' => [
                        [
                            'name' => 'black and white',
                            'type' => 'palette',
                            'value' => 'bg-wh',
                        ],
                    ],
                ],
            ],
        ];

        $inline_props = [
            $this->column_elements['wrapper'] => [
                'min-height' => [
                    'name' => 'Parent height',
                    'type' => 'parent',
                    'value' => '100%',
                ],
            ],
        ];

        return $this->createColumn(
            [
                'column'        => "st-6 st-6-lp st-12-mb st-12-tb",
                'block_props'   => $block_props,
                'inline_props'  => $inline_props,
            ],
            $vseq
        );
    }

    private function getText($text) {
        $paragraph = (new siteParagraphBlockType())->getEmptyBlockData();

        $paragraph->data = [
            'html'        => '<font color="" class="tx-bw-3">'.$text.'</font>',
            'tag'         => 'p',
            'block_props' => [
                'align'         => 't-l',
                'font-header'   => 't-rgl',
                'font-size'     => ['name' => 'Size #6', 'value' => 't-6', 'unit' => 'px', 'type' => 'library'],
                'margin-bottom' => 'm-b-16',
                'margin-top'    => 'm-t-0',
            ],
        ];

        return $paragraph;
    }

    private function getTitle($text) {
        $header = (new siteHeadingBlockType())->getEmptyBlockData();

        $header->data = [
            'html'        => '<font color="" class="tx-bw-1">'.$text.'</font>',
            'tag'         => 'h3',
            'block_props' => [
                'align'         => 't-l',
                'font-header'   => 't-hdn',
                'font-size'     => ['name' => 'Size #5', 'value' => 't-5', 'unit' => 'px', 'type' => 'library'],
                'margin-bottom' => 'm-b-12',
                'margin-top'    => 'm-t-0',
            ],
        ];

        return $header;
    }

    private function getBtn($data) {
        $button = (new siteButtonBlockType())->getEmptyBlockData();

        $button->data = [
            'html'        => $data['text'],
            'tag'         => 'a',
            'block_props' => [
                'border-radius' => 'b-r-r',
                'button-size'   => "inp-m p-l-13 p-r-13",
                'button-style'  => $data['style'],
                'margin-bottom' => 'm-b-8',
                'margin-top' => 'm-t-a',
            ],
        ];

        return $button;
    }

    /**
     * Создаёт последовательность блоков
     *
     * @param bool   $is_horizontal
     * @param string $complex_type
     * @param bool   $indestructible
     * @return siteBlockData
     */
    private function createSequence(bool $is_horizontal = false, string $complex_type = 'with_row', bool $indestructible = false): siteBlockData {
        $seq = (new siteVerticalSequenceBlockType())->getEmptyBlockData();
        $seq->data['is_horizontal'] = $is_horizontal;
        $seq->data['is_complex'] = $complex_type;

        if ($indestructible) {
            $seq->data['indestructible'] = true;
        }

        return $seq;
    }

    /**
     * Создаёт колонку с настройками
     *
     * @param array         $params
     * @param siteBlockData $content
     * @return siteBlockData
     */
    private function createColumn(array $params, siteBlockData $content): siteBlockData {
        $column = (new siteColumnBlockType())->getEmptyBlockData();

        $column->data = [
            'elements'      => $this->column_elements,
            'column'        => $params['column'] ?? 'st-12 st-12-lp st-12-tb st-12-mb',
            'block_props'   => $params['block_props'] ?? [],
            'wrapper_props' => $params['wrapper_props'] ?? [],
            'inline_props'  => $params['inline_props'] ?? [],
        ];

        $column->addChild($content, '');

        return $column;
    }

    /**
     * Создаёт ряд блоков
     *
     * @param array $props
     * @param array $content
     * @return siteBlockData
     */

     private function createRow(array $props, array $content): siteBlockData {
        $row = (new siteRowBlockType())->getExampleBlockData();
        $row->data['block_props'] = $props['block_props'] ?? [];
        $row->data['wrapper_props'] = $props['wrapper_props'] ?? [];

        $hseq = reset($row->children['']);

        foreach ($content as $item) {
            $hseq->addChild($item);
        }

        return $row;
    }

    private function getIcon(string $svg_html, $mt = ''): siteBlockData {
        $icon = (new siteImageBlockType())->getEmptyBlockData();

        $icon->data = [
            'image'       => [
                'type'     => 'svg',
                'fill'     => 'removed',
                'svg_html' => $svg_html,
                'color' => [
                    'name' => 'Palette',
                    'type' => 'palette',
                    'value' => 'tx-bw-1',
                ],
            ],
            'block_props' => [
                'margin-top' => $mt,
                'margin-bottom' => 'm-b-8',
                'margin-right' => 'm-r-12',
                'picture-size' => 'i-m',
            ],
        ];

        return $icon;
    }

    private function getColumnData(): array {
        return [
            [
                'icon' => '<svg xmlns="http://www.w3.org/2000/svg" width="27" height="27" viewBox="0 0 27 27" fill="var(--bw-1)">
<path d="M6.45469 0.756648C6.51669 0.760964 6.57846 0.767432 6.6373 0.777156C6.7221 0.791194 6.81405 0.813781 6.89805 0.851376L6.9791 0.894345L6.98008 0.895321L7.09922 0.968564C7.13949 0.993308 7.18195 1.01973 7.22422 1.04669L7.40879 1.17267C7.84849 1.49178 8.35375 1.98433 8.83164 2.48322C9.10741 2.77113 9.37894 3.06689 9.62949 3.34065C9.88109 3.61555 10.1106 3.86712 10.3043 4.07112L10.7018 4.47445C11.0448 4.81457 11.4091 5.1681 11.7242 5.55258L11.9068 5.78696L11.9537 5.85922C12.0547 6.03045 12.0992 6.23106 12.1285 6.36509L12.1773 6.64438C12.2572 7.27753 12.1108 7.78863 11.8424 8.24498L11.7242 8.43053C11.6002 8.61355 11.4581 8.79003 11.3072 8.96276L10.6842 9.6444C10.5904 9.74753 10.4956 9.84617 10.4029 9.95495C10.357 10.0089 10.3151 10.0608 10.2799 10.1102L10.1939 10.2509C10.1375 10.3648 10.1226 10.5534 10.15 10.7928C10.1764 11.0229 10.2368 11.2597 10.2906 11.4413L10.357 11.6493C10.426 11.8479 10.5058 12.0236 10.6217 12.2011L10.7779 12.4227C11.1957 12.9855 11.9822 13.8538 12.8219 14.6796C13.2991 15.1488 13.7883 15.5993 14.2281 15.9657C14.6728 16.3362 15.0521 16.6084 15.3131 16.7343L15.3844 16.7636C15.5179 16.8109 15.6905 16.8348 15.8629 16.8456L16.0338 16.8525L16.1627 16.8515C16.7106 16.8269 17.0715 16.5639 17.4195 16.2001L17.5689 16.038C17.9546 15.606 18.3771 15.0327 19.0514 14.7558L19.19 14.704L19.4 14.6444C19.8799 14.5327 20.2965 14.6063 20.7418 14.8017L20.8629 14.8524C20.9094 14.8728 20.9612 14.8975 21.0133 14.9296L21.1178 15.0048L21.1188 15.0058L21.4225 15.2753C22.1317 15.9265 22.8358 16.7142 23.4801 17.3583L25.0856 18.9658L25.2652 19.1161C25.3332 19.1693 25.4177 19.236 25.4889 19.3124L25.5514 19.3906C25.6074 19.4712 25.6458 19.5566 25.6734 19.623C25.7166 19.7267 25.7392 19.7892 25.7721 19.8437L25.8502 19.9814C25.9227 20.1179 25.9784 20.254 26.0123 20.3994C26.0579 20.5946 26.0607 20.7932 26.0299 21.0185L25.9811 21.2744C25.961 21.3581 25.9364 21.4409 25.9078 21.5224L25.8102 21.7627L25.6881 21.9921L25.6119 22.1093C25.4152 22.3967 25.0833 22.7729 24.7477 23.1201L24.4742 23.3955C24.2007 23.6641 23.9325 23.9072 23.7311 24.0683L23.7096 24.1172L23.7086 24.1181C23.6318 24.264 23.5042 24.4202 23.3629 24.5683L23.1285 24.7969C23.0458 24.8732 22.9594 24.9495 22.8717 25.0234L22.4723 25.3408C22.3402 25.4399 22.212 25.5305 22.0963 25.6064L21.8844 25.7373L21.7174 25.8252C21.5472 25.9085 21.3681 25.9786 21.193 26.0381L20.9625 26.1113L20.7213 26.1748C20.2257 26.2879 19.6497 26.3213 19.0748 26.2871L18.7887 26.2646C18.2047 26.2068 17.619 26.0778 17.1207 25.8799L16.9127 25.791L16.69 25.6787C16.6348 25.6482 16.5735 25.6254 16.5045 25.6045L16.2711 25.5429C16.1816 25.5208 16.0769 25.4946 15.9723 25.4551L15.8688 25.4111L15.7359 25.334C15.5899 25.2331 15.4331 25.1546 15.2662 25.0791L14.733 24.8428C10.0625 22.6666 5.18465 17.7961 2.61875 13.1542L2.37851 12.7059L2.14511 12.245C1.90888 11.7632 1.70872 11.2568 1.52402 10.7567L1.34433 10.2606L1.1998 9.83484C0.881226 8.84417 0.706412 7.85594 0.759372 6.7811L0.768161 6.5897C0.779653 6.38158 0.805777 6.13115 0.911716 5.91489L0.993747 5.72055L1.06504 5.5057L1.21347 5.0389L1.25156 4.95101C1.27391 4.90576 1.30061 4.85853 1.33066 4.81039L1.42929 4.6639C1.4778 4.59605 1.53272 4.52326 1.59336 4.4471L1.79062 4.20882C1.93088 4.04404 2.08953 3.86586 2.25937 3.68245L2.79355 3.12288C3.3413 2.56266 3.92179 2.00697 4.31797 1.65314L4.64512 1.37384L4.86094 1.21173C5.07825 1.05818 5.30311 0.928324 5.55918 0.816219L5.58848 0.803524L5.61973 0.798641L5.91074 0.764461C6.02283 0.755199 6.14664 0.749099 6.26914 0.749812L6.45469 0.756648ZM6.15684 2.75373C6.11278 2.77983 6.06871 2.80742 6.02402 2.83869L5.87266 2.95295C5.69079 3.10032 5.25535 3.49827 4.75449 3.98909L4.22324 4.52132C4.04855 4.69999 3.881 4.87569 3.72715 5.04183L3.31308 5.50473C3.19542 5.64298 3.11363 5.74787 3.06211 5.81918L2.97617 6.09458C2.94836 6.18483 2.91356 6.29361 2.87168 6.40805L2.85508 6.45395L2.83554 6.4979L2.76719 6.65806C2.76633 6.66958 2.76517 6.68341 2.76426 6.70005L2.75644 6.8729V6.87974C2.71813 7.65774 2.8391 8.39768 3.09824 9.20788L3.22617 9.58288L3.57578 10.5262C3.68867 10.8135 3.80409 11.0843 3.9293 11.3417L4.15097 11.7802L4.37461 12.1972C6.7595 16.5072 11.3364 21.0534 15.5758 23.0293L16.0758 23.2509L16.0836 23.2539L16.0904 23.2568C16.2613 23.3341 16.4867 23.4435 16.7272 23.5947C16.7343 23.5965 16.7417 23.5993 16.7506 23.6015L17.0846 23.6904C17.2334 23.7366 17.4131 23.8032 17.5895 23.8935L17.5904 23.8925L17.7701 23.9824C18.0558 24.1107 18.4869 24.225 18.985 24.2744L19.2027 24.292C19.6953 24.3205 20.1156 24.2741 20.3785 24.1972L20.5631 24.1386C20.7115 24.0876 20.8187 24.0404 20.8883 24.0019L21.0025 23.9316C21.1599 23.8281 21.3759 23.6682 21.5826 23.4941L21.7731 23.3271C21.8288 23.2757 21.8765 23.2285 21.9156 23.1875L21.9488 23.1504L22.0982 22.8134L22.4811 22.5068C22.6609 22.3629 22.9842 22.0665 23.3092 21.7304L23.5533 21.4707C23.6305 21.386 23.7027 21.3038 23.7672 21.2275C23.8309 21.1521 23.8816 21.0886 23.9195 21.038C23.9369 21.0149 23.9484 20.9962 23.9566 20.9843L24.0074 20.8906C24.0114 20.8808 24.0167 20.87 24.0211 20.8574C24.025 20.8461 24.0271 20.8351 24.0299 20.8251C23.9778 20.7339 23.938 20.6526 23.9107 20.5917L23.8014 20.4999L23.733 20.4423L23.6705 20.3789L22.065 18.7714C21.2952 18.0016 20.7592 17.3839 20.0797 16.7587L19.9391 16.6337C19.8928 16.6134 19.8601 16.6033 19.8414 16.5976L19.8121 16.6054C19.7899 16.6144 19.7317 16.6442 19.6217 16.748C19.5558 16.8101 19.4824 16.8875 19.3883 16.9941C19.3408 17.0479 19.2945 17.1026 19.2389 17.1669L19.0602 17.37C18.5907 17.8959 17.7319 18.7833 16.2516 18.8495L16.2145 18.8515H16.1773L16.0484 18.8525H15.9908C15.7421 18.8472 15.2174 18.8265 14.7154 18.6484L14.6686 18.6318L14.6236 18.6132L14.4977 18.5615L14.4439 18.5361C14.0699 18.3556 13.6727 18.0789 13.3043 17.7909L12.9479 17.5029C12.5779 17.1946 12.1865 16.8418 11.8014 16.4755L11.4195 16.1054C10.5485 15.2488 9.67848 14.2981 9.17148 13.6151L9.15684 13.5956L9.14316 13.5751L8.98691 13.3534L8.96641 13.3241L8.94688 13.2948C8.72263 12.9514 8.57681 12.6208 8.46738 12.3056L8.45859 12.2811L8.45176 12.2577L8.38535 12.0497L8.37852 12.0302L8.37266 12.0097C8.32187 11.8383 8.2543 11.591 8.20469 11.3104L8.1627 11.0204C8.12518 10.6928 8.07785 10.0159 8.40098 9.36315L8.44102 9.28405L8.48691 9.20788L8.57285 9.06725L8.60898 9.00768L8.65 8.95104C8.73302 8.83439 8.81685 8.73275 8.88047 8.65807L9.20469 8.29869L9.20762 8.29479L9.8082 7.63658C9.96681 7.4543 10.0611 7.32749 10.1178 7.2313L10.1695 7.12974C10.1806 7.1029 10.1864 7.08202 10.19 7.06626C10.196 7.04007 10.202 6.99518 10.1939 6.91587L10.1773 6.82212L10.1617 6.80259C9.93017 6.52289 9.65741 6.25515 9.29356 5.89438L9.28477 5.88657L9.27695 5.87875L8.87949 5.47543L8.8668 5.46176L8.85313 5.44809L8.15391 4.69125L7.3873 3.86702C6.92168 3.38094 6.52653 3.00638 6.24473 2.79963L6.17539 2.75276C6.16927 2.75301 6.16309 2.75342 6.15684 2.75373Z"></path>
<path d="M14.99 1.27588C16.1111 1.29455 17.1954 1.5212 18.2488 1.93213L18.738 2.13818C21.1624 3.2349 23.2389 5.30995 24.2947 7.74072L24.4626 8.16162C24.6447 8.65394 24.8619 9.33983 25.0222 10.0278C25.1292 10.4868 25.2123 10.9543 25.2419 11.3706C25.2672 11.7267 25.2557 12.0742 25.1658 12.3501L25.1218 12.4644C25.0564 12.6113 24.9683 12.7172 24.8523 12.7944C24.7509 12.8619 24.6354 12.8994 24.5378 12.9321L24.5388 12.9331L24.365 12.9917C24.2351 13.0223 24.0975 12.9997 23.9949 12.9702C23.8874 12.9393 23.7787 12.89 23.696 12.8325C23.4736 12.6783 23.3678 12.4626 23.3162 12.2534C23.2914 12.1531 23.278 12.0492 23.2703 11.9497L23.2576 11.6724C23.2279 10.7732 23.1295 10.02 22.8093 9.19385C22.7511 9.04329 22.682 8.90572 22.6062 8.73584C22.539 8.58531 22.4723 8.41855 22.4324 8.23877C22.3104 8.11957 22.2291 7.965 22.1697 7.84131C22.1278 7.75417 22.0946 7.67988 22.0642 7.61474L21.9724 7.44385C21.1036 6.12486 20.0588 5.07346 18.7175 4.28174L18.4451 4.12646C17.6684 3.70072 16.6922 3.41719 15.8015 3.25635C15.6573 3.23047 15.4427 3.24189 15.1843 3.25049C15.0635 3.25451 14.936 3.25717 14.8191 3.25147C14.7059 3.24593 14.5797 3.23184 14.4714 3.18994C14.3903 3.15849 14.3319 3.12341 14.2537 3.06397C14.0973 2.94518 14.027 2.84647 13.9421 2.66943C13.9046 2.5911 13.89 2.53449 13.866 2.46045C13.8229 2.32798 13.7703 2.13159 13.8122 1.95654L13.8552 1.83545C13.9104 1.7204 13.9964 1.6262 14.071 1.55615C14.1762 1.45745 14.3828 1.27588 14.5066 1.28073C14.7071 1.27417 14.99 1.27588 14.99 1.27588Z"></path>
<path d="M14.5801 5.27537C14.8162 5.24717 15.1293 5.25963 15.4268 5.29783C15.7237 5.33595 16.0321 5.40255 16.2559 5.4951L16.255 5.49607C16.3858 5.55004 16.5221 5.59539 16.6661 5.64353C16.8078 5.69091 16.9592 5.74073 17.1075 5.79881L17.4786 5.95506C17.8503 6.12264 18.2188 6.32355 18.5499 6.55467L18.796 6.74412C19.0555 6.95943 19.3497 7.24721 19.6192 7.54881C19.9759 7.9479 20.315 8.3998 20.4717 8.76658L20.6925 9.31053C20.7627 9.49584 20.8284 9.68426 20.8848 9.874L20.9405 10.081C21.0047 10.338 21.0899 10.7294 21.1553 11.1152C21.1991 11.373 21.2353 11.6353 21.2491 11.8574C21.256 11.9682 21.2578 12.0745 21.251 12.1679C21.2447 12.2548 21.2299 12.3584 21.1856 12.4453L21.1846 12.4443C21.0948 12.6216 20.988 12.7581 20.8526 12.8681C20.7202 12.9758 20.5709 13.0505 20.4112 13.1162L20.3848 13.1269L20.3565 13.1318C20.2641 13.1469 20.1782 13.1404 20.1026 13.126L19.9092 13.0713C19.7751 13.0262 19.6387 12.9252 19.5362 12.8242C19.4611 12.7502 19.3788 12.6516 19.3262 12.542L19.2852 12.4297C19.2549 12.3081 19.2567 12.1622 19.2608 12.0498C19.2656 11.9195 19.2733 11.8234 19.2716 11.7402L19.2598 11.4844C19.2236 10.9782 19.1119 10.5043 18.9171 10.0351L18.8126 9.80076C18.319 8.76234 17.3866 7.94927 16.3048 7.53318L16.087 7.45506C15.9565 7.41208 15.8201 7.38886 15.6602 7.36033C15.5066 7.33292 15.3316 7.30028 15.1583 7.23728C15.0821 7.20965 15.0002 7.2111 14.8653 7.21873C14.7448 7.22554 14.5654 7.23944 14.3839 7.17967L14.3253 7.16014L14.2823 7.11619C14.1943 7.02481 14.0835 6.91303 13.9932 6.77342L13.9112 6.624C13.81 6.3989 13.7854 6.14138 13.8887 5.8906L13.9425 5.7783C14.0766 5.53274 14.2741 5.39685 14.5098 5.29392L14.544 5.27928L14.5801 5.27537Z"></path>
</svg>',
                'title' => 'Officium venditionis',
                'text' => 'Parati sumus de vestris necessitatibus colloqui et optimas solutiones proponere. Nostri periti vobis auxilium dabunt ad idoneum productum eligendum et ad omnes quaestiones de pretiis et condicionibus cooperationis respondendum.',
                'btn' => ['text' => 'Cum gestore communicare', 'style' => ['name' => 'Palette', 'value' => 'btn-blc', 'type' => 'palette']],
                'mt' => 'm-t-0',
            ],
            [
                'icon' => '<svg xmlns="http://www.w3.org/2000/svg" width="29" height="21" viewBox="0 0 29 21" fill="var(--bw-1)">
<path d="M1.93753 0.176797C3.20379 0.0387928 4.55399 0.127863 5.83124 0.129861L13.017 0.139948L22.0457 0.131457C23.6078 0.126664 25.2049 0.034199 26.762 0.128965C27.1327 0.151533 27.5245 0.232615 27.8393 0.437225C28.1402 0.632348 28.322 0.912554 28.388 1.26196C28.5899 2.31676 28.487 3.50617 28.481 4.57845L28.477 9.31953L28.486 15.1987C28.4889 16.3295 28.5469 17.492 28.453 18.6178C28.422 18.9894 28.35 19.357 28.1262 19.6655C27.8753 20.0113 27.5485 20.1157 27.1497 20.1784C26.1533 20.3322 25.001 20.2183 23.9856 20.2233C21.6876 20.2517 19.3896 20.252 17.0916 20.2241C11.9736 20.1768 6.84364 20.3201 1.72764 20.1305C1.68666 20.0514 1.71266 20.0835 1.6377 20.02C1.43982 19.8511 1.24893 19.6755 1.11401 19.449C0.990084 19.2401 0.925112 19.0017 0.904125 18.7603C0.803184 17.5479 0.854162 16.2893 0.850164 15.0714L0.851165 8.57309C0.855163 7.24767 0.761214 2.08249 1.02206 1.0883C1.15198 0.594204 1.52977 0.418554 1.93753 0.176797ZM26.5151 17.5178C26.636 17.3585 26.67 17.2095 26.686 17.016C26.9379 14.0203 26.722 10.9223 26.721 7.91312C26.72 6.58001 26.9409 4.79325 26.726 3.51616C26.707 3.40492 26.678 3.32483 26.626 3.22547L26.4601 3.17315C25.9864 3.93966 19.97 9.90051 19.2144 10.2975C19.7341 10.5502 22.7773 13.4785 22.9942 13.9774C23.0022 13.9961 23.0062 14.0163 23.0122 14.0356C23.5598 14.3799 26.3902 17.0038 26.5151 17.5178ZM25.1159 1.86889L10.2097 1.84972L6.29097 1.84852C5.57639 1.84792 4.76587 1.78511 4.06028 1.89975C4.07727 1.90974 4.09326 1.91932 4.10925 1.92961C4.92178 2.44847 5.66533 3.30736 6.34993 3.99378C7.8204 5.48447 9.28221 6.98381 10.7354 8.49181C11.6928 9.4818 12.6522 10.5995 13.7626 11.4158C14.0694 11.6408 14.5911 11.9811 14.9899 11.8767C15.2807 11.8005 15.5575 11.581 15.7824 11.3889C16.2221 11.0133 19.948 7.29371 20.0759 7.05355C20.1019 7.00442 20.1169 6.94929 20.1239 6.89437C20.6665 6.54926 25.009 2.35451 25.0999 1.95398C25.1069 1.92582 25.1099 1.89725 25.1159 1.86889ZM2.50819 3.09755C2.59414 3.24854 2.61512 3.36567 2.62711 3.53743C2.72606 4.92307 2.821 16.5506 2.61412 17.2741C2.58314 17.3827 2.53118 17.4799 2.47421 17.5767C3.0139 17.3595 5.93218 14.5979 6.18803 14.0797C6.21401 14.0267 6.21202 14.012 6.21801 13.9605C6.71472 13.6461 9.75894 10.7439 9.8269 10.3443C9.83089 10.3177 9.83389 10.2908 9.83689 10.264C9.69197 9.71197 3.55757 3.60484 2.87697 3.15537C2.76103 3.07908 2.64011 3.08677 2.50819 3.09755ZM17.9891 11.4623C17.9671 11.8142 17.6313 12.1331 17.3795 12.3578C16.5959 13.0562 15.5006 13.7268 14.4142 13.6596C12.8421 13.5623 12.0226 11.6356 11.0882 11.5634C10.8003 12.1941 4.72689 18.2186 4.04929 18.4954L20.0779 18.4907C21.7116 18.4968 23.345 18.4927 24.978 18.4785C24.959 18.3982 24.947 18.3331 24.8981 18.2639C24.4303 17.5979 18.8336 11.9503 18.2719 11.6074C18.208 11.5685 18.144 11.5366 18.0771 11.5048L17.9891 11.4623Z"></path>
</svg>',
                'title' => 'Auxilium technicum',
                'text' => 'Quaestiones ortae sunt vel auxilio opus est? Nostrum officium auxilii diei noctuque laborat ut omnia problemata technica solvat et consultationem peritam de usu producti praebeat.',
                'btn' => ['text' => 'Auxilium accipere', 'style' => ['name' => 'Palette', 'value' => "btn-blc-strk", 'type' => 'palette']],
                'mt' => 'm-t-3',
            ],
        ];
    }
}
