
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `wallabag2614`
--

-- --------------------------------------------------------

--
-- Table structure for table `migration_versions`
--

CREATE TABLE `migration_versions` (
  `version` varchar(192) COLLATE utf8_unicode_ci NOT NULL,
  `executed_at` datetime DEFAULT NULL,
  `execution_time` int(11) DEFAULT NULL,
  PRIMARY KEY (`version`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `migration_versions`
--

INSERT INTO `migration_versions` VALUES
('Application\\Migrations\\Version20160401000000', '[[regtime]]', 1701),
('Application\\Migrations\\Version20160410190541', '[[regtime]]', 75),
('Application\\Migrations\\Version20160812120952', '[[regtime]]', 75),
('Application\\Migrations\\Version20160911214952', '[[regtime]]', 14),
('Application\\Migrations\\Version20160916201049', '[[regtime]]', 71),
('Application\\Migrations\\Version20161001072726', '[[regtime]]', 289),
('Application\\Migrations\\Version20161022134138', '[[regtime]]', 855),
('Application\\Migrations\\Version20161024212538', '[[regtime]]', 193),
('Application\\Migrations\\Version20161031132655', '[[regtime]]', 6),
('Application\\Migrations\\Version20161104073720', '[[regtime]]', 43),
('Application\\Migrations\\Version20161106113822', '[[regtime]]', 75),
('Application\\Migrations\\Version20161117071626', '[[regtime]]', 10),
('Application\\Migrations\\Version20161118134328', '[[regtime]]', 77),
('Application\\Migrations\\Version20161122144743', '[[regtime]]', 5),
('Application\\Migrations\\Version20161122203647', '[[regtime]]', 83),
('Application\\Migrations\\Version20161128084725', '[[regtime]]', 73),
('Application\\Migrations\\Version20161128131503', '[[regtime]]', 95),
('Application\\Migrations\\Version20161214094403', '[[regtime]]', 39),
('Application\\Migrations\\Version20170127093841', '[[regtime]]', 67),
('Application\\Migrations\\Version20170327194233', '[[regtime]]', 9),
('Application\\Migrations\\Version20170405182620', '[[regtime]]', 88),
('Application\\Migrations\\Version20170407200919', '[[regtime]]', 90),
('Application\\Migrations\\Version20170420134133', '[[regtime]]', 0),
('Application\\Migrations\\Version20170501115751', '[[regtime]]', 129),
('Application\\Migrations\\Version20170510082609', '[[regtime]]', 19),
('Application\\Migrations\\Version20170511115400', '[[regtime]]', 95),
('Application\\Migrations\\Version20170511211659', '[[regtime]]', 95),
('Application\\Migrations\\Version20170602075214', '[[regtime]]', 5),
('Application\\Migrations\\Version20170719231144', '[[regtime]]', 1),
('Application\\Migrations\\Version20170824113337', '[[regtime]]', 91),
('Application\\Migrations\\Version20171008195606', '[[regtime]]', 76),
('Application\\Migrations\\Version20171105202000', '[[regtime]]', 88),
('Application\\Migrations\\Version20171120163128', '[[regtime]]', 5),
('Application\\Migrations\\Version20171125164500', '[[regtime]]', 5),
('Application\\Migrations\\Version20180405182455', '[[regtime]]', 90),
('Application\\Migrations\\Version20181128203230', '[[regtime]]', 819),
('Application\\Migrations\\Version20181202073750', '[[regtime]]', 206),
('Application\\Migrations\\Version20190117131816', '[[regtime]]', 71),
('Application\\Migrations\\Version20190129120000', '[[regtime]]', 100),
('Application\\Migrations\\Version20190401105353', '[[regtime]]', 123),
('Application\\Migrations\\Version20190425115043', '[[regtime]]', 24),
('Application\\Migrations\\Version20190510141130', '[[regtime]]', 439),
('Application\\Migrations\\Version20190511165128', '[[regtime]]', 165),
('Application\\Migrations\\Version20190601125843', '[[regtime]]', 133),
('Application\\Migrations\\Version20190708122957', '[[regtime]]', 0),
('Application\\Migrations\\Version20190806130304', '[[regtime]]', 272),
('Application\\Migrations\\Version20190808124957', '[[regtime]]', 15),
('Application\\Migrations\\Version20190826204730', '[[regtime]]', 175),
('Application\\Migrations\\Version20200414120227', '[[regtime]]', 0),
('Application\\Migrations\\Version20200428072628', '[[regtime]]', 15),
('Application\\Migrations\\Version20221123132612', '[[regtime]]', 77),
('Application\\Migrations\\Version20221221092957', '[[regtime]]', 90),
('Application\\Migrations\\Version20230613121354', '[[regtime]]', 90);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]annotation`
--

CREATE TABLE `[[dbprefix]]annotation` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `entry_id` int(11) DEFAULT NULL,
  `text` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `quote` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `ranges` longtext COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '(DC2Type:array)',
  PRIMARY KEY (`id`),
  KEY `IDX_A7AED006A76ED395` (`user_id`),
  KEY `IDX_A7AED006BA364942` (`entry_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]config`
--

CREATE TABLE `[[dbprefix]]config` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `items_per_page` int(11) NOT NULL,
  `language` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `feed_token` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `feed_limit` int(11) DEFAULT NULL,
  `reading_speed` double DEFAULT NULL,
  `pocket_consumer_key` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `action_mark_as_read` int(11) DEFAULT '0',
  `list_mode` int(11) DEFAULT NULL,
  `display_thumbnails` int(11) DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_87E64C53A76ED395` (`user_id`),
  KEY `config_feed_token` (`feed_token`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]config`
--

INSERT INTO `[[dbprefix]]config` VALUES
(1, 1, 12, '[[language]]', NULL, 50, 200, NULL, 1, 0, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]entry`
--

CREATE TABLE `[[dbprefix]]entry` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `title` longtext COLLATE utf8mb4_unicode_ci,
  `url` longtext COLLATE utf8mb4_unicode_ci,
  `is_archived` tinyint(1) NOT NULL,
  `is_starred` tinyint(1) NOT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `mimetype` longtext COLLATE utf8mb4_unicode_ci,
  `language` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `reading_time` int(11) NOT NULL,
  `domain_name` longtext COLLATE utf8mb4_unicode_ci,
  `preview_picture` longtext COLLATE utf8mb4_unicode_ci,
  `uid` varchar(23) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `http_status` varchar(3) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `published_at` datetime DEFAULT NULL,
  `published_by` longtext COLLATE utf8mb4_unicode_ci,
  `headers` longtext COLLATE utf8mb4_unicode_ci,
  `starred_at` datetime DEFAULT NULL,
  `origin_url` longtext COLLATE utf8mb4_unicode_ci,
  `archived_at` datetime DEFAULT NULL,
  `hashed_url` tinytext COLLATE utf8mb4_unicode_ci,
  `given_url` longtext COLLATE utf8mb4_unicode_ci,
  `hashed_given_url` tinytext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `IDX_F4D18282A76ED395` (`user_id`),
  KEY `IDX_entry_created_at` (`created_at`),
  KEY `IDX_entry_uid` (`uid`),
  KEY `IDX_entry_starred` (`is_starred`),
  KEY `IDX_entry_archived` (`is_archived`),
  KEY `hashed_url_user_id` (`user_id`,`hashed_url`(40)),
  KEY `hashed_given_url_user_id` (`user_id`,`hashed_given_url`(40)),
  KEY `user_language` (`language`,`user_id`),
  KEY `user_archived` (`user_id`,`is_archived`,`archived_at`),
  KEY `user_created` (`user_id`,`created_at`),
  KEY `user_starred` (`user_id`,`is_starred`,`starred_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]entry_tag`
--

CREATE TABLE `[[dbprefix]]entry_tag` (
  `entry_id` int(11) NOT NULL,
  `tag_id` int(11) NOT NULL,
  PRIMARY KEY (`entry_id`,`tag_id`),
  KEY `IDX_C9F0DD7CBA364942` (`entry_id`),
  KEY `IDX_C9F0DD7CBAD26311` (`tag_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]ignore_origin_instance_rule`
--

CREATE TABLE `[[dbprefix]]ignore_origin_instance_rule` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=4 ;

--
-- Dumping data for table `[[dbprefix]]ignore_origin_instance_rule`
--

INSERT INTO `[[dbprefix]]ignore_origin_instance_rule` VALUES
(1, 'host = "feedproxy.google.com"'),
(2, 'host = "feeds.reuters.com"'),
(3, '_all ~ "https?://www\\.lemonde\\.fr/tiny.*"');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]ignore_origin_user_rule`
--

CREATE TABLE `[[dbprefix]]ignore_origin_user_rule` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `config_id` int(11) NOT NULL,
  `rule` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_config` (`config_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]internal_setting`
--

CREATE TABLE `[[dbprefix]]internal_setting` (
  `name` varchar(191) COLLATE utf8_unicode_ci NOT NULL,
  `value` varchar(191) COLLATE utf8_unicode_ci DEFAULT NULL,
  `section` varchar(191) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`name`),
  UNIQUE KEY `UNIQ_5D9649505E237E06` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `[[dbprefix]]internal_setting`
--

INSERT INTO `[[dbprefix]]internal_setting` VALUES
('api_user_registration', '0', 'api'),
('demo_mode_enabled', '0', 'misc'),
('demo_mode_username', 'wallabag', 'misc'),
('diaspora_url', 'https://diasporapod.com', 'entry'),
('download_images_enabled', '0', 'misc'),
('export_csv', '1', 'export'),
('export_epub', '1', 'export'),
('export_json', '1', 'export'),
('export_mobi', '0', 'export'),
('export_pdf', '1', 'export'),
('export_txt', '1', 'export'),
('export_xml', '1', 'export'),
('import_with_rabbitmq', '0', 'import'),
('import_with_redis', '0', 'import'),
('matomo_enabled', '0', 'analytics'),
('matomo_host', 'matomo.wallabag.org', 'analytics'),
('matomo_site_id', '1', 'analytics'),
('restricted_access', '0', 'entry'),
('shaarli_share_origin_url', '0', 'entry'),
('shaarli_url', 'https://myshaarli.com', 'entry'),
('share_diaspora', '1', 'entry'),
('share_mail', '1', 'entry'),
('share_public', '1', 'entry'),
('share_shaarli', '1', 'entry'),
('share_twitter', '1', 'entry'),
('share_unmark', '1', 'entry'),
('show_printlink', '1', 'entry'),
('store_article_headers', '0', 'entry'),
('unmark_url', 'https://unmark.it', 'entry'),
('wallabag_support_url', 'https://www.wallabag.org/pages/support.html', 'misc');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]oauth2_access_tokens`
--

CREATE TABLE `[[dbprefix]]oauth2_access_tokens` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `user_id` int(11) DEFAULT NULL,
  `token` varchar(191) COLLATE utf8_unicode_ci NOT NULL,
  `expires_at` int(11) DEFAULT NULL,
  `scope` varchar(191) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_368A42095F37A13B` (`token`),
  KEY `IDX_368A420919EB6921` (`client_id`),
  KEY `IDX_368A4209A76ED395` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]oauth2_auth_codes`
--

CREATE TABLE `[[dbprefix]]oauth2_auth_codes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `user_id` int(11) DEFAULT NULL,
  `token` varchar(191) COLLATE utf8_unicode_ci NOT NULL,
  `redirect_uri` longtext COLLATE utf8_unicode_ci NOT NULL,
  `expires_at` int(11) DEFAULT NULL,
  `scope` varchar(191) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_EE52E3FA5F37A13B` (`token`),
  KEY `IDX_EE52E3FA19EB6921` (`client_id`),
  KEY `IDX_EE52E3FAA76ED395` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]oauth2_clients`
--

CREATE TABLE `[[dbprefix]]oauth2_clients` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `random_id` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `redirect_uris` longtext COLLATE utf8_unicode_ci NOT NULL COMMENT '(DC2Type:array)',
  `secret` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `allowed_grant_types` longtext COLLATE utf8_unicode_ci NOT NULL COMMENT '(DC2Type:array)',
  `name` longblob NOT NULL,
  `user_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_C7E1A097A76ED395` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]oauth2_refresh_tokens`
--

CREATE TABLE `[[dbprefix]]oauth2_refresh_tokens` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `user_id` int(11) DEFAULT NULL,
  `token` varchar(191) COLLATE utf8_unicode_ci NOT NULL,
  `expires_at` int(11) DEFAULT NULL,
  `scope` varchar(191) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_20C9FB245F37A13B` (`token`),
  KEY `IDX_20C9FB2419EB6921` (`client_id`),
  KEY `IDX_20C9FB24A76ED395` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]site_credential`
--

CREATE TABLE `[[dbprefix]]site_credential` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `host` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `username` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `password` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `createdAt` datetime NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_user` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tag`
--

CREATE TABLE `[[dbprefix]]tag` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `label` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin,
  `slug` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_4CA58A8C989D9B62` (`slug`),
  KEY `tag_label` (`label`(255))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tagging_rule`
--

CREATE TABLE `[[dbprefix]]tagging_rule` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `config_id` int(11) DEFAULT NULL,
  `rule` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `tags` longtext COLLATE utf8_unicode_ci NOT NULL COMMENT '(DC2Type:simple_array)',
  PRIMARY KEY (`id`),
  KEY `IDX_2D9B3C5424DB0683` (`config_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]user`
--

CREATE TABLE `[[dbprefix]]user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `username` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `username_canonical` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email_canonical` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `salt` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `password` varchar(180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_login` datetime DEFAULT NULL,
  `confirmation_token` varchar(180) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `password_requested_at` datetime DEFAULT NULL,
  `roles` longtext COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '(DC2Type:array)',
  `name` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `authCode` int(11) DEFAULT NULL,
  `emailTwoFactor` tinyint(1) NOT NULL,
  `googleAuthenticatorSecret` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `backupCodes` json DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_1D63E7E592FC23A8` (`username_canonical`),
  UNIQUE KEY `UNIQ_1D63E7E5A0D96FBF` (`email_canonical`),
  UNIQUE KEY `UNIQ_1D63E7E5C05FB297` (`confirmation_token`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]user`
--

INSERT INTO `[[dbprefix]]user` VALUES
(1, '[[admin_username]]', '[[admin_username_lower]]', '[[admin_email]]', '[[admin_email_lower]]', 1, '[[salt]]', '[[admin_pass]]', NULL, NULL, NULL, 'a:2:{i:0;s:9:"ROLE_USER";i:1;s:16:"ROLE_SUPER_ADMIN";}', '[[admin_realname]]', '[[regtime]]', '[[regtime]]', NULL, 0, NULL, NULL);

--
-- Constraints for dumped tables
--

--
-- Constraints for table `[[dbprefix]]annotation`
--
ALTER TABLE `[[dbprefix]]annotation`
  ADD CONSTRAINT `FK_A7AED006A76ED395` FOREIGN KEY (`user_id`) REFERENCES `[[dbprefix]]user` (`id`),
  ADD CONSTRAINT `FK_annotation_entry` FOREIGN KEY (`entry_id`) REFERENCES `[[dbprefix]]entry` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]config`
--
ALTER TABLE `[[dbprefix]]config`
  ADD CONSTRAINT `FK_87E64C53A76ED395` FOREIGN KEY (`user_id`) REFERENCES `[[dbprefix]]user` (`id`);

--
-- Constraints for table `[[dbprefix]]entry`
--
ALTER TABLE `[[dbprefix]]entry`
  ADD CONSTRAINT `FK_F4D18282A76ED395` FOREIGN KEY (`user_id`) REFERENCES `[[dbprefix]]user` (`id`);

--
-- Constraints for table `[[dbprefix]]entry_tag`
--
ALTER TABLE `[[dbprefix]]entry_tag`
  ADD CONSTRAINT `FK_entry_tag_entry` FOREIGN KEY (`entry_id`) REFERENCES `[[dbprefix]]entry` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `FK_entry_tag_tag` FOREIGN KEY (`tag_id`) REFERENCES `[[dbprefix]]tag` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]ignore_origin_user_rule`
--
ALTER TABLE `[[dbprefix]]ignore_origin_user_rule`
  ADD CONSTRAINT `fk_config` FOREIGN KEY (`config_id`) REFERENCES `[[dbprefix]]config` (`id`);

--
-- Constraints for table `[[dbprefix]]oauth2_access_tokens`
--
ALTER TABLE `[[dbprefix]]oauth2_access_tokens`
  ADD CONSTRAINT `FK_368A420919EB6921` FOREIGN KEY (`client_id`) REFERENCES `[[dbprefix]]oauth2_clients` (`id`),
  ADD CONSTRAINT `FK_368A4209A76ED395` FOREIGN KEY (`user_id`) REFERENCES `[[dbprefix]]user` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]oauth2_auth_codes`
--
ALTER TABLE `[[dbprefix]]oauth2_auth_codes`
  ADD CONSTRAINT `FK_EE52E3FA19EB6921` FOREIGN KEY (`client_id`) REFERENCES `[[dbprefix]]oauth2_clients` (`id`),
  ADD CONSTRAINT `FK_EE52E3FAA76ED395` FOREIGN KEY (`user_id`) REFERENCES `[[dbprefix]]user` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]oauth2_clients`
--
ALTER TABLE `[[dbprefix]]oauth2_clients`
  ADD CONSTRAINT `FK_635D765EA76ED395` FOREIGN KEY (`user_id`) REFERENCES `[[dbprefix]]user` (`id`);

--
-- Constraints for table `[[dbprefix]]oauth2_refresh_tokens`
--
ALTER TABLE `[[dbprefix]]oauth2_refresh_tokens`
  ADD CONSTRAINT `FK_20C9FB2419EB6921` FOREIGN KEY (`client_id`) REFERENCES `[[dbprefix]]oauth2_clients` (`id`),
  ADD CONSTRAINT `FK_20C9FB24A76ED395` FOREIGN KEY (`user_id`) REFERENCES `[[dbprefix]]user` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `[[dbprefix]]site_credential`
--
ALTER TABLE `[[dbprefix]]site_credential`
  ADD CONSTRAINT `fk_user` FOREIGN KEY (`user_id`) REFERENCES `[[dbprefix]]user` (`id`);

--
-- Constraints for table `[[dbprefix]]tagging_rule`
--
ALTER TABLE `[[dbprefix]]tagging_rule`
  ADD CONSTRAINT `FK_2D9B3C5424DB0683` FOREIGN KEY (`config_id`) REFERENCES `[[dbprefix]]config` (`id`);

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
