<?php
/**
 * The template for displaying the footer.
 *
*/
?>
    <?php if ( !class_exists( 'ReduxFrameworkPlugin' ) ) { ?>
        <!-- BACK TO TOP BUTTON -->
        <a class="back-to-top sweetthemes-is-visible sweetthemes-fade-out" href="<?php echo esc_url('#0'); ?>">
            <i class="fa fa-long-arrow-up" aria-hidden="true"></i>
        </a>
    <?php } else { ?>
        <?php if (venor('mt_backtotop_status') == true) { ?>
            <!-- BACK TO TOP BUTTON -->
            <a class="back-to-top sweetthemes-is-visible sweetthemes-fade-out" href="<?php echo esc_url('#0'); ?>">
                <i class="fa fa-long-arrow-up" aria-hidden="true"></i>
            </a>
        <?php } ?>
    <?php } ?>
    <!-- FOOTER -->
    <?php $theme_init = new venor_init_class; ?>
    <footer class="<?php echo esc_attr($theme_init->venor_get_footer_variant()); ?>">
        <!-- FOOTER TOP -->
        <div class="row footer-top">
            <div class="container">
            <?php          
                //FOOTER ROW #1
                echo wp_kses_post(venor_footer_row1());
                //FOOTER ROW #2
                echo wp_kses_post(venor_footer_row2());
                //FOOTER ROW #3
                echo wp_kses_post(venor_footer_row3());
             ?>
            </div>
        </div>
        <!-- FOOTER BOTTOM -->
        <div class="row footer-div-parent">
            <div class="footer">
                <div class="container">
                	<p class="copyright text-center">
                        <?php if ( class_exists( 'ReduxFrameworkPlugin' ) ) { ?>
                            <?php echo wp_kses_post(venor('mt_footer_text')); ?>
                        <?php }else{ ?>
                            <?php echo esc_html__(' Venor by Sweet-Themes. 2019 All Rights Reserved. ', 'venor'); ?>
                        <?php } ?>
                    </p>
                </div>
            </div>
        </div>
    </footer>
</div>

<?php venor_footer(); ?>




<section class="sweet-buy-section">

    <div class="sweet-buy-related" style="top: calc(30% - 25px);">
        <a target="_blank" href="https://themeforest.net/item/niva-creative-agency-freelancer-wordpress-theme/22732180">
            <div class="sweet-btn">
                <span class="sweet-icon">
                    <svg x="0px" y="0px"
                         viewBox="0 0 511.992 511.992">
                    <path  d="M411.809,2.806c-18.304-8.992-111.168,1.28-178.112,65.504
                        C128.225,173.622,130.753,312.374,130.753,312.374s-3.488,14.272-18.336-6.432c-32.512-41.44-15.488-136.768-13.568-150.048
                        c2.688-18.72-9.248-19.264-14.208-13.088C-32.863,305.942,73.249,439.51,142.721,481.91c81.344,49.632,241.792,49.6,305.696-91.2
                        C528.033,215.382,434.753,14.038,411.809,2.806z"/>

                    </svg>
                </span>
                <span class="sweet-text-name">RELATED</span>
            </div>
        </a>
    </div>

    <div class="sweet-purchase" style="top: calc(30% + 25px);">
        <a target="_blank" href="https://themeforest.net/checkout/from_item/23106913?license=regular&size=source&support=bundle_12month">
            <span class="sweet-icon">
                <svg x="0px" y="0px" viewBox="0 0 24 24">
                    <circle cx="9" cy="21" r="2"></circle>
                    <circle cx="20" cy="21" r="2"></circle>
                    <path d="M23.8,5.4C23.6,5.1,23.3,5,23,5H6.8L6,0.8C5.9,0.3,5.5,0,5,0H1C0.4,0,0,0.4,0,1s0.4,1,1,1h3.2L5,6.2c0,0,0,0.1,0,0.1
                        l1.7,8.3C7,16,8.2,17,9.6,17c0,0,0,0,0.1,0h9.7c1.5,0,2.7-1,3-2.4L24,6.2C24,5.9,24,5.6,23.8,5.4z"></path>
                    </svg>
            </span>
            <span class="sweet-purchase-text">BUY NOW</span>
        </a>
    </div>

    
</section>

<style type="text/css">
    section.sweet-buy-section {
        width: 300px;
        height: 100%;
        min-height: 100%;
        position: fixed;
        right: -300px;
        top: 0;
        z-index: 777777;
    }
    .sweet-purchase, .sweet-buy-related {
        position: absolute;
        left: -127px;
        z-index: 777777;
        font-size: 12px !important;
        letter-spacing: .07em;
        display: block;
        height: 44px;
        width: 127px;
    }
    .sweet-buy-related .sweet-btn, .sweet-purchase a {
        position: relative;
        display: block;
        cursor: pointer;
        font-size: 0 !important;
        line-height: 44px !important;
        font-weight: 500;
    }
    span.sweet-icon {
        color: #fff;
        width: 44px;
        display: inline-block;
        line-height: 1 !important;
        text-align: center;
        vertical-align: middle;
        position: relative;
    }
    span.sweet-text-name {
        color: #000;
        font-size: 12px !important;
        letter-spacing: 0.07em !important;
    }
    .sweet-purchase {
        background-color: #0d56d9;
        box-shadow: 0 0 9.5px 0.3px rgba(0, 0, 0, 0.1);
    }
    span.sweet-purchase-text {
        color: #fff;
        font-size: 12px !important;
        letter-spacing: .11em !important;
    }
    span.sweet-icon svg {
        max-width: 20px;
        fill: #fff;
        height: 16px;
        position: relative;
        bottom: 4px;
        right: -2px;
    }
    .sweet-buy-related {
        background-color: #fff;
        box-shadow: 0 0 9.5px 0.3px rgba(0, 0, 0, 0.1);
    }
    .sweet-buy-related svg {
        fill: rgb(130, 181, 65) !important;
    }
</style>



</body>
</html>