# List of projects where vendor's API is used

- x-ray: @dkavchuk @skokhan
- userland: @oshyshatskyi @rprilipskii, @alutsiuk

PLEASE, ADD YOUR PROJECT AND CONTACT PERSON HERE SO WE CAN NOTIFY YOU ABOUT CHANGES

# Introduction

Vendor's api is a new proxy level between control panel data and CloudLinux utilities.

The complete integration guide for vendors is located 
[here](https://docs.cloudlinux.com/control_panel_integration/#introduction) 
and must be kept up-to date with api implementation on our side. 

The original ControlPanel API (cpapi) is located at clcommon/cpapi was written years ago
and gave ability for CloudLinux developers to write proxy scripts that translate control panel data
in python objects. Unfortunately, cpapi is not easy to extend by third-party devs: they must know python well 
and also update scripts when we change internal python version in cllib.

As a result of long discussion, Vendors API layer was added. Unlike cpapi, 
it uses executable scripts as data source. E.g. vendor writes `db_info` executable and 
we parse it's request to create python objects:

    
    /scripts/db_info
    
    {
      "data": {
        "mysql": {
          "access": {
            "login": "root",
            "password": "Cphxo6z",
            "host": "localhost",
            "port": 3306
          },
          "mapping": { }
        }
      },
      "metadata": {
        "result": "ok"
      }
    }

The complete list of scripts is located
[here](https://docs.cloudlinux.com/control_panel_integration/#the-list-of-the-integration-scripts).

## Preparation

Unfortunately we don't have already working bundled scripts that you can install 
in your testing environment, but we can well-detailed response examples in 
[docs](https://docs.cloudlinux.com/control_panel_integration/#the-list-of-the-integration-scripts)
which you can copy-paste to simple bash script and use them to check your code locally.

We would really appeciate if someone will create testing package with some mocked integration scripts.

## Vendors API usage in CloudLinux code

Vendors API may be used directly using simple import*:

    from vendors_api import PublicApi
    api = PublicApi()
    
    api.db_info() -> Databases object
    
\* in projects where original cpapi is used we added proxy layer that 
transforms vendor's api objects into cpapi format (see cpapi/plugins/vendors.py). 
That is temporary decision while we don't move our code completely to the new api.

ONLY THINGS DECLARED IN vendors_api.\_\_init__ ARE AVAILABLE FOR PUBLIC USAGE

## Before modifying vendors API

Before adding new data or fields, you must deside whether your changes will break backward compatibility.
It's always recommended to leave some fallbacks in our code in order not to force vendors to update their scripts.

In case if you add some major changes or even break compatibility, you MUST bump api version in spec file:

    Provides: public_cp_vendors_api = 1.3
    
That gives ability for vendor's to conflict new version while their scripts are not ready.

## Adding new fields and scripts

Vendors api is highly covered with json schemas checks and python typing to make it 
catch all possible vendor errors on the early stage.

Let's imagine that you are trying to add new possible field to `db_info` script. 
In order to do that, you must modify python representation first. Go to the `parser.py` and check what 
data type is returned. In our case it is `Databases` object:

    def db_info(self):
        # type: () -> Databases
        
Find the model in `models.py`, modify it's \_\_slots\_\_ to keep new field. 
Next, modify `__init__` to process new fields and save them to model.

That's all for python part.


Next, you must modify script jsonschema that checks responses validity. 
It's located in `schemas/db_info.yaml` for our case:
```text
---
type: object
properties:
  mysql:
    type:
      - object
      - "null"
    properties:
...
```

Don't forget to cover your logic with unittests:
- test_vendors_api.py
- test_vendors_api_cpapi.py
- test_vendors_api_models.py
- test_vendors_api_validation.py

# Review and merging

Please ask @oshyshatskyi, @avolkov or @alutsik about reviewing and merging your change.