<?php
/*
UserSpice 5 - Default TOTP Requirements Configuration
DO NOT EDIT THIS FILE DIRECTLY

To customize TOTP requirements, copy this file to:
usersc/includes/totp_requirements.php

This allows you to maintain your customizations through UserSpice updates.
*/

// Default TOTP Requirements
$totp_requirements = [
    'login_methods' => [
        'password' => true,      
        'email' => true,       
        'passkeys' => false,    
        'google' => false,      
        'facebook' => false,     
        'oauth' => false,        // Generic OAuth (for plugins)
        'okta' => false,        
        'saml' => false,        
        'ldap' => false, 
        'discord' => false,
        'twitch' => false,      
    ],
    
    // Pages that should never trigger TOTP redirects
    'safe_pages' => [
        'totp_management.php',
        'totp_verification.php', 
        'logout.php',
        'maintenance.php',
        'banned.php',
        'complete.php',
        'verify.php',
        'verify_thankyou.php',
        'verify_resend.php',
        'verify_resend_thankyou.php',
        'update.php',
        'oauth_success.php',
        'callback.php',
    ],
    


];

/*
CUSTOMIZATION EXAMPLES for usersc/includes/totp_requirements.php:

// Force admins to always use TOTP regardless of login method
if (hasPerm(2, $user_id)) {
    foreach ($totp_requirements['login_methods'] as $method => $required) {
        $totp_requirements['login_methods'][$method] = true;
    }
}



// Remove TOTP for specific accounts
$sample_accounts = [1, 5, 10, 15];
if (in_array($user_id, $sample_accounts)) {
    foreach ($totp_requirements['login_methods'] as $method => $required) {
        $totp_requirements['login_methods'][$method] = false;
    }

}

// Require TOTP based on IP ranges
$client_ip = $_SERVER['REMOTE_ADDR'] ?? '';
if (!in_array($client_ip, ['192.168.1.0/24', '10.0.0.0/8')) {
    // External IPs require TOTP for all login methods
    foreach ($totp_requirements['login_methods'] as $method => $required) {
        $totp_requirements['login_methods'][$method] = true;
    }
}

// Prevent TOTP on localhost
if (strpos($client_ip, '127.0.0.') === 0 || strpos($client_ip, '::1') === 0) {
    foreach ($totp_requirements['login_methods'] as $method => $required) {
        $totp_requirements['login_methods'][$method] = false;
    }
}
*/

?>