<?php defined('BX_DOL') or die('hack attempt');
/**
 * Copyright (c) UNA, Inc - https://una.io
 * MIT License - https://opensource.org/licenses/MIT
 *
 * @defgroup    UnaBaseView UNA Base Representation Classes
 * @{
 */

/**
 * Menu representation.
 * @see BxDolMenu
 */
class BxBaseMenuManage extends BxTemplMenu
{
    protected $_sObjectManage;
    protected $_oObjectManage;
    protected $_bAsButton;

    protected $_iContentId;

    public function __construct ($aObject, $oTemplate)
    {
        parent::__construct ($aObject, $oTemplate);

        $this->_sObjectManage = false;
        $this->_oObjectManage = null;
        $this->_bAsButton = false;

        $this->_iContentId = 0;
    }

    public function isVisible()
    {
        if((int)$this->_aObject['active'] == 0)
            return false;

        if(!$this->_oObjectManage || !$this->_oObjectManage->isVisible())
            return false;
        
        return true;
    }

    public function setContentId($iContentId)
    {
        $this->_iContentId = $iContentId;
    }

    /**
     * Get current menu in manage menu
     * @return menu object name
     */
    public function getObjectManage()
    {        
        return $this->_sObjectManage;
    }

    /**
     * Set current menu object in manage menu
     * @param $sMenuObject menu object name
     * @param $bAsButton boolean use autogenerated menu with single 'more' button or not
     */
    public function setObjectManage ($sMenuObject, $bAsButton = false)
    {
        $this->_sObjectManage = $sMenuObject;
        $this->_oObjectManage = BxDolMenu::getObjectInstance($this->_sObjectManage);
        $this->_bAsButton = $bAsButton;
    }

    public function getCode ()
    {
        if(!$this->isVisible())
            return '';

        if(!empty($this->_iContentId) && method_exists($this->_oObjectManage, 'setContentId'))
            $this->_oObjectManage->setContentId($this->_iContentId);

        $this->_addJsCss();
        if(!$this->_bAsButton)
            return $this->_oObjectManage->getCode();

        $oMenu = new BxTemplMenu(['template' => 'menu_horizontal.html', 'menu_id' => $this->_sObjectManage . '_wrapper', 'menu_items' => [
            ['id' => $this->_sObjectManage . '_more', 'name' => $this->_sObjectManage . '_more', 'link' => 'javascript:void(0)', 'onclick' => 'bx_menu_popup(\'' . $this->_sObjectManage . '\', this, {pointer: {el: $(this).parents(\'li:first\'), align:\'right\'}, cssClass: \'bx-popup-menu\'}, {id: ' . $this->_iContentId . '});', 'title' => '', 'icon' => $this->_oTemplate->getImageAuto('cog', false)]
        ]]);

        return $oMenu->getCode();
    }
    
    public function getCodeAPI ()
    {
        if(!$this->isVisible())
            return [];

        if(!empty($this->_iContentId) && method_exists($this->_oObjectManage, 'setContentId'))
            $this->_oObjectManage->setContentId($this->_iContentId);

        return $this->_oObjectManage->getCodeAPI();
    }
}

/** @} */
