<?php

class Notifier_Models_Mappers_NotifierSubscriptionsMapper extends Application_Model_Mappers_Abstract{

    protected $_dbTable = 'Notifier_Models_Dbtables_NotifierSubscriptionsDbtable';

    protected $_model = 'Notifier_Models_Models_NotifierSubscriptionsModel';

    public function save($model)
    {
        if (!$model instanceof $this->_model) {
            throw new Exceptions_SeotoasterException('Given parameter should be ' . $this->_model . ' instance');
        }
        $data = array(
            'token' => $model->getToken(),
            'endpoint' => $model->getEndpoint(),
            'auth' => $model->getAuth(),
            'p256dh' => $model->getP256dh(),
        );

        $notifierSubscription = $this->getByToken($data['token']);
        if (!$notifierSubscription instanceof Notifier_Models_Models_NotifierSubscriptionsModel) {
            $id = $this->getDbTable()->insert($data);
            return $model->setId($id);
        }
        $where = $this->getDbTable()->getAdapter()->quoteInto('token = ?', $data['token']);
        $this->getDbTable()->update($data, $where);

        return $model;
    }

    public function delete($token) {
        $where = $this->getDbTable()->getAdapter()->quoteInto('token = ?', $token);
        $this->getDbTable()->delete($where);
    }

    public function getByToken($token)
    {
        $where = $this->getDbTable()->getAdapter()->quoteInto('token = ?', $token);
        return $this->_findWhere($where);
    }

}