<?php

class Notifier_Models_Mappers_NotifierNewsInfoMapper extends Application_Model_Mappers_Abstract
{

    protected $_dbTable = 'Notifier_Models_Dbtables_NotifierNewsInfoDbtable';

    protected $_model = 'Notifier_Models_Models_NotifierNewsInfoModel';

    public function save($model)
    {
        if (!$model instanceof $this->_model) {
            throw new Exceptions_SeotoasterException('Given parameter should be ' . $this->_model . ' instance');
        }
        $data = [
            'news_id' => $model->getNewsId(),
            'published_at' => $model->getPublishedAt()
        ];

        $notifierInfo = $this->findByNewsId($data['news_id']);
        if (!$notifierInfo instanceof Notifier_Models_Models_NotifierNewsInfoModel) {
            $id = $this->getDbTable()->insert($data);
            return $model->setId($id);
        }
        $where = $this->getDbTable()->getAdapter()->quoteInto('news_id = ?', $data['news_id']);
        $this->getDbTable()->update($data, $where);

        return $model;
    }

    /**
     * Find by news id
     *
     * @param int $newsId news id
     * @return null
     * @throws Exception
     */
    public function findByNewsId($newsId)
    {
        $where = $this->getDbTable()->getAdapter()->quoteInto('news_id = ?', $newsId);
        return $this->_findWhere($where);
    }

}