define([
    'underscore',
    'backbone'
], function(_, Backbone){

    var NewsView = Backbone.View.extend({
        tagName: 'li',
        className: 'news-item',
        template: $('#newsItemTemplate').template(),
        events: {
            'click :not(.news-item-delete)' : 'editNewsItem'
        },
        initialize: function() {
            this.model.view = this;
        },
        editNewsItem: function(e) {
            e.preventDefault();
            showSpinner();
            if($(e.currentTarget).hasClass('news-item-url')){
                var newsUrl = $(e.currentTarget).closest('.news-item').find('.news-item-url').attr('href');
                window.open(newsUrl/*,'_blank'*/);
            }else{
                appRouter.navigate('edit/' + this.model.get('id'), {trigger: true});
                $('#manage-posts-container').hide("slide", { direction: "right"});
                $('#manage-posts-container-filter').hide("slide", { direction: "left"});
            }
            hideSpinner();
        },
        render: function(){
            $(this.el).html($.tmpl(this.template, this.model.toJSON()));
            return this;
        }
    });

    return NewsView;
});