<?php
class Newslog_Models_Mapper_NewsEventMapper extends Application_Model_Mappers_Abstract {

    protected $_dbTable = 'Newslog_Models_DbTable_NewsEvent';

    protected $_model   = 'Newslog_Models_Model_NewsEvent';

    public function save($model) {
        if(!$model instanceof $this->_model) {
            $model = new $this->_model($model);
        }
        $data = array(
            'news_tag_id'    => $model->getNewsTagId(),
            'archive_tag_id' => $model->getArchiveTagId()
        );
        if($model->getId()) {
            $where = $this->getDbTable()->getAdapter()->quoteInto('id = ?', $model->getId());
            $this->getDbTable()->update($data, $where);
        } else {
            $id = $this->getDbTable()->insert($data);
            if($id) {
                $model->setId($id);
            } else {
                throw new Exceptions_NewslogException('Can not save the model!');
            }
        }

        $model->notifyObservers();

        return $model;
    }

    public function delete($id) {
        $where        = $this->getDbTable()->getAdapter()->quoteInto('id = ?', $id);
        $deleteResult = $this->getDbTable()->delete($where);
        return $deleteResult;
    }

    public function findByTagId($tagId){
        $where = $this->getDbTable()->getAdapter()->quoteInto('news_tag_id = ?', $tagId);
        return $this->_findWhere($where);
    }


}