define([
    'backbone',
    '../collections/organizations-timeline',
    'text!../templates/paginator.html',
    'text!../templates/organization-timeline-upcoming.html',
    'i18n!../../../nls/dashboard_'+$('#main-dashboard-system-language').val()+'_ln',
    'moment',
    'accounting'
], function(Backbone,
            OrganizationTimelineCollection, PaginatorTmpl, OrganizationTimelineUpcomingTmpl, i18n, moment, accounting
){

    var OrganizationsTimelineUpcomingView = Backbone.View.extend({
        el: $('#organization-timeline-upcoming-events'),
        events: {
            'click a[data-role=delete]': 'deleteFromTimeline'
        },
        templates: {
        },
        initialize: function(organizationModel){
            this.timelineUpcoming = new OrganizationTimelineCollection();
            this.timelineUpcoming.timelineType = 'upcoming';
            this.timelineUpcoming.organizationId = organizationModel.get('id');
            this.timelineUpcoming.userTimezoneOffset = organizationModel.get('userTimezoneOffset');
            this.timelineUpcoming.on('reset', this.renderTimeline, this);
            this.timelineUpcoming.on('add', this.renderTimeline, this);
            this.timelineUpcoming.on('destroy', this.renderTimeline, this);
        },
        render: function(){
            var el = $('#lead-contacts'),
                selectedLeads = $(el).val();

            this.timelineUpcoming.server_api = _.extend(this.timelineUpcoming.server_api, {
                'leadId': !_.isEmpty(selectedLeads) ? selectedLeads : [],
                'filter': function() {
                    return {
                        'filter-by-action-type': $('.timeline-filter-by-action-type:checked').val(),
                        'filter-by-type':  $('#filter-action-log-type-block-state').val(),
                        'filter-by-sub-type' : $('#filter-action-log-subtype-state').val()
                    };
                }
            });
            this.timelineUpcoming.pager();
        },
        renderTimeline: function(){
            this.$el.find('#organization-timeline-upcoming-events-body').empty();
            this.timelineUpcoming.each(this.renderTimelineItem, this);
            this.timelineUpcoming.info()['i18n'] = i18n;
            if(this.$el.find('style').length > 0) {
                this.$el.find('style').remove();
            }
        },
        renderTimelineItem: function(TimelineItemData) {
            this.$el.find('#organization-timeline-upcoming-events-body').append( _.template(OrganizationTimelineUpcomingTmpl, {
                'timeLineItem': TimelineItemData,
                'monthRow':false,
                'users':this.timelineUpcoming.usersList,
                'currentUserId':this.timelineUpcoming.currentUserId,
                'accounting': accounting,
                'moneyFormat': this.timelineUpcoming.moneyFormat,
                'userTimezoneOffset': this.timelineUpcoming.userTimezoneOffset,
                'moment':moment,
                'i18n':i18n,
                'leadInfo' : !_.isEmpty(this.timelineUpcoming.leadInfo) ? this.timelineUpcoming.leadInfo : [],
                'gatewayLabelsList':this.timelineUpcoming.gatewayLabelsList
            }));
        },
        deleteFromTimeline: function(e){
            var cid = $(e.currentTarget).data('timeline-id'),
                model = this.timelineUpcoming.get(cid);

            showConfirm(_.isUndefined(i18n['Are you sure want to delete'])?'Are you sure want to delete':i18n['Are you sure want to delete'], function(){
                if (model){
                    model.destroy();
                }
            });
        }
    });

    return OrganizationsTimelineUpcomingView;
});
