define([
    'backbone',
    'i18n!../../../nls/dashboard_'+$('#main-dashboard-system-language').val()+'_ln'
], function(Backbone, i18n){
    var LeadOrganizationFormView = Backbone.View.extend({
        el: $('#lead-organization-form'),
        events: {
            'submit': 'submit',
            'blur #lead-organization-name': 'checkOrganizationName',
            'keyup #lead-organization-name': 'checkOrganizationName'
        },
        templates: {

        },
        initialize: function(){
            this.$el = $('#lead-organization-form');
            this.$el.attr('action', $('#website_url').val()+'api/leads/leadorganization');
            $("#lead-organization-name")
                .on("keydown", function(event) {
                    if ( event.keyCode === $.ui.keyCode.TAB &&
                        $(this).autocomplete( "instance" ).menu.active) {
                        event.preventDefault();
                    }
                })
                .autocomplete({
                    source: function( request, response ) {
                        $.ajax({
                            'url': $('#website_url').val()+'api/leads/leadorganization/',
                            'type':'GET',
                            'dataType':'json',
                            'data': {searchTerm: request.term}
                        }).done(function(responseData){
                            if (!_.isEmpty(responseData)) {
                                response($.map(responseData, function (responseData) {
                                    return {
                                        label: responseData.organization_name,
                                        value: responseData.organization_name
                                    };
                                }));
                            }
                        });
                    },
                    search: function() {

                    },
                    focus: function() {
                        return false;
                    },
                    select: function( event, ui ) {

                    }
                });

        },
        render: function(){
            return this;
        },
        checkOrganizationName:function(e)
        {
            var organizationName = $(e.currentTarget).val();
            if (_.isEmpty(organizationName)) {
                return false;
            }

            $.ajax({
                'url': $('#website_url').val()+'api/leads/leadorganization/',
                'type':'GET',
                'dataType':'json',
                'data': {searchTerm:organizationName}
            }).done(function(responseData){
                if (!_.isEmpty(responseData[0])) {
                    $('#lead-organization-form-save').val(_.isUndefined(i18n['Go to profile']) ? 'Go to profile':i18n['Go to profile']).attr('id', 'go-to-lead-organization-profile');
                    $(document).find('#go-to-lead-organization-profile').data('cid', responseData[0].id);
                } else {
                    $('#go-to-lead-organization-profile').attr('id', 'lead-organization-form-save').val('Add organization');
                }
            }).fail(function(response){
                console.log(response);
            });
        },
        submit: function(e){
            e.preventDefault();

            var self = this,
                form = $(e.currentTarget),
                isValid = true,
                submitButton = form.find('#lead-organization-form-save');

            if (submitButton.length < 1) {
                return false;
            }
            _.each(form.find('.required'), function(el){
                if (!$(el).val()){
                    isValid = false;
                }
            });

            if (!isValid){
                showMessage(_.isUndefined(i18n['Missing required field'])?'Missing required field':i18n['Missing required field'], true);
                return false;
            }


            var formParams = form.serialize();

            $.ajax({
                url: form.attr('action'),
                type: 'POST',
                data: formParams,
                dataType: 'json'
            }).done(function(response) {
                 self.$el.trigger('LeadOrganizationForm:created');
                 showMessage(response.responseText, false, 5000);
                 form.find('input[type="text"]').val('');
                 form.find('textarea').val('');
                 $('.switch-lead-organization-creation').trigger('click');
            }).fail(function(response){
                showMessage(response.responseJSON, true, 5000);
            });
            return false;

        }
    });

    return LeadOrganizationFormView;
});