define([
    'backbone',
    '../models/organization-custom-params',
    '../collections/organization-custom-params',
    'text!../templates/paginator.html',
    'text!../templates/organization-custom-params.html',
    'text!../templates/organization-custom-options-params.html',
    'i18n!../../../nls/dashboard_'+$('#main-dashboard-system-language').val()+'_ln',
    'moment'
], function(Backbone,
            OrganizationCustomParamModel, OrganizationCustomParamsCollection, PaginatorTmpl, OrganizationCustomParamsTmpl, OrganizationCustomOptionsParamsTmpl, i18n, moment
){

    var OrganizationCustomParamsView = Backbone.View.extend({
        el: $('#lead-organization-detailed-view-statistics-tab-custom-params'),
        events: {
            'blur .lead-organization-custom-param-input-data,.lead-organization-custom-param-input-data-tab': 'saveOrganizationParamData',
            'change .lead-organization-custom-param-option-data,.lead-organization-custom-param-option-data-tab': 'saveOrganizationParamData',
            'change .lead-organization-custom-param-date-data,.lead-organization-custom-param-date-data-tab': 'saveOrganizationParamData',
            'change input.lead-organization-custom-param-checkbox-data,input.lead-organization-custom-param-checkbox-data-tab': 'saveOrganizationParamData',
            'change input.lead-organization-custom-param-radio-data,input.lead-organization-custom-param-radio-data-tab': 'saveOrganizationParamData'
        },
        templates: {
            paginator: _.template(PaginatorTmpl)
        },
        initialize: function(organizationId, options){
            this.organizationCustomParams = new OrganizationCustomParamsCollection();
            this.organizationCustomParams.grid = options.grid || false;
            this.organizationCustomParams.organizationId = organizationId || false;
            this.organizationCustomParams.customTabId = options.customTabId || null;

            this.organizationCustomParams.on('reset', this.renderCustomParams, this);
            this.organizationCustomParams.on('add', this.renderCustomParams, this);
            this.organizationCustomParams.on('destroy', this.renderCustomParams, this);
        },
        render: function(){
            this.organizationCustomParams.pager();
        },
        renderCustomParams: function(){
            this.$el.empty();
            if (this.organizationCustomParams.length === 0) {
                var emptyAttributesText = (_.isUndefined(i18n['Add custom organization fields to your setup first and they\'ll show up here']) ? 'Add custom organization fields to your setup first and they\'ll show up here':i18n['Add custom organization fields to your setup first and they\'ll show up here']);
                this.$el.append('<span class="text-center block larger" id="custom-attributes-empty-message"><b>'+emptyAttributesText+'</b></span>');
            } else {
                this.organizationCustomParams.each(this.renderCustomParam, this);
            }
            this.organizationCustomParams.info()['i18n'] = i18n;
        },
        renderCustomParam: function(organizationCustomParamData)
        {
            var customAttributes = organizationCustomParamData.attributes,
                customTabField = false;

            if(typeof customAttributes.visible !== 'undefined') {
                customTabField = true;
                if(!customAttributes.visible) {
                    return;
                }
            }

            if(customAttributes.param_type == 'text'){
                this.$el.append(_.template(OrganizationCustomParamsTmpl, {'paramsData': organizationCustomParamData, 'customTabField': customTabField, 'i18n': i18n}));
            }else{
                this.$el.append(_.template(OrganizationCustomOptionsParamsTmpl, {'paramsData': organizationCustomParamData, 'customTabField': customTabField, 'i18n': i18n}));
                if(customAttributes.param_type == 'date'){
                    var leadOrganizationCustomParamDateData = $('#lead-organization-custom-param-date-data'+customAttributes.param_id);
                    if(customTabField) {
                        leadOrganizationCustomParamDateData = $('#lead-organization-custom-param-date-data'+customAttributes.param_id+'-tab');
                    }

                    leadOrganizationCustomParamDateData.datepicker({
                        dateFormat: 'd-M-yy',
                        changeMonth: true,
                        changeYear: true
                    });
                    if(customAttributes.param_value != null && customAttributes.param_value != ''){
                        leadOrganizationCustomParamDateData.val(moment(customAttributes.param_value, 'YYYY-MM-DD HH:mm:ss').format('DD-MMMM-YYYY'));
                    }
                }
            }
        },
        saveOrganizationParamData: function(e)
        {
            var organizationId = $('#lead-organization-detailed-view-statistics-tab-custom-params').data('organization-id'),
                currentEl = $(e.currentTarget),
                paramId = currentEl.data('param-id'),
                paramType = currentEl.data('param-type'),
                id = currentEl.data('id'),
                oldParamValue = currentEl.data('old-value'),
                currentValue = currentEl.val(),
                self = this;

            /*if(paramType == 'date'){
                currentValue = (currentEl.val()) ? $.datepicker.formatDate('yy-mm-dd', currentEl.datepicker("getDate")): '';
            }*/

            if(paramType == 'checkbox'){
                currentValue = (currentEl.is( ":checked" )) ? currentValue: '';
            }

            if(paramType == 'radio'){
                oldParamValue = $('.lead-organization-custom-param-radio-'+id).data('old-value');
            }

            if (oldParamValue === currentValue) {
                return false;
            }

            if(typeof id === 'undefined'){
                return false;
            }

            if (!id) {
                this.organizationCustomParamModel = new OrganizationCustomParamModel();
            } else {
                this.organizationCustomParamModel = new OrganizationCustomParamModel({'id':id});
            }

            this.organizationCustomParamModel.set('organization_id', organizationId);
            this.organizationCustomParamModel.set('param_value', currentValue);
            this.organizationCustomParamModel.set('param_id', paramId);
            this.organizationCustomParamModel.set('secureToken', $('#lead-organization-grid-token').val());
            this.organizationCustomParamModel.set('param_type', paramType);
            this.organizationCustomParamModel.save(null, {
                success: function(model, response){
                    showMessage(response.responseText.message, false, 5000);
                    if(paramType == 'radio') {
                        $('.lead-organization-custom-param-radio-'+id).data('old-value', currentValue);
                    } else {
                        currentEl.data('old-value', currentValue);
                    }

                    if (self.organizationCustomParamModel.isNew()) {
                        currentEl.data('id', response.responseText.id);
                    }
                },
                error: function(model, response){
                    showMessage(response.responseJSON, true, 5000);
                }
            });

        }
    });

    return OrganizationCustomParamsView;
});
