define([
    'backbone',
    './organization-form',
    './organization-grid',
    './organization-filter-preset-config',
    './organization-detailed-info',
    '../models/organization',
    './organization-main',
    '../../leads/views/lead-recently-viewed',
    'i18n!../../../nls/dashboard_'+$('#main-dashboard-system-language').val()+'_ln'
], function(Backbone,
            OrganizationFormView, OrganizationGridView, OrganizationFilterPresetConfig, OrganizationDetailedView, OrganizationModel, OrganizationMainView, LeadRecentlyViewedView, i18n){
    var OrganizationsRouter = Backbone.Router.extend({

        routes: {
            ''         : 'index',
            'organization/:id' : 'leadOrganizationDetails'
        },
        index: function (){
            //init organization grid data
            $('#lead-organization-block').removeClass('hidden');
            this.OrganizationForm = new OrganizationFormView();
            this.OrganizationForm.render();

            this.OrganizationGrid = new OrganizationGridView();
            this.OrganizationGrid.render();

            this.recentlyViewed = new LeadRecentlyViewedView();
            this.recentlyViewed.render();

            this.OrganizationForm.$el.on('LeadOrganizationForm:created', _.bind(this.OrganizationGrid.render, this.OrganizationGrid));
            this.OrganizationGrid.$el.on('LeadOrganizationStatus:changed', _.bind(this.OrganizationGrid.render, this.OrganizationGrid));

            this.OrganizationFilterPreset = new OrganizationFilterPresetConfig();
            this.OrganizationFilterPreset.render();

            this.OrganizationMainView = new OrganizationMainView();
            this.OrganizationMainView.render();

        },
        leadOrganizationDetails: function(organizationId)
        {
            if (!organizationId) {
                return false;
            }

            this.OrganizationModel =  new OrganizationModel();
            this.OrganizationModel.set('id', organizationId);
            this.OrganizationModel.fetch({data: { isGrid: true, detailedInfo:true},
                'success': function(OrganizationModel){
                    if(_.isUndefined(OrganizationModel.get('organization_name'))) {
                        window.location.href = window.location.pathname;
                    } else {
                        if(!_.isUndefined(this.OrganizationDetailed)) {
                            this.OrganizationDetailed.$el.unbind();
                        }
                        $('#lead-organizations-recently-viewed-block').addClass('hidden');
                        this.OrganizationDetailed = new OrganizationDetailedView(OrganizationModel);
                        window.OrganizationDetailed = this.OrganizationDetailed;
                        this.OrganizationDetailed.render();
                        $('#lead-organization-table-block').hide();
                        $('.lead-organization-filters').hide();
                        $('#lead-organization-grid-back-link').removeClass('hidden');
                        $('#lead-organization-block').removeClass('hidden');
                        $('.filter-configuration-elements').addClass('hidden');
                        $('#lead-organization-additional-filters').hide();
                        if (window.location.hash !== '') {
                            $('#lead-organization-grid-back').attr('href', $('#website_url').val()+'dashboard/organizations/');
                        }
                        $.post($('#website_url').val()+'plugin/leads/run/logLastViewed/', {'id':organizationId, 'secureToken':$('#lead-organization-grid-token').val(), 'type':'organization'}, function(){
                        }, 'json');
                    }
                }
            });
        },
        leadTooltipInfo: function (param) {
            var equal = _.isUndefined(i18n['Equal']) ? 'Equal' : i18n['Equal'],
                equalDescription = _.isUndefined(i18n['If you only want to match 1 item, like city, then type in its name, like']) ? 'If you only want to match 1 item, like city, then type in its name, like' : i18n['If you only want to match 1 item, like city, then type in its name, like'],
                notEqual = _.isUndefined(i18n['Not Equal']) ? 'Not Equal' : i18n['Not Equal'],
                notEqualDescription = _.isUndefined(i18n['If you want to match all items except one, then type in the name of the item you want to exclude']) ? 'If you want to match all items except one, then type in the name of the item you want to exclude' : i18n['If you want to match all items except one, then type in the name of the item you want to exclude'],
                contains = _.isUndefined(i18n['Contains']) ? 'Contains' : i18n['Contains'],
                containsDescription = _.isUndefined(i18n['If you want to match all items containing some specific word, then type in this specific word here']) ? 'If you want to match all items containing some specific word, then type in this specific word here' : i18n['If you want to match all items containing some specific word, then type in this specific word here'],
                any = _.isUndefined(i18n['Any']) ? 'Any' : i18n['Any'],
                anyDescription = _.isUndefined(i18n['If you want to match any item out of some range, then type in the list of items separated with comma']) ? 'If you want to match any item out of some range, then type in the list of items separated with comma' : i18n['If you want to match any item out of some range, then type in the list of items separated with comma'],
                greaterthan = _.isUndefined(i18n['Greater Than']) ? 'Greater Than' : i18n['Greater Than'],
                greaterthanDescription = _.isUndefined(i18n['Use when you want results that exceed the value you enter']) ? 'Use when you want results that exceed the value you enter' : i18n['Use when you want results that exceed the value you enter'],
                lessthan = _.isUndefined(i18n['Less Than']) ? 'Less Than' : i18n['Less Than'],
                lessthanDescription = _.isUndefined(i18n['Use for results that are less than the value you enter']) ? 'Use for results that are less than the value you enter' : i18n['Use for results that are less than the value you enter'];

            var description = '\'<b>'+equal+'</b>\' - '+equalDescription+' \'Boston\'. <br/>' +
                '\'<b>'+ notEqual +'</b>\' - '+ notEqualDescription +'. <br/>' +
                '\'<b>'+ contains +'</b>\' - '+ containsDescription +'. <br/>' +
                '\'<b>'+ any +'</b>\'- '+ anyDescription +'. <br/>' +
                '\'<b>'+ greaterthan +'</b>\'- '+ greaterthanDescription +'. <br/>' +
                '\'<b>'+ lessthan +'</b>\'- '+ lessthanDescription +'.';

            if(!_.isEmpty(param)){
                if(param == 'equal'){
                    description =  equalDescription +' \'Boston\'.';
                }else if(param == 'notequal'){
                    description = notEqualDescription +'.';
                }else if(param == 'like'){
                    description = containsDescription +'.';
                }else if(param == 'in'){
                    description = anyDescription +'.';
                }else if(param == 'greaterthan'){
                    description = greaterthanDescription +'.';
                }else if(param == 'lessthan'){
                    description = lessthanDescription +'.';
                }
            }

            return description;
        }

    });

    var initialize = function() {
        window.appLeadOrganizationRouter = new OrganizationsRouter();
        Backbone.history.start();
    };

    return {
        initialize: initialize
    };
});