define([
    'backbone',
    '../models/organization-custom-params',
    'backbone.paginator'
], function(Backbone, OrganizationCustomParamsModel){

    var OrganizationCustomParamsCollection = Backbone.Paginator.requestPager.extend({
        model: OrganizationCustomParamsModel,
        paginator_core: {
            type: 'GET',
            dataType: 'json',
            url: function(){
                return $('#website_url').val() + 'api/leads/organizationcustomparams/';
            }
        },
        paginator_ui: {
            firstPage:    0,
            currentPage:  0,
            perPage:     100,
            totalPages:  100
        },
        server_api: {
            count: true,
            limit: function() { return this.perPage; },
            offset: function() { return this.currentPage * this.perPage },
            key: function(){ return this.key; },
            organizationId:function(){
                return this.organizationId;
            },
            grid:function(){return this.grid;},
            customTabId:function(){return this.customTabId;}
        },
        parse: function(response, xhr){
            if (this.server_api.count){
                this.totalRecords = response.totalRecords;
            } else {
                this.totalRecords = response.length;
            }

            this.totalPages = Math.floor(this.totalRecords / this.perPage);
            return this.server_api.count ? response.data : response;
        }

    });

    return OrganizationCustomParamsCollection;
});