define([
    'backbone',
    '../collections/leads-timeline',
    'text!../templates/paginator.html',
    'text!../templates/lead-timeline-log.html',
    'i18n!../../../nls/dashboard_'+$('#main-dashboard-system-language').val()+'_ln',
    'moment',
    'accounting'
], function(Backbone,
            LeadTimelineCollection, PaginatorTmpl, LeadTimelineLogTmpl, i18n, moment, accounting
){

    var LeadsTimelineTodayView = Backbone.View.extend({
        el: $('#lead-timeline-today'),
        events: {
            'click .timeline-view-profile': 'viewProfileRecord',
            'blur .add-additional-meeting-info': 'addMeetingAdditionalInfo'
        },
        templates: {
        },
        initialize: function(leadModel){
            this.timelineToday = new LeadTimelineCollection();
            this.timelineToday.timelineType = 'today';
            this.timelineToday.leadId = leadModel.get('id');
            this.timelineToday.userTimezoneOffset = leadModel.get('userTimezoneOffset');
            this.timelineToday.on('reset', this.renderTimeline, this);
            this.timelineToday.on('add', this.renderTimeline, this);
            this.timelineToday.on('destroy', this.renderTimeline, this);
        },
        render: function(){
            this.timelineToday.server_api = _.extend(this.timelineToday.server_api, {
                'filter': function() {
                    return {
                        'filter-by-action-type': $('.timeline-filter-by-action-type:checked').val(),
                        'filter-by-type':  $('#filter-action-log-type-block-state').val(),
                        'filter-by-sub-type' : $('#filter-action-log-subtype-state').val()
                    };
                }
            });
            this.timelineToday.pager();
        },
        viewProfileRecord: function(e){
            e.preventDefault();

            var visitLogId = $(e.currentTarget).data('timiline-profile-visit-id'),
                positionInGridLeadId = $(e.currentTarget).data('lead-id');

            $.ajax({
                url: $('#website_url').val()+'api/leads/leadprofile/',
                type: 'GET',
                data: {'visitLogId':visitLogId, 'calculatePositionInGrid':true, 'positionInGridLeadId':positionInGridLeadId},
                dataType: 'json'
            }).done(function(response) {
                window.LeadDetailedView.showVisitInProfile(response.visitPageNumber, visitLogId);
            }).fail(function(response){
                showMessage(response.responseJSON, true, 5000);
            });
        },
        addMeetingAdditionalInfo: function(e)
        {
            var el = $(e.currentTarget),
                meetingLogId = el.data('meeting-log-id'),
                additionalComment = el.val(),
                oldAdditionalData = el.data('old-additional-data');
            if (oldAdditionalData === additionalComment) {
                return false;
            }

            $.ajax({
                url: $('#website_url').val()+'api/leads/leadmeetinglog/',
                type: 'PUT',
                data: JSON.stringify({'id':meetingLogId, 'additional_content':additionalComment, 'secureToken':$('#lead-grid-token').val()}),
                dataType: 'json'
            }).done(function(response) {
                showMessage(response.responseText, false, 5000);
                el.data('old-additional-data', additionalComment);
            }).fail(function(response){
                showMessage(response.responseJSON, true, 5000);
            });
        },
        renderTimeline: function(){
            this.$el.find('#lead-timeline-today-body').empty();
            this.timelineToday.each(this.renderTimelineItem, this);
            this.timelineToday.info()['i18n'] = i18n;
            if(this.$el.find('style').length > 0) {
                this.$el.find('style').remove();
            }

            $('._lbox').magnificPopup({type: 'image'});
        },
        renderTimelineItem: function(TimelineItemData) {
            this.$el.find('#lead-timeline-today-body').append( _.template(LeadTimelineLogTmpl, {
                'timeLineItem': TimelineItemData, 'monthRow':false, 'users':this.timelineToday.usersList, 'currentUserId':this.timelineToday.currentUserId,
                'currencySymbol':this.timelineToday.currencySymbol,   'logType': 'today',
                'moment': moment,
                'accounting': accounting,
                'moneyFormat': this.timelineToday.moneyFormat,
                'i18n': i18n,
                'userTimezoneOffset': this.timelineToday.userTimezoneOffset,
                'gatewayLabelsList':this.timelineToday.gatewayLabelsList
            }));
        }
    });

    return LeadsTimelineTodayView;
});
