define([
    'backbone',
    '../collections/leads-timeline',
    'text!../templates/paginator.html',
    'text!../templates/lead-timeline-log.html',
    'i18n!../../../nls/dashboard_'+$('#main-dashboard-system-language').val()+'_ln',
    'moment',
    'accounting'
], function(Backbone,
            LeadTimelineCollection, PaginatorTmpl, LeadTimelineLogTmpl, i18n, moment, accounting
){

    var LeadsTimelineLogView = Backbone.View.extend({
        el: $('#lead-timeline-log'),
        events: {
            'click td.lead-timeline-log-history-grid-paginator a.page': 'navigate',
            'blur .add-additional-meeting-info': 'addMeetingAdditionalInfo',
            'click .timeline-view-profile': 'viewProfileRecord'
        },
        templates: {
            paginator: _.template(PaginatorTmpl)
        },
        initialize: function(leadModel){
            this.timelineLog = new LeadTimelineCollection();
            this.timelineLog.leadId = leadModel.get('id');
            this.timelineLog.userTimezoneOffset = leadModel.get('userTimezoneOffset');
            this.timelineLog.on('reset', this.renderTimeline, this);
            this.timelineLog.on('add', this.renderTimeline, this);
            this.timelineLog.on('destroy', this.renderTimeline, this);

        },
        render: function(param){
            if(!_.isUndefined(param)) {
                this.timelineLog.currentPage = 0;
            }
            this.timelineLog.server_api = _.extend(this.timelineLog.server_api, {
                'filter': function() {
                    return {
                        'filter-by-action-type': $('.timeline-filter-by-action-type:checked').val(),
                        'filter-by-type':  $('#filter-action-log-type-block-state').val(),
                        'filter-by-sub-type' : $('#filter-action-log-subtype-state').val()
                    };
                }
            });
            this.timelineLog.pager();
        },
        renderTimeline: function(){
            this.previousLogMonth = false;
            this.$el.find('#lead-timeline-log-body').empty();
            this.timelineLog.each(this.renderTimelineItem, this);
            this.timelineLog.info()['i18n'] = i18n;
            if (this.timelineLog.information.totalRecords > 0) {
                this.$('td.lead-timeline-log-history-grid-paginator').html(this.templates.paginator(this.timelineLog.information));
            } else {
                this.$('td.lead-timeline-log-history-grid-paginator').html('');
            }
            if(this.$el.find('style').length > 0) {
                this.$el.find('style').remove();
            }

            $('._lbox').magnificPopup({type: 'image'});
        },
        viewProfileRecord: function(e){
            e.preventDefault();

            var visitLogId = $(e.currentTarget).data('timiline-profile-visit-id'),
                positionInGridLeadId = $(e.currentTarget).data('lead-id');

            $.ajax({
                url: $('#website_url').val()+'api/leads/leadprofile/',
                type: 'GET',
                data: {'visitLogId':visitLogId, 'calculatePositionInGrid':true, 'positionInGridLeadId':positionInGridLeadId},
                dataType: 'json'
            }).done(function(response) {
                window.LeadDetailedView.showVisitInProfile(response.visitPageNumber, visitLogId);
            }).fail(function(response){
                showMessage(response.responseJSON, true, 5000);
            });
        },
        renderTimelineItem: function(TimelineItemData) {
            var previousCreatedLogDate = moment(TimelineItemData.get('created_at'), 'YYYY-MM-DD HH:mm:ss').format('MMMM'),
                monthRow = false;
            if (_.isUndefined(this.previousLogMonth) || this.previousLogMonth !== previousCreatedLogDate) {
                this.previousLogMonth = previousCreatedLogDate;
                monthRow = previousCreatedLogDate;
            }

            this.$el.find('#lead-timeline-log-body').append( _.template(LeadTimelineLogTmpl, {
                'timeLineItem': TimelineItemData, 'monthRow':monthRow, 'users':this.timelineLog.usersList, 'currentUserId':this.timelineLog.currentUserId, 'currencySymbol':this.timelineLog.currencySymbol,
                'logType': 'expired',
                'moment': moment,
                'accounting': accounting,
                'moneyFormat': this.timelineLog.moneyFormat,
                'i18n' : i18n,
                'userTimezoneOffset': this.timelineLog.userTimezoneOffset,
                'gatewayLabelsList':this.timelineLog.gatewayLabelsList
            }));
        },
        addMeetingAdditionalInfo: function(e)
        {
            var el = $(e.currentTarget),
                meetingLogId = el.data('meeting-log-id'),
                additionalComment = el.val(),
                oldAdditionalData = el.data('old-additional-data');
            if (oldAdditionalData === additionalComment) {
                return false;
            }

            $.ajax({
                url: $('#website_url').val()+'api/leads/leadmeetinglog/',
                type: 'PUT',
                data: JSON.stringify({'id':meetingLogId, 'additional_content':additionalComment, 'secureToken':$('#lead-grid-token').val()}),
                dataType: 'json'
            }).done(function(response) {
                showMessage(response.responseText, false, 5000);
                el.data('old-additional-data', additionalComment);
            }).fail(function(response){
                showMessage(response.responseJSON, true, 5000);
            });
        },
        navigate: function(e){
            e.preventDefault();

            var page = $(e.currentTarget).data('page');
            if ($.isNumeric(page)){
                this.timelineLog.goTo(page);
            } else {
                switch(page){
                    case 'first':
                        this.timelineLog.goTo(this.timelineLog.firstPage);
                        break;
                    case 'last':
                        this.timelineLog.goTo(this.timelineLog.totalPages);
                        break;
                    case 'prev':
                        this.timelineLog.requestPreviousPage();
                        break;
                    case 'next':
                        this.timelineLog.requestNextPage();
                        break;
                }
            }
        }
    });

    return LeadsTimelineLogView;
});
