define([
    'backbone',
    '../collections/lead-opportunity-timeline',
    'text!../templates/lead-opportunity-timeline.html',
    'text!../templates/lead-opportunity-timeline-filter.html',
    'text!../templates/paginator.html',
    '../models/lead-opportunity-quote',
    '../collections/lead-opportunities',
    'i18n!../../../nls/dashboard_'+$('#main-dashboard-system-language').val()+'_ln',
    'moment',
    'accounting',
    'chosen',
], function(Backbone,
            LeadOpportunityTimelineCollection, LeadOpportunityTimelineTmpl, LeadOpportunityTimelineFilterTmpl, PaginatorTmpl, LeadOpportunityQuoteModel, LeadOpportunityCollection, i18n, moment, accounting, chosen
){

    var LeadOpportunityTimelineView = Backbone.View.extend({
        el: $('#lead-detailed-view-statistics-tab-opportunity'),
        events: {
            'click .create-new-quote-for-opportunity': 'createQuote',
            'click .remove-quote-opportunity': 'removeQuote',
            'click .remove-quote-opportunity-section': 'removeOpportunity',
            'click .edit-quote-opportunity-section': 'editOpportunity',
            'change #opportunity-timeline-filter': 'filterBy',
            'click td.lead-opportunity-timeline-grid-paginator a.page': 'navigate',
            'click .lead-form-timeline-opportunity-create-option': 'changeCreationType',
            'click .assign-quote-opportunity': 'assignExistedQuoteOpportunity',
            'click .clear-input-autocomplete': 'clearInputAutocomplete',
            'change .quote-owners-list':'changeQuoteOwner'
        },
        templates: {
            paginator: _.template(PaginatorTmpl)
        },
        initialize: function(leadId){
            this.opportunityTimeline = new LeadOpportunityTimelineCollection();
            this.opportunityTimeline.lead_id = leadId;
            this.opportunityTimeline.on('reset', this.renderTimeline, this);
            this.opportunityTimeline.on('add', this.renderTimeline, this);
            this.opportunityTimeline.on('destroy', this.renderTimeline, this);

        },
        render: function(param){
            if(!_.isUndefined(param)) {
                this.opportunityTimeline.currentPage = 0;
                this.keepFilter = true;
            } else {
                this.keepFilter = false;
            }

            this.opportunityTimeline.server_api = _.extend(this.opportunityTimeline.server_api, {
                'filter': function() {
                    return {
                        'filter-by-opportunity-stage': $('#opportunity-timeline-filter').val()
                    };
                }
            });
            this.opportunityTimeline.server_api.order = 'plo.created_at DESC';
            this.opportunityTimeline.pager();
        },
        changeCreationType: function(e)
        {
            var el = $(e.currentTarget),
                currentStatus = el.data('checked'),
                switchType = el.data('type');

            $(el).closest('td').find('.search-opportunity-quote').prop('checked', false);
            $(el).closest('td').find('.lead-form-timeline-opportunity-create-option').removeClass('checked-btn');
            $(el).addClass('checked-btn');
            if (currentStatus !== true) {
                el.prop('checked', true);
                el.data('checked', true);
            }

            if (switchType === 'create_quote_duplicate') {
                $(el).closest('td').find('.search-opportunity-quote').removeClass('hidden');
            } else {
                $(el).closest('td').find('.search-opportunity-quote').addClass('hidden');
                $(el).closest('td').find('.search-opportunity-quote').val('');
                $(el).closest('td').find('.duplicate-quote-id').val('');
                $(el).closest('td').find('.search-opportunity-quote').closest('.search-block-element-autocomplete').find('.clear-input-autocomplete').addClass('hidden');
            }

            $(el).closest('td').find('.quote-chosen-type').val(switchType);

        },
        renderTimeline: function(){
            this.previousOpportunity = false;
            this.$el.find('tbody').empty();
            if (!this.keepFilter) {
                this.$el.find('#lead-opportunity-filter-block').empty();
                this.$el.find('#lead-opportunity-filter-block').append(_.template(LeadOpportunityTimelineFilterTmpl, {'opportunityStages': this.opportunityTimeline.opportunityStages, 'i18n' : i18n}));
            }
            this.opportunityTimeline.each(this.renderTimelineItem, this);
            this.opportunityTimeline.info()['i18n'] = i18n;
            this.$('td.lead-opportunity-timeline-grid-paginator').html(this.templates.paginator(this.opportunityTimeline.information));
            if (typeof tableResponsive === "function") {
                tableResponsive();
            }

            $(".search-opportunity-quote").on("keydown", function(event) {
                $(this).closest('td').find('.duplicate-quote-id').val('');

                var clearInputAutocomplete = $(event.target).closest('.search-block-element-autocomplete').find('span.clear-input-autocomplete');
                if(typeof clearInputAutocomplete !== 'undefined') {
                    clearInputAutocomplete.addClass('hidden');
                }

                if ( event.keyCode === $.ui.keyCode.TAB &&
                    $(this).autocomplete( "instance" ).menu.active) {
                    event.preventDefault();
                }

                if (event.keyCode === 13) {
                    $(event.target).trigger('keydown');
                }
            }).autocomplete({
                source: function(request, response) {
                    $.ajax({
                        'url': $('#website_url').val()+'plugin/leads/run/getQuoteNames/',
                        'type':'GET',
                        'dataType':'json',
                        'data': {searchTerm: request.term}
                    }).done(function(responseData){
                        if (!_.isEmpty(responseData)) {
                            response($.map(responseData, function (responseData) {
                                return {
                                    label: responseData.title,
                                    value: responseData.title,
                                    custom: responseData.id,
                                };
                            }));
                        }
                    });
                },
                select: function(event, ui ) {
                    var clearInputEl = $(event.target).closest('.search-block-element-autocomplete').find('span.clear-input-autocomplete');
                    if(typeof clearInputEl !== 'undefined') {
                        if(ui.item.custom.length > 0) {
                            $(clearInputEl).removeClass('hidden');
                        } else {
                            $(clearInputEl).addClass('hidden');
                        }
                    }

                    $(this).closest('td').find('.duplicate-quote-id').val(ui.item.custom);
                }
            });

            var self = this;

            $('.search-opportunity-clear-quote').chosen({max_selected_options: 1}).change(function(e){
                e.preventDefault();
                var quoteId = $(e.currentTarget).val();
                if(quoteId != null) {
                    $(this).closest('td').find('.duplicate-quote-id').val(quoteId);
                } else {
                    $(this).closest('td').find('.duplicate-quote-id').val('');
                }

                var searchChoice = $(".chosen-choices li.search-choice");
                if(searchChoice.length) {
                    _.each(searchChoice, function (cName, key) {
                        if($(cName).find('span').length == 1) {
                            $(cName).find('span')[0].textContent = self.truncateString($(cName).find('span')[0].textContent, 15);
                        }
                    });
                }
            });

         },
        truncateString: function (str, num) {
            if (str.length <= num) {
                return str;
            }
            return str.slice(0, num) + '...';
        },
        renderTimelineItem: function(opportunityData) {
            var newOpportunityRow = false,
                opportunityId = opportunityData.get('opportunity_id');
            if (_.isUndefined(this.previousOpportunity) || this.previousOpportunity !== opportunityId) {
                this.previousOpportunity = opportunityId;
                newOpportunityRow = true;
            }

            this.$el.find('tbody').append(_.template(LeadOpportunityTimelineTmpl, {
                'opportunityData': opportunityData, 'newOpportunityRow':newOpportunityRow,
                'opportunityStages':this.opportunityTimeline.opportunityStages,
                'quoteTemplates':this.opportunityTimeline.quoteTemplates,
                'quoteOwners':this.opportunityTimeline.quoteOwners,
                'users':this.opportunityTimeline.usersList,
                'currentUserId':this.opportunityTimeline.currentUserId,
                'currencySymbol':this.opportunityTimeline.currencySymbol,
                'expectedCloseDate': moment(opportunityData.get('expected_close_date'), 'YYYY-MM-DD HH:mm:ss').format('DD-MMM-YYYY'),
                'opportunityCreatedAt': moment(opportunityData.get('opportunityCreatedAt'), 'YYYY-MM-DD HH:mm:ss').format('DD-MMM-YYYY'),
                'moment': moment,
                'accounting': accounting,
                'moneyFormat': this.opportunityTimeline.moneyFormat,
                'i18n' : i18n,
                'leadsData':this.opportunityTimeline.leadsData,
                'quotesWithoutLeads':this.opportunityTimeline.quotesWithoutLeads,
            }));
        },
        editOpportunity: function(e)
        {
            e.preventDefault();
            var delLinkEl = $(e.currentTarget),
                opportunityId = delLinkEl.data('quote-opportunity-id'),
                opportunityTabEl = $('#lead-detailed-view-config-tabs-tab').find('[data-tab-id="lead-detailed-view-config-tab-opportunity"]');
            opportunityTabEl.addClass('remoteOpen').data('checked-opportunity-id', opportunityId).trigger('click');
            $('body,html').animate({
                scrollTop: $('#lead-detailed-view-config-tabs-tab').offset().top - 300
            }, 1000);

        },
        createQuote: function(e)
        {
            e.preventDefault();

            var self = this,
                mainEl = $(e.currentTarget),
                quoteTitleElem = $(e.currentTarget).closest('td').find('.create-new-quote-for-opportunity-title'),
                duplicateQuoteId = $(e.currentTarget).closest('td').find('.duplicate-quote-id').val(),
                leadId = quoteTitleElem.data('lead-id'),
                opportunityId = quoteTitleElem.data('lead-opportunity-id'),
                quoteLabel = quoteTitleElem.val(),
                duplicateEl = $(e.currentTarget).closest('td').find('.duplicate-quote-id'),
                switcherType = $(e.currentTarget).closest('td').find('.quote-chosen-type').val();

            if (switcherType === 'create_quote_duplicate' && duplicateQuoteId == '') {
                showMessage(_.isUndefined(i18n['Please search by quote title'])?'Please search by quote title':i18n['Please search by quote title'], true, 5000);
                return false;
            }

            this.leadOpportunityQuoteModel = new LeadOpportunityQuoteModel();
            mainEl.closest('td').find('.create-new-quote-for-opportunity').prop('disabled', true);

            this.leadOpportunityQuoteModel.set('secureToken', $('#lead-grid-token').val());
            this.leadOpportunityQuoteModel.set('opportunity_id', opportunityId);
            this.leadOpportunityQuoteModel.set('lead_id', leadId);
            this.leadOpportunityQuoteModel.set('quote_title', quoteLabel);
            this.leadOpportunityQuoteModel.set('duplicate_quote_id', duplicateQuoteId);
            this.leadOpportunityQuoteModel.save(null, {
                success: function(model, response){
                    mainEl.closest('td').find('.create-new-quote-for-opportunity').prop('disabled', false);
                    self.$el.trigger('opportunitiesQuotes:created');
                    duplicateEl.val('');
                    showMessage(response.responseText.message, false, 5000);
                    if (typeof window.LeadDetailedView !== 'undefined') {
                        window.LeadDetailedView.renderOpportunityStatsOnly();
                    }

                },
                error: function(model, response){
                    mainEl.closest('td').find('.create-new-quote-for-opportunity').prop('disabled', false);
                    showMessage(JSON.parse(response.responseText), true, 5000);
                }
            });
            return false;

        },
        assignExistedQuoteOpportunity: function (e)
        {
            e.preventDefault();

            var self = this,
                quoteId = $(e.currentTarget).closest('td').find('.duplicate-quote-id').val(),
                quoteTitleElem = $(e.currentTarget).closest('td').find('.create-new-quote-for-opportunity-title'),
                leadId = quoteTitleElem.data('lead-id'),
                opportunityId = quoteTitleElem.data('lead-opportunity-id');

            showConfirm(_.isUndefined(i18n['Are you sure want to assign existed quote?'])?'Are you sure want to assign existed quote?':i18n['Are you sure want to assign existed quote?'], function(){
                $.ajax({
                    'url': $('#website_url').val()+'plugin/leads/run/assignExistedQuoteOpportunuty/',
                    'type':'POST',
                    'dataType':'json',
                    'data': {
                        secureToken   : $('#lead-grid-token').val(),
                        quote_id      : quoteId,
                        opportunity_id: opportunityId,
                        lead_id       : leadId
                    }
                }).done(function(response){
                    if(response.error == 1) {
                        showMessage(response.responseText, true, 5000);
                    } else {
                        self.$el.trigger('opportunitiesQuotes:created');
                        showMessage(response.responseText, false, 3000);
                        if (typeof window.LeadDetailedView !== 'undefined') {
                            window.LeadDetailedView.renderOpportunityStatsOnly();
                        }
                    }
                });
            });

        },
        filterBy: function(e)
        {
            e.preventDefault();
            this.showLoader();
            this.$el.trigger('opportunitiesQuotes:created', true);
        },
        removeQuote: function(e)
        {
            var self = this;
            e.preventDefault();
            showConfirm(_.isUndefined(i18n['Are you sure want to delete the quote?'])?'Are you sure want to delete the quote?':i18n['Are you sure want to delete the quote?'], function(){
                var delLinkEl = $(e.currentTarget),
                    quoteId = delLinkEl.data('quote-id');

                $.ajax({
                    'url': $('#website_url').val() + 'api/quote/quotes/id/'+quoteId,
                    'type': 'DELETE',
                    'dataType': 'json'
                }).done(function(){
                    self.$el.trigger('opportunitiesQuotes:created', true);
                    if (typeof window.LeadDetailedView !== 'undefined') {
                        window.LeadDetailedView.renderOpportunityStatsOnly();
                    }
                });
            });
        },
        removeOpportunity: function(e)
        {
            e.preventDefault();
            var self = this;
            showConfirm(_.isUndefined(i18n['Attention, you are about to delete the opportunity. All attached quotes will be deleted as well.'])?'Attention, you are about to delete the opportunity. All attached quotes will be deleted as well.':i18n['Attention, you are about to delete the opportunity. All attached quotes will be deleted as well.'], function(){
                var delLinkEl = $(e.currentTarget),
                    opportunityId = delLinkEl.data('quote-opportunity-id');

                $.ajax({
                    'url': $('#website_url').val() + 'api/leads/leadopportunity/id/'+opportunityId,
                    'type': 'DELETE',
                    'dataType': 'json'
                }).done(function(response){
                    self.$el.trigger('opportunitiesQuotes:created', true);
                    showMessage(response.responseText, true, 5000);
                    if (typeof window.LeadDetailedView !== 'undefined') {
                        window.LeadDetailedView.renderOpportunityStatsOnly();
                        window.LeadDetailedView.reRenderOpportunityTab();
                    }
                });
            });

        },
        navigate: function(e){
            e.preventDefault();

            var page = $(e.currentTarget).data('page');
            this.showLoader();
            if ($.isNumeric(page)){
                this.opportunityTimeline.goTo(page);
            } else {
                switch(page){
                    case 'first':
                        this.opportunityTimeline.goTo(this.opportunityTimeline.firstPage);
                        break;
                    case 'last':
                        this.opportunityTimeline.goTo(this.opportunityTimeline.information.lastPage);
                        break;
                    case 'prev':
                        this.opportunityTimeline.requestPreviousPage();
                        break;
                    case 'next':
                        this.opportunityTimeline.requestNextPage();
                        break;
                }
            }
        },
        showLoader: function () {
            this.$el.find('tbody').html('<tr><td class="text-center" colspan="7" style="text-align: center;"><img src="' + $('#website_url').val() + 'system/images/spinner-small.gif" border="0" alt="loading..." /></td></tr>');
        },
        clearInputAutocomplete:function (e) {
            var searchInput = $(e.currentTarget).closest('.search-block-element-autocomplete').find('input.search-opp-quote');
            var duplicateQuoteIdEl = $(e.currentTarget).closest('.quote-block').find('input.duplicate-quote-id');

            if(typeof searchInput !== 'undefined') {
                searchInput.val('').focus();
                $(e.currentTarget).addClass('hidden');
                duplicateQuoteIdEl.val('');
            }
        },
        changeQuoteOwner(e)
        {
            var el = $(e.currentTarget),
                quoteId = el.data('quote-id'),
                quoteOwnerId = el.val();

            $.ajax({
                type: 'POST',
                url: $('#website_url').val()+'plugin/quote/run/changeQuoteOwner',
                data: {
                    quoteOwnerId: quoteOwnerId,
                    id: quoteId
                }
            });
        }
    });

    return LeadOpportunityTimelineView;
});
