define([
    'backbone',
    '../models/lead-opportunity',
    '../models/lead-opportunity-quote',
    'text!../templates/lead-opportunity-detailed-tab.html',
    '../collections/lead-opportunities',
    'i18n!../../../nls/dashboard_'+$('#main-dashboard-system-language').val()+'_ln',
    'moment'
], function(Backbone, LeadOpportunityModel, LeadOpportunityQuoteModel, LeadOpportunityTmpl, LeadOpportunityCollection, i18n, moment){
    var LeadOpportunityFormView = Backbone.View.extend({
        el: $('#lead-detailed-view-config-tab-opportunity'),
        events: {
            'click .create-quote-and-opportunity': 'submit',
            'submit #lead-tab-opportunity-quote-form': 'createQuote',
            'click .lead-tab-opportunity-switch':'switchOpportunity',
            'change .lead-form-opportunity': 'chooseExistingOpportunity',
            'keypress .lead-form-opportunity-value' : 'checkInputOpportunityValue',
            'click .lead-form-opportunity-create-option' : 'changeCreationType',
            'click .clear-input-autocomplete': 'clearInputAutocomplete',
        },
        templates: {

        },
        initialize: function(leadModel, leadOpportunitiesData){
            this.leadModel = leadModel;
            this.leadOpportunitiesData = leadOpportunitiesData;
        },
        render: function(){
            this.$el.empty();
            this.$el.html(_.template(LeadOpportunityTmpl, {'leadModel': this.leadModel, 'leadOpportunitiesData': this.leadOpportunitiesData, 'i18n': i18n}));
            this.$el.attr('action', $('#website_url').val()+'api/leads/opportunity');

            $('#lead-form-opportunity-created-at-date').val(this.leadOpportunitiesData.createdAtDate);
            $('#lead-form-opportunity-expected-close-date').val(moment(this.leadOpportunitiesData.createdAtDate).add(30, 'day').format('DD-MMM-YYYY'));

            var leadOpportunityCreatedAtDate = $('#lead-form-opportunity-created-at-date'),
                leadOpportunityEndDate = $('#lead-form-opportunity-expected-close-date');

            $('#lead-form-opportunity-created-at-date').datepicker({
                dateFormat: 'd-M-yy',
                changeMonth: true,
                changeYear: true,
                yearRange: "c-5:c+5",
                onSelect: function(selectedDate){
                    let createdAtDate = moment(leadOpportunityCreatedAtDate.datepicker('getDate')).startOf('day').format('YYYY-MM-DD');
                    let endDate = moment(leadOpportunityEndDate.datepicker('getDate')).endOf('day').format('YYYY-MM-DD');
                    if (endDate !== '' && createdAtDate !== '') {
                        if(createdAtDate > endDate) {
                            leadOpportunityEndDate.datepicker("setDate", selectedDate);
                        }
                    }
                }
            });

            $('#lead-form-opportunity-expected-close-date').datepicker({
                dateFormat: 'd-M-yy',
                defaultDate: "+1w",
                changeMonth: true,
                changeYear: true,
                yearRange: "c-5:c+5",
                onSelect: function(selectedDate){
                    let createdAtDate = moment(leadOpportunityCreatedAtDate.datepicker('getDate')).startOf('day').format('YYYY-MM-DD');
                    let endDate = moment(leadOpportunityEndDate.datepicker('getDate')).endOf('day').format('YYYY-MM-DD');
                    if (endDate !== '' && createdAtDate !== '' && createdAtDate !== 'Invalid date') {
                        if(createdAtDate > endDate) {
                            leadOpportunityCreatedAtDate.datepicker("setDate", selectedDate);
                        }
                    }
                }
            });

            if (typeof this.leadOpportunitiesData.checkedOpportunityId !== 'undefined' && this.leadOpportunitiesData.checkedOpportunityId !== '') {
                var opportunityTabEl = $('#lead-detailed-view-config-tabs-tab').find('[data-tab-id="lead-detailed-view-config-tab-opportunity"]');
                opportunityTabEl.data('checked-opportunity-id', '');
                this.$el.find('#lead-tab-existing-opportunity').trigger('click');
                this.$el.find('.lead-form-opportunity').val(this.leadOpportunitiesData.checkedOpportunityId).trigger('change');
            }

            $("#search-opportunity-quote").on("keydown", function(event) {
                $('#duplicate_quote_id').val('');
                var clearInputAutocomplete = $("#search-opportunity-quote").closest('.search-block-element-autocomplete').find('.clear-input-autocomplete');
                if(typeof clearInputAutocomplete !== 'undefined') {
                    clearInputAutocomplete.addClass('hidden');
                }

                if ( event.keyCode === $.ui.keyCode.TAB &&
                    $(this).autocomplete( "instance" ).menu.active) {
                    event.preventDefault();
                }

                if (event.keyCode === 13) {
                    $("#search-opportunity-quote").trigger('keydown');
                }
            }).autocomplete({
                source: function(request, response) {
                    $.ajax({
                        'url': $('#website_url').val()+'plugin/leads/run/getQuoteNames/',
                        'type':'GET',
                        'dataType':'json',
                        'data': {searchTerm: request.term}
                    }).done(function(responseData){
                        if (!_.isEmpty(responseData)) {
                            response($.map(responseData, function (responseData) {
                                return {
                                    label: responseData.title,
                                    value: responseData.title,
                                    custom: responseData.id,
                                };
                            }));
                        }
                    });
                },
                select: function(event, ui ) {
                    var clearInputEl = $("#search-opportunity-quote").closest('.search-block-element-autocomplete').find('span.clear-input-autocomplete');
                    if(typeof clearInputEl !== 'undefined') {
                        if(ui.item.custom.length > 0) {
                            $(clearInputEl).removeClass('hidden');
                        } else {
                            $(clearInputEl).addClass('hidden');
                        }
                    }

                    $('#duplicate_quote_id').val(ui.item.custom);
                }
            });

            return this;
        },
        changeCreationType: function(e)
        {
            var el = $(e.currentTarget),
                currentStatus = el.data('checked');

            if (currentStatus !== true) {
                el.prop('checked', true);
                el.data('checked', true);
            }

            if ($(el).val() === 'create_quote_duplicate') {
                $('#search-opportunity-quote').removeClass('hidden');
            } else {
                $('#search-opportunity-quote').addClass('hidden');
                $('#duplicate_quote_id').val('');
                $('#search-opportunity-quote').val('');
                var clearInputAutocomplete = $("#search-opportunity-quote").closest('.search-block-element-autocomplete').find('.clear-input-autocomplete');
                if(typeof clearInputAutocomplete !== 'undefined') {
                    clearInputAutocomplete.addClass('hidden');
                }
            }

            $('span.opportunity-creation-label').addClass('hidden');
            $('#lead-form-opportunity-'+$(el).val()+'-label').removeClass('hidden');
        },
        chooseExistingOpportunity: function(e)
        {
            var switchOpportunity = $(e.currentTarget),
                opportunityForm = switchOpportunity.closest('form'),
                opportunitySwitchVal = switchOpportunity.val(),
                opportunityId = opportunityForm.find('.lead-form-opportunity').val();

            if (opportunitySwitchVal == '0') {
                opportunityForm.find('.lead-form-opportunity-name').addClass('hidden');
                opportunityForm.find('.lead-form-opportunity').removeClass('grid_4').addClass('grid_6');
                opportunityForm.find('.lead-opportunity-type-selection').val(0);
                opportunityForm.find('.lead-form-opportunity-value').val('');
                opportunityForm.find('.lead-form-opportunity-stages').val(1);
                //$('#lead-form-opportunity-expected-close-date').val('');
                opportunityForm.find('#lead-form-opportunity-created-at-date').closest('p').removeClass('grid_2').addClass('grid_3');
                opportunityForm.find('#lead-form-opportunity-expected-close-date').closest('p').removeClass('grid_2').addClass('grid_3');
                //opportunityForm.find('.lead-form-opportunity-name').removeClass('grid_3').addClass('grid_4');
                //opportunityForm.find('#lead-form-opportunity-expected-close-date').closest('p').removeClass('grid_2').addClass('grid_3');
                //opportunityForm.find('.lead-form-opportunity-value').closest('p').removeClass('grid_2').addClass('grid_3');
            } else {
                var opportunityModel = this.leadOpportunitiesData.get(opportunityId);
                opportunityForm.find('.lead-form-opportunity-name').val(opportunityModel.get('opportunity_name')).removeClass('hidden');
                opportunityForm.find('.lead-form-opportunity').removeClass('grid_6').addClass('grid_4');
                //opportunityForm.find('.lead-form-opportunity-name').removeClass('grid_4').addClass('grid_3');
                opportunityForm.find('.lead-opportunity-type-selection').val(opportunityModel.get('opportunity_type_id'));
                opportunityForm.find('.lead-form-opportunity-value').val(parseInt(opportunityModel.get('opportunity_value'), 10));
                opportunityForm.find('.lead-form-opportunity-stages').val(opportunityModel.get('opportunity_stage_id'));
                if (!_.isEmpty(opportunityModel.get('expected_close_date')) && opportunityModel.get('expected_close_date') !== '0000-00-00 00:00:00') {
                    $('#lead-form-opportunity-expected-close-date').val(moment(opportunityModel.get('expected_close_date'), 'YYYY-MM-DD HH:mm:ss').format('DD-MMM-YYYY'));
                } else {
                    $('#lead-form-opportunity-expected-close-date').val('');
                }
                if (!_.isEmpty(opportunityModel.get('created_at')) && opportunityModel.get('created_at') !== '0000-00-00 00:00:00') {
                    $('#lead-form-opportunity-created-at-date').val(moment(opportunityModel.get('created_at'), 'YYYY-MM-DD HH:mm:ss').format('DD-MMM-YYYY'));
                }

                opportunityForm.find('#lead-form-opportunity-created-at-date').closest('p').removeClass('grid_3').addClass('grid_2');
                opportunityForm.find('#lead-form-opportunity-expected-close-date').closest('p').removeClass('grid_3').addClass('grid_2');
            }
        },
        switchOpportunity: function(e){
            var switchEl = $(e.currentTarget),
                opportunityForm = switchEl.closest('form'),
                opportunitySwitchVal = switchEl.val(),
                createOpportunityMessage = _.isUndefined(i18n['Create Opportunity'])?'Create Opportunity':i18n['Create Opportunity'],
                updateOpportunityMessage = _.isUndefined(i18n['Update Opportunity'])?'Update Opportunity':i18n['Update Opportunity'];


            opportunityForm.find('.lead-opportunity-type-selection').val(0);
            opportunityForm.find('.lead-form-opportunity-value').val('');
            opportunityForm.find('.lead-form-opportunity-stages').val(1);
            //$('#lead-form-opportunity-expected-close-date').val('');

            if (opportunitySwitchVal === 'old') {
                opportunityForm.find('.lead-form-opportunity').val(0).removeClass('hidden');
                opportunityForm.find('.lead-form-opportunity-name').removeClass('grid_6').addClass('grid_4').addClass('hidden');
                opportunityForm.find('.lead-form-opportunity').removeClass('grid_4').addClass('grid_6');
                opportunityForm.find('.create-quote-and-opportunity').text(updateOpportunityMessage);
            } else {
                opportunityForm.find('.lead-form-opportunity-name').removeClass('grid_4').addClass('grid_6').val('').removeClass('hidden');
                opportunityForm.find('.lead-form-opportunity').removeClass('grid_6').addClass('grid_4');
                opportunityForm.find('.lead-form-opportunity-stages').val('1').removeClass('hidden');
                opportunityForm.find('.lead-form-opportunity').addClass('hidden');
                opportunityForm.find('.create-quote-and-opportunity').text(createOpportunityMessage);
                opportunityForm.find('#lead-form-opportunity-created-at-date').closest('p').removeClass('grid_2').addClass('grid_3');
                opportunityForm.find('#lead-form-opportunity-expected-close-date').closest('p').removeClass('grid_2').addClass('grid_3');
                //opportunityForm.find('.lead-form-opportunity-value').closest('p').removeClass('grid_2').addClass('grid_3');
                //opportunityForm.find('#lead-form-opportunity-expected-close-date').closest('p').removeClass('grid_2').addClass('grid_3');
            }
        },
        createQuote: function(e)
        {
            e.preventDefault();

             var self = this,
                form = $(e.currentTarget),
                isValid = true,
                leadId = form.data('lead-id'),
                opportunityId = form.find('.opportunity-id').val(),
                quoteLabel = form.find('.quote-label').val(),
                duplicateQuoteId = $('#duplicate_quote_id').val(),
                errorMessage = '';

            _.each(form.find('.required'), function(el){
                if (!$(el).val()){
                    isValid = false;
                }
            });

            if (!quoteLabel) {
                errorMessage += (_.isUndefined(i18n['Please specify quote title'])?'Please specify quote title':i18n['Please specify quote title'])+ '<br/>';
                form.find('.quote-label').addClass('error');
                isValid = false;
            } else {
                form.find('.quote-label').removeClass('error');
            }

            if (!isValid){
                showMessage(errorMessage, true);
                return false;
            }


            this.leadOpportunityQuoteModel = new LeadOpportunityQuoteModel();

            form.find('.create-quote-from-opportunity').prop('disabled', true);
            this.leadOpportunityQuoteModel.set('secureToken', $('#lead-grid-token').val());
            this.leadOpportunityQuoteModel.set('opportunity_id', opportunityId);
            this.leadOpportunityQuoteModel.set('lead_id', leadId);
            this.leadOpportunityQuoteModel.set('quote_title', quoteLabel);
            this.leadOpportunityQuoteModel.set('duplicate_quote_id', duplicateQuoteId);
            this.leadOpportunityQuoteModel.save(null, {
                success: function(model, response){
                    form.find('.create-quote-from-opportunity').prop('disabled', false);
                    showMessage(response.responseText.message, false, 5000);
                    //window.open($('#website_url').val()+response.responseText.quoteLink , '_blank');
                    self.leadOpportunityDataModel = new LeadOpportunityCollection();
                    self.leadOpportunityDataModel.fetch({data: {'excludeEmptyOpportunityStages':true, 'lead_id': leadId},
                        'success': function(leadOpportunityDataModel){
                            self.leadOpportunitiesData = leadOpportunityDataModel;
                            self.render();
                            if (typeof window.LeadDetailedView.opportunitiesQuotes !== 'undefined') {
                                window.LeadDetailedView.opportunitiesQuotes.render();
                            }

                        }
                    });
                },
                error: function(model, response){
                    form.find('.create-quote-from-opportunity').prop('disabled', false);
                    showMessage(response.responseText, true, 5000);
                }
            });
            return false;

        },
        checkInputOpportunityValue: function (e) {
            var char = e.key;
            var validChar = parseInt(char);

           if(isNaN(validChar)){
               showMessage(_.isUndefined(i18n['You can use only whole numbers'])?'You can use only whole numbers':i18n['You can use only whole numbers'], true);
               return false;
           }
        },
        submit: function(e){
            e.preventDefault();

            var self = this,
                form = $(e.currentTarget).closest('#lead-tab-opportunity-form'),
                isValid = true,
                leadId = form.data('lead-id'),
                opportunityType = $('.lead-tab-opportunity-switch:checked').val(),
                stageId = form.find('.lead-form-opportunity-stages').val(),
                opportunityName = form.find('.lead-form-opportunity-name').val(),
                createQuote = form.find('.lead-form-opportunity-create-quote').is(':checked'),
                leadOpportunityValue = form.find('.lead-form-opportunity-value').val(),
                createdAtDate = ($('#lead-form-opportunity-created-at-date').val()) ? $.datepicker.formatDate('yy-mm-dd', $('#lead-form-opportunity-created-at-date').datepicker("getDate")): '',
                expectedCloseDate = ($('#lead-form-opportunity-expected-close-date').val()) ? $.datepicker.formatDate('yy-mm-dd', $('#lead-form-opportunity-expected-close-date').datepicker("getDate")): '',
                opportunityTypeId = $('#lead-opportunity-type-selection').val(),
                quoteType = $('.lead-form-opportunity-create-option:checked').val(),
                opportunityQuoteLabel = $('#search-opportunity-quote').val(),
                duplicateQuoteId = $('#duplicate_quote_id').val(),
                errorMessage = '';

            _.each(form.find('.required'), function(el){
                if (!$(el).val()){
                    isValid = false;
                }
            });

            if (!opportunityName) {
                errorMessage += (_.isUndefined(i18n['Please specify opportunity name'])?'Please specify opportunity name':i18n['Please specify opportunity name'])+ '<br/>';
                form.find('.lead-form-opportunity-name').addClass('error');
                isValid = false;
            } else {
                form.find('.lead-form-opportunity-name').removeClass('error');
            }

            if (!leadOpportunityValue) {
                errorMessage += (_.isUndefined(i18n['Please specify opportunity value'])?'Please specify opportunity value':i18n['Please specify opportunity value'])+ '<br/>';
                form.find('.lead-form-opportunity-value').addClass('error');
                isValid = false;
            } else {
                form.find('.lead-form-opportunity-value').removeClass('error');
            }

            if (!expectedCloseDate) {
                errorMessage += (_.isUndefined(i18n['Please specify expected closed date'])?'Please specify expected closed date':i18n['Please specify expected closed date'])+ '<br/>';
                form.find('#lead-form-opportunity-expected-close-date').addClass('error');
                isValid = false;
            } else {
                form.find('#lead-form-opportunity-expected-close-date').removeClass('error');
            }

            if (opportunityQuoteLabel !== '' && duplicateQuoteId == '') {
                showMessage(_.isUndefined(i18n['Original quote not found. Please use search box and choose quote'])?'Original quote not found. Please use search box and choose quote':i18n['Original quote not found. Please use search box and choose quote'], true);
                return false;
            }

            if (!isValid){
                showMessage(errorMessage, true);
                return false;
            }

            if (opportunityType === 'old') {
                var opportunityId = form.find('.lead-form-opportunity').val(),
                    opportunityModel = this.leadOpportunitiesData.get(opportunityId);
                if (!opportunityModel) {
                    showMessage(_.isUndefined(i18n['Please select opportunity from the list'])?'Please select opportunity from the list':i18n['Please select opportunity from the list'], true, 5000);
                    return false;
                }
            } else {
                opportunityModel = new LeadOpportunityModel();
            }

            form.find('.create-quote-and-opportunity').attr('disabled', true);
            opportunityModel.set('secureToken', $('#lead-grid-token').val());
            opportunityModel.set('opportunity_stage_id', stageId);
            opportunityModel.set('opportunity_value', leadOpportunityValue);
            opportunityModel.set('created_at', createdAtDate);
            opportunityModel.set('expected_close_date', expectedCloseDate);
            opportunityModel.set('lead_id', leadId);
            opportunityModel.set('opportunity_name', opportunityName);
            opportunityModel.set('opportunity_type_id', opportunityTypeId);
            opportunityModel.set('duplicate_quote_id', duplicateQuoteId);
            opportunityModel.save(null, {
                success: function(model, response){
                    if(response.error == 1) {
                        form.find('.create-quote-and-opportunity').attr('disabled', false);
                        var errMessage = (_.isUndefined(i18n['Missing mandatory params'])?'Missing mandatory params':i18n['Missing mandatory params']) + ':';

                        if(!_.isEmpty(response.responseText.missingParams)){
                            _.each(response.responseText.missingParams, function (id, item) {
                                errMessage += '<p> ' + (_.isUndefined(i18n[item])?item:i18n[item]) + '</p>';
                            });
                        }

                        showMessage(errMessage, true, 5000);
                    } else {
                        form.find('.create-quote-and-opportunity').attr('disabled', false);
                        showMessage(response.responseText.message, false, 5000);
                        if (quoteType === 'create_new_quote' || quoteType === 'create_quote_duplicate') {
                            $('#lead-tab-opportunity-quote-form').removeClass('hidden');
                            $('#lead-tab-opportunity-form').addClass('hidden');
                            $('#lead-tab-opportunity-quote-form').find('.opportunity-id').val(response.responseText.opportunityId);
                        } else {
                            self.leadOpportunityDataModel = new LeadOpportunityCollection();
                            self.leadOpportunityDataModel.fetch({data: {'excludeEmptyOpportunityStages':true, 'lead_id': leadId},
                                'success': function(leadOpportunityDataModel){
                                    self.leadOpportunitiesData = leadOpportunityDataModel;
                                    self.render();

                                }
                            });
                        }

                        if (typeof window.LeadDetailedView.opportunitiesQuotes !== 'undefined') {
                            window.LeadDetailedView.opportunitiesQuotes.render();
                        }

                        if (typeof window.LeadDetailedView !== 'undefined') {
                            window.LeadDetailedView.renderOpportunityStatsOnly();
                        }
                    }
                },
                error: function(model, response){
                    form.find('.create-quote-and-opportunity').attr('disabled', false);
                    showMessage(JSON.parse(response.responseText), true, 5000);
                }
            });
        },
        clearInputAutocomplete:function (e) {
            var searchInput = $(e.currentTarget).closest('.search-block-element-autocomplete').find('input.search-input-autocomplete');

            if(typeof searchInput !== 'undefined') {
                searchInput.val('').focus();
                $(e.currentTarget).addClass('hidden');
                $('#duplicate_quote_id').val('');
            }
        },
    });

    return LeadOpportunityFormView;
});
