define([
    'backbone',
    '../collections/lead-email-sequence',
    './lead-email-sequence-filter-top',
    './lead-email-sequence-filter-bottom',
    './lead-email-sequence-subscribe',
    './lead-email-sequence-log',
    'i18n!../../../nls/dashboard_'+$('#main-dashboard-system-language').val()+'_ln',
    'moment'
], function(Backbone, LeadEmailSequenceCollection, LeadEmailSequenceFilterTopView, LeadEmailSequenceFilterBottomView, LeadEmailSequenceSubscribeView, LeadEmailSequenceLogView,
         i18n, moment
){

    var LeadEmailSequenceView = Backbone.View.extend({
        el: $('#lead-email-sequence-tab-content'),
        events: {
            'click .test-email-sequence-email': 'testEmailSequenceEmail',
            'click .remove-sequence': 'removeSequence'
        },
        templates: {
        },
        initialize: function(leadId, currentPage){
            this.emailSequenceFilterTopView = new LeadEmailSequenceFilterTopView(leadId);
            this.emailSequenceFilterBottomView = new LeadEmailSequenceFilterBottomView(leadId);
            this.emailSequenceSubscribeView = new LeadEmailSequenceSubscribeView(leadId);
            this.emailSequenceLogView = new LeadEmailSequenceLogView(leadId);
            return this;
        },
        render: function(param){
            this.assign({
                '#lead-email-sequence-list': this.emailSequenceSubscribeView,
                '#lead-email-sequence-log': this.emailSequenceLogView,
                '#lead-email-sequence-filter-block-top': this.emailSequenceFilterTopView,
                '#lead-email-sequence-filter-block-bottom': this.emailSequenceFilterBottomView
            });

            this.emailSequenceFilterTopView.$el.on('EmailSequenceLog:filtered', _.bind(this.emailSequenceLogView.render, this.emailSequenceLogView));
            this.emailSequenceFilterBottomView.$el.on('EmailSequenceLog:filtered', _.bind(this.emailSequenceLogView.render, this.emailSequenceLogView));
        },
        assign: function (selector, view) {
            var selectors;
            if (_.isObject(selector)) {
                selectors = selector;
            }
            else {
                selectors = {};
                selectors[selector] = view;
            }
            if (!selectors) return;
            _.each(selectors, function (view, selector) {
                view.setElement(this.$(selector)).render();
            }, this);
        },
        testEmailSequenceEmail: function(e)
        {
            e.preventDefault();

            var sequenceQueueId = $(e.currentTarget).data('cart-sequence-queue-id');

            //showConfirm(_.isUndefined(i18n['Are you sure you want to send notification?'])?'Are you sure you want to send notification?':i18n['Are you sure you want to send notification?'], function() {
                $.ajax({
                    'url': $('#website_url').val()+'plugin/leads/run/sendCartStatusQueueEmail/',
                    'data' : {
                        'secureToken': $('#lead-grid-token').val(),
                        'queueId' : sequenceQueueId
                    },
                    'type': 'POST',
                    'dataType' : 'json'
                }).done(function(response) {
                    if(response.error == 1) {
                        showMessage(response.responseText, true, 5000);
                    } else {
                        showMessage(response.responseText, false, 5000);
                    }
                });
            //});
        },
        removeSequence: function (e)
        {
            e.preventDefault();
            var sequenceId = $(e.currentTarget).data('sequence-id'),
                self = this;

            showConfirm(_.isUndefined(i18n['Are you sure you want to delete?'])?'Are you sure you want to delete?':i18n['Are you sure you want to delete?'], function() {
                $.ajax({
                    'url': $('#website_url').val()+'plugin/leads/run/deleteSequence/',
                    'data' : {
                        'secureToken': $('#lead-grid-token').val(),
                        'sequenceId' : sequenceId
                    },
                    'type': 'POST',
                    'dataType' : 'json'
                }).done(function(response) {
                    if(response.error == 1) {
                        showMessage(response.responseText, true, 5000);
                    } else {
                        showMessage(response.responseText, false, 5000);
                        self.emailSequenceLogView.render();
                    }
                });
            });
        }
    });

    return LeadEmailSequenceView;
});