define([
    'backbone',
    'text!../templates/email-sequence-tab/lead-email-sequence-filter.html',
    'i18n!../../../nls/dashboard_'+$('#main-dashboard-system-language').val()+'_ln',
    'moment'
], function(Backbone, LeadEmailSequenceFilterTmpl, i18n, moment
){
    var LeadsEmailSequenceFilterView = Backbone.View.extend({
        el: $('#lead-email-sequence-filter-block-top'),
        events: {
            'click #email-sequence-filter-button-top': 'filterEmailSequence',
            'click .email-sequence-filter-month':'sequenceMonth',
            'click #email-sequence-filter-today-top': 'sequenceToday',
            'change .email-sequence-filter-month-select': 'changeMonth',
            'change .email-sequence-filter-year-select': 'changeYear'
        },
        templates: {
        },
        initialize: function(){

        },
        render: function(){
            this.$el.empty();
            this.$el.append(_.template(LeadEmailSequenceFilterTmpl, {
                'moment': moment,
                'type' : 'top',
                'i18n' : i18n
            }));
        },
        changeMonth: function(e){
            $('.email-sequence-filter-month-select').val($(e.currentTarget).val());
        },
        changeYear: function(e) {
            $('.email-sequence-filter-year-select').val($(e.currentTarget).val());
        },
        sequenceMonth: function(e) {
            e.preventDefault();

            var currentMonth = parseInt($('.email-sequence-filter-month-select').val()),
                currentYear = parseInt($('.email-sequence-filter-year-select').val()),
                el = $(e.currentTarget),
                sequenceMonthType = el.data('sequence-month-type');

            if (sequenceMonthType === 'previous') {
            }

            if (sequenceMonthType === 'next') {
                if (currentMonth < 12) {
                    currentMonth = currentMonth + 1;
                    if (currentMonth < 10) {
                        currentMonth = '0'+currentMonth;
                    }
                    $('.email-sequence-filter-month-select').val(currentMonth);
                } else {
                    currentYear = currentYear + 1;
                    if ($(".email-sequence-filter-year-select option[value="+currentYear+"]").length > 0) {
                        $('.email-sequence-filter-year-select').val(currentYear);
                        $('.email-sequence-filter-month-select').val('01');
                    } else {
                        showMessage(_.isUndefined(i18n['we don\'t have data for the next year'])?'we don\'t have data for the next year':i18n['we don\'t have data for the next year'], true, 5000);
                        return false;
                    }
                }
            } else {
                if (currentMonth != '01') {
                    currentMonth = currentMonth - 1;
                    if (currentMonth < 10) {
                        currentMonth = '0'+currentMonth;
                    }
                    $('.email-sequence-filter-month-select').val(currentMonth);
                } else {
                    currentYear = currentYear - 1;
                    if ($(".email-sequence-filter-year-select option[value="+currentYear+"]").length > 0) {
                        $('.email-sequence-filter-year-select').val(currentYear);
                        $('.email-sequence-filter-month-select').val('12');
                    } else {
                        showMessage(_.isUndefined(i18n['we don\'t have data for the next year'])?'we don\'t have data for the next year':i18n['we don\'t have data for the next year'], true, 5000);
                        return false;
                    }
                }
            }

            this.applyFilter();

        },
        sequenceToday: function(e)
        {
            e.preventDefault();

            var self = this;

            $(e.currentTarget).addClass('scroll-today-item');

            $.ajax({
                'url': $('#website_url').val() + 'plugin/leads/run/getCurrentMonthAndYear/',
                'type' : 'POST',
                'dataType': 'json',
                'data': {}
            }).done(function(response){
                $('.email-sequence-filter-month-select').val(response.responseText.month);
                $('.email-sequence-filter-year-select').val(response.responseText.year);
                self.applyFilter();
            }).fail(function(response){
                showMessage(_.isUndefined(i18n['please contact support team'])?'please contact support team':i18n['please contact support team'], true, 5000);
            });

        },
        filterEmailSequence: function(e){
            var el =  $(e.currentTarget);
            this.applyFilter();
        },
        applyFilter: function(){
            this.$el.trigger('EmailSequenceLog:filtered');
        }
    });

    return LeadsEmailSequenceFilterView;
});