tinymce.PluginManager.add('leadcallstatus', function(editor, url) {

    function getValues() {
        var shortCodeList = [];
        $.ajax({
            type: 'post',
            url: window.location.protocol+'//'+window.location.host + '/plugin/leads/run/getLeadCallStatuses/',
            success: function(usefullshortcodes) {
                for(var i in usefullshortcodes) {
                    for(var j in usefullshortcodes[i]) {
                        var newShortcode = {};
                        if(typeof usefullshortcodes[i][j].alias !== 'undefined') {
                            newShortcode['text'] = usefullshortcodes[i][j].alias;
                            newShortcode['value'] = usefullshortcodes[i][j].option;
                        }
                        else {
                            newShortcode['text'] = usefullshortcodes[i][j];
                            newShortcode['value'] = usefullshortcodes[i][j];
                        }
                        shortCodeList.push(newShortcode)
                    }
                }
                //remove existing menu if it is already rendered
                if(button.menu){
                    button.menu.remove();
                    button.menu = null;
                }

                button.settings.values = button.settings.menu = shortCodeList;
            },
            dataType: 'json'
        });
        return shortCodeList;
    }

    // Add a button that opens a window
    editor.addButton('leadcallstatus', {
        type: 'listbox',
        text: 'Set call status',
        icon : false,
        values: getValues(),
        onselect: function() {
            $('input[name="callStatus"]').val(this.value());
            //set call status
            this.text(this.text());
        },
        onPostRender: function() {
            button = this;
        }
    });
});