tinymce.PluginManager.add('charlimit', function(ed) {
    ed.on('init', function() {
        charlimitProcessing();

        function charlimitProcessing() {

            var msgLength = 0,
                endsymbols = 0,
                span = $('#limit-symbols');

            if(span) {
                var max = $(span).attr('data-maxlength');

                ed.on('change',function(editor) {
                    msgLength = ed.getContent({format : 'text'}).length;
                    endsymbols = max - msgLength;
                    if(ed.getContent() == editor.lastLevel.content || ed.getContent() == '') {
                        endsymbols = max;
                    }

                    if(msgLength > max) {
                        ed.setContent('');
                        ed.insertContent(editor.lastLevel.content);
                    }
                    $('#limit-symbols').attr('data-maxlength', endsymbols).text(endsymbols);

                    return tinymce.dom.Event.cancel(editor);
                });

                ed.on('paste',function(editor) {
                    msgLength = ed.getContent({format: 'text'}).length;
                    var msg;

                    if(typeof editor.clipboardData !== 'undefined') {
                        msg =  editor.clipboardData.getData('text');
                    } else {
                        msg = ed.getContent({format: 'text'});
                    }

                    if (typeof msg !== 'undefined') {
                        var currentsymbolsCount = msgLength + msg.length;

                        if (currentsymbolsCount > max) {
                            return tinymce.dom.Event.cancel(editor);
                        } else {
                            $('#limit-symbols').text(max - currentsymbolsCount);
                        }
                    }
                });
            }
        }
    });
});