define([
    'backbone',
    '../models/lead-profile',
    'backbone.paginator'
], function(Backbone, LeadProfileModel){

    var LeadsProfileCollection = Backbone.Paginator.requestPager.extend({
        model: LeadProfileModel,
        paginator_core: {
            type: 'GET',
            dataType: 'json',
            url: function(){
                return $('#website_url').val() + 'api/leads/leadprofile/';
            }
        },
        paginator_ui: {
            firstPage:    0,
            currentPage:  0,
            perPage:     10,
            totalPages:  10
        },
        server_api: {
            count: true,
            limit: function() { return this.perPage; },
            offset: function() { return this.currentPage * this.perPage },
            key: function(){ return this.key; },
            leadId:function(){return this.leadId}

        },
        parse: function(response, xhr){
            if (this.server_api.count){
                this.totalRecords = response.totalRecords;
            } else {
                this.totalRecords = response.length;
            }
            this.ipAddressesData = response.ipAddressesData;
            this.googleApiKey = response.googleApiKey;
            this.googleMapId = response.googleMapId;
            this.stats = response.stats;
            this.firstVisitInfo = response.firstVisitInfo;
            this.lastVisitInfo = response.lastVisitInfo;
            this.countryCodes = response.countryCodes;
            this.currentDate = response.currentDate;
            this.pageLoadAverage = response.pageLoadAverage;
            this.totalPages = Math.floor(this.totalRecords / this.perPage);
            return this.server_api.count ? response.data : response;
        }

    });

    return LeadsProfileCollection;
});