define([
    'backbone',
    '../models/lead-opportunity',
    'backbone.paginator'
], function(Backbone, LeadOpportunityModel){

    var LeadOpportunitiesCollection = Backbone.Paginator.requestPager.extend({
        model: LeadOpportunityModel,
        paginator_core: {
            type: 'GET',
            dataType: 'json',
            url: function(){
                return $('#website_url').val() + 'api/leads/leadopportunity/';
            }
        },
        paginator_ui: {
            firstPage:    0,
            currentPage:  0,
            perPage:     10,
            totalPages:  10
        },
        server_api: {
            count: true,
            limit: function() { return this.perPage; },
            offset: function() { return this.currentPage * this.perPage },
            key: function(){ return this.key; },
            lead_id:function(){return this.lead_id}
        },
        parse: function(response, xhr){
            if (this.server_api.count){
                this.totalRecords = response.totalRecords;
            } else {
                this.totalRecords = response.length;
            }

            this.opportunityStages = response.opportunityStages;
            this.opportunityStagesDefault = response.defaultStage;
            this.createdAtDate = response.createdAtDate;
            this.opportunityTypes = response.opportunityTypes;
            this.totalPages = Math.floor(this.totalRecords / this.perPage);
            return this.server_api.count ? response.data : response;
        }

    });

    return LeadOpportunitiesCollection;
});