define([
    'backbone',
    '../collections/score-rules-config',
    'text!../templates/paginator.html',
    'text!../templates/score-rules/score-rules-grid-row.html',
    'i18n!../../../nls/dashboard_'+$('#main-dashboard-system-language').val()+'_ln',
    'moment'
], function(Backbone,
            ScoreRulesConfigCollection, PaginatorTmpl, ScoreRulesGridRowTmpl, i18n, moment
){

    var LeadScoreRulesGridView = Backbone.View.extend({
        el: $('#lead-score-builder-grid-block'),
        events: {
            'click a.form-field-rules-row-delete': 'deleteRule'
        },
        templates: {
            paginator: _.template(PaginatorTmpl)
        },
        initialize: function(options){
            this.$el.unbind();

            this.scoreRulesConfig = new ScoreRulesConfigCollection();
            this.scoreRulesConfig.isGrid = true;

            this.scoreRulesConfig.on('reset', this.renderRules, this);
            this.scoreRulesConfig.on('add', this.renderRules, this);
            this.scoreRulesConfig.on('destroy', this.renderRules, this);
        },
        render: function(){
            this.scoreRulesConfig.server_api = _.extend(this.scoreRulesConfig.server_api, {
            });
            this.scoreRulesConfig.server_api.order = 'plsrgc.created_at DESC';
            this.scoreRulesConfig.pager();
        },
        renderRules: function(){
            this.$el.find('#lead-score-builder-grid-block-positive').empty();
            this.$el.find('#lead-score-builder-grid-block-negative').empty();
            this.scoreRulesConfig.each(this.renderRule, this);
            this.scoreRulesConfig.info()['i18n'] = i18n;
            this.$('td.lead-form-rules-paginator').html(this.templates.paginator(this.scoreRulesConfig.information));
            if (typeof tableResponsive === "function") {
                tableResponsive();
            }
        },
        renderRule: function(scoreRuleData){
            var scoreSign = scoreRuleData.get('score_sign');
            if (scoreSign === '-') {
                this.$el.find('#lead-score-builder-grid-block-negative').append(_.template(ScoreRulesGridRowTmpl, {
                    'scoreRuleData': scoreRuleData,
                    'moment': moment,
                    'i18n': i18n,
                    'ruleSetLegends': this.scoreRulesConfig.ruleSetLegends,
                    'leadOwners' : this.scoreRulesConfig.leadOwners,
                    'customerGroups':this.scoreRulesConfig.customerGroups,
                    'countryCodes':this.scoreRulesConfig.countryCodes,
                    'stages':this.scoreRulesConfig.stages,
                    'industries':this.scoreRulesConfig.industries,
                    'leadOrganizationPredefinedAttributes':this.scoreRulesConfig.leadsPredefinedValues,
                    'leadTags':this.scoreRulesConfig.leadTags,
                    'opportunityStages':this.scoreRulesConfig.opportunityStages,
                    'opportunityTypes':this.scoreRulesConfig.opportunityTypes,
                    'emailSequencies':this.scoreRulesConfig.emailSequencies
                }));
            } else {
                this.$el.find('#lead-score-builder-grid-block-positive').append(_.template(ScoreRulesGridRowTmpl, {
                    'scoreRuleData': scoreRuleData,
                    'moment': moment,
                    'i18n': i18n,
                    'ruleSetLegends': this.scoreRulesConfig.ruleSetLegends,
                    'leadOwners' : this.scoreRulesConfig.leadOwners,
                    'customerGroups':this.scoreRulesConfig.customerGroups,
                    'countryCodes':this.scoreRulesConfig.countryCodes,
                    'stages':this.scoreRulesConfig.stages,
                    'industries':this.scoreRulesConfig.industries,
                    'leadOrganizationPredefinedAttributes':this.scoreRulesConfig.leadsPredefinedValues,
                    'leadTags':this.scoreRulesConfig.leadTags,
                    'opportunityStages':this.scoreRulesConfig.opportunityStages,
                    'opportunityTypes':this.scoreRulesConfig.opportunityTypes,
                    'emailSequencies':this.scoreRulesConfig.emailSequencies
                }));
            }
        },
        alphabeticalSort: function(obj){
            // convert object into array
            var sortable=[];
            for(var key in obj)
                if(obj.hasOwnProperty(key))
                    sortable.push([key, obj[key]]); // each item is an array in format [key, value]

            // sort items by value
            sortable.sort(function(a, b)
            {
                var x=a[1].toLowerCase(),
                    y=b[1].toLowerCase();
                return x<y ? -1 : x>y ? 1 : 0;
            });
            return sortable; // array in format [ [ key1, val1 ], [ key2, val2 ], ... ]
        },
        editAttribute: function(e)
        {
            var currentAttribute = $(e.currentTarget),
                currentValue = currentAttribute.val(),
                oldValue = currentAttribute.data('old-value'),
                ruleId = currentAttribute.data('cid'),
                ruleModel = this.scoreRulesConfig.get(ruleId),
                attrName =  currentAttribute.data('attrName');

            if (currentValue != oldValue) {
                ruleModel.set(attrName, currentValue);
                ruleModel.set('secureToken', $('#form-leads-grid-token').val());
                ruleModel.save(null, {
                    success: function(model, response){
                        currentAttribute.data('old-value', currentValue);
                        showMessage(response.responseText.message, false, 5000);
                    },
                    error: function(model, response){
                        currentAttribute.val(oldValue);
                        showMessage(response.responseJSON, true, 5000);
                    }
                });

            }

        },
        deleteRule: function(e){
            var cid = $(e.currentTarget).data('cid'),
                model = this.scoreRulesConfig.get(cid);

            showConfirm(_.isUndefined(i18n['Are you sure want to delete'])?'Are you sure want to delete':i18n['Are you sure want to delete'], function(){
                if (model) {
                    model.destroy({
                        wait: true,
                        success: function(model, response){

                        },
                        error: function(model, response){
                            showMessage(response.responseJSON, true, 2000);
                        }
                    });
                }
            });
        }
    });

    return LeadScoreRulesGridView;
});