define([
    'backbone',
    'text!../templates/form-builder/form-builder-form.html',
    'text!../templates/form-builder/form-builder-form-field-standard-config.html',
    'text!../templates/form-builder/form-builder-preview-field-config.html',
    'text!../templates/form-builder/form-builder-form-field-custom-config.html',
    '../collections/form-builder-config',
    'moment',
    'selectText',
    'i18n!../../../nls/dashboard_'+$('#main-dashboard-system-language').val()+'_ln'
], function(Backbone, FormBuilderFormViewTmpl, FormBuilderFormFieldStandardConfigViewTmpl, FormBuilderPreviewFieldConfigViewTmpl, FormBuilderFormFieldCustomConfigViewTmpl, FormsCollection, moment, selectText, i18n){
    var LeadBuilderFormView = Backbone.View.extend({
        el: $('#lead-form-builder-form-block'),
        events: {
            'click .configure-builder-form-field': 'configureBuilderFormField',
            'click #add-to-form-preview': 'addToPreview',
            'click .edit-builder-field': 'editBuilderField',
            'click .delete-builder-field': 'deleteBuilderField',
            'click #form-builder-generate-preview': 'generatePreview',
            'keypress input[name="builder-field-default-field-rows"]': 'checkDigitsValue',
            'keypress input[name="builder-field-default-field-cols"]': 'checkDigitsValue',
            'change input.form-builder-form-type': 'changeFormType',
            'click #copy-builder-form': 'copyFormCode',
            'click #copy-builder-form-without-styles': 'copyFormCodeWithoutStyles',
            'click #form-builder-generate-preview-and-save': 'generatePreviewAndSave',
            'change #external-form-assign-email': 'switchEmail',
            'change #external-form-assign-email-reply': 'switchReplyEmail',
            'click #copy-builder-form-and-create-page': 'copyFormCode',
            'click #custom-fields-btn': 'showCustomFields'
        },
        templates: {

        },
        initialize: function(){
            this.$el.unbind();
            this.$el = $('#lead-form-builder-form-block');
            this.$el.attr('action', $('#website_url').val()+'api/leads/formbuilderconfig');

            this.forms = new FormsCollection();
            this.forms.isGrid = true;
            this.forms.on('reset', this.renderBuilderForm, this);
            this.forms.on('add', this.renderBuilderForm, this);
            this.forms.on('destroy', this.renderBuilderForm, this);

        },
        render: function(){
            this.forms.pager();

            window.onbeforeunload = function(){cleanLocalStorage()};
        },
        cleanLocalStorage: function()
        {
            if (typeof this.forms.storageKeys !== 'undefined') {
                _.each(this.forms.storageKeys, function(value){
                    window.localStorage.removeItem(value);
                });
            }

        },
        switchEmail: function(e)
        {
            var el = $(e.currentTarget);

            if (el.is(':checked')) {
                this.$el.find('#form-builder-external-config-params-admin-email').removeClass('hidden');
            } else {
                this.$el.find('#form-builder-external-config-params-admin-email').addClass('hidden');
            }
        },
        switchReplyEmail: function(e)
        {
            var el = $(e.currentTarget);

            if (el.is(':checked')) {
                this.$el.find('#form-builder-external-config-params-reply-email').removeClass('hidden');
            } else {
                this.$el.find('#form-builder-external-config-params-reply-email').addClass('hidden');
            }
        },
        changeFormType: function(e)
        {
            if ($(e.currentTarget).val() === 'external') {
                $('#form-builder-external-config-params').removeClass('hidden');
                $('#form-builder-generate-preview').addClass('hidden');
                $('#general-form-builder-config-settings-emails').removeClass('hidden');
            } else {
                $('#form-builder-external-config-params').addClass('hidden');
                $('#form-builder-generate-preview').removeClass('hidden');
                $('#general-form-builder-config-settings-emails').addClass('hidden');
            }
        },
        renderBuilderForm: function()
        {
            this.$el.html(_.template(FormBuilderFormViewTmpl, {
                'moment': moment,
                'i18n': i18n,
                'forms':'',
                'emailTemplates': this.forms.emailTemplates,
                'additionalLeadsCustomFields': this.forms.additionalLeadsCustomFields,
                'additionalOrganizationsCustomFields': this.forms.additionalOrganizationsCustomFields,
                'limitedAccess' : this.forms.limitedAccess,
                'additionalFieldGroupParams' : this.forms.additionalFieldGroupParams
            }));

            this.$el.find('#forms-elements-for-builder-block-crm a').first().trigger('click');

        },
        showCustomFields: function(e)
        {
            e.preventDefault();
            var el = $(e.currentTarget);

            if (el.hasClass('close')) {
                $('#forms-elements-for-builder-block-custom').show();
                el.removeClass('close').addClass('open').val('Hide');
            } else {
                $('#forms-elements-for-builder-block-custom').hide();
                el.removeClass('open').addClass('close').val('Show');
            }
        },
        copyFormCode: function(e)
        {
            e.preventDefault();
            if ($(e.currentTarget).data('without-message')) {
                this.copyFunction();
            } else {
                if (typeof window.device !== 'undefined' && (!window.device.tablet() && !window.device.mobile())) {
                    this.copyFunction(true);
                }
            }

            if (typeof window.device !== 'undefined') {
                if (window.device.tablet() || window.device.mobile()) {
                    $('#generated-web-form-code').selectText();
                }
            }

        },
        copyFormCodeWithoutStyles: function(e)
        {
            e.preventDefault();
            if ($(e.currentTarget).data('without-message')) {
                this.copyFunction(false, true);
            } else {
                if (typeof window.device !== 'undefined' && (!window.device.tablet() && !window.device.mobile())) {
                    this.copyFunction(true, true);
                }
            }

            if (typeof window.device !== 'undefined') {
                if (window.device.tablet() || window.device.mobile()) {
                    $('#generated-web-form-code').selectText();
                }
            }

        },
        copyFunction: function(withoutMessage, withoutStyles)
        {
            if(document.queryCommandSupported("copy")) {
                var copyFromEl = $('<textarea/>'),
                    contentToCopy = this.$el.find('#generated-web-form-code').text();


                if (typeof withoutStyles !== 'undefined' && withoutStyles === true) {
                    contentToCopy = contentToCopy.replace(/<style.*?<\/style>/gis, '');
                }

                copyFromEl.text(contentToCopy);

                $('body').append(copyFromEl);
                copyFromEl.select();
                document.execCommand('copy', true);
                copyFromEl.remove();
                if (typeof withoutMessage !== 'undefined' && withoutMessage === true) {
                    showMessage(_.isUndefined(i18n['Copied to clipboard']) ? 'Copied to clipboard' : i18n['Copied to clipboard'], true, 5000);
                }
            }
        },
        configureBuilderFormField: function(e)
        {
            e.preventDefault();

            var fieldType = $(e.currentTarget).data('form-field-type'),
                systemType =  $(e.currentTarget).data('form-field-system-type'),
                fieldSubType =  $(e.currentTarget).data('form-field-sub-type'),
                fieldLabel =  $(e.currentTarget).data('form-field-label'),
                self = this,
                fieldParams = {'fieldName': fieldSubType, 'fieldLabel':fieldLabel},
                additionalFieldGroupParams = [];

            additionalFieldGroupParams.customerGroups = this.alphabeticalSort(this.forms.additionalFieldGroupParams.customerGroups);
            additionalFieldGroupParams.leadTags = this.alphabeticalSort(this.forms.additionalFieldGroupParams.leadTags);
            additionalFieldGroupParams.phoneCountryCodes = this.alphabeticalSort(this.forms.additionalFieldGroupParams.phoneCountryCodes);
            additionalFieldGroupParams.countryCodes = this.alphabeticalSort(this.forms.additionalFieldGroupParams.countryCodes);
            additionalFieldGroupParams.stateCodes = this.alphabeticalSort(this.forms.additionalFieldGroupParams.stateCodes);

            if (typeof fieldSubType === 'undefined') {
                fieldSubType = '';
            }

            if (systemType === 'crm') {
                 self.$el.find('#forms-elements-field-config-builder-block').html(_.template(FormBuilderFormFieldStandardConfigViewTmpl, {
                    'moment': moment,
                    'i18n': i18n,
                    'fieldType': fieldType,
                    'fieldSubType': fieldSubType,
                    'systemType': systemType,
                    'fieldParams': fieldParams,
                    'editMode': true,
                    'additionalFieldGroupParams': additionalFieldGroupParams,
                    'additionalParams': this.forms.additionalFieldGroupParams
                 }));
            } else if (systemType === 'custom') {
                fieldSubType =  $(e.currentTarget).data('form-field-custom-name');
                fieldLabel =  $(e.currentTarget).data('form-field-label');

                var fieldOptions =  $(e.currentTarget).data('form-field-options');

                if (!_.isEmpty(fieldOptions)) {
                    fieldOptions = fieldOptions.split(',');
                }

                fieldParams = {'fieldName': fieldSubType, 'fieldLabel':fieldLabel, 'fieldOptions': fieldOptions};

                this.$el.find('#forms-elements-field-config-builder-block').html(_.template(FormBuilderFormFieldCustomConfigViewTmpl, {
                    'moment': moment,
                    'i18n': i18n,
                    'fieldType': fieldType,
                    'fieldSubType': fieldSubType,
                    'systemType' : systemType,
                    'fieldParams':fieldParams,
                    'editMode': true
                }));
            } else {
                this.$el.find('#forms-elements-field-config-builder-block').html(_.template(FormBuilderFormFieldStandardConfigViewTmpl, {
                    'moment': moment,
                    'i18n': i18n,
                    'fieldType': fieldType,
                    'fieldSubType': fieldSubType,
                    'systemType' : systemType,
                    'fieldParams':fieldParams,
                    'additionalFieldGroupParams': additionalFieldGroupParams,
                    'additionalParams': this.forms.additionalFieldGroupParams
                }));

            }

            this.$el.find('.configure-builder-form-field').removeClass('current');
            $(e.currentTarget).addClass('current');

            this.$el.find('#forms-elements-field-config-builder-block').data('form-field-type', fieldType);
            this.$el.find('#forms-elements-field-config-builder-block').data('form-field-sub-type', fieldSubType);
            this.$el.find('#forms-elements-field-config-builder-block').data('form-field-system-type', systemType);
            this.$el.find('#add-to-form-preview').removeClass('hidden');

        },
        addToPreview: function(e)
        {
            e.preventDefault();

            var fieldEl = $('#forms-elements-field-config-builder-block'),
                fieldType = fieldEl.data('form-field-type'),
                fieldSubType = fieldEl.data('form-field-sub-type'),
                systemType = fieldEl.data('form-field-system-type'),
                fieldLabel = fieldEl.find('input[name="builder-field-label"]').val(),
                fieldName = fieldEl.find('input[name="builder-field-name"]').val(),
                fieldDefaultValue = fieldEl.find('input[name="builder-field-default-value"]').val(),
                fieldCustomCssValue = fieldEl.find('input[name="builder-field-custom-css"]').val(),
                fieldPlaceholder = fieldEl.find('input[name="builder-field-placeholder-value"]').val(),
                fieldCols = fieldEl.find('input[name="builder-field-default-field-cols"]').val(),
                fieldOptions = fieldEl.find('[name="builder-field-option"]').val(),
                fieldRows = fieldEl.find('input[name="builder-field-default-field-rows"]').val(),
                editFieldEl = fieldEl.find('input[name="field-on-edit"]'),
                fieldKey = fieldName.replace(/[^A-Za-z0-9\-_]/g,'-'),
                storageKeys = [],
                previewBlock = $('#forms-field-builder-preview-block'),
                additionalFieldGroupParams = [],
                isRequiredEl = fieldEl.find('input[name="builder-field-is-required"]'),
                isRequiredField = 0;

            if (typeof fieldSubType === 'undefined') {
                fieldSubType = '';
            }

            if (isRequiredEl.is(':checked')) {
                isRequiredField = 1;
            }

            additionalFieldGroupParams.customerGroups = this.alphabeticalSort(this.forms.additionalFieldGroupParams.customerGroups);
            additionalFieldGroupParams.leadTags = this.alphabeticalSort(this.forms.additionalFieldGroupParams.leadTags);
            additionalFieldGroupParams.phoneCountryCodes = this.alphabeticalSort(this.forms.additionalFieldGroupParams.phoneCountryCodes);
            additionalFieldGroupParams.countryCodes = this.alphabeticalSort(this.forms.additionalFieldGroupParams.countryCodes);
            additionalFieldGroupParams.stateCodes = this.alphabeticalSort(this.forms.additionalFieldGroupParams.stateCodes);

            fieldDefaultValue = (!_.isUndefined(fieldDefaultValue) ? fieldDefaultValue : '');

            if (!fieldLabel && (fieldType !== 'checkbox' && fieldType !== 'radio')) {
                showMessage(_.isUndefined(i18n['Field label must be not empty.']) ? 'Field label must be not empty.' : i18n['Field label must be not empty.'], true, 5000);
                return false;
            }

            if (!fieldName) {
                showMessage(_.isUndefined(i18n['Field name must be not empty.']) ? 'Field name must be not empty.' : i18n['Field name must be not empty.'], true, 5000);
                return false;
            }

            if (fieldName.match(/[^A-Za-z0-9\-_]/g)) {
                showMessage(_.isUndefined(i18n['Only alphabetic and numeric characters, and "_" are allowed to be used in the field name']) ? 'Only alphabetic and numeric characters, and "_" are allowed to be used in the field name' : i18n['Only alphabetic and numeric characters, and "_" are allowed to be used in the field name'], true, 5000);
                return false;
            }

            if (fieldCustomCssValue.match(/[^A-Za-z0-9\-_]/g)) {
                showMessage(_.isUndefined(i18n['Custom css class must contains only digits or alphabets symbols. Also special symbols - _ allowed']) ? 'Custom css class must contains only digits or alphabets symbols. Also special symbols - _ allowed' : i18n['Custom css class must contains only digits or alphabets symbols. Also special symbols - _ allowed'], true, 5000);
                return false;
            }

            if (typeof fieldOptions !== 'undefined') {
                fieldOptions = fieldOptions.split("\n");
                fieldOptions = $.map(fieldOptions, $.trim);
                fieldOptions = fieldOptions.filter(function (entry) {
                    return entry.trim() != '';
                });
                fieldOptions = fieldOptions.filter(function (entry) {
                    return /\S/.test(entry);
                });
            }
            if ((fieldType === 'dropdown' || fieldType === 'radio' || fieldType === 'checkbox') && _.isEmpty(fieldOptions)) {
                showMessage(_.isUndefined(i18n['You must specify at least one option']) ? 'You must specify at least one option' : i18n['You must specify at least one option'], true, 5000);
                return false;
            }


            if (previewBlock.find('[name="'+fieldKey+'"]').length > 0 && editFieldEl.length === 0) {
                showMessage(_.isUndefined(i18n['Field already exists']) ? 'Field already exists' : i18n['Field already exists'], true, 5000);
                return false;
            }

            if (fieldSubType === 'country' && systemType === 'crm') {
                fieldOptions =  additionalFieldGroupParams.countryCodes;
            }
            if (fieldSubType === 'group-name' && systemType === 'crm') {
                fieldOptions =  additionalFieldGroupParams.customerGroups;
            }
            if (fieldSubType === 'tag-name' && systemType === 'crm') {
                fieldOptions =  additionalFieldGroupParams.leadTags;
            }

            if (fieldSubType === 'state' && systemType === 'crm') {
                fieldOptions =  additionalFieldGroupParams.stateCodes;
            }

            if ((fieldSubType === 'mobile' || fieldSubType === 'phone') && systemType === 'crm') {
                fieldOptions = additionalFieldGroupParams.phoneCountryCodes;
            }

            var fieldParams = {
                    'fieldDefaultValue': fieldDefaultValue,
                    'fieldName': fieldKey,
                    'fieldLabel': fieldLabel,
                    'fieldType': fieldType,
                    'fieldPlaceholder': fieldPlaceholder,
                    'fieldCustomCssValue': fieldCustomCssValue,
                    'fieldCols':fieldCols,
                    'fieldRows' : fieldRows,
                    'fieldOptions': fieldOptions,
                    'fieldSubType': fieldSubType,
                    'systemType' : systemType,
                    'additionalFieldGroupParams': additionalFieldGroupParams,
                    'additionalParams': this.forms.additionalFieldGroupParams,
                    'isRequiredField':isRequiredField

                };

            if ($('[data-field-builder-params-id="'+editFieldEl.val()+'"]').length > 0) {
                var storageKey = editFieldEl.val();
            } else {
                var storageKey = new Date().getTime().toString()+fieldKey;
            }

            localStorage.setItem(storageKey, JSON.stringify(fieldParams));

            var params = {
                'moment': moment,
                'i18n': i18n,
                'fieldType': fieldType,
                'fieldName': fieldKey,
                'fieldParams' : fieldParams,
                'fieldDefaultValue' : fieldDefaultValue,
                'fieldLabel': fieldLabel,
                'fieldPlaceholder': fieldPlaceholder,
                'storageKey': storageKey,
                'fieldCols' : fieldCols,
                'fieldRows': fieldRows,
                'fieldOptions': fieldOptions,
                'fieldSubType': fieldSubType,
                'systemType' : systemType,
                'additionalFieldGroupParams': additionalFieldGroupParams,
                'additionalParams': this.forms.additionalFieldGroupParams,
                'isRequiredField':isRequiredField
            };

            if (previewBlock.find('[name="'+fieldKey+'"]').length > 0 && $('[data-field-builder-params-id="'+editFieldEl.val()+'"]').length > 0 && editFieldEl.length > 0) {
                this.$el.find('[data-field-builder-params-id="'+editFieldEl.val()+'"]').replaceWith(_.template(FormBuilderPreviewFieldConfigViewTmpl, params));
            } else {
                this.$el.find('#default-builder-preview-text').after(_.template(FormBuilderPreviewFieldConfigViewTmpl, params));
            }

            this.$el.find('#forms-field-builder-preview-block').sortable({placeholder: "ui-state-highlight",helper:'clone', axis: "y"});
            //this.$el.find('#forms-elements-field-config-builder-block').empty();
            this.$el.find('.form-preview-configuration-elements').removeClass('hidden');
            this.$el.find('#add-to-form-preview').addClass('hidden');

            if (typeof this.forms.storageKeys === 'undefined') {
                storageKeys.push(storageKey);
                this.forms.storageKeys = storageKeys;
            } else {
                var storageKeys = this.forms.storageKeys;
                if (!_.contains(storageKeys, storageKey)) {
                    storageKeys.push(storageKey);
                }
                this.forms.storageKeys = storageKeys;
            }

            if (this.$el.find('.form-builder-form-type:checked').val() === 'external') {
                this.$el.find('#form-builder-generate-preview').addClass('hidden');
            }

            this.$el.find('#default-builder-preview-text').addClass('hidden');
            if (systemType === 'crm') {
                this.$el.find('#forms-elements-for-builder-block-crm [data-form-field-sub-type="'+fieldSubType+'"]').trigger('click');
            } else if (systemType === 'custom') {
                this.$el.find('#forms-elements-for-builder-block-custom [data-form-field-sub-type="'+fieldSubType+'"]').trigger('click');
            } else {
                this.$el.find('#forms-elements-for-builder-block [data-form-field-type="'+fieldType+'"]').trigger('click');
            }

            this.$el.find('#generated-web-form-code').empty();
            this.$el.find('#copy-builder-form').addClass('hidden');
            this.$el.find('#copy-builder-form-without-styles').addClass('hidden');
            this.$el.find('#copy-builder-form-and-create-page').addClass('hidden');
            this.$el.find('#copy-builder-form-and-create-page-info').addClass('hidden');

            flexkit._chooseBoxStyle();

        },
        editBuilderField: function(e)
        {
            var previewFieldRow = $(e.currentTarget).closest('.preview-builder-row'),
                builderRowParamsId = previewFieldRow.data('field-builder-params-id'),
                builderRowParamsData = JSON.parse(localStorage.getItem(builderRowParamsId)),
                fieldType = builderRowParamsData.fieldType,
                fieldSubType = builderRowParamsData.fieldSubType,
                systemType = builderRowParamsData.systemType,
                additionalFieldGroupParams = [];

            additionalFieldGroupParams.customerGroups = this.alphabeticalSort(this.forms.additionalFieldGroupParams.customerGroups);
            additionalFieldGroupParams.leadTags = this.alphabeticalSort(this.forms.additionalFieldGroupParams.leadTags);
            additionalFieldGroupParams.phoneCountryCodes = this.alphabeticalSort(this.forms.additionalFieldGroupParams.phoneCountryCodes);
            additionalFieldGroupParams.countryCodes = this.alphabeticalSort(this.forms.additionalFieldGroupParams.countryCodes);
            additionalFieldGroupParams.stateCodes = this.alphabeticalSort(this.forms.additionalFieldGroupParams.stateCodes);

            if (typeof fieldSubType === 'undefined') {
                fieldSubType = '';
            }

            if (systemType == 'custom') {
                this.$el.find('#forms-elements-field-config-builder-block').html(_.template(FormBuilderFormFieldCustomConfigViewTmpl, {
                    'moment': moment,
                    'i18n': i18n,
                    'fieldType': fieldType,
                    'fieldSubType': fieldSubType,
                    'systemType' : systemType,
                    'fieldParams':builderRowParamsData,
                    'editMode': true,
                    'editFieldId' : builderRowParamsId,
                    'additionalFieldGroupParams': additionalFieldGroupParams,
                    'additionalParams': this.forms.additionalFieldGroupParams
                }));
            } else {
                this.$el.find('#forms-elements-field-config-builder-block').html(_.template(FormBuilderFormFieldStandardConfigViewTmpl, {
                    'moment': moment,
                    'i18n': i18n,
                    'fieldType': fieldType,
                    'fieldParams': builderRowParamsData,
                    'editFieldId' : builderRowParamsId,
                    'editMode': true,
                    'fieldSubType': fieldSubType,
                    'systemType' : systemType,
                    'additionalFieldGroupParams': additionalFieldGroupParams,
                    'additionalParams': this.forms.additionalFieldGroupParams
                }));
            }

            var optionsEl = this.$el.find('#forms-elements-field-config-builder-block').find('[name="builder-field-option"]');

            if (optionsEl.length > 0) {
                optionsEl.val(optionsEl.val().replace(/(?:(?:\r\n|\r|\n)\s*){2}/g, "\n"));
            }
            this.$el.find('#forms-elements-field-config-builder-block').data('form-field-type', fieldType);
            this.$el.find('#add-to-form-preview').removeClass('hidden');

        },
        deleteBuilderField: function(e)
        {
            $(e.currentTarget).closest('.preview-builder-row').remove();
            if (this.$el.find('#form-builder-preview-block').find('.sortable').length === 0) {
                this.$el.find('.form-preview-configuration-elements').addClass('hidden');
                this.$el.find('#default-builder-preview-text').removeClass('hidden');
            }
        },
        generatePreview: function(e)
        {
            e.preventDefault();

            var formName = $('#form-preview-name').val(),
                formNameClean = formName.replace(/[^A-Za-z0-9\s\-_]/g,'-'),
                formFieldsElms = $('.preview-builder-row'),
                formFieldsData = [],
                self = this;

            if (formFieldsElms.length == 0) {
                showMessage(_.isUndefined(i18n['Custom css class must contains only digits or alphabets symbols. Also special symbols - _ allowed']) ? 'Custom css class must contains only digits or alphabets symbols. Also special symbols - _ allowed' : i18n['Custom css class must contains only digits or alphabets symbols. Also special symbols - _ allowed'], true, 5000);
                return false;
            }

            if (formName.match(/[^A-Za-z0-9\s\-_]/g)) {
                showMessage(_.isUndefined(i18n['Form name must contains only digits or alphabets symbols. Also special symbols - _ allowed']) ? 'Form name must contains only digits or alphabets symbols. Also special symbols - _ allowed' : i18n['Form name must contains only digits or alphabets symbols. Also special symbols - _ allowed'], true, 5000);
                return false;
            }

            $.each(formFieldsElms, function(){
                formFieldsData.push(JSON.parse(localStorage.getItem($(this).data('field-builder-params-id'))));
            });

            $.ajax({
               'url' : $('#website_url').val()+'plugin/leads/run/getFormFieldsCode/',
               'data': {"formFieldsData": JSON.stringify(formFieldsData)},
               'type' : 'POST',
               'dataType' : 'json'
            }).done(function(response){
                self.updatePreview(response.responseText);
            });


        },
        generatePreviewAndSave: function()
        {
            var self = this,
                formName = $('#form-preview-name').val(),
                formType = $('.form-builder-form-type:checked').val(),
                formTitle = $('#form-builder-title').val(),
                formDomain = $('#form-builder-domain-name').val(),
                formButton = $('#form-builder-button-button-label').val(),
                formFieldsElms = $('.preview-builder-row'),
                formFieldsData = [],
                recaptchaPublicKey = $('#form-builder-recaptcha-public-key').val(),
                recaptchaPrivateKey = $('#form-builder-recaptcha-private-key').val(),
                successUrl = $('#form-builder-success-url').val(),
                failUrl = $('#form-builder-fail-url').val(),
                smsMobile = $('#form-sms-mobile').val(),
                externalId = $('#form-external-id').val(),
                sendEmail = 0,
                sendAutoReply = 0,
                sendEmailConfig = {},
                sendAutoReplyConfig = {};


            if (formFieldsElms.length == 0) {
                showMessage(_.isUndefined(i18n['Custom css class must contains only digits or alphabets symbols. Also special symbols - _ allowed']) ? 'Custom css class must contains only digits or alphabets symbols. Also special symbols - _ allowed' : i18n['Custom css class must contains only digits or alphabets symbols. Also special symbols - _ allowed'], true, 5000);
                return false;
            }

            $.each(formFieldsElms, function(){
                formFieldsData.push(JSON.parse(localStorage.getItem($(this).data('field-builder-params-id'))));
            });

            if (formName.match(/[^A-Za-z0-9\s\-_]/g)) {
                showMessage(_.isUndefined(i18n['Form name must contains only digits or alphabets symbols. Also special symbols - _ allowed']) ? 'Form name must contains only digits or alphabets symbols. Also special symbols - _ allowed' : i18n['Form name must contains only digits or alphabets symbols. Also special symbols - _ allowed'], true, 5000);
                return false;
            }

            if (_.isEmpty(formName)) {
                showMessage(_.isUndefined(i18n['Please provide form configuration name']) ? 'Please provide form configuration name' : i18n['Please provide form configuration name'], true, 5000);
                return false;
            }

            var data = {'secureToken': $('#tools-leads-grid-token').val(), 'form_name' : formName, 'form_type': formType, 'field_data': formFieldsData};

            if (formType === 'external') {
                if (_.isEmpty(formTitle)) {
                    showMessage(_.isUndefined(i18n['Please specify form title']) ? 'Please specify form title' : i18n['Please specify form title'], true, 5000);
                    return false;
                }

                formDomain = formDomain.replace('/^(https?|ftp):\/\//', '');

                if (_.isEmpty(formDomain)) {
                    showMessage(_.isUndefined(i18n['Please specify website domain']) ? 'Please specify website domain' : i18n['Please specify website domain'], true, 5000);
                    return false;
                }

                if (!formDomain.match(/^[a-zA-Z0-9][a-zA-Z0-9-]{0,61}[a-zA-Z0-9](?:\.[a-zA-Z]{2,})+$/)) {
                    showMessage(_.isUndefined(i18n['Please specify correct domain name']) ? 'Please specify correct domain name' : i18n['Please specify correct domain name'], true, 5000);
                    return false;
                }

                if (_.isEmpty(formButton)) {
                    showMessage(_.isUndefined(i18n['Please specify form button']) ? 'Please specify form button' : i18n['Please specify form button'], true, 5000);
                    return false;
                }

                if (_.isEmpty(recaptchaPublicKey)) {
                    showMessage(_.isUndefined(i18n['Please specify recaptcha public key']) ? 'Please specify recaptcha public key' : i18n['Please specify recaptcha public key'], true, 5000);
                    return false;
                }

                if (_.isEmpty(recaptchaPrivateKey)) {
                    showMessage(_.isUndefined(i18n['Please specify recaptcha private key']) ? 'Please specify recaptcha private key' : i18n['Please specify recaptcha private key'], true, 5000);
                    return false;
                }

                var emailValidation = /^(([^<>()\[\]\.,;:\s@\"]+(\.[^<>()\[\]\.,;:\s@\"]+)*)|(\".+\"))@(([^<>()[\]\.,;:\s@\"]+\.)+[^<>()[\]\.,;:\s@\"]{2,})$/i;

                if (self.$el.find('#external-form-assign-email').is(':checked')) {
                    sendEmail = 1;

                    var emailsTo = self.$el.find('#admin-email-email').val(),
                        emailsTo = $.trim(emailsTo).split(','),
                        adminEmailTemplate = self.$el.find('#admin-email-template').val(),
                        adminEmailFrom = $.trim(self.$el.find('#admin-email-from').val()),
                        adminEmailSubject = $.trim(self.$el.find('#admin-email-subject').val()),
                        adminEmailMessage = $.trim(self.$el.find('#admin-email-message').val()),
                        errorAdminEmail = false;

                    if (adminEmailTemplate == '0') {
                        showMessage(_.isUndefined(i18n['Please choose email template for admin']) ? 'Please choose email template for admin' : i18n['Please choose email template for admin'], true, false);
                        return false;
                    }

                    $.each(emailsTo, function(key, email){
                        var status = emailValidation.test(email);
                        if (status === false) {
                            errorAdminEmail = true;
                            return false;
                        }
                    });

                    if (errorAdminEmail === true) {
                        showMessage(_.isUndefined(i18n['Please specify valid email address']) ? 'Please specify valid email address' : i18n['Please specify valid email address'], true, false);
                        return false;
                    }

                    if (_.isEmpty(emailsTo) || emailsTo === '') {
                        showMessage(_.isUndefined(i18n['Please specify email']) ? 'Please specify email' : i18n['Please specify email'], true, false);
                        return false;
                    }

                    var statusEmailFrom = emailValidation.test(adminEmailFrom);
                    if (statusEmailFrom === false) {
                        showMessage(_.isUndefined(i18n['Please specify valid email from address']) ? 'Please specify valid email from address' : i18n['Please specify valid email from address'], true, false);
                        return false;
                    }


                    if (_.isEmpty(adminEmailFrom) || adminEmailFrom === '') {
                        showMessage(_.isUndefined(i18n['Please specify email from']) ? 'Please specify email from' : i18n['Please specify email from'], true, false);
                        return false;
                    }

                    if (_.isEmpty(adminEmailSubject) || adminEmailSubject === '') {
                        showMessage(_.isUndefined(i18n['Please specify email subject']) ? 'Please specify email subject' : i18n['Please specify email subject'], true, false);
                        return false;
                    }

                    sendEmailConfig = {'emailTo': emailsTo.join(','), 'adminEmailTemplate':adminEmailTemplate, 'adminEmailFrom': adminEmailFrom, 'adminEmailSubject': adminEmailSubject, 'adminEmailMessage': adminEmailMessage};
                    data.sendEmailConfig = sendEmailConfig;
                }

                if (self.$el.find('#external-form-assign-email-reply').is(':checked')) {
                    sendAutoReply = 1;
                    var sendSms = 0;
                    if (self.$el.find('#external-form-send-sms').is(':checked')) {
                        sendSms = 1;
                    }

                    var replyFromEmail = $.trim(self.$el.find('#auto-reply-from-email').val()),
                        autoReplyEmailFromTemplate = self.$el.find('#select-reply-email-template').val(),
                        autoReplyFromName = self.$el.find('#auto-reply-from-name').val(),
                        autoReplySubject = self.$el.find('#auto-reply-subject').val(),
                        autoReplyMessage = self.$el.find('#auto-reply-message').val();

                    var statusReplyEmailFrom = emailValidation.test(replyFromEmail);
                    if (statusReplyEmailFrom === false) {
                        showMessage(_.isUndefined(i18n['Please specify valid email address for auto reply']) ? 'Please specify valid email address for auto reply' : i18n['Please specify valid email address for auto reply'], true, false);
                        return false;
                    }

                    if (autoReplyEmailFromTemplate == '0') {
                        showMessage(_.isUndefined(i18n['Please choose email template for auto reply']) ? 'Please choose email template for auto reply' : i18n['Please choose email template for auto reply'], true, false);
                        return false;
                    }

                    if (_.isEmpty(autoReplyFromName) || autoReplyFromName === '') {
                        showMessage(_.isUndefined(i18n['Please specify auto reply from name']) ? 'Please specify auto reply from name' : i18n['Please specify auto reply from name'], true, false);
                        return false;
                    }

                    if (_.isEmpty(autoReplySubject) || autoReplySubject === '') {
                        showMessage(_.isUndefined(i18n['Please specify auto reply subject']) ? 'Please specify auto reply subject' : i18n['Please specify auto reply subject'], true, false);
                        return false;
                    }

                    sendAutoReplyConfig = {'replyFromEmail': replyFromEmail, 'autoReplyEmailTemplate':autoReplyEmailFromTemplate, 'autoReplyFromName': autoReplyFromName, 'autoReplySubject': autoReplySubject, 'autoReplyMessage': autoReplyMessage, 'sendSms': sendSms}
                    data.sendAutoReplyConfig = sendAutoReplyConfig;

                }

                data.recaptchaPublicKey = recaptchaPublicKey;
                data.recaptchaPrivateKey = recaptchaPrivateKey;
                data.form_title = formTitle;
                data.form_domain = formDomain;
                data.form_button_label = formButton;
                data.successUrl = successUrl;
                data.failUrl = failUrl;
                data.sendEmail = sendEmail;
                data.sendAutoReply = sendAutoReply;
                data.smsMobile = smsMobile;
                data.externalId = externalId;
            }

            $.ajax({
                url: $('#website_url').val()+'api/leads/formbuilder',
                type: 'POST',
                data: {'formFieldsData' : JSON.stringify(data)},
                dataType: 'json'
            }).done(function(response) {
                self.updatePreview(response.responseText.model.formCode);
                self.$el.trigger('LeadBuilderFormGrid:created');
                //self.renderBuilderForm();
                showMessage(response.responseText.message, false, 5000);
            }).fail(function(response){
                showMessage(response.responseJSON, true, 5000);
            });
            return false;
        },
        updatePreview: function(formCode)
        {
            this.$el.find('#default-builder-copy-form-code').addClass('hidden');
            this.$el.find('#generated-web-form-code').text(formCode);
            this.$el.find('#copy-builder-form').removeClass('hidden');
            this.$el.find('#copy-builder-form-without-styles').removeClass('hidden');
            this.$el.find('#copy-builder-form-and-create-page').removeClass('hidden');
            this.$el.find('#copy-builder-form-and-create-page-info').removeClass('hidden');
        },
        checkDigitsValue: function (e) {
            var char = e.key;
            var validChar = parseInt(char);

            if(isNaN(validChar)){
                showMessage(_.isUndefined(i18n['You can use only whole numbers'])?'You can use only whole numbers':i18n['You can use only whole numbers'], true);
                return false;
            }
        },
        alphabeticalSort: function(obj){
            // convert object into array
            var sortable=[];
            for(var key in obj)
                if(obj.hasOwnProperty(key))
                    sortable.push([key, obj[key]]); // each item is an array in format [key, value]

            // sort items by value
            sortable.sort(function(a, b)
            {
                var x=a[1].toLowerCase(),
                    y=b[1].toLowerCase();
                return x<y ? -1 : x>y ? 1 : 0;
            });
            return sortable; // array in format [ [ key1, val1 ], [ key2, val2 ], ... ]
        }
    });

    return LeadBuilderFormView;
});

function cleanLocalStorage(data)
{
    window.appLeadToolsRouter.LeadsToolsMainView.LeadBuilderFormView.cleanLocalStorage();

}
