define([
    'backbone',
    '../collections/lead-reports',
    'text!../templates/graph-placeholder.html',
    'text!../templates/card-comparison.html',
    'text!../templates/card-comparison-pie.html',
    'i18n!../../../nls/dashboard_'+$('#lead-reports-system-language').val()+'_ln',
    'moment',
    'c3',
    'd3',
    'D3Funnel',
    'accounting',
    'chosen'
], function(Backbone, LeadReportsCollection, GraphPlaceholderTmpl, CardComparisonTmpl, CardComparisonPieTmpl, i18n, moment, c3, d3, D3Funnel, accounting
){

    var LeadReportsView = Backbone.View.extend({
        el: $('#lead-reports-view-tabs-block'),
        events: {
            'click #lead-reports-view-tabs li': 'showLeadReportsTab',
            'click .switch-card-comparison': 'switchCardComparison',
            'click .funnel-date-range-type-switcher': 'switchFunnelGraphType',
            'change #sequences-emails-per-open-select': 'selectOpenSequenceEmailsName',
            'change #sequences-emails-per-send-select': 'selectSendSequenceEmailsName',
            'change #sequences-sms-per-send-select': 'selectSendSequenceSmsName',
            'change #opportunity-stage-per-tag-sale-select': 'selectLeadsSaleTagName',
        },
        templates: {
        },
        initialize: function(){
            this.LeadReportsCollection = new LeadReportsCollection();
            this.LeadReportsCollection.on('reset', this.renderTabContent, this);
            this.LeadReportsCollection.on('add', this.renderTabContent, this);
            this.LeadReportsCollection.on('destroy', this.renderTabContent, this);
        },
        render: function() {
            var tabEl = $('.lead-report-tab.current'),
                graphTypes = $(tabEl).data('report-graphs').split(','),
                tabContentName =  $(tabEl).data('tab-name'),
                leadReportsCompare = 0,
                leadReportsFilterStartDate = ($('#lead-reports-filter-start-date').val()) ? $.datepicker.formatDate('yy-mm-dd', $('#lead-reports-filter-start-date').datepicker("getDate")): '',
                leadReportsFilterEndDate =  ($('#lead-reports-filter-end-date').val()) ? $.datepicker.formatDate('yy-mm-dd', $('#lead-reports-filter-end-date').datepicker("getDate")): '',
                leadReportsCompareFilterStartDate = ($('#lead-reports-filter-compare-start-date').val()) ? $.datepicker.formatDate('yy-mm-dd', $('#lead-reports-filter-compare-start-date').datepicker("getDate")): '',
                leadReportsCompareFilterEndDate = ($('#lead-reports-filter-compare-end-date').val()) ? $.datepicker.formatDate('yy-mm-dd', $('#lead-reports-filter-compare-end-date').datepicker("getDate")): '',
                funnelDateRangeType = $('#funnel-date-range-type-custom').val();

            if ($('#lead-reports-compare').is(':checked')) {
                leadReportsCompare = 1;
            }

            this.LeadReportsCollection.server_api.graphTypes = graphTypes;
            this.LeadReportsCollection.server_api.tabContentName = tabContentName;
            this.LeadReportsCollection.server_api.leadReportsCompare = leadReportsCompare;
            this.LeadReportsCollection.server_api.leadReportsFilterStartDate = leadReportsFilterStartDate;
            this.LeadReportsCollection.server_api.leadReportsFilterEndDate = leadReportsFilterEndDate;
            this.LeadReportsCollection.server_api.leadReportsCompareFilterStartDate = leadReportsCompareFilterStartDate;
            this.LeadReportsCollection.server_api.leadReportsCompareFilterEndDate = leadReportsCompareFilterEndDate;
            this.LeadReportsCollection.server_api.funnelDateRangeType = funnelDateRangeType;
            this.LeadReportsCollection.pager();
            return this;
        },
        renderTabContent: function(tabContentName) {
            var tabName = this.LeadReportsCollection.tabContentName,
                graphs = this.LeadReportsCollection.graphs;

            if(tabName == 'forecast') {
                $('.rangeOptions').hide();
                $('.rangeOptions-forecast').show();
            } else {
                $('.rangeOptions').trigger('change');
                $('.rangeOptions').show();
                $('.rangeOptions-forecast').hide();
            }
            if (tabName === 'sales-rep') {
                if (typeof graphs.byRep !== 'undefined') {
                    $('#lead-report-by-rep').empty();
                    $('#lead-report-by-rep-card-comparison').empty();
                    $('#lead-report-by-rep').removeClass('no-graph-data');
                    $('#lead-report-by-rep-legend').empty();
                    if (typeof graphs.byRep.axes !== 'undefined') {
                        if (typeof graphs.byRep.dataToCompare !== 'undefined') {
                            chartData = [
                                graphs.byRep.axes,
                                graphs.byRep.data,
                                graphs.byRep.dataToCompare
                            ];
                        } else {
                            chartData = [
                                graphs.byRep.axes,
                                graphs.byRep.data
                            ];
                        }

                        var onlyData = [];
                        var fullColorPattern = [];

                        if(typeof graphs.byRep.data !== 'undefined') {
                            var mainPart = graphs.byRep.data[0];
                            onlyData.push(mainPart);
                            if(typeof graphs.byRep.colorPattern[0] !== 'undefined') {
                                fullColorPattern['*'+mainPart] = graphs.byRep.colorPattern[0];
                            }
                        }

                        if(typeof graphs.byRep.dataToCompare !== 'undefined') {
                            var comparePart = graphs.byRep.dataToCompare[0];
                            if(comparePart != graphs.byRep.data[0]) {
                                onlyData.push(comparePart);
                                if(typeof graphs.byRep.colorPattern[1] !== 'undefined') {
                                    fullColorPattern['*'+comparePart] = graphs.byRep.colorPattern[1];
                                }
                            } else {
                                fullColorPattern = [];
                            }
                        } else {
                            fullColorPattern = [];
                        }

                        this.createBarChart(chartData, '#lead-report-by-rep', 45, {
                            colorPattern: graphs.byRep.colorPattern,
                            labels: true,
                            title: graphs.byRep.title,
                            customYAxisFormat: {
                                type: 'onlyInteger'
                            },
                            //showLegend : true,
                            axesAdditionalInfo: graphs.byRep.axesAdditionalInfo
                        });
                        $('#lead-report-by-rep').find('svg').closest('div').after('<div id="lead-report-by-rep-legend"></div>');
                        this.createCustomLegend('#lead-report-by-rep-legend', '#lead-report-by-rep', onlyData,  fullColorPattern);
                        if (typeof graphs.byRep.dataToCompare !== 'undefined') {
                            $('#lead-report-by-rep').find('svg').before(_.template(CardComparisonTmpl, {'comparisonData': graphs.byRep.comparisonData, 'i18n': i18n}));
                        }
                    } else {
                        $('#lead-report-by-rep').append(_.template(GraphPlaceholderTmpl, {'i18n': i18n}));
                        $('#lead-report-by-rep').addClass('no-graph-data');
                    }
                }

                if (typeof graphs.opportunitiesCountPerRep !== 'undefined') {
                    $('#lead-report-opportunities-count-per-rep').empty();
                    $('#lead-report-opportunities-count-per-rep-card-comparison').empty();
                    $('#lead-report-opportunities-count-per-rep').removeClass('no-graph-data');
                    $('#lead-report-opportunities-count-per-rep-legend').empty();
                    if (typeof graphs.opportunitiesCountPerRep.axes !== 'undefined') {
                        if (typeof graphs.opportunitiesCountPerRep.dataToCompare !== 'undefined') {
                            chartData = [
                                graphs.opportunitiesCountPerRep.axes,
                                graphs.opportunitiesCountPerRep.data,
                                graphs.opportunitiesCountPerRep.dataToCompare
                            ];
                        } else {
                            chartData = [
                                graphs.opportunitiesCountPerRep.axes,
                                graphs.opportunitiesCountPerRep.data
                            ];
                        }

                        var onlyData = [];
                        var fullColorPattern = [];

                        if(typeof graphs.opportunitiesCountPerRep.data !== 'undefined') {
                            var mainPart = graphs.opportunitiesCountPerRep.data[0];
                            onlyData.push(mainPart);
                            if(typeof graphs.opportunitiesCountPerRep.colorPattern[0] !== 'undefined') {
                                fullColorPattern['*'+mainPart] = graphs.opportunitiesCountPerRep.colorPattern[0];
                            }
                        }

                        if(typeof graphs.opportunitiesCountPerRep.dataToCompare !== 'undefined') {
                            var comparePart = graphs.opportunitiesCountPerRep.dataToCompare[0];
                            if(comparePart != graphs.opportunitiesCountPerRep.data[0]) {
                                onlyData.push(comparePart);
                                if(typeof graphs.opportunitiesCountPerRep.colorPattern[1] !== 'undefined') {
                                    fullColorPattern['*'+comparePart] = graphs.opportunitiesCountPerRep.colorPattern[1];
                                }
                            } else {
                                fullColorPattern = [];
                            }
                        } else {
                            fullColorPattern = [];
                        }

                        this.createBarChart(chartData, '#lead-report-opportunities-count-per-rep', 45, {
                            colorPattern: graphs.opportunitiesCountPerRep.colorPattern,
                            labels: true,
                            title: graphs.opportunitiesCountPerRep.title,
                            customYAxisFormat: {
                                type: 'onlyInteger'
                            },
                            //showLegend : true,
                            axesAdditionalInfo: graphs.opportunitiesCountPerRep.axesAdditionalInfo
                        });
                        $('#lead-report-opportunities-count-per-rep').find('svg').closest('div').after('<div id="lead-report-opportunities-count-per-rep-legend"></div>');
                        this.createCustomLegend('#lead-report-opportunities-count-per-rep-legend', '#lead-report-opportunities-count-per-rep', onlyData,  fullColorPattern);
                        if (typeof graphs.opportunitiesCountPerRep.dataToCompare !== 'undefined') {
                            $('#lead-report-opportunities-count-per-rep').find('svg').before(_.template(CardComparisonTmpl, {'comparisonData': graphs.opportunitiesCountPerRep.comparisonData, 'i18n': i18n}));
                        }
                    } else {
                        $('#lead-report-opportunities-count-per-rep').append(_.template(GraphPlaceholderTmpl, {'i18n': i18n}));
                        $('#lead-report-opportunities-count-per-rep').addClass('no-graph-data');
                    }
                }

                if (typeof graphs.opportunitiesAmountPerRep !== 'undefined') {
                    $('#lead-report-opportunities-amount-per-rep').empty();
                    $('#lead-report-opportunities-amount-per-rep-card-comparison').empty();
                    $('#lead-report-opportunities-amount-per-rep').removeClass('no-graph-data');
                    $('#lead-report-opportunities-amount-per-rep-legend').empty();
                    if (typeof graphs.opportunitiesAmountPerRep.axes !== 'undefined') {
                        if (typeof graphs.opportunitiesAmountPerRep.dataToCompare !== 'undefined') {
                            chartData = [
                                graphs.opportunitiesAmountPerRep.axes,
                                graphs.opportunitiesAmountPerRep.data,
                                graphs.opportunitiesAmountPerRep.dataToCompare
                            ];
                        } else {
                            chartData = [
                                graphs.opportunitiesAmountPerRep.axes,
                                graphs.opportunitiesAmountPerRep.data
                            ];
                        }

                        var onlyData = [];
                        var fullColorPattern = [];

                        if(typeof graphs.opportunitiesAmountPerRep.data !== 'undefined') {
                            var mainPart = graphs.opportunitiesAmountPerRep.data[0];
                            onlyData.push(mainPart);
                            if(typeof graphs.opportunitiesAmountPerRep.colorPattern[0] !== 'undefined') {
                                fullColorPattern['*'+mainPart] = graphs.opportunitiesAmountPerRep.colorPattern[0];
                            }
                        }

                        if(typeof graphs.opportunitiesAmountPerRep.dataToCompare !== 'undefined') {
                            var comparePart = graphs.opportunitiesAmountPerRep.dataToCompare[0];
                            if(comparePart != graphs.opportunitiesAmountPerRep.data[0]) {
                                onlyData.push(comparePart);
                                if(typeof graphs.opportunitiesAmountPerRep.colorPattern[1] !== 'undefined') {
                                    fullColorPattern['*'+comparePart] = graphs.opportunitiesAmountPerRep.colorPattern[1];
                                }
                            } else {
                                fullColorPattern = [];
                            }
                        } else {
                            fullColorPattern = [];
                        }

                        this.createBarChart(chartData, '#lead-report-opportunities-amount-per-rep', 45, {
                            customYAxisFormat: {
                                type: 'currency',
                                sign: this.LeadReportsCollection.currencySymbol

                            },
                            colorPattern: graphs.opportunitiesAmountPerRep.colorPattern,
                            labels: {
                                type: 'currency',
                                sign: this.LeadReportsCollection.currencySymbol
                            },
                            title: graphs.opportunitiesAmountPerRep.title,
                            //showLegend : true,
                            axesAdditionalInfo: graphs.opportunitiesAmountPerRep.axesAdditionalInfo
                        });
                        $('#lead-report-opportunities-amount-per-rep').find('svg').closest('div').after('<div id="lead-report-opportunities-amount-per-rep-legend"></div>');
                        this.createCustomLegend('#lead-report-opportunities-amount-per-rep-legend', '#lead-report-opportunities-amount-per-rep', onlyData,  fullColorPattern);
                        if (typeof graphs.opportunitiesAmountPerRep.dataToCompare !== 'undefined') {
                            $('#lead-report-opportunities-amount-per-rep').find('svg').before(_.template(CardComparisonTmpl, {'comparisonData': graphs.opportunitiesAmountPerRep.comparisonData, 'i18n': i18n}));
                        }
                    } else {
                        $('#lead-report-opportunities-amount-per-rep').append(_.template(GraphPlaceholderTmpl, {'i18n': i18n}));
                        $('#lead-report-opportunities-amount-per-rep').addClass('no-graph-data');
                    }
                }

                if (typeof graphs.activitiesPerRep !== 'undefined') {
                    $('#lead-report-activities-per-rep').empty();
                    $('#lead-report-activities-per-rep-legend').remove();
                    $('#lead-report-activities-per-rep-card-comparison').empty();
                    $('#lead-report-activities-per-rep').removeClass('no-graph-data');
                    if (typeof graphs.activitiesPerRep.axes !== 'undefined') {
                        chartData = [
                            graphs.activitiesPerRep.axes
                        ];

                        var dataGroupFrom = graphs.activitiesPerRep.dataGroupFrom,
                            groups = [],
                            onlyData = [],
                            compare = false;

                        groups.push(dataGroupFrom);

                        $.each(graphs.activitiesPerRep.data, function(activity, graphData){
                            var cleanLegendId = '';
                            if (!_.isArray(graphData)) {
                                var dataArr = [];
                                $.each(graphData, function(key, elem){
                                    dataArr[key] = elem;
                                });
                                chartData.push(dataArr);
                            } else {
                                chartData.push(graphData);
                            }

                            if (graphData[0].match(/\*/) !== null) {
                                cleanLegendId = graphData[0].substring(1);
                            } else {
                                cleanLegendId = graphData[0];
                            }
                            if (_.indexOf(onlyData, cleanLegendId) == '-1') {
                                onlyData.push(cleanLegendId);
                            }
                        });


                        if (typeof graphs.activitiesPerRep.dataToCompare !== 'undefined') {
                            groups.push(graphs.activitiesPerRep.dataGroupTo);
                            compare = true;
                        }

                        var additionalFilterPreset = [];

                        if(typeof graphs.activitiesPerRep.additionalFilterPreset !== 'undefined') {
                            additionalFilterPreset = graphs.activitiesPerRep.additionalFilterPreset;
                        }

                        this.createBarChart(chartData, '#lead-report-activities-per-rep', 45, {
                            groups:groups,
                            colorPattern: graphs.activitiesPerRep.colorPattern,
                            title: graphs.activitiesPerRep.title,
                            customYAxisFormat: {
                                type: 'onlyInteger'
                            },
                            axesAdditionalInfo: graphs.activitiesPerRep.axesAdditionalInfo,
                            tooltip: {filterFromDate: graphs.activitiesPerRep.filterFromDate, filterToDate: graphs.activitiesPerRep.filterToDate, compare:compare},
                            additionalFilterPreset: additionalFilterPreset
                        });


                        $('#lead-report-activities-per-rep').find('svg').closest('div').after('<div id="lead-report-activities-per-rep-legend"></div>');
                        this.createCustomLegend('#lead-report-activities-per-rep-legend', '#lead-report-activities-per-rep', onlyData,  graphs.activitiesPerRep.fullColorPattern);
                        if (typeof graphs.activitiesPerRep.dataToCompare !== 'undefined') {
                            $('#lead-report-activities-per-rep').find('svg').before(_.template(CardComparisonTmpl, {'comparisonData': graphs.activitiesPerRep.comparisonData, 'i18n': i18n}));
                        }
                    } else {
                        $('#lead-report-activities-per-rep').append(_.template(GraphPlaceholderTmpl, {'i18n': i18n}));
                        $('#lead-report-activities-per-rep').addClass('no-graph-data');
                    }
                }

                if (typeof graphs.tasksCountPerRep !== 'undefined') {
                    $('#lead-report-tasks-count-per-rep').empty();
                    $('#lead-report-tasks-count-per-rep-legend').remove();
                    $('#lead-report-tasks-count-per-rep-card-comparison').empty();
                    $('#lead-report-tasks-count-per-rep').removeClass('no-graph-data');
                    if (typeof graphs.tasksCountPerRep.axes !== 'undefined') {
                        chartData = [
                            graphs.tasksCountPerRep.axes
                        ];


                        var dataGroupFrom = graphs.tasksCountPerRep.dataGroupFrom,
                            groups = [],
                            onlyData = [],
                            compare = false;

                        groups.push(dataGroupFrom);

                        $.each(graphs.tasksCountPerRep.data, function(opportunity, graphData){
                            var cleanLegendId = '';
                            if (!_.isArray(graphData)) {
                                var dataArr = [];
                                $.each(graphData, function(key, elem){
                                    dataArr[key] = elem;
                                });
                                chartData.push(dataArr);
                            } else {
                                chartData.push(graphData);
                            }

                            if (graphData[0].match(/\*/) !== null) {
                                cleanLegendId = graphData[0].substring(1);
                            } else {
                                cleanLegendId = graphData[0];
                            }
                            if (_.indexOf(onlyData, cleanLegendId) == '-1') {
                                onlyData.push(cleanLegendId);
                            }
                        });

                        if (typeof graphs.tasksCountPerRep.dataToCompare !== 'undefined') {
                            groups.push(graphs.tasksCountPerRep.dataGroupTo);
                            compare = true;
                        }
                        this.createBarChart(chartData, '#lead-report-tasks-count-per-rep', 45, {
                            groups:groups,
                            colorPattern: graphs.tasksCountPerRep.colorPattern,
                            title: graphs.tasksCountPerRep.title,
                            customYAxisFormat: {
                                type: 'onlyInteger'
                            },
                            axesAdditionalInfo: graphs.tasksCountPerRep.axesAdditionalInfo,
                            tooltip: {filterFromDate: graphs.tasksCountPerRep.filterFromDate, filterToDate: graphs.tasksCountPerRep.filterToDate, compare:compare}
                        });

                        $('#lead-report-tasks-count-per-rep').find('svg').closest('div').after('<div id="lead-report-tasks-count-per-rep-legend"></div>');
                        this.createCustomLegend('#lead-report-tasks-count-per-rep-legend', '#lead-report-tasks-count-per-rep', onlyData,  graphs.tasksCountPerRep.fullColorPattern);
                        if (typeof graphs.tasksCountPerRep.dataToCompare !== 'undefined') {
                            $('#lead-report-tasks-count-per-rep').find('svg').before(_.template(CardComparisonTmpl, {'comparisonData': graphs.tasksCountPerRep.comparisonData, 'i18n': i18n}));
                        }
                    } else {
                        $('#lead-report-tasks-count-per-rep').append(_.template(GraphPlaceholderTmpl, {'i18n': i18n}));
                        $('#lead-report-tasks-count-per-rep').addClass('no-graph-data');
                    }
                }

                if (typeof graphs.opportunitiesStagePerRep !== 'undefined') {
                    $('#lead-report-opportunities-stage-per-rep-tooltip').remove();
                    $('#lead-report-opportunities-stage-per-rep').empty();
                    $('#lead-report-opportunities-stage-per-rep').removeClass('no-graph-data');
                    $('#lead-report-opportunities-stage-per-rep-card-comparison').empty();
                    if (typeof graphs.opportunitiesStagePerRep.axes !== 'undefined') {
                        chartData = [
                            graphs.opportunitiesStagePerRep.axes
                        ];

                        var opportunitiesGroupFrom = graphs.opportunitiesStagePerRep.opportunitiesGroupFrom,
                            groups = [],
                            onlyData = [],
                            compare = false;

                        groups.push(opportunitiesGroupFrom);

                        $.each(graphs.opportunitiesStagePerRep.data, function(opportunity, opportunityData){
                            chartData.push(opportunityData);
                            var cleanLegendId = '';

                            if (opportunityData[0].match(/\*/) !== null) {
                                cleanLegendId = opportunityData[0].substring(1);
                            } else {
                                cleanLegendId = opportunityData[0];
                            }
                            if (_.indexOf(onlyData, cleanLegendId) == '-1') {
                                onlyData.push(cleanLegendId);
                            }
                        });

                        if (typeof graphs.opportunitiesStagePerRep.dataToCompare !== 'undefined') {
                            groups.push(graphs.opportunitiesStagePerRep.opportunitiesGroupTo);
                            compare = true;
                        }
                        this.createBarChart(chartData, '#lead-report-opportunities-stage-per-rep', 45, {
                            groups:groups,
                            colorPattern: graphs.opportunitiesStagePerRep.colorPattern,
                            title: graphs.opportunitiesStagePerRep.title,
                            customYAxisFormat: {
                                type: 'onlyInteger'
                            },
                            axesAdditionalInfo: graphs.opportunitiesStagePerRep.axesAdditionalInfo,
                            tooltip: {filterFromDate: graphs.opportunitiesStagePerRep.filterFromDate, filterToDate: graphs.opportunitiesStagePerRep.filterToDate, compare:compare}
                        });
                        $('#lead-report-opportunities-stage-per-rep').find('svg').closest('div').after('<div id="lead-report-opportunities-stage-per-rep-tooltip"></div>');
                        this.createCustomLegend('#lead-report-opportunities-stage-per-rep-tooltip', '#lead-report-opportunities-stage-per-rep', onlyData,  graphs.opportunitiesStagePerRep.fullColorPattern);
                        if (typeof graphs.opportunitiesStagePerRep.dataToCompare !== 'undefined') {
                            $('#lead-report-opportunities-stage-per-rep').find('svg').before(_.template(CardComparisonTmpl, {'comparisonData': graphs.opportunitiesStagePerRep.comparisonData, 'i18n': i18n}));
                        }
                    } else {
                        $('#lead-report-opportunities-stage-per-rep').append(_.template(GraphPlaceholderTmpl, {'i18n': i18n}));
                        $('#lead-report-opportunities-stage-per-rep').addClass('no-graph-data');
                    }
                }
            }
            if (tabName === 'group') {
                if (typeof graphs.byGroup !== 'undefined') {
                    $('#lead-report-by-group').empty();
                    $('#lead-report-by-group-card-comparison').empty();
                    $('#lead-report-by-group').removeClass('no-graph-data');
                    $('#lead-report-by-group-legend').empty();
                    if (typeof graphs.byGroup.axes !== 'undefined') {
                        if (typeof graphs.byGroup.dataToCompare !== 'undefined') {
                            chartData = [
                                graphs.byGroup.axes,
                                graphs.byGroup.data,
                                graphs.byGroup.dataToCompare
                            ];
                        } else {
                            chartData = [
                                graphs.byGroup.axes,
                                graphs.byGroup.data
                            ];
                        }

                        var onlyData = [];
                        var fullColorPattern = [];

                        if(typeof graphs.byGroup.data !== 'undefined') {
                            var mainPart = graphs.byGroup.data[0];
                            onlyData.push(mainPart);
                            if(typeof graphs.byGroup.colorPattern[0] !== 'undefined') {
                                fullColorPattern['*'+mainPart] = graphs.byGroup.colorPattern[0];
                            }
                        }

                        if(typeof graphs.byGroup.dataToCompare !== 'undefined') {
                            var comparePart = graphs.byGroup.dataToCompare[0];
                            if(comparePart != graphs.byGroup.data[0]) {
                                onlyData.push(comparePart);
                                if(typeof graphs.byGroup.colorPattern[1] !== 'undefined') {
                                    fullColorPattern['*'+comparePart] = graphs.byGroup.colorPattern[1];
                                }
                            } else {
                                fullColorPattern = [];
                            }
                        } else {
                            fullColorPattern = [];
                        }

                        this.createBarChart(chartData, '#lead-report-by-group', 45, {
                            colorPattern: graphs.byGroup.colorPattern,
                            labels: true,
                            title: graphs.byGroup.title,
                            customYAxisFormat: {
                                type: 'onlyInteger'
                            },
                            //showLegend : true,
                            axesAdditionalInfo: graphs.byGroup.axesAdditionalInfo
                        });
                        $('#lead-report-by-group').find('svg').closest('div').after('<div id="lead-report-by-group-legend"></div>');
                        this.createCustomLegend('#lead-report-by-group-legend', '#lead-report-by-group', onlyData,  fullColorPattern);
                        if (typeof graphs.byGroup.dataToCompare !== 'undefined') {
                            $('#lead-report-by-group').find('svg').before(_.template(CardComparisonTmpl, {'comparisonData': graphs.byGroup.comparisonData, 'i18n': i18n}));
                        }
                    } else {
                        $('#lead-report-by-group').append(_.template(GraphPlaceholderTmpl, {'i18n': i18n}));
                        $('#lead-report-by-group').addClass('no-graph-data');
                    }
                }

                if (typeof graphs.lifecycleByGroup !== 'undefined') {
                    $('#lead-report-lifecycle-by-group').empty();
                    $('#lead-report-lifecycle-by-group-card-comparison').empty();
                    $('#lead-report-lifecycle-by-group').removeClass('no-graph-data');
                    $('#lead-report-lifecycle-by-group-legend').empty();
                    if (typeof graphs.lifecycleByGroup.axes !== 'undefined') {
                        if (typeof graphs.lifecycleByGroup.dataToCompare !== 'undefined') {
                            chartData = [
                                graphs.lifecycleByGroup.axes,
                                graphs.lifecycleByGroup.data,
                                graphs.lifecycleByGroup.dataToCompare
                            ];
                        } else {
                            chartData = [
                                graphs.lifecycleByGroup.axes,
                                graphs.lifecycleByGroup.data
                            ];
                        }

                        var additionalFilterPreset = [];

                        if(typeof graphs.lifecycleByGroup.additionalFilterPreset !== 'undefined') {
                            additionalFilterPreset = graphs.lifecycleByGroup.additionalFilterPreset;
                        }

                        var onlyData = [];
                        var fullColorPattern = [];

                        if(typeof graphs.lifecycleByGroup.data !== 'undefined') {
                            var mainPart = graphs.lifecycleByGroup.data[0];
                            onlyData.push(mainPart);
                            if(typeof graphs.lifecycleByGroup.colorPattern[0] !== 'undefined') {
                                fullColorPattern['*'+mainPart] = graphs.lifecycleByGroup.colorPattern[0];
                            }
                        }

                        if(typeof graphs.lifecycleByGroup.dataToCompare !== 'undefined') {
                            var comparePart = graphs.lifecycleByGroup.dataToCompare[0];
                            if(comparePart != graphs.lifecycleByGroup.data[0]) {
                                onlyData.push(comparePart);
                                if(typeof graphs.lifecycleByGroup.colorPattern[1] !== 'undefined') {
                                    fullColorPattern['*'+comparePart] = graphs.lifecycleByGroup.colorPattern[1];
                                }
                            } else {
                                fullColorPattern = [];
                            }
                        } else {
                            fullColorPattern = [];
                        }

                        this.createBarChart(chartData, '#lead-report-lifecycle-by-group', 45, {
                            colorPattern: graphs.lifecycleByGroup.colorPattern,
                            labels: true,
                            title: graphs.lifecycleByGroup.title,
                            customYAxisFormat: {
                                type: 'onlyInteger'
                            },
                            //showLegend : true,
                            axesAdditionalInfo: graphs.lifecycleByGroup.axesAdditionalInfo,
                            additionalFilterPreset: additionalFilterPreset
                        });
                        $('#lead-report-lifecycle-by-group').find('svg').closest('div').after('<div id="lead-report-lifecycle-by-group-legend"></div>');
                        this.createCustomLegend('#lead-report-lifecycle-by-group-legend', '#lead-report-lifecycle-by-group', onlyData,  fullColorPattern);
                        if (typeof graphs.lifecycleByGroup.dataToCompare !== 'undefined') {
                            $('#lead-report-lifecycle-by-group').find('svg').before(_.template(CardComparisonTmpl, {'comparisonData': graphs.lifecycleByGroup.comparisonData, 'i18n': i18n}));
                        }
                    } else {
                        $('#lead-report-lifecycle-by-group').append(_.template(GraphPlaceholderTmpl, {'i18n': i18n}));
                        $('#lead-report-lifecycle-by-group').addClass('no-graph-data');
                    }
                }

                if (typeof graphs.opportunityCountPerGroup !== 'undefined') {
                    $('#lead-report-opportunity-count-per-group').empty();
                    $('#lead-report-opportunity-count-per-group-card-comparison').empty();
                    $('#lead-report-opportunity-count-per-group').removeClass('no-graph-data');
                    $('#lead-report-opportunity-count-per-group-legend').empty();
                    if (typeof graphs.opportunityCountPerGroup.axes !== 'undefined') {
                        if (typeof graphs.opportunityCountPerGroup.dataToCompare !== 'undefined') {
                            chartData = [
                                graphs.opportunityCountPerGroup.axes,
                                graphs.opportunityCountPerGroup.data,
                                graphs.opportunityCountPerGroup.dataToCompare
                            ];
                        } else {
                            chartData = [
                                graphs.opportunityCountPerGroup.axes,
                                graphs.opportunityCountPerGroup.data
                            ];
                        }

                        var onlyData = [];
                        var fullColorPattern = [];

                        if(typeof graphs.opportunityCountPerGroup.data !== 'undefined') {
                            var mainPart = graphs.opportunityCountPerGroup.data[0];
                            onlyData.push(mainPart);
                            if(typeof graphs.opportunityCountPerGroup.colorPattern[0] !== 'undefined') {
                                fullColorPattern['*'+mainPart] = graphs.opportunityCountPerGroup.colorPattern[0];
                            }
                        }

                        if(typeof graphs.opportunityCountPerGroup.dataToCompare !== 'undefined') {
                            var comparePart = graphs.opportunityCountPerGroup.dataToCompare[0];
                            if(comparePart != graphs.opportunityCountPerGroup.data[0]) {
                                onlyData.push(comparePart);
                                if(typeof graphs.opportunityCountPerGroup.colorPattern[1] !== 'undefined') {
                                    fullColorPattern['*'+comparePart] = graphs.opportunityCountPerGroup.colorPattern[1];
                                }
                            } else {
                                fullColorPattern = [];
                            }
                        } else {
                            fullColorPattern = [];
                        }

                        this.createBarChart(chartData, '#lead-report-opportunity-count-per-group', 45, {
                            colorPattern: graphs.opportunityCountPerGroup.colorPattern,
                            labels: true,
                            title: graphs.opportunityCountPerGroup.title,
                            customYAxisFormat: {
                                type: 'onlyInteger'
                            },
                            //showLegend : true,
                            axesAdditionalInfo: graphs.opportunityCountPerGroup.axesAdditionalInfo
                        });
                        $('#lead-report-opportunity-count-per-group').find('svg').closest('div').after('<div id="lead-report-opportunity-count-per-group-legend"></div>');
                        this.createCustomLegend('#lead-report-opportunity-count-per-group-legend', '#lead-report-opportunity-count-per-group', onlyData,  fullColorPattern);
                        if (typeof graphs.opportunityCountPerGroup.dataToCompare !== 'undefined') {
                            $('#lead-report-opportunity-count-per-group').find('svg').before(_.template(CardComparisonTmpl, {'comparisonData': graphs.opportunityCountPerGroup.comparisonData, 'i18n': i18n}));
                        }
                    } else {
                        $('#lead-report-opportunity-count-per-group').append(_.template(GraphPlaceholderTmpl, {'i18n': i18n}));
                        $('#lead-report-opportunity-count-per-group').addClass('no-graph-data');
                    }
                }
                if (typeof graphs.opportunityAmountByGroup !== 'undefined') {
                    $('#lead-report-opportunity-amount-by-group').empty();
                    $('#lead-report-opportunity-amount-by-group-card-comparison').empty();
                    $('#lead-report-opportunity-amount-by-group').removeClass('no-graph-data');
                    $('#lead-report-opportunity-amount-by-group-legend').empty();
                    if (typeof graphs.opportunityAmountByGroup.axes !== 'undefined') {
                        if (typeof graphs.opportunityAmountByGroup.dataToCompare !== 'undefined') {
                            chartData = [
                                graphs.opportunityAmountByGroup.axes,
                                graphs.opportunityAmountByGroup.data,
                                graphs.opportunityAmountByGroup.dataToCompare
                            ];
                        } else {
                            chartData = [
                                graphs.opportunityAmountByGroup.axes,
                                graphs.opportunityAmountByGroup.data
                            ];
                        }

                        var onlyData = [];
                        var fullColorPattern = [];

                        if(typeof graphs.opportunityAmountByGroup.data !== 'undefined') {
                            var mainPart = graphs.opportunityAmountByGroup.data[0];
                            onlyData.push(mainPart);
                            if(typeof graphs.opportunityAmountByGroup.colorPattern[0] !== 'undefined') {
                                fullColorPattern['*'+mainPart] = graphs.opportunityAmountByGroup.colorPattern[0];
                            }
                        }

                        if(typeof graphs.opportunityAmountByGroup.dataToCompare !== 'undefined') {
                            var comparePart = graphs.opportunityAmountByGroup.dataToCompare[0];
                            if(comparePart != graphs.opportunityAmountByGroup.data[0]) {
                                onlyData.push(comparePart);
                                if(typeof graphs.opportunityAmountByGroup.colorPattern[1] !== 'undefined') {
                                    fullColorPattern['*'+comparePart] = graphs.opportunityAmountByGroup.colorPattern[1];
                                }
                            } else {
                                fullColorPattern = [];
                            }
                        } else {
                            fullColorPattern = [];
                        }

                        this.createBarChart(chartData, '#lead-report-opportunity-amount-by-group', 45, {
                            colorPattern: graphs.opportunityAmountByGroup.colorPattern,
                            customYAxisFormat: {
                                type: 'currency',
                                sign: this.LeadReportsCollection.currencySymbol

                            },
                            labels: {
                                type: 'currency',
                                sign: this.LeadReportsCollection.currencySymbol
                            },
                            title: graphs.opportunityAmountByGroup.title,
                            //showLegend : true,
                            axesAdditionalInfo: graphs.opportunityAmountByGroup.axesAdditionalInfo
                        });
                        $('#lead-report-opportunity-amount-by-group').find('svg').closest('div').after('<div id="lead-report-opportunity-amount-by-group-legend"></div>');
                        this.createCustomLegend('#lead-report-opportunity-amount-by-group-legend', '#lead-report-opportunity-amount-by-group', onlyData,  fullColorPattern);
                        if (typeof graphs.opportunityAmountByGroup.dataToCompare !== 'undefined') {
                            $('#lead-report-opportunity-amount-by-group').find('svg').before(_.template(CardComparisonTmpl, {'comparisonData': graphs.opportunityAmountByGroup.comparisonData, 'i18n': i18n}));
                        }
                    } else {
                        $('#lead-report-opportunity-amount-by-group').append(_.template(GraphPlaceholderTmpl, {'i18n': i18n}));
                        $('#lead-report-opportunity-amount-by-group').addClass('no-graph-data');
                    }
                }

                if (typeof graphs.opportunityStagePerGroup !== 'undefined') {
                    $('#lead-report-opportunity-stage-per-group').empty();
                    $('#lead-report-opportunity-stage-per-group-legend').remove();
                    $('#lead-report-opportunity-stage-per-group-card-comparison').empty();
                    $('#lead-report-opportunity-stage-per-group').removeClass('no-graph-data');
                    if (typeof graphs.opportunityStagePerGroup.axes !== 'undefined') {
                        chartData = [
                            graphs.opportunityStagePerGroup.axes
                        ];


                        var opportunitiesGroupFrom = graphs.opportunityStagePerGroup.opportunitiesGroupFrom,
                            groups = [],
                            onlyData = [],
                            compare = false;

                        groups.push(opportunitiesGroupFrom);

                        $.each(graphs.opportunityStagePerGroup.data, function(opportunity, opportunityData){
                            var cleanLegendId = '';
                            if (!_.isArray(opportunityData)) {
                                var dataArr = [];
                                $.each(opportunityData, function(key, elem){
                                    dataArr[key] = elem;
                                });
                                chartData.push(dataArr);
                            } else {
                                chartData.push(opportunityData);
                            }

                            if (opportunityData[0].match(/\*/) !== null) {
                                cleanLegendId = opportunityData[0].substring(1);
                            } else {
                                cleanLegendId = opportunityData[0];
                            }
                            if (_.indexOf(onlyData, cleanLegendId) == '-1') {
                                onlyData.push(cleanLegendId);
                            }
                        });

                        if (typeof graphs.opportunityStagePerGroup.dataToCompare !== 'undefined') {
                            groups.push(graphs.opportunityStagePerGroup.opportunitiesGroupTo);
                            compare = true;
                        }
                        this.createBarChart(chartData, '#lead-report-opportunity-stage-per-group', 45, {
                            groups:groups,
                            colorPattern: graphs.opportunityStagePerGroup.colorPattern,
                            title: graphs.opportunityStagePerGroup.title,
                            customYAxisFormat: {
                                type: 'onlyInteger'
                            },
                            axesAdditionalInfo: graphs.opportunityStagePerGroup.axesAdditionalInfo,
                            tooltip: {filterFromDate: graphs.opportunityStagePerGroup.filterFromDate, filterToDate: graphs.opportunityStagePerGroup.filterToDate, compare:compare}
                        });

                        $('#lead-report-opportunity-stage-per-group').find('svg').closest('div').after('<div id="lead-report-opportunity-stage-per-group-legend"></div>');
                        this.createCustomLegend('#lead-report-opportunity-stage-per-group-legend', '#lead-report-opportunity-stage-per-group', onlyData,  graphs.opportunityStagePerGroup.fullColorPattern);
                        if (typeof graphs.opportunityStagePerGroup.dataToCompare !== 'undefined') {
                            $('#lead-report-opportunity-stage-per-group').find('svg').before(_.template(CardComparisonTmpl, {'comparisonData': graphs.opportunityStagePerGroup.comparisonData, 'i18n': i18n}));
                        }
                    } else {
                        $('#lead-report-opportunity-stage-per-group').append(_.template(GraphPlaceholderTmpl, {'i18n': i18n}));
                        $('#lead-report-opportunity-stage-per-group').addClass('no-graph-data');
                    }
                }
            }
            if (tabName === 'source') {
                if (typeof graphs.bySource !== 'undefined') {
                    $('#lead-report-by-source').empty();
                    $('#lead-report-by-source-legend').remove();
                    $('#lead-report-by-source-card-comparison').empty();
                    $('#lead-report-by-source').removeClass('no-graph-data');
                    if (typeof graphs.bySource.axes !== 'undefined') {
                        chartData = [
                            graphs.bySource.axes
                        ];

                        var opportunitiesGroupFrom = graphs.bySource.opportunitiesGroupFrom,
                            groups = [],
                            onlyData = [],
                            compare = false;

                        groups.push(opportunitiesGroupFrom);

                        $.each(graphs.bySource.data, function(opportunity, opportunityData){
                            var cleanLegendId = '';
                            if (!_.isArray(opportunityData)) {
                                var dataArr = [];
                                $.each(opportunityData, function(key, elem){
                                    dataArr[key] = elem;
                                });
                                chartData.push(dataArr);
                            } else {
                                chartData.push(opportunityData);
                            }

                            if (opportunityData[0].match(/\*/) !== null) {
                                cleanLegendId = opportunityData[0].substring(1);
                            } else {
                                cleanLegendId = opportunityData[0];
                            }
                            if (_.indexOf(onlyData, cleanLegendId) == '-1') {
                                onlyData.push(cleanLegendId);
                            }
                        });

                        if (typeof graphs.bySource.dataToCompare !== 'undefined') {
                            groups.push(graphs.bySource.opportunitiesGroupTo);
                            compare = true;
                        }

                        var additionalFilterPreset = [];

                        if(typeof graphs.bySource.additionalFilterPreset !== 'undefined') {
                            additionalFilterPreset = graphs.bySource.additionalFilterPreset;
                        }

                        this.createBarChart(chartData, '#lead-report-by-source', 45, {
                            groups:groups,
                            colorPattern: graphs.bySource.colorPattern,
                            title: graphs.bySource.title,
                            customYAxisFormat: {
                                type: 'onlyInteger'
                            },
                            axesAdditionalInfo: graphs.bySource.axesAdditionalInfo,
                            tooltip: {filterFromDate: graphs.bySource.filterFromDate, filterToDate: graphs.bySource.filterToDate, compare: compare},
                            additionalFilterPreset: additionalFilterPreset
                        });
                        $('#lead-report-by-source').find('svg').closest('div').after('<div id="lead-report-by-source-legend"></div>');
                        this.createCustomLegend('#lead-report-by-source-legend', '#lead-report-by-source', onlyData, graphs.bySource.fullColorPattern);
                        if (typeof graphs.bySource.dataToCompare !== 'undefined') {
                            $('#lead-report-by-source').find('svg').before(_.template(CardComparisonTmpl, {'comparisonData': graphs.bySource.comparisonData, 'i18n': i18n}));
                        }
                    } else {
                        $('#lead-report-by-source').append(_.template(GraphPlaceholderTmpl, {'i18n': i18n}));
                        $('#lead-report-by-source').addClass('no-graph-data');
                    }
                }

                if (typeof graphs.opportunityCountPerSource !== 'undefined') {
                    $('#lead-report-opportunity-count-per-source').empty();
                    $('#lead-report-opportunity-count-per-source-card-comparison').empty();
                    $('#lead-report-opportunity-count-per-source').removeClass('no-graph-data');
                    $('#lead-report-opportunity-count-per-source-legend').empty();
                    if (typeof graphs.opportunityCountPerSource.axes !== 'undefined') {
                        if (typeof graphs.opportunityCountPerSource.dataToCompare !== 'undefined') {
                            chartData = [
                                graphs.opportunityCountPerSource.axes,
                                graphs.opportunityCountPerSource.data,
                                graphs.opportunityCountPerSource.dataToCompare
                            ];
                        } else {
                            chartData = [
                                graphs.opportunityCountPerSource.axes,
                                graphs.opportunityCountPerSource.data
                            ];
                        }

                        var onlyData = [];
                        var fullColorPattern = [];

                        if(typeof graphs.opportunityCountPerSource.data !== 'undefined') {
                            var mainPart = graphs.opportunityCountPerSource.data[0];
                            onlyData.push(mainPart);
                            if(typeof graphs.opportunityCountPerSource.colorPattern[0] !== 'undefined') {
                                fullColorPattern['*'+mainPart] = graphs.opportunityCountPerSource.colorPattern[0];
                            }
                        }

                        if(typeof graphs.opportunityCountPerSource.dataToCompare !== 'undefined') {
                            var comparePart = graphs.opportunityCountPerSource.dataToCompare[0];
                            if(comparePart != graphs.opportunityCountPerSource.data[0]) {
                                onlyData.push(comparePart);
                                if(typeof graphs.opportunityCountPerSource.colorPattern[1] !== 'undefined') {
                                    fullColorPattern['*'+comparePart] = graphs.opportunityCountPerSource.colorPattern[1];
                                }
                            } else {
                                fullColorPattern = [];
                            }
                        } else {
                            fullColorPattern = [];
                        }

                        this.createBarChart(chartData, '#lead-report-opportunity-count-per-source', 45, {
                            colorPattern: graphs.opportunityCountPerSource.colorPattern,
                            labels: true,
                            title: graphs.opportunityCountPerSource.title,
                            customYAxisFormat: {
                                type: 'onlyInteger'
                            },
                            //showLegend : true,
                            axesAdditionalInfo: graphs.opportunityCountPerSource.axesAdditionalInfo
                        });
                        $('#lead-report-opportunity-count-per-source').find('svg').closest('div').after('<div id="lead-report-opportunity-count-per-source-legend"></div>');
                        this.createCustomLegend('#lead-report-opportunity-count-per-source-legend', '#lead-report-opportunity-count-per-source', onlyData,  fullColorPattern);
                        if (typeof graphs.opportunityCountPerSource.dataToCompare !== 'undefined') {
                            $('#lead-report-opportunity-count-per-source').find('svg').before(_.template(CardComparisonTmpl, {'comparisonData': graphs.opportunityCountPerSource.comparisonData, 'i18n': i18n}));
                        }
                    } else {
                        $('#lead-report-opportunity-count-per-source').append(_.template(GraphPlaceholderTmpl, {'i18n': i18n}));
                        $('#lead-report-opportunity-count-per-source').addClass('no-graph-data');
                    }
                }

                if (typeof graphs.opportunityAmountBySource !== 'undefined') {
                    $('#lead-report-opportunity-amount-by-source').empty();
                    $('#lead-report-opportunity-amount-by-source-card-comparison').empty();
                    $('#lead-report-opportunity-amount-by-source').removeClass('no-graph-data');
                    $('#lead-report-opportunity-amount-by-source-legend').empty();
                    if (typeof graphs.opportunityAmountBySource.axes !== 'undefined') {
                        if (typeof graphs.opportunityAmountBySource.dataToCompare !== 'undefined') {
                            chartData = [
                                graphs.opportunityAmountBySource.axes,
                                graphs.opportunityAmountBySource.data,
                                graphs.opportunityAmountBySource.dataToCompare
                            ];
                        } else {
                            chartData = [
                                graphs.opportunityAmountBySource.axes,
                                graphs.opportunityAmountBySource.data
                            ];
                        }

                        var onlyData = [];
                        var fullColorPattern = [];

                        if(typeof graphs.opportunityAmountBySource.data !== 'undefined') {
                            var mainPart = graphs.opportunityAmountBySource.data[0];
                            onlyData.push(mainPart);
                            if(typeof graphs.opportunityAmountBySource.colorPattern[0] !== 'undefined') {
                                fullColorPattern['*'+mainPart] = graphs.opportunityAmountBySource.colorPattern[0];
                            }
                        }

                        if(typeof graphs.opportunityAmountBySource.dataToCompare !== 'undefined') {
                            var comparePart = graphs.opportunityAmountBySource.dataToCompare[0];
                            if(comparePart != graphs.opportunityAmountBySource.data[0]) {
                                onlyData.push(comparePart);
                                if(typeof graphs.opportunityAmountBySource.colorPattern[1] !== 'undefined') {
                                    fullColorPattern['*'+comparePart] = graphs.opportunityAmountBySource.colorPattern[1];
                                }
                            } else {
                                fullColorPattern = [];
                            }
                        } else {
                            fullColorPattern = [];
                        }

                        this.createBarChart(chartData, '#lead-report-opportunity-amount-by-source', 45, {
                            colorPattern: graphs.opportunityAmountBySource.colorPattern,
                            customYAxisFormat: {
                                type: 'currency',
                                sign: this.LeadReportsCollection.currencySymbol

                            },
                            labels: {
                                type: 'currency',
                                sign: this.LeadReportsCollection.currencySymbol
                            },
                            title: graphs.opportunityAmountBySource.title,
                            //showLegend : true,
                            axesAdditionalInfo: graphs.opportunityAmountBySource.axesAdditionalInfo
                        });
                        $('#lead-report-opportunity-amount-by-source').find('svg').closest('div').after('<div id="lead-report-opportunity-amount-by-source-legend"></div>');
                        this.createCustomLegend('#lead-report-opportunity-amount-by-source-legend', '#lead-report-opportunity-amount-by-source', onlyData,  fullColorPattern);
                        if (typeof graphs.opportunityAmountBySource.dataToCompare !== 'undefined') {
                            $('#lead-report-opportunity-amount-by-source').find('svg').before(_.template(CardComparisonTmpl, {'comparisonData': graphs.opportunityAmountBySource.comparisonData, 'i18n': i18n}));
                        }
                    } else {
                        $('#lead-report-opportunity-amount-by-source').append(_.template(GraphPlaceholderTmpl, {'i18n': i18n}));
                        $('#lead-report-opportunity-amount-by-source').addClass('no-graph-data');
                    }
                }

                if (typeof graphs.opportunityStagePerSource !== 'undefined') {
                    $('#lead-report-opportunity-stage-per-source').empty();
                    $('#lead-report-opportunity-stage-per-source-legend').remove();
                    $('#lead-report-opportunity-stage-per-source-card-comparison').empty();
                    $('#lead-report-opportunity-stage-per-source').removeClass('no-graph-data');
                    if (typeof graphs.opportunityStagePerSource.axes !== 'undefined') {
                        chartData = [
                            graphs.opportunityStagePerSource.axes
                        ];

                        var opportunitiesGroupFrom = graphs.opportunityStagePerSource.opportunitiesGroupFrom,
                            groups = [],
                            onlyData = [],
                            compare = false;

                        groups.push(opportunitiesGroupFrom);

                        $.each(graphs.opportunityStagePerSource.data, function(opportunity, opportunityData){
                            var cleanLegendId = '';
                            if (!_.isArray(opportunityData)) {
                                var dataArr = [];
                                $.each(opportunityData, function(key, elem){
                                    dataArr[key] = elem;
                                });
                                chartData.push(dataArr);
                            } else {
                                chartData.push(opportunityData);
                            }

                            if (opportunityData[0].match(/\*/) !== null) {
                                cleanLegendId = opportunityData[0].substring(1);
                            } else {
                                cleanLegendId = opportunityData[0];
                            }
                            if (_.indexOf(onlyData, cleanLegendId) == '-1') {
                                onlyData.push(cleanLegendId);
                            }
                        });

                        if (typeof graphs.opportunityStagePerSource.dataToCompare !== 'undefined') {
                            groups.push(graphs.opportunityStagePerSource.opportunitiesGroupTo);
                            compare = true;
                        }

                        this.createBarChart(chartData, '#lead-report-opportunity-stage-per-source', 45, {
                            groups:groups,
                            colorPattern: graphs.opportunityStagePerSource.colorPattern,
                            title: graphs.opportunityStagePerSource.title,
                            customYAxisFormat: {
                                type: 'onlyInteger'
                            },
                            axesAdditionalInfo: graphs.opportunityStagePerSource.axesAdditionalInfo,
                            tooltip: {filterFromDate: graphs.opportunityStagePerSource.filterFromDate, filterToDate: graphs.opportunityStagePerSource.filterToDate, compare: compare}
                        });
                        $('#lead-report-opportunity-stage-per-source').find('svg').closest('div').after('<div id="lead-report-opportunity-stage-per-source-legend"></div>');
                        this.createCustomLegend('#lead-report-opportunity-stage-per-source-legend', '#lead-report-opportunity-stage-per-source', onlyData, graphs.opportunityStagePerSource.fullColorPattern);
                        if (typeof graphs.opportunityStagePerSource.dataToCompare !== 'undefined') {
                            $('#lead-report-opportunity-stage-per-source').find('svg').before(_.template(CardComparisonTmpl, {'comparisonData': graphs.opportunityStagePerSource.comparisonData, 'i18n': i18n}));
                        }
                    } else {
                        $('#lead-report-opportunity-stage-per-source').append(_.template(GraphPlaceholderTmpl, {'i18n': i18n}));
                        $('#lead-report-opportunity-stage-per-source').addClass('no-graph-data');
                    }
                }

                if (typeof graphs.byLifecycle !== 'undefined') {
                    $('#lead-report-by-lifecycle').empty();
                    $('#lead-report-by-lifecycle-card-comparison').empty();
                    $('#lead-report-by-lifecycle').removeClass('no-graph-data');
                    $('#lead-report-by-lifecycle-legend').empty();
                    if (typeof graphs.byLifecycle.axes !== 'undefined') {
                        if (typeof graphs.byLifecycle.dataToCompare !== 'undefined') {
                            chartData = [
                                graphs.byLifecycle.axes,
                                graphs.byLifecycle.data,
                                graphs.byLifecycle.dataToCompare
                            ];
                        } else {
                            chartData = [
                                graphs.byLifecycle.axes,
                                graphs.byLifecycle.data
                            ];
                        }

                        var additionalFilterPreset = [];

                        if(typeof graphs.byLifecycle.additionalFilterPreset !== 'undefined') {
                            additionalFilterPreset = graphs.byLifecycle.additionalFilterPreset;
                        }

                        var onlyData = [];
                        var fullColorPattern = [];

                        if(typeof graphs.byLifecycle.data !== 'undefined') {
                            var mainPart = graphs.byLifecycle.data[0];
                            onlyData.push(mainPart);
                            if(typeof graphs.byLifecycle.colorPattern[0] !== 'undefined') {
                                fullColorPattern['*'+mainPart] = graphs.byLifecycle.colorPattern[0];
                            }
                        }

                        if(typeof graphs.byLifecycle.dataToCompare !== 'undefined') {
                            var comparePart = graphs.byLifecycle.dataToCompare[0];
                            if(comparePart != graphs.byLifecycle.data[0]) {
                                onlyData.push(comparePart);
                                if(typeof graphs.byLifecycle.colorPattern[1] !== 'undefined') {
                                    fullColorPattern['*'+comparePart] = graphs.byLifecycle.colorPattern[1];
                                }
                            } else {
                                fullColorPattern = [];
                            }
                        } else {
                            fullColorPattern = [];
                        }

                        this.createBarChart(chartData, '#lead-report-by-lifecycle', 45, {
                            colorPattern: graphs.byLifecycle.colorPattern,
                            labels: true,
                            title: graphs.byLifecycle.title,
                            customYAxisFormat: {
                                type: 'onlyInteger'
                            },
                            //showLegend : true,
                            axesAdditionalInfo: graphs.byLifecycle.axesAdditionalInfo,
                            additionalFilterPreset: additionalFilterPreset
                        });
                        $('#lead-report-by-lifecycle').find('svg').closest('div').after('<div id="lead-report-by-lifecycle-legend"></div>');
                        this.createCustomLegend('#lead-report-by-lifecycle-legend', '#lead-report-by-lifecycle', onlyData,  fullColorPattern);
                        if (typeof graphs.byLifecycle.dataToCompare !== 'undefined') {
                            $('#lead-report-by-lifecycle').find('svg').before(_.template(CardComparisonTmpl, {'comparisonData': graphs.byLifecycle.comparisonData, 'i18n': i18n}));
                        }
                    } else {
                        $('#lead-report-by-lifecycle').append(_.template(GraphPlaceholderTmpl, {'i18n': i18n}));
                        $('#lead-report-by-lifecycle').addClass('no-graph-data');
                    }
                }

                if (typeof graphs.byCampaign !== 'undefined') {
                    $('#lead-report-by-campaign').empty();
                    $('#lead-report-by-campaign-card-comparison').empty();
                    $('#lead-report-by-campaign').removeClass('no-graph-data');
                    $('#lead-report-by-campaign-legend').empty();
                    if (typeof graphs.byCampaign.axes !== 'undefined') {
                        if (typeof graphs.byCampaign.dataToCompare !== 'undefined') {
                            chartData = [
                                graphs.byCampaign.axes,
                                graphs.byCampaign.data,
                                graphs.byCampaign.dataToCompare
                            ];
                        } else {
                            chartData = [
                                graphs.byCampaign.axes,
                                graphs.byCampaign.data
                            ];
                        }

                        var onlyData = [];
                        var fullColorPattern = [];

                        if(typeof graphs.byCampaign.data !== 'undefined') {
                            var mainPart = graphs.byCampaign.data[0];
                            onlyData.push(mainPart);
                            if(typeof graphs.byCampaign.colorPattern[0] !== 'undefined') {
                                fullColorPattern['*'+mainPart] = graphs.byCampaign.colorPattern[0];
                            }
                        }

                        if(typeof graphs.byCampaign.dataToCompare !== 'undefined') {
                            var comparePart = graphs.byCampaign.dataToCompare[0];
                            if(comparePart != graphs.byCampaign.data[0]) {
                                onlyData.push(comparePart);
                                if(typeof graphs.byCampaign.colorPattern[1] !== 'undefined') {
                                    fullColorPattern['*'+comparePart] = graphs.byCampaign.colorPattern[1];
                                }
                            } else {
                                fullColorPattern = [];
                            }
                        } else {
                            fullColorPattern = [];
                        }

                        this.createBarChartCampaign(chartData, '#lead-report-by-campaign', 45, {
                            colorPattern: graphs.byCampaign.colorPattern,
                            labels: true,
                            title: graphs.byCampaign.title,
                            customYAxisFormat: {
                                type: 'onlyInteger'
                            },
                            //showLegend : true,
                            axesAdditionalInfo: graphs.byCampaign.axesAdditionalInfo,
                            greaterThanLimit: graphs.byCampaign.greaterThanLimit,
                        });
                        $('#lead-report-by-campaign').find('svg').closest('div').after('<div id="lead-report-by-campaign-legend"></div>');
                        this.createCustomLegend('#lead-report-by-campaign-legend', '#lead-report-by-campaign', onlyData,  fullColorPattern);
                        if (typeof graphs.byCampaign.dataToCompare !== 'undefined') {
                            $('#lead-report-by-campaign').find('svg').before(_.template(CardComparisonTmpl, {'comparisonData': graphs.byCampaign.comparisonData, 'i18n': i18n}));
                        }
                    } else {
                        $('#lead-report-by-campaign').append(_.template(GraphPlaceholderTmpl, {'i18n': i18n}));
                        $('#lead-report-by-campaign').addClass('no-graph-data');
                    }
                }
            }
            if (tabName === 'sales') {
                if (typeof graphs.opportunityStagePieOriginal !== 'undefined') {
                    $('#lead-report-opportunity-stage-pie-original').empty();
                    $('#lead-report-opportunity-stage-pie-original-legend').remove();
                    $('#lead-report-opportunity-stage-pie-original').removeClass('no-graph-data');
                    if (typeof graphs.opportunityStagePieOriginal.data !== 'undefined') {
                        var chartData = [],
                            labelsData = {},
                            self = this;

                        $.each(graphs.opportunityStagePieOriginal.data, function(opportunity, opportunityData){
                            chartData.push([opportunityData.count +' '+ opportunityData.stageName + ' | ' + (_.isUndefined(i18n['Amount'])?'Amount':i18n['Amount']) + ': '+ self.LeadReportsCollection.currencySymbol + d3.format(",")(opportunityData.amount), opportunityData.amount]);
                            if (opportunity === '100') {
                                labelsData.Won = 'Won with '+ opportunityData.count +' deals';
                            } else {
                                labelsData.Lost = 'Lost with '+ opportunityData.count +' deals';
                            }
                       });

                        this.createPieChart(chartData, '#lead-report-opportunity-stage-pie-original', 45, {
                            colorPattern: graphs.opportunityStagePieOriginal.colorPattern,
                            title: graphs.opportunityStagePieOriginal.title,
                            axesAdditionalInfo: graphs.opportunityStagePieOriginal.axesAdditionalInfo,
                            amountComparison: {
                                labelsData: labelsData,
                                sign: this.LeadReportsCollection.currencySymbol
                            },
                            showLegend: true,
                            legendPosition: 'right'
                        });
                        //$('#lead-report-opportunity-stage-pie-original').find('svg').closest('div').after('<div id="lead-report-opportunity-stage-pie-original-legend"><span>'+graphs.opportunityStagePieOriginal.filterPeriod+'</span></div>');
                    } else {
                        $('#lead-report-opportunity-stage-pie-original').append(_.template(GraphPlaceholderTmpl, {'i18n': i18n}));
                        $('#lead-report-opportunity-stage-pie-original').addClass('no-graph-data');
                    }
                }

                if (typeof graphs.opportunityStagePieCompare !== 'undefined') {
                    $('#lead-report-opportunity-stage-pie-compare').empty();
                    $('#lead-report-opportunity-stage-pie-compare').parent('div').removeClass('hidden');
                    $('#lead-report-opportunity-stage-pie-compare-legend').remove();
                    $('#lead-report-opportunity-stage-pie-compare-card-comparison').empty();
                    $('#lead-report-opportunity-stage-pie-compare').removeClass('no-graph-data');
                    if (typeof graphs.opportunityStagePieCompare.data !== 'undefined') {
                        var chartData = [],
                            labelsData = {},
                            self = this;

                        $.each(graphs.opportunityStagePieCompare.data, function(opportunity, opportunityData){
                            //chartData.push([opportunityData.stageName, opportunityData.amount]);
                            chartData.push([opportunityData.count +' '+ opportunityData.stageName + ' | '+ (_.isUndefined(i18n['Amount'])?'Amount':i18n['Amount']) +': '+ self.LeadReportsCollection.currencySymbol + d3.format(",")(opportunityData.amount), opportunityData.amount]);
                            if (opportunity === '100') {
                                labelsData.Won = 'Won with '+ opportunityData.count +' deals';
                            } else {
                                labelsData.Lost = 'Lost with '+ opportunityData.count +' deals';
                            }
                        });

                        this.createPieChart(chartData, '#lead-report-opportunity-stage-pie-compare', 45, {
                            colorPattern: graphs.opportunityStagePieCompare.colorPattern,
                            title: graphs.opportunityStagePieCompare.title,
                            axesAdditionalInfo: graphs.opportunityStagePieCompare.axesAdditionalInfo,
                            amountComparison: {
                                labelsData: labelsData,
                                sign: this.LeadReportsCollection.currencySymbol
                            },
                            showLegend: true,
                            legendPosition: 'right'
                        });
                        //$('#lead-report-opportunity-stage-pie-compare').find('svg').closest('div').after('<div id="lead-report-opportunity-stage-pie-compare-legend"><span>'+graphs.opportunityStagePieCompare.filterPeriod+'</span></div>');

                    } else {
                        $('#lead-report-opportunity-stage-pie-compare').append(_.template(GraphPlaceholderTmpl, {'i18n': i18n}));
                        $('#lead-report-opportunity-stage-pie-compare').addClass('no-graph-data');

                    }
                    if (typeof graphs.opportunityStagePieCompare.comparisonData !== 'undefined' && typeof graphs.opportunityStagePieCompare.data !== 'undefined') {
                        $('#lead-report-opportunity-stage-pie-original').find('svg').before(_.template(CardComparisonPieTmpl, {'comparisonData': graphs.opportunityStagePieCompare.comparisonData, 'i18n': i18n}));
                    }
                } else {
                    $('#lead-report-opportunity-stage-pie-compare').empty();
                    $('#lead-report-opportunity-stage-pie-compare').parent('div').addClass('hidden');
                    $('#lead-report-opportunity-stage-pie-compare-legend').remove();
                }

                if (typeof graphs.onlineSalesStagePieOriginal !== 'undefined') {
                    $('#lead-report-online-sales-stage-pie-original').empty();
                    $('#lead-report-online-sales-stage-pie-original-legend').remove();
                    $('#lead-report-online-sales-stage-pie-original').removeClass('no-graph-data');

                    if (typeof graphs.onlineSalesStagePieOriginal.data !== 'undefined') {
                        var chartData = [],
                            labelsData = {},
                            self = this;
                        $.each(graphs.onlineSalesStagePieOriginal.data, function(opportunity, opportunityData){
                            chartData.push([(_.isUndefined(i18n['Amount'])?'Amount':i18n['Amount']) +': ' + self.LeadReportsCollection.currencySymbol + d3.format(",")(Math.round(opportunityData.amount)) + ' (' + opportunityData.count + ')', opportunityData.amount]);
                        });

                        this.createPieChart(chartData, '#lead-report-online-sales-stage-pie-original', 45, {
                            colorPattern: ['#6fce70'],
                            title: graphs.onlineSalesStagePieOriginal.title,
                            axesAdditionalInfo: ['100'],
                            amountComparison: {
                                labelsData: labelsData,
                                sign: this.LeadReportsCollection.currencySymbol
                            },
                            showLegend: true,
                            legendPosition: 'right'
                        });
                        //$('#lead-report-online-sales-stage-pie-original').find('svg').closest('div').after('<div id="lead-report-online-sales-stage-pie-original-legend"><span>'+graphs.onlineSalesStagePieOriginal.filterPeriod+'</span></div>');
                    } else {
                        $('#lead-report-online-sales-stage-pie-original').append(_.template(GraphPlaceholderTmpl, {'i18n': i18n}));
                        $('#lead-report-online-sales-stage-pie-original').addClass('no-graph-data');
                    }
                }

                if (typeof graphs.onlineSalesStagePieCompare !== 'undefined') {
                    $('#lead-report-online-sales-stage-pie-compare').empty();
                    $('#lead-report-online-sales-stage-pie-compare-legend').remove();
                    $('#lead-report-online-sales-stage-pie-compare').parent('div').removeClass('hidden');
                    $('#lead-report-online-sales-stage-pie-compare').removeClass('no-graph-data');

                    if (typeof graphs.onlineSalesStagePieCompare.data !== 'undefined') {
                        var chartData = [],
                            labelsData = {},
                            self = this;

                        $.each(graphs.onlineSalesStagePieCompare.data, function(opportunity, opportunityData){
                            chartData.push([(_.isUndefined(i18n['Amount'])?'Amount':i18n['Amount']) +': ' + self.LeadReportsCollection.currencySymbol + d3.format(",")(Math.round(opportunityData.amount)) + ' (' + opportunityData.count + ')', opportunityData.amount]);
                        });

                        this.createPieChart(chartData, '#lead-report-online-sales-stage-pie-compare', 45, {
                            colorPattern: ['#6fce70'],
                            title: graphs.onlineSalesStagePieCompare.title,
                            axesAdditionalInfo: ['100'],
                            amountComparison: {
                                labelsData: labelsData,
                                sign: this.LeadReportsCollection.currencySymbol
                            },
                            showLegend: true,
                            legendPosition: 'right'
                        });

                        //$('#lead-report-online-sales-stage-pie-compare').find('svg').closest('div').after('<div id="lead-report-online-sales-stage-pie-compare-legend"><span>'+graphs.onlineSalesStagePieCompare.filterPeriod+'</span></div>');

                        if (typeof graphs.onlineSalesStagePieCompare.comparisonData !== 'undefined' && typeof graphs.onlineSalesStagePieCompare.data !== 'undefined') {
                            $('#lead-report-online-sales-stage-pie-original').find('svg').before(_.template(CardComparisonPieTmpl, {'comparisonData': graphs.onlineSalesStagePieCompare.comparisonData, 'i18n': i18n}));
                        }
                    } else {
                        $('#lead-report-online-sales-stage-pie-compare').append(_.template(GraphPlaceholderTmpl, {'i18n': i18n}));
                        $('#lead-report-online-sales-stage-pie-compare').addClass('no-graph-data');
                    }
                } else {
                    $('#lead-report-online-sales-stage-pie-compare').empty();
                    $('#lead-report-online-sales-stage-pie-compare').parent('div').addClass('hidden');
                    $('#lead-report-online-sales-stage-pie-compare-legend').remove();
                }

                if (typeof graphs.opportunityStagePerRepSale !== 'undefined') {
                    $('#lead-report-opportunity-stage-per-rep-sale-tooltip').remove();
                    $('#lead-report-opportunity-stage-per-rep-sale').empty().removeClass('no-graph-data');
                    $('#lead-report-opportunity-stage-per-rep-sale-card-comparison').empty();
                    if (typeof graphs.opportunityStagePerRepSale.axes !== 'undefined') {
                        chartData = [
                            graphs.opportunityStagePerRepSale.axes
                        ];

                        var opportunitiesGroupFrom = graphs.opportunityStagePerRepSale.opportunitiesGroupFrom,
                            groups = [],
                            onlyData = [],
                            compare = false;

                        groups.push(opportunitiesGroupFrom);

                        $.each(graphs.opportunityStagePerRepSale.data, function(opportunity, opportunityData){
                            chartData.push(opportunityData);
                            var cleanLegendId = '';

                            if (opportunityData[0].match(/\*/) !== null) {
                                cleanLegendId = opportunityData[0].substring(1);
                            } else {
                                cleanLegendId = opportunityData[0];
                            }
                            if (_.indexOf(onlyData, cleanLegendId) == '-1') {
                                onlyData.push(cleanLegendId);
                            }
                        });

                        if (typeof graphs.opportunityStagePerRepSale.dataToCompare !== 'undefined') {
                            groups.push(graphs.opportunityStagePerRepSale.opportunitiesGroupTo);
                            compare = true;
                        }
                        this.createBarChart(chartData, '#lead-report-opportunity-stage-per-rep-sale', 45, {
                            groups:groups,
                            colorPattern: graphs.opportunityStagePerRepSale.colorPattern,
                            title: graphs.opportunityStagePerRepSale.title,
                            customYAxisFormat: {
                                type: 'currency',
                                sign: this.LeadReportsCollection.currencySymbol
                            },
                            axesAdditionalInfo: graphs.opportunityStagePerRepSale.axesAdditionalInfo,
                            tooltip: {filterFromDate: graphs.opportunityStagePerRepSale.filterFromDate, filterToDate: graphs.opportunityStagePerRepSale.filterToDate, compare:compare, 'roughData':graphs.opportunityStagePerRepSale.roughData}
                        });
                        $('#lead-report-opportunity-stage-per-rep-sale').find('svg').closest('div').after('<div id="lead-report-opportunity-stage-per-rep-sale-tooltip"></div>');
                        this.createCustomLegend('#lead-report-opportunity-stage-per-rep-sale-tooltip', '#lead-report-opportunity-stage-per-rep-sale', onlyData,  graphs.opportunityStagePerRepSale.fullColorPattern);
                        if (typeof graphs.opportunityStagePerRepSale.dataToCompare !== 'undefined') {
                            $('#lead-report-opportunity-stage-per-rep-sale').find('svg').before(_.template(CardComparisonTmpl, {'comparisonData': graphs.opportunityStagePerRepSale.comparisonData, 'i18n': i18n}));
                        }
                    } else {
                        $('#lead-report-opportunity-stage-per-rep-sale').append(_.template(GraphPlaceholderTmpl, {'i18n': i18n})).addClass('no-graph-data');
                    }
                }

                if (typeof graphs.opportunityStagePerSourceSale !== 'undefined') {
                    $('#lead-report-opportunity-stage-per-source-sale-tooltip').remove();
                    $('#lead-report-opportunity-stage-per-source-sale').empty().removeClass('no-graph-data');
                    $('#lead-report-opportunity-stage-per-source-sale-card-comparison').empty();
                    if (typeof graphs.opportunityStagePerSourceSale.axes !== 'undefined') {
                        chartData = [
                            graphs.opportunityStagePerSourceSale.axes
                        ];

                        var opportunitiesGroupFrom = graphs.opportunityStagePerSourceSale.opportunitiesGroupFrom,
                            groups = [],
                            onlyData = [],
                            compare = false;

                        groups.push(opportunitiesGroupFrom);

                        $.each(graphs.opportunityStagePerSourceSale.data, function(opportunity, opportunityData){
                            chartData.push(opportunityData);
                            var cleanLegendId = '';

                            if (opportunityData[0].match(/\*/) !== null) {
                                cleanLegendId = opportunityData[0].substring(1);
                            } else {
                                cleanLegendId = opportunityData[0];
                            }
                            if (_.indexOf(onlyData, cleanLegendId) == '-1') {
                                onlyData.push(cleanLegendId);
                            }
                        });

                        if (typeof graphs.opportunityStagePerSourceSale.dataToCompare !== 'undefined') {
                            groups.push(graphs.opportunityStagePerSourceSale.opportunitiesGroupTo);
                            compare = true;
                        }
                        this.createBarChart(chartData, '#lead-report-opportunity-stage-per-source-sale', 45, {
                            groups:groups,
                            colorPattern: graphs.opportunityStagePerSourceSale.colorPattern,
                            title: graphs.opportunityStagePerSourceSale.title,
                            customYAxisFormat: {
                                type: 'currency',
                                sign: this.LeadReportsCollection.currencySymbol
                            },
                            axesAdditionalInfo: graphs.opportunityStagePerSourceSale.axesAdditionalInfo,
                            tooltip: {filterFromDate: graphs.opportunityStagePerSourceSale.filterFromDate, filterToDate: graphs.opportunityStagePerSourceSale.filterToDate, compare:compare, 'roughData':graphs.opportunityStagePerSourceSale.roughData}
                        });
                        $('#lead-report-opportunity-stage-per-source-sale').find('svg').closest('div').after('<div id="lead-report-opportunity-stage-per-source-sale-tooltip"></div>');
                        this.createCustomLegend('#lead-report-opportunity-stage-per-source-sale-tooltip', '#lead-report-opportunity-stage-per-source-sale', onlyData,  graphs.opportunityStagePerSourceSale.fullColorPattern);
                        if (typeof graphs.opportunityStagePerSourceSale.dataToCompare !== 'undefined') {
                            $('#lead-report-opportunity-stage-per-source-sale').find('svg').before(_.template(CardComparisonTmpl, {'comparisonData': graphs.opportunityStagePerSourceSale.comparisonData, 'i18n': i18n}));
                        }
                    } else {
                        $('#lead-report-opportunity-stage-per-source-sale').append(_.template(GraphPlaceholderTmpl, {'i18n': i18n})).addClass('no-graph-data');
                    }
                }

                if (typeof graphs.opportunityStagePerGroupSale !== 'undefined') {
                    $('#lead-report-opportunity-stage-per-group-sale-tooltip').remove();
                    $('#lead-report-opportunity-stage-per-group-sale').empty().removeClass('no-graph-data');
                    $('#lead-report-opportunity-stage-per-group-sale-comparison').empty();
                    if (typeof graphs.opportunityStagePerGroupSale.axes !== 'undefined') {
                        chartData = [
                            graphs.opportunityStagePerGroupSale.axes
                        ];

                        var opportunitiesGroupFrom = graphs.opportunityStagePerGroupSale.opportunitiesGroupFrom,
                            groups = [],
                            onlyData = [],
                            compare = false;

                        groups.push(opportunitiesGroupFrom);

                        $.each(graphs.opportunityStagePerGroupSale.data, function(opportunity, opportunityData){
                            chartData.push(opportunityData);
                            var cleanLegendId = '';

                            if (opportunityData[0].match(/\*/) !== null) {
                                cleanLegendId = opportunityData[0].substring(1);
                            } else {
                                cleanLegendId = opportunityData[0];
                            }
                            if (_.indexOf(onlyData, cleanLegendId) == '-1') {
                                onlyData.push(cleanLegendId);
                            }
                        });

                        if (typeof graphs.opportunityStagePerGroupSale.dataToCompare !== 'undefined') {
                            groups.push(graphs.opportunityStagePerGroupSale.opportunitiesGroupTo);
                            compare = true;
                        }
                        this.createBarChart(chartData, '#lead-report-opportunity-stage-per-group-sale', 45, {
                            groups:groups,
                            colorPattern: graphs.opportunityStagePerGroupSale.colorPattern,
                            title: graphs.opportunityStagePerGroupSale.title,
                            customYAxisFormat: {
                                type: 'currency',
                                sign: this.LeadReportsCollection.currencySymbol
                            },
                            axesAdditionalInfo: graphs.opportunityStagePerGroupSale.axesAdditionalInfo,
                            tooltip: {filterFromDate: graphs.opportunityStagePerGroupSale.filterFromDate, filterToDate: graphs.opportunityStagePerGroupSale.filterToDate, compare:compare, 'roughData':graphs.opportunityStagePerGroupSale.roughData}
                        });
                        $('#lead-report-opportunity-stage-per-group-sale').find('svg').closest('div').after('<div id="lead-report-opportunity-stage-per-group-sale-tooltip"></div>');
                        this.createCustomLegend('#lead-report-opportunity-stage-per-group-sale-tooltip', '#lead-report-opportunity-stage-per-group-sale', onlyData,  graphs.opportunityStagePerGroupSale.fullColorPattern);
                        if (typeof graphs.opportunityStagePerGroupSale.dataToCompare !== 'undefined') {
                            $('#lead-report-opportunity-stage-per-group-sale').find('svg').before(_.template(CardComparisonTmpl, {'comparisonData': graphs.opportunityStagePerGroupSale.comparisonData, 'i18n': i18n}));
                        }
                    } else {
                        $('#lead-report-opportunity-stage-per-group-sale').append(_.template(GraphPlaceholderTmpl, {'i18n': i18n})).addClass('no-graph-data');
                    }
                }

                if (typeof graphs.opportunityStagePerTagSale !== 'undefined') {
                    $('#opportunity-stage-per-tag-sale-select').chosen({max_selected_options: 10});
                    $('#lead-report-opportunity-stage-per-tag-sale-tooltip').remove();
                    $('#lead-report-opportunity-stage-per-tag-sale').empty().removeClass('no-graph-data');
                    $('#lead-report-opportunity-stage-per-tag-sale-card-comparison').empty();
                    if (typeof graphs.opportunityStagePerTagSale.axes !== 'undefined') {
                        var axes = [];

                        if (typeof graphs.opportunityStagePerTagSale.dataToCompare !== 'undefined') {
                            if(graphs.opportunityStagePerTagSale.axes.length >= 12) {
                                var i = 0;
                                $.each(graphs.opportunityStagePerTagSale.axes, function(key, param){
                                    i++;
                                    if(i <= 11) {
                                        axes[key] = param;
                                    }
                                });
                            } else {
                                axes = graphs.opportunityStagePerTagSale.axes;
                            }

                            chartData = [
                                axes,
                            ];
                        } else {
                            if(graphs.opportunityStagePerTagSale.axes.length >= 12) {
                                var i = 0;
                                $.each(graphs.opportunityStagePerTagSale.axes, function(key, param){
                                    i++;
                                    if(i <= 11) {
                                        axes[key] = param;
                                    }
                                });
                            } else {
                                axes = graphs.opportunityStagePerTagSale.axes;
                            }

                            chartData = [
                                axes,
                            ];
                        }

                        var opportunitiesGroupFrom = graphs.opportunityStagePerTagSale.opportunitiesGroupFrom,
                            groups = [],
                            onlyData = [],
                            compare = false;

                        groups.push(opportunitiesGroupFrom);

                        $.each(graphs.opportunityStagePerTagSale.data, function(opportunity, opportunityData){
                            chartData.push(opportunityData);
                            var cleanLegendId = '';

                            if (opportunityData[0].match(/\*/) !== null) {
                                cleanLegendId = opportunityData[0].substring(1);
                            } else {
                                cleanLegendId = opportunityData[0];
                            }
                            if (_.indexOf(onlyData, cleanLegendId) == '-1') {
                                onlyData.push(cleanLegendId);
                            }
                        });

                        if (typeof graphs.opportunityStagePerTagSale.dataToCompare !== 'undefined') {
                            groups.push(graphs.opportunityStagePerTagSale.opportunitiesGroupTo);
                            compare = true;
                        }
                        this.createBarChart(chartData, '#lead-report-opportunity-stage-per-tag-sale', 45, {
                            groups:groups,
                            colorPattern: graphs.opportunityStagePerTagSale.colorPattern,
                            title: graphs.opportunityStagePerTagSale.title,
                            customYAxisFormat: {
                                type: 'currency',
                                sign: this.LeadReportsCollection.currencySymbol
                            },
                            axesAdditionalInfo: graphs.opportunityStagePerTagSale.axesAdditionalInfo,
                            tooltip: {filterFromDate: graphs.opportunityStagePerTagSale.filterFromDate, filterToDate: graphs.opportunityStagePerTagSale.filterToDate, compare:compare, 'roughData':graphs.opportunityStagePerTagSale.roughData}
                        });
                        $('#lead-report-opportunity-stage-per-tag-sale').find('svg').closest('div').after('<div id="lead-report-opportunity-stage-per-tag-sale-tooltip"></div>');
                        this.createCustomLegend('#lead-report-opportunity-stage-per-tag-sale-tooltip', '#lead-report-opportunity-stage-per-tag-sale', onlyData,  graphs.opportunityStagePerTagSale.fullColorPattern);
                        if (typeof graphs.opportunityStagePerTagSale.dataToCompare !== 'undefined') {
                            $('#lead-report-opportunity-stage-per-tag-sale').find('svg').before(_.template(CardComparisonTmpl, {'comparisonData': graphs.opportunityStagePerTagSale.comparisonData, 'i18n': i18n}));
                        }

                        if(typeof graphs.opportunityStagePerTagSale.axesAdditionalInfo !== 'undefined') {
                            var options = '',
                                selectedOptions = [];

                            $.each(graphs.opportunityStagePerTagSale.axesAdditionalInfo, function(key, param){
                                if(param != 'x') {
                                    options += '<option value="'+param+'">'+graphs.opportunityStagePerTagSale.axes[key]+'</option>';
                                }
                            });

                            $('#opportunity-stage-per-tag-sale-select').empty().append(options);
                            if(selectedOptions.length) {
                                $('#opportunity-stage-per-tag-sale-select').val(selectedOptions).trigger("chosen:updated");
                            } else {
                                $('#opportunity-stage-per-tag-sale-select').trigger("chosen:updated");
                            }
                        }
                    } else {
                        $('#opportunity-stage-per-tag-sale-select').empty().trigger("chosen:updated");
                        $('#lead-report-opportunity-stage-per-tag-sale').append(_.template(GraphPlaceholderTmpl, {'i18n': i18n})).addClass('no-graph-data');
                    }
                }
            }
            if (tabName === 'forecast') {
                if (typeof graphs.opportunityStageFunnelOriginal !== 'undefined') {
                    $('#lead-report-opportunity-stage-funnel').empty();
                    //$('#lead-report-opportunity-stage-funnel-title').remove();
                    $('#lead-report-opportunity-stage-funnel').removeClass('no-graph-data');
                    $('#lead-report-opportunity-stage-funnel-sales-expectation').remove();
                    if (typeof graphs.opportunityStageFunnelOriginal.data !== 'undefined') {
                        var chartData = [];

                        $.each(graphs.opportunityStageFunnelOriginal.data, function(opportunity, opportunityData){
                            chartData.push([opportunityData.stageName +' ' + opportunity, parseInt(opportunityData.count), opportunityData.color]);
                        });

                        this.createFunnelChart(chartData, '#lead-report-opportunity-stage-funnel', 40, 70, {'axesAdditionalInfo': graphs.opportunityStageFunnelOriginal.axesAdditionalInfo, 'moneyFormat':graphs.opportunityStageFunnelOriginal.moneyFormat, 'allData': graphs.opportunityStageFunnelOriginal.data});
                        //this.createCustomLegend('#lead-report-opportunity-stage-per-source-sale-tooltip', '#lead-report-opportunity-stage-per-source-sale', onlyData,  graphs.opportunityStagePerSourceSale.fullColorPattern);
                        //$('#lead-report-opportunity-stage-funnel').before('<div id="lead-report-opportunity-stage-funnel-title" class="mb10px"><span class="c3-title">'+(_.isUndefined(i18n['Total pipeline by stage'])?'Total pipeline by stage':i18n['Total pipeline by stage'])+'</span></div>');//+graphs.opportunityStageFunnelOriginal.title+' for '+graphs.opportunityStageFunnelOriginal.filterPeriod+
                        if (typeof graphs.opportunityStageFunnelOriginal.salesExpectation !== 'undefined') {
                            var salesExpectation = accounting.formatMoney(Math.round(graphs.opportunityStageFunnelOriginal.salesExpectation), JSON.parse(graphs.opportunityStageFunnelOriginal.moneyFormat));

                            $('#lead-report-opportunity-stage-funnel').after('<div class="lead-report-opportunity-stage-funnel-sales-expectation-box" id="lead-report-opportunity-stage-funnel-sales-expectation"><span class="sales-expectation-label">'+(_.isUndefined(i18n['Sales forecast'])?'Sales forecast':i18n['Sales forecast'])+'</span><span class="sales-expectation-value">'+salesExpectation+'</span></div>');
                        }
                    } else {
                        $('#lead-report-opportunity-stage-funnel').append(_.template(GraphPlaceholderTmpl, {'i18n': i18n}));
                        //$('#lead-report-opportunity-stage-funnel-title').remove();
                        $('#lead-report-opportunity-stage-funnel').addClass('no-graph-data');
                    }
                }

                if (typeof graphs.opportunityStageFunnelCompare !== 'undefined') {
                    $('#lead-report-opportunity-stage-funnel-compare').empty();
                    $('#lead-report-opportunity-stage-funnel-compare').parent('div').removeClass('hidden');
                    $('#lead-report-opportunity-stage-funnel-compare-card-comparison').empty();
                    //$('#lead-report-opportunity-stage-funnel-compare-title').remove();
                    $('#lead-report-opportunity-stage-funnel-compare-sales-expectation').remove();
                    $('#lead-report-opportunity-stage-funnel-compare').removeClass('no-graph-data');
                    if (typeof graphs.opportunityStageFunnelCompare.data !== 'undefined') {
                        var chartData = [];

                        $.each(graphs.opportunityStageFunnelCompare.data, function(opportunity, opportunityData){
                            chartData.push([opportunityData.stageName +' ' + opportunity, parseInt(opportunityData.count), opportunityData.color]);
                        });

                        this.createFunnelChart(chartData, '#lead-report-opportunity-stage-funnel-compare', 40, 70, {'axesAdditionalInfo': graphs.opportunityStageFunnelCompare.axesAdditionalInfo, 'moneyFormat':graphs.opportunityStageFunnelCompare.moneyFormat, 'allData': graphs.opportunityStageFunnelCompare.data });
                        //$('#lead-report-opportunity-stage-funnel-compare').before('<div id="lead-report-opportunity-stage-funnel-compare-title" class="mb10px"><span class="c3-title">'+(_.isUndefined(i18n['Total pipeline by stage'])?'Total pipeline by stage':i18n['Total pipeline by stage'])+'</span></div>');//+graphs.opportunityStageFunnelCompare.title+' for '+graphs.opportunityStageFunnelCompare.filterPeriod+

                    } else {
                        $('#lead-report-opportunity-stage-funnel-compare').append(_.template(GraphPlaceholderTmpl, {'i18n': i18n}));
                        $('#lead-report-opportunity-stage-funnel-compare').addClass('no-graph-data');
                    }
                    if (typeof graphs.opportunityStageFunnelCompare.comparisonData !== 'undefined' && typeof graphs.opportunityStageFunnelCompare.data !== 'undefined') {
                        $('#lead-report-opportunity-stage-funnel').find('svg').before(_.template(CardComparisonTmpl, {'comparisonData': graphs.opportunityStageFunnelCompare.comparisonData, 'i18n': i18n}));
                    }
                    if (typeof graphs.opportunityStageFunnelCompare.salesExpectation !== 'undefined') {
                        var salesExpectation = accounting.formatMoney(Math.round(graphs.opportunityStageFunnelCompare.salesExpectation), JSON.parse(graphs.opportunityStageFunnelCompare.moneyFormat));
                        
                        $('#lead-report-opportunity-stage-funnel-compare').after('<div class="lead-report-opportunity-stage-funnel-sales-expectation-box" id="lead-report-opportunity-stage-funnel-compare-sales-expectation"><span class="sales-expectation-label">'+ (_.isUndefined(i18n['Sales forecast'])?'Sales forecast':i18n['Sales forecast']) +'</span><span class="sales-expectation-value">'+salesExpectation+'</span></div>');
                    }
                } else {
                    $('#lead-report-opportunity-stage-funnel-compare').empty();
                    $('#lead-report-opportunity-stage-funnel-compare').parent('div').addClass('hidden');
                    //$('#lead-report-opportunity-stage-funnel-compare-title').remove();
                }
            }

            if (tabName === 'marketing') {
                //Email open
                $('#sequences-emails-per-open-select').chosen({max_selected_options: 5});
                if (typeof graphs.marketingEmailsCountPerOpen !== 'undefined') {
                    $('#lead-report-marketing-emails-count-per-open').empty();
                    $('#lead-report-marketing-emails-count-per-open-card-comparison').empty();
                    //$('#lead-report-marketing-emails-count-per-open-title').removeClass('hidden');
                    $('#lead-report-marketing-emails-count-per-open').removeClass('no-graph-data');
                    $('#lead-report-marketing-emails-count-per-open-legend').empty();
                    if (typeof graphs.marketingEmailsCountPerOpen.axes !== 'undefined') {
                        var axes = [],
                            data = [],
                            dataToCompare = [];

                        if (typeof graphs.marketingEmailsCountPerOpen.dataToCompare !== 'undefined') {
                            if(graphs.marketingEmailsCountPerOpen.axes.length >= 7) {
                                var i = 0;
                                $.each(graphs.marketingEmailsCountPerOpen.axes, function(key, param){
                                    i++;
                                    if(i <= 6) {
                                        axes[key] = param;
                                        data[key] = graphs.marketingEmailsCountPerOpen.data[key];
                                        dataToCompare[key] = graphs.marketingEmailsCountPerOpen.dataToCompare[key];
                                    }
                                });
                            } else {
                                axes = graphs.marketingEmailsCountPerOpen.axes;
                                data = graphs.marketingEmailsCountPerOpen.data;
                                dataToCompare = graphs.marketingEmailsCountPerOpen.dataToCompare;
                            }

                            chartData = [
                                axes,
                                data,
                                dataToCompare
                            ];
                        } else {
                            if(graphs.marketingEmailsCountPerOpen.axes.length >= 7) {
                                var i = 0;
                                $.each(graphs.marketingEmailsCountPerOpen.axes, function(key, param){
                                    i++;
                                    if(i <= 6) {
                                        axes[key] = param;
                                        data[key] = graphs.marketingEmailsCountPerOpen.data[key];
                                    }
                                });
                            } else {
                                axes = graphs.marketingEmailsCountPerOpen.axes;
                                data = graphs.marketingEmailsCountPerOpen.data;
                            }

                            chartData = [
                                axes,
                                data
                            ];
                        }

                        var onlyData = [];
                        var fullColorPattern = [];

                        if(typeof graphs.marketingEmailsCountPerOpen.data !== 'undefined') {
                            var mainPart = graphs.marketingEmailsCountPerOpen.data[0];
                            onlyData.push(mainPart);
                            if(typeof graphs.marketingEmailsCountPerOpen.colorPattern[0] !== 'undefined') {
                                fullColorPattern['*'+mainPart] = graphs.marketingEmailsCountPerOpen.colorPattern[0];
                            }
                        }

                        if(typeof graphs.marketingEmailsCountPerOpen.dataToCompare !== 'undefined') {
                            var comparePart = graphs.marketingEmailsCountPerOpen.dataToCompare[0];
                            if(comparePart != graphs.marketingEmailsCountPerOpen.data[0]) {
                                onlyData.push(comparePart);
                                if(typeof graphs.marketingEmailsCountPerOpen.colorPattern[1] !== 'undefined') {
                                    fullColorPattern['*'+comparePart] = graphs.marketingEmailsCountPerOpen.colorPattern[1];
                                }
                            } else {
                                fullColorPattern = [];
                            }
                        } else {
                            fullColorPattern = [];
                        }

                        this.createBarChart(chartData, '#lead-report-marketing-emails-count-per-open', 45, {
                            colorPattern: graphs.marketingEmailsCountPerOpen.colorPattern,
                            labels: true,
                            title: graphs.marketingEmailsCountPerOpen.title,
                            customYAxisFormat: {
                                type: 'onlyInteger'
                            },
                            //showLegend : true,
                            axesAdditionalInfo: graphs.marketingEmailsCountPerOpen.axesAdditionalInfo
                        });
                        $('#lead-report-marketing-emails-count-per-open').find('svg').closest('div').after('<div id="lead-report-marketing-emails-count-per-open-legend"></div>');
                        this.createCustomLegend('#lead-report-marketing-emails-count-per-open-legend', '#lead-report-marketing-emails-count-per-open', onlyData,  fullColorPattern);
                        if (typeof graphs.marketingEmailsCountPerOpen.dataToCompare !== 'undefined') {
                            $('#lead-report-marketing-emails-count-per-open').find('svg').before(_.template(CardComparisonTmpl, {'comparisonData': graphs.marketingEmailsCountPerOpen.comparisonData, 'i18n': i18n}));
                        }

                        if(typeof graphs.marketingEmailsCountPerOpen.axesAdditionalInfo !== 'undefined') {
                            var options = '',
                                selectedOptions = [];

                            //var i = 0;
                            $.each(graphs.marketingEmailsCountPerOpen.axesAdditionalInfo, function(key, param){
                                if(param != 'x') {
                                    /*i++;
                                    if(i <= 5) {
                                        selectedOptions.push(param);
                                    }*/
                                    options += '<option value="'+param+'">'+graphs.marketingEmailsCountPerOpen.axes[key]+'</option>';
                                }
                            });

                            $('#sequences-emails-per-open-select').empty().append(options);

                            if(selectedOptions.length) {
                                $('#sequences-emails-per-open-select').val(selectedOptions).trigger("chosen:updated");
                            } else {
                                $('#sequences-emails-per-open-select').trigger("chosen:updated");
                            }
                        }

                    } else {
                        $('#sequences-emails-per-open-select').empty().trigger("chosen:updated");
                        //$('#lead-report-marketing-emails-count-per-open-title').addClass('hidden');
                        $('#lead-report-marketing-emails-count-per-open').append(_.template(GraphPlaceholderTmpl, {'i18n': i18n}));
                        $('#lead-report-marketing-emails-count-per-open').addClass('no-graph-data');
                    }
                }

                //Email send
                $('#sequences-emails-per-send-select').chosen({max_selected_options: 5});
                if (typeof graphs.marketingEmailsCountPerSend !== 'undefined') {
                    $('#lead-report-marketing-emails-count-per-send').empty();
                    $('#lead-report-marketing-emails-count-per-send-card-comparison').empty();
                    //$('#lead-report-marketing-emails-count-per-send-title').removeClass('hidden');
                    $('#lead-report-marketing-emails-count-per-send').removeClass('no-graph-data');
                    $('#lead-report-marketing-emails-count-per-send-legend').empty();
                    if (typeof graphs.marketingEmailsCountPerSend.axes !== 'undefined') {
                        var axes = [],
                            data = [],
                            dataToCompare = [];

                        if (typeof graphs.marketingEmailsCountPerSend.dataToCompare !== 'undefined') {
                            if(graphs.marketingEmailsCountPerSend.axes.length >= 7) {
                                var i = 0;
                                $.each(graphs.marketingEmailsCountPerSend.axes, function(key, param){
                                    i++;
                                    if(i <= 6) {
                                        axes[key] = param;
                                        data[key] = graphs.marketingEmailsCountPerSend.data[key];
                                        dataToCompare[key] = graphs.marketingEmailsCountPerSend.dataToCompare[key];
                                    }
                                });
                            } else {
                                axes = graphs.marketingEmailsCountPerSend.axes;
                                data = graphs.marketingEmailsCountPerSend.data;
                                dataToCompare = graphs.marketingEmailsCountPerSend.dataToCompare;
                            }

                            chartData = [
                                axes,
                                data,
                                dataToCompare
                            ];
                        } else {
                            if(graphs.marketingEmailsCountPerSend.axes.length >= 7) {
                                var i = 0;
                                $.each(graphs.marketingEmailsCountPerSend.axes, function(key, param){
                                    i++;
                                    if(i <= 6) {
                                        axes[key] = param;
                                        data[key] = graphs.marketingEmailsCountPerSend.data[key];
                                    }
                                });
                            } else {
                                axes = graphs.marketingEmailsCountPerSend.axes;
                                data = graphs.marketingEmailsCountPerSend.data;
                            }

                            chartData = [
                                axes,
                                data
                            ];
                        }

                        var onlyData = [];
                        var fullColorPattern = [];

                        if(typeof graphs.marketingEmailsCountPerSend.data !== 'undefined') {
                            var mainPart = graphs.marketingEmailsCountPerSend.data[0];
                            onlyData.push(mainPart);
                            if(typeof graphs.marketingEmailsCountPerSend.colorPattern[0] !== 'undefined') {
                                fullColorPattern['*'+mainPart] = graphs.marketingEmailsCountPerSend.colorPattern[0];
                            }
                        }

                        if(typeof graphs.marketingEmailsCountPerSend.dataToCompare !== 'undefined') {
                            var comparePart = graphs.marketingEmailsCountPerSend.dataToCompare[0];
                            if(comparePart != graphs.marketingEmailsCountPerSend.data[0]) {
                                onlyData.push(comparePart);
                                if(typeof graphs.marketingEmailsCountPerSend.colorPattern[1] !== 'undefined') {
                                    fullColorPattern['*'+comparePart] = graphs.marketingEmailsCountPerSend.colorPattern[1];
                                }
                            } else {
                                fullColorPattern = [];
                            }
                        } else {
                            fullColorPattern = [];
                        }

                        this.createBarChart(chartData, '#lead-report-marketing-emails-count-per-send', 45, {
                            colorPattern: graphs.marketingEmailsCountPerSend.colorPattern,
                            labels: true,
                            title: graphs.marketingEmailsCountPerSend.title,
                            customYAxisFormat: {
                                type: 'onlyInteger'
                            },
                            //showLegend : true,
                            axesAdditionalInfo: graphs.marketingEmailsCountPerSend.axesAdditionalInfo
                        });
                        $('#lead-report-marketing-emails-count-per-send').find('svg').closest('div').after('<div id="lead-report-marketing-emails-count-per-send-legend"></div>');
                        this.createCustomLegend('#lead-report-marketing-emails-count-per-send-legend', '#lead-report-marketing-emails-count-per-send', onlyData,  fullColorPattern);
                        if (typeof graphs.marketingEmailsCountPerSend.dataToCompare !== 'undefined') {
                            $('#lead-report-marketing-emails-count-per-send').find('svg').before(_.template(CardComparisonTmpl, {'comparisonData': graphs.marketingEmailsCountPerSend.comparisonData, 'i18n': i18n}));
                        }

                        if(typeof graphs.marketingEmailsCountPerSend.axesAdditionalInfo !== 'undefined') {
                            var options = '',
                                selectedOptions = [];

                            //var i = 0;
                            $.each(graphs.marketingEmailsCountPerSend.axesAdditionalInfo, function(key, param){
                                if(param != 'x') {
                                    /*i++;
                                    if(i <= 5) {
                                        selectedOptions.push(param);
                                    }*/
                                    options += '<option value="'+param+'">'+graphs.marketingEmailsCountPerSend.axes[key]+'</option>';
                                }
                            });

                            $('#sequences-emails-per-send-select').empty().append(options);

                            if(selectedOptions.length) {
                                $('#sequences-emails-per-send-select').val(selectedOptions).trigger("chosen:updated");
                            } else {
                                $('#sequences-emails-per-send-select').trigger("chosen:updated");
                            }
                        }

                    } else {
                        $('#sequences-emails-per-send-select').empty().trigger("chosen:updated");
                        //$('#lead-report-marketing-emails-count-per-send-title').addClass('hidden');
                        $('#lead-report-marketing-emails-count-per-send').append(_.template(GraphPlaceholderTmpl, {'i18n': i18n}));
                        $('#lead-report-marketing-emails-count-per-send').addClass('no-graph-data');
                    }
                }

                //SMS
                $('#sequences-sms-per-send-select').chosen({max_selected_options: 5});
                if (typeof graphs.marketingSMSCountPerSend !== 'undefined') {
                    $('#lead-report-marketing-sms-count-per-send').empty();
                    $('#lead-report-marketing-sms-count-per-send-card-comparison').empty();
                    //$('#lead-report-marketing-sms-count-per-send-title').removeClass('hidden');
                    $('#lead-report-marketing-sms-count-per-send').removeClass('no-graph-data');
                    $('#lead-report-marketing-sms-count-per-send-legend').empty();
                    if (typeof graphs.marketingSMSCountPerSend.axes !== 'undefined') {
                        var axes = [],
                            data = [],
                            dataToCompare = [];

                        if (typeof graphs.marketingSMSCountPerSend.dataToCompare !== 'undefined') {
                            if(graphs.marketingSMSCountPerSend.axes.length >= 7) {
                                var i = 0;
                                $.each(graphs.marketingSMSCountPerSend.axes, function(key, param){
                                    i++;
                                    if(i <= 6) {
                                        axes[key] = param;
                                        data[key] = graphs.marketingSMSCountPerSend.data[key];
                                        dataToCompare[key] = graphs.marketingSMSCountPerSend.dataToCompare[key];
                                    }
                                });
                            } else {
                                axes = graphs.marketingSMSCountPerSend.axes;
                                data = graphs.marketingSMSCountPerSend.data;
                                dataToCompare = graphs.marketingSMSCountPerSend.dataToCompare;
                            }

                            chartData = [
                                axes,
                                data,
                                dataToCompare
                            ];
                        } else {
                            if(graphs.marketingSMSCountPerSend.axes.length >= 7) {
                                var i = 0;
                                $.each(graphs.marketingSMSCountPerSend.axes, function(key, param){
                                    i++;
                                    if(i <= 6) {
                                        axes[key] = param;
                                        data[key] = graphs.marketingSMSCountPerSend.data[key];
                                    }
                                });
                            } else {
                                axes = graphs.marketingSMSCountPerSend.axes;
                                data = graphs.marketingSMSCountPerSend.data;
                            }

                            chartData = [
                                axes,
                                data
                            ];
                        }

                        var onlyData = [];
                        var fullColorPattern = [];

                        if(typeof graphs.marketingSMSCountPerSend.data !== 'undefined') {
                            var mainPart = graphs.marketingSMSCountPerSend.data[0];
                            onlyData.push(mainPart);
                            if(typeof graphs.marketingSMSCountPerSend.colorPattern[0] !== 'undefined') {
                                fullColorPattern['*'+mainPart] = graphs.marketingSMSCountPerSend.colorPattern[0];
                            }
                        }

                        if(typeof graphs.marketingSMSCountPerSend.dataToCompare !== 'undefined') {
                            var comparePart = graphs.marketingSMSCountPerSend.dataToCompare[0];
                            if(comparePart != graphs.marketingSMSCountPerSend.data[0]) {
                                onlyData.push(comparePart);
                                if(typeof graphs.marketingSMSCountPerSend.colorPattern[1] !== 'undefined') {
                                    fullColorPattern['*'+comparePart] = graphs.marketingSMSCountPerSend.colorPattern[1];
                                }
                            } else {
                                fullColorPattern = [];
                            }
                        } else {
                            fullColorPattern = [];
                        }

                        this.createBarChart(chartData, '#lead-report-marketing-sms-count-per-send', 45, {
                            colorPattern: graphs.marketingSMSCountPerSend.colorPattern,
                            labels: true,
                            title: graphs.marketingSMSCountPerSend.title,
                            customYAxisFormat: {
                                type: 'onlyInteger'
                            },
                            //showLegend : true,
                            axesAdditionalInfo: graphs.marketingSMSCountPerSend.axesAdditionalInfo
                        });
                        $('#lead-report-marketing-sms-count-per-send').find('svg').closest('div').after('<div id="lead-report-marketing-sms-count-per-send-legend"></div>');
                        this.createCustomLegend('#lead-report-marketing-sms-count-per-send-legend', '#lead-report-marketing-sms-count-per-send', onlyData,  fullColorPattern);
                        if (typeof graphs.marketingSMSCountPerSend.dataToCompare !== 'undefined') {
                            $('#lead-report-marketing-sms-count-per-send').find('svg').before(_.template(CardComparisonTmpl, {'comparisonData': graphs.marketingSMSCountPerSend.comparisonData, 'i18n': i18n}));
                        }

                        if(typeof graphs.marketingSMSCountPerSend.axesAdditionalInfo !== 'undefined') {
                            var options = '',
                                selectedOptions = [];

                            //var i = 0;
                            $.each(graphs.marketingSMSCountPerSend.axesAdditionalInfo, function(key, param){
                                if(param != 'x') {
                                    /*i++;
                                    if(i <= 5) {
                                        selectedOptions.push(param);
                                    }*/
                                    options += '<option value="'+param+'">'+graphs.marketingSMSCountPerSend.axes[key]+'</option>';
                                }
                            });

                            $('#sequences-sms-per-send-select').empty().append(options);

                            if(selectedOptions.length) {
                                $('#sequences-sms-per-send-select').val(selectedOptions).trigger("chosen:updated");
                            } else {
                                $('#sequences-sms-per-send-select').trigger("chosen:updated");
                            }
                        }

                    } else {
                        $('#sequences-sms-per-send-select').empty().trigger("chosen:updated");
                        //$('#lead-report-marketing-sms-count-per-send-title').addClass('hidden');
                        $('#lead-report-marketing-sms-count-per-send').append(_.template(GraphPlaceholderTmpl, {'i18n': i18n}));
                        $('#lead-report-marketing-sms-count-per-send').addClass('no-graph-data');
                    }
                }
            }

        },
        showLeadReportsTab: function(e)
        {
            var el = $(e.currentTarget),
                tabBlockContentId = el.data('tab-id'),
                tabContentName = el.data('tab-name'),
                tabBlockContentEl = $('#'+tabBlockContentId),
                self = this,
                tabContentBlock = el.closest('#lead-reports-view-tabs-block').find('.lead-reports-view-tab-content');

            if (el.hasClass('current')) {
                return false;
            }

            tabContentBlock.addClass('hidden');
            $('#lead-reports-view-tabs').find('li').removeClass('current');
            this.hideTab(tabBlockContentEl, el);
            this.render();
        },
        switchCardComparison: function(e){
            var el = $(e.currentTarget),
                comparisonBlock = el.closest('.card-comparison-row').find('ul');

            if (comparisonBlock.hasClass('hidden')) {
                comparisonBlock.removeClass('hidden');
                el.removeClass('closed-comparison');
                el.text((_.isUndefined(i18n['collapse comparison'])?'collapse comparison':i18n['collapse comparison']));
            } else {
                comparisonBlock.addClass('hidden');
                el.addClass('closed-comparison');
                el.text((_.isUndefined(i18n['expand comparison'])?'expand comparison':i18n['expand comparison']));
            }
        },
        hideTab: function (tabBlockContentEl, el){
            tabBlockContentEl.removeClass('hidden');
            el.closest('li').addClass('current');
        },
        assign: function (selector, view) {
            var selectors;
            if (_.isObject(selector)) {
                selectors = selector;
            }
            else {
                selectors = {};
                selectors[selector] = view;
            }
            if (!selectors) return;
            _.each(selectors, function (view, selector) {
                view.setElement(this.$(selector)).render();
            }, this);
        },
        createFunnelChart: function(chartData, chartEl, percentHeight, percentWidth, customParamsData)
        {
            var height = this.processWidth(percentHeight),
                width = this.processWidth(percentWidth);

            if (typeof customParamsData !== 'undefined' && typeof customParamsData.percentFromEl !== 'undefined') {
                height =  this.processWidth(percentHeight, chartEl);
                width  =  this.processWidth(percentWidth, chartEl);
            }

            var options = {
                chart: {
                    width: width,
                    height: height,
                    curve: 'enabled',
                    bottomWidth: 3 / 8,
                    bottomPinch: 0

                },
                block: {
                    minHeight: 10,
                    dynamicHeight: true,
                    highlight: true
                },
                //'{f}'+' '+(_.isUndefined(i18n['opps'])?'opps':i18n['opps']) + '{v}'
                label: {
                    format: function(label, value){
                        var opportunityValue = label.replace(/(.*)((\d){2}%)$/ui, function(a, b, c){
                            return c;
                        });

                        var amount = accounting.formatMoney(Math.round(customParamsData.allData[opportunityValue]['amount']), JSON.parse(customParamsData.moneyFormat));
                        return value +' '+(_.isUndefined(i18n['opps in'])?'opps in':i18n['opps in'])+' '+customParamsData.allData[opportunityValue]['leadsCount'] + ' '+ (_.isUndefined(i18n['accounts'])?'accounts':i18n['accounts']) + ': '+amount+' '+(_.isUndefined(i18n['total at'])?'total at':i18n['total at'])+ ' '+opportunityValue+' '+(_.isUndefined(i18n['stage'])?'stage':i18n['stage']);
                    }
                },
                events: {
                    click: {
                        block: function(d) {
                            console.log(d);
                            console.log(customParamsData);
                            if (typeof customParamsData !== 'undefined' && typeof customParamsData.axesAdditionalInfo !== 'undefined' && customParamsData.axesAdditionalInfo !== '') {
                                console.log(d.index);
                                console.log(customParamsData.axesAdditionalInfo[d.index]);

                                var id = d.index,
                                    leadReportsCompare = 0,
                                    leadReportsFilterStartDate = ($('#lead-reports-filter-start-date').val()) ? $.datepicker.formatDate('yy-mm-dd', $('#lead-reports-filter-start-date').datepicker("getDate")): '',
                                    leadReportsFilterEndDate =  ($('#lead-reports-filter-end-date').val()) ? $.datepicker.formatDate('yy-mm-dd', $('#lead-reports-filter-end-date').datepicker("getDate")): '',
                                    leadReportsCompareFilterStartDate = ($('#lead-reports-filter-compare-start-date').val()) ? $.datepicker.formatDate('yy-mm-dd', $('#lead-reports-filter-compare-start-date').datepicker("getDate")): '',
                                    leadReportsCompareFilterEndDate = ($('#lead-reports-filter-compare-end-date').val()) ? $.datepicker.formatDate('yy-mm-dd', $('#lead-reports-filter-compare-end-date').datepicker("getDate")): '',
                                    leadReportsFilterStartDateLabel = ($('#lead-reports-filter-start-date').val()) ? $.datepicker.formatDate('dd-M-yy', $('#lead-reports-filter-start-date').datepicker("getDate")): '',
                                    leadReportsFilterEndDateLabel =  ($('#lead-reports-filter-end-date').val()) ? $.datepicker.formatDate('dd-M-yy', $('#lead-reports-filter-end-date').datepicker("getDate")): '',
                                    leadReportsCompareFilterStartDateLabel = ($('#lead-reports-filter-compare-start-date').val()) ? $.datepicker.formatDate('dd-M-yy', $('#lead-reports-filter-compare-start-date').datepicker("getDate")): '',
                                    leadReportsCompareFilterEndDateLabel = ($('#lead-reports-filter-compare-end-date').val()) ? $.datepicker.formatDate('dd-M-yy', $('#lead-reports-filter-compare-end-date').datepicker("getDate")): '',
                                    filterFromDate = '',
                                    filterToDate = '',
                                    filterType = $(chartEl).data('lead-grid-filter-data-type'),
                                    filterFromDateNameAlternative = $(chartEl).data('lead-grid-filter-from-date-name'),
                                    filterToDateNameAlternative = $(chartEl).data('lead-grid-filter-to-date-name'),
                                    predefinedFilterParams = $(chartEl).data('lead-grid-filter-predefined-params'),
                                    filterTypeId = customParamsData.axesAdditionalInfo[id],
                                    defaultFilterFromDateNameField = 'created_at_from',
                                    defaultFilterToDateNameField = 'created_at_to',
                                    comparisonFlag = $(chartEl).data('lead-grid-filter-comparison-flag'),

                                    funnelDateRangeTypeSwitch = $(chartEl).data('funnel-date-range-type-switch'),
                                    funnelDateRangeTypeSwitchFromDate = $(chartEl).data('funnel-date-range-type-switch-from-date'),
                                    funnelDateRangeTypeSwitchToDate = $(chartEl).data('funnel-date-range-type-switch-to-date');

                                if (typeof filterFromDateNameAlternative !== 'undefined' && filterFromDateNameAlternative !== '') {
                                    defaultFilterFromDateNameField = filterFromDateNameAlternative;
                                }

                                if (typeof filterToDateNameAlternative !== 'undefined' && filterToDateNameAlternative !== '') {
                                    defaultFilterToDateNameField = filterToDateNameAlternative;
                                }

                                if (typeof funnelDateRangeTypeSwitch !== 'undefined' && funnelDateRangeTypeSwitch !== '' && $('#funnel-date-range-type-custom').val() === 'created') {
                                    if (typeof funnelDateRangeTypeSwitchFromDate !== 'undefined' && funnelDateRangeTypeSwitchFromDate !== '') {
                                        defaultFilterFromDateNameField = funnelDateRangeTypeSwitchFromDate;
                                    }
                                    if (typeof funnelDateRangeTypeSwitchToDate !== 'undefined' && funnelDateRangeTypeSwitchToDate !== '') {
                                        defaultFilterToDateNameField = funnelDateRangeTypeSwitchToDate;
                                    }
                                }

                                if (leadReportsCompareFilterStartDateLabel == '') {
                                    leadReportsCompareFilterStartDateLabel = $.datepicker.formatDate('dd-M-yy', new Date());
                                }

                                if (leadReportsCompareFilterEndDateLabel == '') {
                                    leadReportsCompareFilterEndDateLabel = $.datepicker.formatDate('dd-M-yy', new Date());
                                }

                                if (typeof comparisonFlag !== 'undefined' && comparisonFlag !== '') {
                                    filterFromDate  = leadReportsCompareFilterStartDateLabel;
                                    filterToDate  = leadReportsCompareFilterEndDateLabel;
                                    console.log('comparison');
                                }  else {
                                    filterFromDate  = leadReportsFilterStartDateLabel;
                                    filterToDate  = leadReportsFilterEndDateLabel;
                                    console.log('original');
                                }

                                if (typeof filterType !== 'undefined' && filterType !== '') {
                                    console.log(filterType);
                                    //document.getElementById("lead-filter-reports-form").reset();
                                    var filterFinalUrl = $('#website_url').val() + 'dashboard/leads/?filter=1&'+defaultFilterFromDateNameField+'='+filterFromDate+'&'+defaultFilterToDateNameField+'='+filterToDate+'&'+filterType+'=' + filterTypeId;

                                    if (typeof predefinedFilterParams !== 'undefined' && predefinedFilterParams !== '') {
                                        filterFinalUrl = filterFinalUrl+'&'+predefinedFilterParams;
                                    }

                                    window.open(filterFinalUrl, '_blank');
                                }

                                console.log(filterTypeId);
                                console.log(filterFromDate);
                                console.log(filterToDate);
                                console.log(chartData);
                                console.log(chartEl);
                            }
                        }
                    }
                },
                tooltip : {
                    enabled: false,
                    format: '{l}'+' '+(_.isUndefined(i18n['Quantity'])?'Quantity':i18n['Quantity']) + ' ' + '({f})'
                }
            };

            var chart = new D3Funnel(chartEl);
            chart.draw(chartData, options);
        },
        createPieChart: function(chartData, chartEl, percent, customParamsData)
        {
            var barWidth = this.processWidth(percent),
                colorPattern = [],
                title = '',
                showLegend = false,
                legendPosition = 'bottom';

            if (typeof customParamsData.colorPattern !== 'undefined') {
                colorPattern = customParamsData.colorPattern;
            }

            if (typeof customParamsData.title !== 'undefined') {
                title = customParamsData.title;
            }

            if (typeof customParamsData.showLegend !== 'undefined'){
                showLegend = true;
            }

            if(typeof customParamsData.legendPosition !== 'undefined'){
                legendPosition = customParamsData.legendPosition;
            }

            var chart = c3.generate({
                bindto: chartEl,
                onresize: function(){
                    chart.resize({
                        width:  barWidth,
                        height: barWidth/2
                    });
                },
                size: {
                    width: barWidth,
                    height: barWidth/2
                },
                data: {
                    columns: chartData,
                    type : 'pie',
                    onclick: function (d, i) {
                        if (typeof customParamsData  !== 'undefined' &&  typeof customParamsData.axesAdditionalInfo !== 'undefined') {

                            var id = arguments[0]['id'],
                                axeXValue = arguments[0]['index'],
                                leadReportsCompare = 0,
                                leadReportsFilterStartDate = ($('#lead-reports-filter-start-date').val()) ? $.datepicker.formatDate('yy-mm-dd', $('#lead-reports-filter-start-date').datepicker("getDate")): '',
                                leadReportsFilterEndDate =  ($('#lead-reports-filter-end-date').val()) ? $.datepicker.formatDate('yy-mm-dd', $('#lead-reports-filter-end-date').datepicker("getDate")): '',
                                leadReportsCompareFilterStartDate = ($('#lead-reports-filter-compare-start-date').val()) ? $.datepicker.formatDate('yy-mm-dd', $('#lead-reports-filter-compare-start-date').datepicker("getDate")): '',
                                leadReportsCompareFilterEndDate = ($('#lead-reports-filter-compare-end-date').val()) ? $.datepicker.formatDate('yy-mm-dd', $('#lead-reports-filter-compare-end-date').datepicker("getDate")): '',
                                leadReportsFilterStartDateLabel = ($('#lead-reports-filter-start-date').val()) ? $.datepicker.formatDate('dd-M-yy', $('#lead-reports-filter-start-date').datepicker("getDate")): '',
                                leadReportsFilterEndDateLabel =  ($('#lead-reports-filter-end-date').val()) ? $.datepicker.formatDate('dd-M-yy', $('#lead-reports-filter-end-date').datepicker("getDate")): '',
                                leadReportsCompareFilterStartDateLabel = ($('#lead-reports-filter-compare-start-date').val()) ? $.datepicker.formatDate('dd-M-yy', $('#lead-reports-filter-compare-start-date').datepicker("getDate")): '',
                                leadReportsCompareFilterEndDateLabel = ($('#lead-reports-filter-compare-end-date').val()) ? $.datepicker.formatDate('dd-M-yy', $('#lead-reports-filter-compare-end-date').datepicker("getDate")): '',
                                filterFromDate = '',
                                filterToDate = '',
                                filterType = $(chartEl).data('lead-grid-filter-data-type'),
                                customTabUrl = $(chartEl).data('custom-tab-url'),
                                filterFromDateNameAlternative = $(chartEl).data('lead-grid-filter-from-date-name'),
                                filterToDateNameAlternative = $(chartEl).data('lead-grid-filter-to-date-name'),
                                predefinedFilterParams = $(chartEl).data('lead-grid-filter-predefined-params'),
                                filterTypeId = customParamsData.axesAdditionalInfo[axeXValue],
                                defaultFilterFromDateNameField = 'created_at_from',
                                defaultFilterToDateNameField = 'created_at_to',
                                pieComparison = $(chartEl).data('lead-grid-filter-comparison-flag');

                            if (typeof filterFromDateNameAlternative !== 'undefined' && filterFromDateNameAlternative !== '') {
                                defaultFilterFromDateNameField = filterFromDateNameAlternative;
                            }

                            if (typeof filterToDateNameAlternative !== 'undefined' && filterToDateNameAlternative !== '') {
                                defaultFilterToDateNameField = filterToDateNameAlternative;
                            }

                            console.log(axeXValue);
                            console.log(id);
                            if (typeof pieComparison !== 'undefined' && pieComparison !== '') {
                                filterFromDate  = leadReportsCompareFilterStartDateLabel;
                                filterToDate  = leadReportsCompareFilterEndDateLabel;
                                console.log('comparison');
                            }  else {
                                filterFromDate  = leadReportsFilterStartDateLabel;
                                filterToDate  = leadReportsFilterEndDateLabel;
                                console.log('original');
                            }

                            if (typeof filterType !== 'undefined' && filterType !== '') {
                                //document.getElementById("lead-filter-reports-form").reset();
                               // return false;
                                if (typeof customTabUrl !== 'undefined' && customTabUrl !== '') {
                                    var filterFinalUrl = $('#website_url').val() + customTabUrl+'?filter=1&' + defaultFilterFromDateNameField + '=' + filterFromDate + '&' + defaultFilterToDateNameField + '=' + filterToDate + '&' + filterType + '=' + filterTypeId;
                                } else {
                                    //document.getElementById("lead-filter-reports-form").reset();
                                    var filterFinalUrl = $('#website_url').val() + 'dashboard/leads/?filter=1&' + defaultFilterFromDateNameField + '=' + filterFromDate + '&' + defaultFilterToDateNameField + '=' + filterToDate + '&' + filterType + '=' + filterTypeId;
                                }

                                if (typeof predefinedFilterParams !== 'undefined' && predefinedFilterParams !== '') {
                                    filterFinalUrl = filterFinalUrl+'&'+predefinedFilterParams;
                                }

                                window.open(filterFinalUrl, '_blank');
                            }

                            console.log(filterTypeId);
                            console.log(filterFromDate);
                            console.log(filterToDate);
                            console.log(chartData);
                            console.log(chartEl);

                        }
                    }
                },
                title: {
                    text: title,
                    position: 'top-center'
                },
                color: {
                    pattern: colorPattern
                },
                //pie: {
                //    label: {
                //        format: function (value, ratio, id) {
                //            if (typeof customParamsData.amountComparison !== 'undefined') {
                //                if (id == 'Won') {
                //                    return d3.format('$')(value) +' '+ customParamsData.amountComparison.labelsData.Won;
                //                } else {
                //                    return d3.format('$')(value) +' '+ customParamsData.amountComparison.labelsData.Lost;
                //                }
                //            }
                //        }
                //    }
                //},
                //Alternative tooltip
                tooltip: {
                    format: {
                        title: function(d){return null;},
                        value: function (value, ratio, id) {
                            if (typeof customParamsData.amountComparison !== 'undefined') {
                                if (id.match(/(.*)Won/ui)) {
                                    if (!_.isEmpty(customParamsData.amountComparison.labelsData)) {
                                        return customParamsData.amountComparison.sign + d3.format(",")(value) + ' ' + customParamsData.amountComparison.labelsData.Won;
                                    } else {
                                        return customParamsData.amountComparison.sign + d3.format(",")(value);
                                    }
                                } else {
                                    if (!_.isEmpty(customParamsData.amountComparison.labelsData)) {
                                        return customParamsData.amountComparison.sign + d3.format(",")(value) + ' ' + customParamsData.amountComparison.labelsData.Lost;
                                    } else {
                                        return customParamsData.amountComparison.sign + d3.format(",")(value);
                                    }
                                }
                            }
                        },
                        name: function(){return '';}
                    }
                },
                legend: {
                        show: showLegend,
                        position: legendPosition

                }
            });

            // find all the labels
            d3.selectAll(".c3-chart-arc>text")
                .attr("transform", function(d,i){
                    var r = 90, //<-- adjust this to move the labels
                        a = (d.startAngle + d.endAngle) / 2 - (Math.PI / 2);
                    // compute the new centroid
                    return "translate(" + (Math.cos(a) * r) + "," + (Math.sin(a) * r) + ")";
                });
        },
        createBarChart: function(chartData, chartEl, percent, customParamsData) {
            var barWidth = this.processWidth(percent),
                yAxisTick =  {
                    centered: true,
                    outer: false,
                    multiline: true
                },
                showLegend = false,
                groups = [],
                order = null,
                colorPattern = [],
                labels = [],
                title = '',
                tooltip = true,
                compare = false,
                roughData = {},
                self = this;

            if (typeof customParamsData !== 'undefined') {
                if(typeof customParamsData.showLegend !== 'undefined'){
                    showLegend = true;
                }

                if (typeof customParamsData.customYAxisFormat !== 'undefined') {
                    if (customParamsData.customYAxisFormat.type === 'currency') {
                        yAxisTick.format = function(d) { return customParamsData.customYAxisFormat.sign + d3.format(",")(d); }
                    }

                    if (customParamsData.customYAxisFormat.type === 'onlyInteger') {
                        yAxisTick.format = d3.format("d")
                    }
                }

                if (typeof customParamsData.groups !== 'undefined') {
                    groups = customParamsData.groups;
                }

                if (typeof customParamsData.colorPattern !== 'undefined') {
                    colorPattern = customParamsData.colorPattern;
                }

                if (typeof customParamsData.title !== 'undefined') {
                    title = customParamsData.title;
                }

                if (typeof customParamsData.labels !== 'undefined') {
                    if (typeof customParamsData.labels.type !== 'undefined' && customParamsData.labels.type === 'currency') {
                        labels = {
                            format: function (v, id, i, j) {
                                if (v !== 0) {
                                    return customParamsData.labels.sign + d3.format(",")(v);
                                }
                            }
                        }
                    } else {
                        labels = {
                            format: function (v, id, i, j) {
                                if (v !== 0) {
                                    return v;
                                }
                            }
                        }
                    }
                }

                if (typeof customParamsData.tooltip !== 'undefined') {
                    if (customParamsData.tooltip.compare !== 'undefined' && customParamsData.tooltip.compare === true) {
                        compare = true;
                    }

                    if (customParamsData.tooltip.roughData !== 'undefined') {
                        roughData = customParamsData.tooltip.roughData;
                    }

                    tooltip = {
                        format: {
                            //value: function (value, ratio, id) {
                            //    return value;
                            //},
                            //name: function (value, ratio, id) {
                            //    if (id.match(/\*/) !== null) {
                            //        return id.replace('*', '') + ' ' + customParamsData.tooltip.filterToDate;
                            //    } else {
                            //        return id  + ' ' + customParamsData.tooltip.filterFromDate;
                            //    }
                            //}

                        },
                        contents: function (d, defaultTitleFormat, defaultValueFormat, color) {
                            var $$ = this, config = $$.config,
                                titleFormat = config.tooltip_format_title || defaultTitleFormat,
                                nameFormat = config.tooltip_format_name || function (name) { return name; },
                                valueFormat = config.tooltip_format_value || defaultValueFormat,
                                text, i, title, value, name, bgcolor,
                                dataParams = {},
                                usedParams = {},
                                textItemRow = '';

                            for (i = 0; i < d.length; i++) {
                                if (! (d[i] && (d[i].value || d[i].value === 0))) { continue; }
                                name = nameFormat(d[i].name);
                                value = valueFormat(d[i].value, d[i].ratio, d[i].id, d[i].index);
                                bgcolor = $$.levelColor ? $$.levelColor(d[i].value) : color(d[i].id);
                                title = titleFormat ? titleFormat(d[i].x) : d[i].x;
                                dataParams[name] = {'value' : value, 'bgcolor' : bgcolor, 'line': d[i].id};
                                if (!_.isEmpty(roughData)) {
                                    var roughDataItem = _.find(roughData, function(item) {
                                        if (name.match(/\*/) !== null && compare === true) {
                                            return (item.full_name == title && item.type == 'previous' && item.description == name.substring(1));
                                        } else {
                                            return (item.full_name == title && item.type == 'current' && item.description == name);
                                        }
                                    });

                                    dataParams[name].amount = accounting.formatMoney(Math.round(roughDataItem.amount), JSON.parse(self.LeadReportsCollection.moneyFormat));
                                    dataParams[name].count = roughDataItem.count;
                                } else {
                                    dataParams[name].amount = '';
                                    dataParams[name].count = '';
                                }

                            }

                            for (key in dataParams) {
                                if (!text) {
                                    text = "<table class='" + $$.CLASS.tooltip + "'>" + "<tr><th style='text-align: center'>" + title + "</th><th style='text-align: center'>"+customParamsData.tooltip.filterFromDate+"</th>";
                                    if (compare === true) {
                                        text += "<th style='text-align: center'>"+customParamsData.tooltip.filterToDate+"</th></tr>";
                                    }
                                }


                                if ((typeof usedParams[key] !== 'undefined' || typeof usedParams[key.substring(1)] !== 'undefined') && compare === true) {
                                    continue;
                                }

                                text += "<tr class='" + $$.CLASS.tooltipName + "-" + key + "'>";


                                if (key.match(/\*/) !== null) {
                                    text += "<td class='name'><span style='background-color:" + dataParams[key]['bgcolor'] + "'></span>" + key.substring(1)+"</td>";
                                } else {
                                    text += "<td class='name'><span style='background-color:" + dataParams[key]['bgcolor'] + "'></span>" + key+"</td>";
                                }

                                if (key.match(/\*/) !== null && compare === true) {
                                    if (typeof dataParams[key.substring(1)] !== 'undefined') {
                                        if (typeof dataParams[key.substring(1)]['count'] !== 'undefined' && dataParams[key.substring(1)]['count'] !== '') {
                                            textItemRow = dataParams[key.substring(1)]['value']  + ' ('+dataParams[key.substring(1)]['count']+')';
                                        } else {
                                            textItemRow = dataParams[key.substring(1)]['value'];
                                        }
                                        text += "<td  style='text-align:center;' class='value'>" + textItemRow + "</td>";

                                    } else {
                                        text += "<td  style='text-align:center;' class='value'>" + 0 + "</td>";
                                    }
                                    if (typeof dataParams[key]['count'] !== 'undefined' && dataParams[key]['count'] !== '') {
                                        textItemRow = dataParams[key]['value'] + ' ('+ dataParams[key]['count']+')';
                                    } else {
                                        textItemRow =  dataParams[key]['value'];
                                    }
                                    text += "<td  style='text-align:center;' class='value'>"+ textItemRow + "</td>";
                                } else if (compare === true){
                                    if (typeof dataParams[key]['count'] !== 'undefined' && dataParams[key]['count'] !== '') {
                                        textItemRow = dataParams[key]['value'] + ' ('+ dataParams[key]['count']+ ')';
                                    } else {
                                        textItemRow = dataParams[key]['value'];
                                    }
                                    text += "<td  style='text-align:center;'  class='value'>"+ textItemRow + "</td>";
                                    if (typeof dataParams['*'+key] !== 'undefined') {
                                        if (typeof dataParams['*'+key]['count'] !== 'undefined' && dataParams['*'+key]['count'] !== '') {
                                            textItemRow = dataParams['*'+key]['value'] + ' ('+ dataParams['*'+key]['count']+ ')';
                                        } else {
                                            textItemRow = dataParams['*'+key]['value'];
                                        }
                                        text += "<td  style='text-align:center;' class='value'>" + textItemRow + "</td>";
                                    } else {
                                        text += "<td  style='text-align:center;' class='value'>" + 0 + "</td>";
                                    }
                                } else {
                                    if (typeof dataParams[key]['count'] !== 'undefined' && dataParams[key]['count'] !== '') {
                                        textItemRow =  dataParams[key]['value'] + ' ('+dataParams[key]['count']+')';
                                    } else {
                                        textItemRow = dataParams[key]['value'];
                                    }
                                    text += "<td  style='text-align:center;' class='value'>" + textItemRow + "</td>";
                                }


                                text += "</tr>";

                                usedParams[key] = true;
                            }

                            return text + "</table>";
                        }
                    }
                }
            }

            var chart = c3.generate({
                bindto: chartEl,
                size: {
                    width: barWidth,
                    height: barWidth/2.5
                },
                onresize: function(){
                    if (typeof window.device !== 'undefined') {
                        if (window.device.tablet() || window.device.mobile()) {
                            var koef = 1.1;
                            if (window.device.mobile()) {
                                if (!window.device.landscape()) {
                                    koef = 1.6;
                                }
                            }
                            chart.resize({
                                width: self.processWidth()/koef,
                                height: self.processWidth() / 2.5
                            });
                        }
                    } else {
                        chart.resize({
                            width: barWidth,
                            height: barWidth / 2.5
                        });
                    }
                },
                data: {
                    x: 'x',
                    columns:chartData,
                    type: 'bar',
                    groups:groups,
                    order: order,
                    labels: labels,
                    onclick: function () {
                        if (typeof customParamsData  !== 'undefined' &&  typeof customParamsData.axesAdditionalInfo !== 'undefined') {


                            var id = arguments[0]['id'],
                                axeXValue = arguments[0]['x'],
                                leadReportsCompare = 0,
                                leadReportsFilterStartDate = ($('#lead-reports-filter-start-date').val()) ? $.datepicker.formatDate('yy-mm-dd', $('#lead-reports-filter-start-date').datepicker("getDate")): '',
                                leadReportsFilterEndDate =  ($('#lead-reports-filter-end-date').val()) ? $.datepicker.formatDate('yy-mm-dd', $('#lead-reports-filter-end-date').datepicker("getDate")): '',
                                leadReportsCompareFilterStartDate = ($('#lead-reports-filter-compare-start-date').val()) ? $.datepicker.formatDate('yy-mm-dd', $('#lead-reports-filter-compare-start-date').datepicker("getDate")): '',
                                leadReportsCompareFilterEndDate = ($('#lead-reports-filter-compare-end-date').val()) ? $.datepicker.formatDate('yy-mm-dd', $('#lead-reports-filter-compare-end-date').datepicker("getDate")): '',
                                leadReportsFilterStartDateLabel = ($('#lead-reports-filter-start-date').val()) ? $.datepicker.formatDate('dd-M-yy', $('#lead-reports-filter-start-date').datepicker("getDate")): '',
                                leadReportsFilterEndDateLabel =  ($('#lead-reports-filter-end-date').val()) ? $.datepicker.formatDate('dd-M-yy', $('#lead-reports-filter-end-date').datepicker("getDate")): '',
                                leadReportsCompareFilterStartDateLabel = ($('#lead-reports-filter-compare-start-date').val()) ? $.datepicker.formatDate('dd-M-yy', $('#lead-reports-filter-compare-start-date').datepicker("getDate")): '',
                                leadReportsCompareFilterEndDateLabel = ($('#lead-reports-filter-compare-end-date').val()) ? $.datepicker.formatDate('dd-M-yy', $('#lead-reports-filter-compare-end-date').datepicker("getDate")): '',
                                filterFromDate = '',
                                filterToDate = '',
                                filterType = $(chartEl).data('lead-grid-filter-data-type'),
                                customTabUrl = $(chartEl).data('custom-tab-url'),
                                filterFromDateNameAlternative = $(chartEl).data('lead-grid-filter-from-date-name'),
                                filterToDateNameAlternative = $(chartEl).data('lead-grid-filter-to-date-name'),
                                predefinedFilterParams = $(chartEl).data('lead-grid-filter-predefined-params'),
                                filterTypeId = customParamsData.axesAdditionalInfo[axeXValue+1],
                                defaultFilterFromDateNameField = 'created_at_from',
                                defaultFilterToDateNameField = 'created_at_to',
                                additionalFilter = '',
                                rangeOptions = $('.rangeOptions').val(),
                                filterFromToDateDisabled = $(chartEl).data('lead-grid-filter-from-to-date-disabled');

                                if(typeof customParamsData.additionalFilterPreset !== 'undefined') {
                                    additionalFilter = customParamsData.additionalFilterPreset[axeXValue+1];
                                }

                            if ($('#lead-reports-compare').is(':checked')) {
                                leadReportsCompare = 1;
                            }

                            if (typeof filterFromDateNameAlternative !== 'undefined' && filterFromDateNameAlternative !== '') {
                                defaultFilterFromDateNameField = filterFromDateNameAlternative;
                            }

                            if (typeof filterToDateNameAlternative !== 'undefined' && filterToDateNameAlternative !== '') {
                                defaultFilterToDateNameField = filterToDateNameAlternative;
                            }

                            console.log(axeXValue);
                            console.log(id);
                            if (leadReportsCompareFilterStartDateLabel == '') {
                                leadReportsCompareFilterStartDateLabel = $.datepicker.formatDate('dd-M-yy', new Date());
                            }

                            if (leadReportsCompareFilterEndDateLabel == '') {
                                leadReportsCompareFilterEndDateLabel = $.datepicker.formatDate('dd-M-yy', new Date());
                            }

                            var isComparisonRow = 0;
                            if (id.match(/\*/) !== null && leadReportsCompare  === 1) {
                                filterFromDate  = leadReportsCompareFilterStartDateLabel;
                                filterToDate  = leadReportsCompareFilterEndDateLabel;
                                console.log('comparison');
                                isComparisonRow = 1;
                            } else if(leadReportsCompare  === 1) {
                                var startEndDateLabel = leadReportsCompareFilterStartDateLabel + ' to '+ leadReportsCompareFilterEndDateLabel;
                                console.log(startEndDateLabel);
                                console.log(id);
                                if (startEndDateLabel == id) {
                                    filterFromDate  = leadReportsCompareFilterStartDateLabel;
                                    filterToDate  = leadReportsCompareFilterEndDateLabel;
                                    console.log('comparison');
                                    isComparisonRow = 1;
                                } else {
                                    filterFromDate  = leadReportsFilterStartDateLabel;
                                    filterToDate  = leadReportsFilterEndDateLabel;
                                    console.log('original');
                                }
                            }  else {
                                filterFromDate  = leadReportsFilterStartDateLabel;
                                filterToDate  = leadReportsFilterEndDateLabel;
                                console.log('original');
                            }

                            if (typeof filterType !== 'undefined' && filterType !== '') {
                                var additionalFilterParams = '';

                                if(typeof additionalFilter !== 'undefined') {
                                    additionalFilterParams = additionalFilter;
                                }

                                console.log(filterType);
                                //document.getElementById("lead-filter-reports-form").reset();

                                var filterFinalUrl = $('#website_url').val() + 'dashboard/leads/?filter=1&'+defaultFilterFromDateNameField+'='+filterFromDate+'&'+defaultFilterToDateNameField+'='+filterToDate+'&'+filterType+'=' + filterTypeId + '&range_options=' + rangeOptions + additionalFilterParams;

                                if(typeof filterFromToDateDisabled !== 'undefined' && filterFromToDateDisabled == '1') {
                                    var nextSequenceFrom = 'next_sequence_from='+filterFromDate;
                                    var nextSequenceTo = 'next_sequence_to='+filterToDate;

                                    filterFinalUrl = $('#website_url').val() + 'dashboard/leads/?filter=1&'+filterType+'=' + filterTypeId + '&' + nextSequenceFrom + '&' + nextSequenceTo;
                                }

                                if (typeof predefinedFilterParams !== 'undefined' && predefinedFilterParams !== '') {
                                    filterFinalUrl = filterFinalUrl+'&'+predefinedFilterParams;
                                }

                                console.log(filterFinalUrl);
                                window.open(filterFinalUrl, '_blank');
                            }

                            console.log(filterTypeId);
                            console.log(filterFromDate);
                            console.log(filterToDate);
                            console.log(chartData);
                            console.log(chartEl);

                        }
                    }
                },
                color: {
                    pattern: colorPattern
                },
                axis: {
                    rotated: true,
                    x: {
                        type: 'category',
                        show: true,
                        tick: {
                            centered: true,
                            multiline:true,
                            width: 150

                        }
                    },
                    y:{
                        show: true,
                        tick: yAxisTick
                    }
                },
                grid: {
                    x: {
                        show: true
                    }
                },
                title: {
                    text: title,
                    position: 'top-center'
                },
                legend: {
                    show: showLegend,
                    position: 'bottom'
                },
                tooltip: tooltip

            });

            $(chartEl).data('c3-chart', chart);
        },
        processWidth: function(percent, element){
            if (typeof window.device !== 'undefined') {
                if (window.device.tablet() || window.device.mobile()) {
                    if (window.device.landscape()) {
                        if (window.device.mobile()) {
                            percent = 90;
                        } else {
                            percent = 45;
                        }
                    } else {
                        percent = 90;
                    }

                }
            }
            if (typeof element !== 'undefined') {
                return (($(element).width() * percent) / 100);
            } else {
                return (($(document).width() * percent) / 100);
            }
        },
        processHeight: function(percent, element){
            if (typeof window.device !== 'undefined') {
                if (window.device.tablet() || window.device.mobile()) {
                    percent = 90;
                }
            }
            if (typeof element !== 'undefined') {
                return (($(element).height() * percent) / 100);
            } else {
                return (($(document).height() * percent) / 100);
            }
        },
        switchFunnelGraphType: function(e)
        {
            e.preventDefault();
            var el = $(e.currentTarget),
                type = el.data('filter-log-type');

            $('.funnel-date-range-type-switcher').removeClass('current');
            $('#funnel-date-range-type-custom').val(type);
            el.addClass('current');

            window.appLeadRepostsRouter.LeadReportsFilterView.applyFilter();


        },
        selectOpenSequenceEmailsName: function (e)
        {
            e.preventDefault();
            var el = $(e.currentTarget),
                self = this,
                selectedSequence = el.val();

            $.ajax({
                'url': $('#website_url').val()+'plugin/leads/run/changeMarketingEmailsAndSendSmsSequence/',
                'type':'POST',
                'dataType':'json',
                'data': {
                    'secureToken'                       : $('#lead-reports-grid-token').val(),
                    'sequenceType'                      : 'email',
                    'sequenceAction'                    : 'open',
                    'selectedSequence'                  : selectedSequence,
                    'leadReportsCompare'                : self.LeadReportsCollection.server_api.leadReportsCompare,
                    'leadReportsFilterStartDate'        : self.LeadReportsCollection.server_api.leadReportsFilterStartDate,
                    'leadReportsFilterEndDate'          : self.LeadReportsCollection.server_api.leadReportsFilterEndDate,
                    'leadReportsCompareFilterStartDate' : self.LeadReportsCollection.server_api.leadReportsCompareFilterStartDate,
                    'leadReportsCompareFilterEndDate'   : self.LeadReportsCollection.server_api.leadReportsCompareFilterEndDate
                }
            }).done(function(response){
                if(response.error == 1) {
                    $('#sequences-emails-per-open-select').val(0);
                } else {
                    $('#lead-report-marketing-emails-count-per-open').empty();
                    $('#lead-report-marketing-emails-count-per-open-card-comparison').empty();
                    $('#lead-report-marketing-emails-count-per-open').removeClass('no-graph-data');
                    if (typeof response.responseText.sequencesDataReportResult.axes !== 'undefined') {
                        var axes = [],
                            data = [],
                            dataToCompare = [];

                        if (typeof response.responseText.sequencesDataReportResult.dataToCompare !== 'undefined') {
                            if(response.responseText.sequencesDataReportResult.axes.length >= 7) {
                                var i = 0;
                                $.each(response.responseText.sequencesDataReportResult.axes, function(key, param){
                                    i++;
                                    if(i <= 6) {
                                        axes[key] = param;
                                        data[key] = response.responseText.sequencesDataReportResult.data[key];
                                        dataToCompare[key] = response.responseText.sequencesDataReportResult.dataToCompare[key];
                                    }
                                });
                            } else {
                                axes = response.responseText.sequencesDataReportResult.axes;
                                data = response.responseText.sequencesDataReportResult.data;
                                dataToCompare = response.responseText.sequencesDataReportResult.dataToCompare;
                            }

                            chartData = [
                                axes,
                                data,
                                dataToCompare
                            ];
                        } else {
                            if(response.responseText.sequencesDataReportResult.axes.length >= 7) {
                                var i = 0;
                                $.each(response.responseText.sequencesDataReportResult.axes, function(key, param){
                                    i++;
                                    if(i <= 6) {
                                        axes[key] = param;
                                        data[key] = response.responseText.sequencesDataReportResult.data[key];
                                    }
                                });
                            } else {
                                axes = response.responseText.sequencesDataReportResult.axes;
                                data = response.responseText.sequencesDataReportResult.data;
                            }

                            chartData = [
                                axes,
                                data
                            ];
                        }
                        self.createBarChart(chartData, '#lead-report-marketing-emails-count-per-open', 45, {
                            colorPattern: response.responseText.sequencesDataReportResult.colorPattern,
                            labels: true,
                            title: response.responseText.sequencesDataReportResult.title,
                            customYAxisFormat: {
                                type: 'onlyInteger'
                            },
                            showLegend : true,
                            axesAdditionalInfo: response.responseText.sequencesDataReportResult.axesAdditionalInfo
                        });
                        if (typeof response.responseText.sequencesDataReportResult.dataToCompare !== 'undefined') {
                            $('#lead-report-marketing-emails-count-per-open').find('svg').before(_.template(CardComparisonTmpl, {'comparisonData': response.responseText.sequencesDataReportResult.comparisonData, 'i18n': i18n}));
                        }

                        $('#sequences-emails-per-open-select').val(selectedSequence).trigger("chosen:updated");
                    } else {
                        $('#sequences-emails-per-open-select').empty();
                        $('#lead-report-marketing-emails-count-per-open').append(_.template(GraphPlaceholderTmpl, {'i18n': i18n}));
                        $('#lead-report-marketing-emails-count-per-open').addClass('no-graph-data');
                    }
                }
            });
        },
        selectLeadsSaleTagName: function (e)
        {
            e.preventDefault();
            var el = $(e.currentTarget),
                self = this,
                selectedTag = el.val();

            $.ajax({
                'url': $('#website_url').val()+'plugin/leads/run/changeLeadsSalesTags/',
                'type':'POST',
                'dataType':'json',
                'data': {
                    'secureToken'                       : $('#lead-reports-grid-token').val(),
                    'selectedTag'                       : selectedTag,
                    'leadReportsCompare'                : self.LeadReportsCollection.server_api.leadReportsCompare,
                    'leadReportsFilterStartDate'        : self.LeadReportsCollection.server_api.leadReportsFilterStartDate,
                    'leadReportsFilterEndDate'          : self.LeadReportsCollection.server_api.leadReportsFilterEndDate,
                    'leadReportsCompareFilterStartDate' : self.LeadReportsCollection.server_api.leadReportsCompareFilterStartDate,
                    'leadReportsCompareFilterEndDate'   : self.LeadReportsCollection.server_api.leadReportsCompareFilterEndDate
                }
            }).done(function(response){
                if(response.error == 1) {
                    $('#opportunity-stage-per-tag-sale-select').val(0);
                } else {
                    $('#lead-report-opportunity-stage-per-tag-sale-tooltip').remove();
                    $('#lead-report-opportunity-stage-per-tag-sale').empty().removeClass('no-graph-data');
                    $('#lead-report-opportunity-stage-per-tag-sale-card-comparison').empty();

                    if (typeof response.responseText.opportunityStagePerTagSaleResult.axes !== 'undefined') {
                        var axes = [],
                            chartData = [];

                        if (typeof response.responseText.opportunityStagePerTagSaleResult.dataToCompare !== 'undefined') {
                            if(response.responseText.opportunityStagePerTagSaleResult.axes.length >= 12) {
                                var i = 0;
                                $.each(response.responseText.opportunityStagePerTagSaleResult.axes, function(key, param){
                                    i++;
                                    if(i <= 11) {
                                        axes[key] = param;
                                    }
                                });
                            } else {
                                axes = response.responseText.opportunityStagePerTagSaleResult.axes;
                            }

                            chartData = [
                                axes,
                            ];
                        } else {
                            if(response.responseText.opportunityStagePerTagSaleResult.axes.length >= 12) {
                                var i = 0;
                                $.each(response.responseText.opportunityStagePerTagSaleResult.axes, function(key, param){
                                    i++;
                                    if(i <= 11) {
                                        axes[key] = param;
                                    }
                                });
                            } else {
                                axes = response.responseText.opportunityStagePerTagSaleResult.axes;
                            }

                            chartData = [
                                axes,
                            ];
                        }

                        var opportunitiesGroupFrom = response.responseText.opportunityStagePerTagSaleResult.opportunitiesGroupFrom,
                            groups = [],
                            onlyData = [],
                            compare = false;

                        groups.push(opportunitiesGroupFrom);

                        $.each(response.responseText.opportunityStagePerTagSaleResult.data, function(opportunity, opportunityData){
                            chartData.push(opportunityData);
                            var cleanLegendId = '';

                            if (opportunityData[0].match(/\*/) !== null) {
                                cleanLegendId = opportunityData[0].substring(1);
                            } else {
                                cleanLegendId = opportunityData[0];
                            }
                            if (_.indexOf(onlyData, cleanLegendId) == '-1') {
                                onlyData.push(cleanLegendId);
                            }
                        });


                        if (typeof response.responseText.opportunityStagePerTagSaleResult.dataToCompare !== 'undefined') {
                            groups.push(response.responseText.opportunityStagePerTagSaleResult.opportunitiesGroupTo);
                            compare = true;
                        }

                        self.createBarChart(chartData, '#lead-report-opportunity-stage-per-tag-sale', 45, {
                            groups:groups,
                            colorPattern: response.responseText.opportunityStagePerTagSaleResult.colorPattern,
                            title: response.responseText.opportunityStagePerTagSaleResult.title,
                            customYAxisFormat: {
                                type: 'currency',
                                sign: self.LeadReportsCollection.currencySymbol
                            },
                            axesAdditionalInfo: response.responseText.opportunityStagePerTagSaleResult.axesAdditionalInfo,
                            tooltip: {filterFromDate: response.responseText.opportunityStagePerTagSaleResult.filterFromDate, filterToDate: response.responseText.opportunityStagePerTagSaleResult.filterToDate, compare:compare, 'roughData':response.responseText.opportunityStagePerTagSaleResult.roughData}
                        });
                        $('#lead-report-opportunity-stage-per-tag-sale').find('svg').closest('div').after('<div id="lead-report-opportunity-stage-per-tag-sale-tooltip"></div>');
                        self.createCustomLegend('#lead-report-opportunity-stage-per-tag-sale-tooltip', '#lead-report-opportunity-stage-per-tag-sale', onlyData,  response.responseText.opportunityStagePerTagSaleResult.fullColorPattern);
                        if (typeof response.responseText.opportunityStagePerTagSaleResult.dataToCompare !== 'undefined') {
                            $('#lead-report-opportunity-stage-per-tag-sale').find('svg').before(_.template(CardComparisonTmpl, {'comparisonData': response.responseText.opportunityStagePerTagSaleResult.comparisonData, 'i18n': i18n}));
                        }
                        $('#opportunity-stage-per-tag-sale-select').val(selectedTag).trigger("chosen:updated");
                    } else {
                        $('#opportunity-stage-per-tag-sale-select').empty();
                        $('#lead-report-opportunity-stage-per-tag-sale').append(_.template(GraphPlaceholderTmpl, {'i18n': i18n}));
                        $('#lead-report-opportunity-stage-per-tag-sale').addClass('no-graph-data');
                    }
                }
            });
        },
        selectSendSequenceEmailsName: function (e)
        {
            e.preventDefault();
            var el = $(e.currentTarget),
                self = this,
                selectedSequence = el.val();

            $.ajax({
                'url': $('#website_url').val()+'plugin/leads/run/changeMarketingEmailsAndSendSmsSequence/',
                'type':'POST',
                'dataType':'json',
                'data': {
                    'secureToken'                       : $('#lead-reports-grid-token').val(),
                    'sequenceType'                      : 'email',
                    'sequenceAction'                    : 'send',
                    'selectedSequence'                  : selectedSequence,
                    'leadReportsCompare'                : self.LeadReportsCollection.server_api.leadReportsCompare,
                    'leadReportsFilterStartDate'        : self.LeadReportsCollection.server_api.leadReportsFilterStartDate,
                    'leadReportsFilterEndDate'          : self.LeadReportsCollection.server_api.leadReportsFilterEndDate,
                    'leadReportsCompareFilterStartDate' : self.LeadReportsCollection.server_api.leadReportsCompareFilterStartDate,
                    'leadReportsCompareFilterEndDate'   : self.LeadReportsCollection.server_api.leadReportsCompareFilterEndDate
                }
            }).done(function(response){
                if(response.error == 1) {
                    $('#sequences-emails-per-send-select').val(0);
                } else {
                    $('#lead-report-marketing-emails-count-per-send').empty();
                    $('#lead-report-marketing-emails-count-per-send-card-comparison').empty();
                    $('#lead-report-marketing-emails-count-per-send').removeClass('no-graph-data');
                    if (typeof response.responseText.sequencesDataReportResult.axes !== 'undefined') {
                        var axes = [],
                            data = [],
                            dataToCompare = [];

                        if (typeof response.responseText.sequencesDataReportResult.dataToCompare !== 'undefined') {
                            if(response.responseText.sequencesDataReportResult.axes.length >= 7) {
                                var i = 0;
                                $.each(response.responseText.sequencesDataReportResult.axes, function(key, param){
                                    i++;
                                    if(i <= 6) {
                                        axes[key] = param;
                                        data[key] = response.responseText.sequencesDataReportResult.data[key];
                                        dataToCompare[key] = response.responseText.sequencesDataReportResult.dataToCompare[key];
                                    }
                                });
                            } else {
                                axes = response.responseText.sequencesDataReportResult.axes;
                                data = response.responseText.sequencesDataReportResult.data;
                                dataToCompare = response.responseText.sequencesDataReportResult.dataToCompare;
                            }

                            chartData = [
                                axes,
                                data,
                                dataToCompare
                            ];
                        } else {
                            if(response.responseText.sequencesDataReportResult.axes.length >= 7) {
                                var i = 0;
                                $.each(response.responseText.sequencesDataReportResult.axes, function(key, param){
                                    i++;
                                    if(i <= 6) {
                                        axes[key] = param;
                                        data[key] = response.responseText.sequencesDataReportResult.data[key];
                                    }
                                });
                            } else {
                                axes = response.responseText.sequencesDataReportResult.axes;
                                data = response.responseText.sequencesDataReportResult.data;
                            }

                            chartData = [
                                axes,
                                data
                            ];
                        }
                        self.createBarChart(chartData, '#lead-report-marketing-emails-count-per-send', 45, {
                            colorPattern: response.responseText.sequencesDataReportResult.colorPattern,
                            labels: true,
                            title: response.responseText.sequencesDataReportResult.title,
                            customYAxisFormat: {
                                type: 'onlyInteger'
                            },
                            showLegend : true,
                            axesAdditionalInfo: response.responseText.sequencesDataReportResult.axesAdditionalInfo
                        });
                        if (typeof response.responseText.sequencesDataReportResult.dataToCompare !== 'undefined') {
                            $('#lead-report-marketing-emails-count-per-send').find('svg').before(_.template(CardComparisonTmpl, {'comparisonData': response.responseText.sequencesDataReportResult.comparisonData, 'i18n': i18n}));
                        }

                        $('#sequences-emails-per-send-select').val(selectedSequence).trigger("chosen:updated");
                    } else {
                        $('#sequences-emails-per-send-select').empty();
                        $('#lead-report-marketing-emails-count-per-send').append(_.template(GraphPlaceholderTmpl, {'i18n': i18n}));
                        $('#lead-report-marketing-emails-count-per-send').addClass('no-graph-data');
                    }
                }
            });
        },
        selectSendSequenceSmsName: function (e)
        {
            e.preventDefault();
            var el = $(e.currentTarget),
                self = this,
                selectedSequence = el.val();

            $.ajax({
                'url': $('#website_url').val()+'plugin/leads/run/changeMarketingEmailsAndSendSmsSequence/',
                'type':'POST',
                'dataType':'json',
                'data': {
                    'secureToken'                       : $('#lead-reports-grid-token').val(),
                    'sequenceType'                      : 'sms',
                    'selectedSequence'                  : selectedSequence,
                    'leadReportsCompare'                : self.LeadReportsCollection.server_api.leadReportsCompare,
                    'leadReportsFilterStartDate'        : self.LeadReportsCollection.server_api.leadReportsFilterStartDate,
                    'leadReportsFilterEndDate'          : self.LeadReportsCollection.server_api.leadReportsFilterEndDate,
                    'leadReportsCompareFilterStartDate' : self.LeadReportsCollection.server_api.leadReportsCompareFilterStartDate,
                    'leadReportsCompareFilterEndDate'   : self.LeadReportsCollection.server_api.leadReportsCompareFilterEndDate
                }
            }).done(function(response){
                if(response.error == 1) {
                    $('#sequences-sms-per-send-select').val(0);
                } else {
                    $('#lead-report-marketing-sms-count-per-send').empty();
                    $('#lead-report-marketing-sms-count-per-send-card-comparison').empty();
                    $('#lead-report-marketing-sms-count-per-send').removeClass('no-graph-data');
                    if (typeof response.responseText.sequencesDataReportResult.axes !== 'undefined') {
                        var axes = [],
                            data = [],
                            dataToCompare = [];

                        if (typeof response.responseText.sequencesDataReportResult.dataToCompare !== 'undefined') {
                            if(response.responseText.sequencesDataReportResult.axes.length >= 7) {
                                var i = 0;
                                $.each(response.responseText.sequencesDataReportResult.axes, function(key, param){
                                    i++;
                                    if(i <= 6) {
                                        axes[key] = param;
                                        data[key] = response.responseText.sequencesDataReportResult.data[key];
                                        dataToCompare[key] = response.responseText.sequencesDataReportResult.dataToCompare[key];
                                    }
                                });
                            } else {
                                axes = response.responseText.sequencesDataReportResult.axes;
                                data = response.responseText.sequencesDataReportResult.data;
                                dataToCompare = response.responseText.sequencesDataReportResult.dataToCompare;
                            }

                            chartData = [
                                axes,
                                data,
                                dataToCompare
                            ];
                        } else {
                            if(response.responseText.sequencesDataReportResult.axes.length >= 7) {
                                var i = 0;
                                $.each(response.responseText.sequencesDataReportResult.axes, function(key, param){
                                    i++;
                                    if(i <= 6) {
                                        axes[key] = param;
                                        data[key] = response.responseText.sequencesDataReportResult.data[key];
                                    }
                                });
                            } else {
                                axes = response.responseText.sequencesDataReportResult.axes;
                                data = response.responseText.sequencesDataReportResult.data;
                            }

                            chartData = [
                                axes,
                                data
                            ];
                        }
                        self.createBarChart(chartData, '#lead-report-marketing-sms-count-per-send', 45, {
                            colorPattern: response.responseText.sequencesDataReportResult.colorPattern,
                            labels: true,
                            title: response.responseText.sequencesDataReportResult.title,
                            customYAxisFormat: {
                                type: 'onlyInteger'
                            },
                            showLegend : true,
                            axesAdditionalInfo: response.responseText.sequencesDataReportResult.axesAdditionalInfo
                        });
                        if (typeof response.responseText.sequencesDataReportResult.dataToCompare !== 'undefined') {
                            $('#lead-report-marketing-sms-count-per-send').find('svg').before(_.template(CardComparisonTmpl, {'comparisonData': response.responseText.sequencesDataReportResult.comparisonData, 'i18n': i18n}));
                        }

                        $('#sequences-sms-per-sendn-select').val(selectedSequence).trigger("chosen:updated");
                    } else {
                        $('#sequences-sms-per-send-select').empty();
                        $('#lead-report-marketing-sms-count-per-send').append(_.template(GraphPlaceholderTmpl, {'i18n': i18n}));
                        $('#lead-report-marketing-sms-count-per-send').addClass('no-graph-data');
                    }
                }
            });
        },
        createCustomLegend: function(legend, chartEl, xValues, fullColorPattern){
            $('.chart-legend', legend).remove();
            d3.select(legend).append('ul').attr('class', 'chart-legend pl0px')
                .selectAll('li')
                .data(xValues)
                .enter()
                .append('li')
                .style('white-space', 'nowrap')
                .attr('data-id', function (id) { return id; })
                .on('mouseover', function (id) {
                    if(!$(this).hasClass('clicked')) {
                        $(chartEl).data('c3-chart').focus(id);
                        $('li:not([data-id="' + id + '"])', legend).css('opacity', '0.3');
                    }
                })
                .on('mouseout', function (id) {
                    $(chartEl).data('c3-chart').revert();
                    $('li:not(".clicked")', legend).css('opacity', '1');
                })
                .on('click', function (id) {
                    if (id.match(/\*/) !== null) {
                        $(chartEl).data('c3-chart').toggle(id);
                        $(chartEl).data('c3-chart').toggle(id.substring(1));
                    } else {
                        $(chartEl).data('c3-chart').toggle(id);
                        $(chartEl).data('c3-chart').toggle('*'+id);
                    }

                    $(chartEl).data('c3-chart').revert();
                    if(!$(this).hasClass('clicked')) {
                        $(this).addClass('clicked');
                        $(this).css('opacity', '0.3');
                        $('li:not(".clicked")', legend).css('opacity', '1');
                    }
                    else{
                        $('li:not(".clicked")', legend).css('opacity', '0.3');
                        $(this).removeClass('clicked');
                        $(this).css('opacity', '1');
                        if (id.match(/\*/) !== null) {
                            $(chartEl).data('c3-chart').focus(id);
                            $(chartEl).data('c3-chart').focus(id.substring(1))
                        } else {
                            $(chartEl).data('c3-chart').focus(id);
                            $(chartEl).data('c3-chart').focus('*'+id)
                        }
                    }
                })
                .append('span')
                .each(function (id) {

                    var colorId = id;
                    if (!_.has(fullColorPattern, id)) {
                        colorId = '*'+id;
                    }

                    var color = fullColorPattern[colorId];

                  //  d3.select(this).style('background-color', $(chartEl).data('c3-chart').color(id));
                    d3.select(this).style('background-color', color);
                    $(this).after('<i> '+ id + '</i>');
                });
        },
        createBarChartCampaign: function(chartData, chartEl, percent, customParamsData) {
            var barWidth = this.processWidth(percent),
                yAxisTick =  {
                    centered: true,
                    outer: false,
                    multiline: true
                },
                showLegend = false,
                groups = [],
                order = null,
                colorPattern = [],
                labels = [],
                title = '',
                tooltip = true,
                compare = false,
                roughData = {},
                self = this,
                showSubchart = false;

            if (typeof customParamsData !== 'undefined') {
                if(typeof customParamsData.showLegend !== 'undefined'){
                    showLegend = true;
                }

                if (typeof customParamsData.customYAxisFormat !== 'undefined') {
                    if (customParamsData.customYAxisFormat.type === 'currency') {
                        yAxisTick.format = function(d) { return customParamsData.customYAxisFormat.sign + d3.format(",")(d); }
                    }

                    if (customParamsData.customYAxisFormat.type === 'onlyInteger') {
                        yAxisTick.format = d3.format("d")
                    }
                }

                if (typeof customParamsData.groups !== 'undefined') {
                    groups = customParamsData.groups;
                }

                if (typeof customParamsData.colorPattern !== 'undefined') {
                    colorPattern = customParamsData.colorPattern;
                }

                if (typeof customParamsData.title !== 'undefined') {
                    title = customParamsData.title;
                }

                if (typeof customParamsData.labels !== 'undefined') {
                    if (typeof customParamsData.labels.type !== 'undefined' && customParamsData.labels.type === 'currency') {
                        labels = {
                            format: function (v, id, i, j) {
                                if (v !== 0) {
                                    return customParamsData.labels.sign + d3.format(",")(v);
                                }
                            }
                        }
                    } else {
                        labels = {
                            format: function (v, id, i, j) {
                                if (v !== 0) {
                                    return v;
                                }
                            }
                        }
                    }
                }

                if (typeof customParamsData.tooltip !== 'undefined') {
                    if (customParamsData.tooltip.compare !== 'undefined' && customParamsData.tooltip.compare === true) {
                        compare = true;
                    }

                    if (customParamsData.tooltip.roughData !== 'undefined') {
                        roughData = customParamsData.tooltip.roughData;
                    }

                    tooltip = {
                        format: {
                        },
                        contents: function (d, defaultTitleFormat, defaultValueFormat, color) {
                            var $$ = this, config = $$.config,
                                titleFormat = config.tooltip_format_title || defaultTitleFormat,
                                nameFormat = config.tooltip_format_name || function (name) { return name; },
                                valueFormat = config.tooltip_format_value || defaultValueFormat,
                                text, i, title, value, name, bgcolor,
                                dataParams = {},
                                usedParams = {},
                                textItemRow = '';

                            for (i = 0; i < d.length; i++) {
                                if (! (d[i] && (d[i].value || d[i].value === 0))) { continue; }
                                name = nameFormat(d[i].name);
                                value = valueFormat(d[i].value, d[i].ratio, d[i].id, d[i].index);
                                bgcolor = $$.levelColor ? $$.levelColor(d[i].value) : color(d[i].id);
                                title = titleFormat ? titleFormat(d[i].x) : d[i].x;
                                dataParams[name] = {'value' : value, 'bgcolor' : bgcolor, 'line': d[i].id};
                                if (!_.isEmpty(roughData)) {
                                    var roughDataItem = _.find(roughData, function(item) {
                                        if (name.match(/\*/) !== null && compare === true) {
                                            return (item.full_name == title && item.type == 'previous' && item.description == name.substring(1));
                                        } else {
                                            return (item.full_name == title && item.type == 'current' && item.description == name);
                                        }
                                    });

                                    dataParams[name].amount = accounting.formatMoney(Math.round(roughDataItem.amount), JSON.parse(self.LeadReportsCollection.moneyFormat));
                                    dataParams[name].count = roughDataItem.count;
                                } else {
                                    dataParams[name].amount = '';
                                    dataParams[name].count = '';
                                }

                            }

                            for (key in dataParams) {
                                if (!text) {
                                    text = "<table class='" + $$.CLASS.tooltip + "'>" + "<tr><th style='text-align: center'>" + title + "</th><th style='text-align: center'>"+customParamsData.tooltip.filterFromDate+"</th>";
                                    if (compare === true) {
                                        text += "<th style='text-align: center'>"+customParamsData.tooltip.filterToDate+"</th></tr>";
                                    }
                                }


                                if ((typeof usedParams[key] !== 'undefined' || typeof usedParams[key.substring(1)] !== 'undefined') && compare === true) {
                                    continue;
                                }

                                text += "<tr class='" + $$.CLASS.tooltipName + "-" + key + "'>";


                                if (key.match(/\*/) !== null) {
                                    text += "<td class='name'><span style='background-color:" + dataParams[key]['bgcolor'] + "'></span>" + key.substring(1)+"</td>";
                                } else {
                                    text += "<td class='name'><span style='background-color:" + dataParams[key]['bgcolor'] + "'></span>" + key+"</td>";
                                }

                                if (key.match(/\*/) !== null && compare === true) {
                                    if (typeof dataParams[key.substring(1)] !== 'undefined') {
                                        if (typeof dataParams[key.substring(1)]['count'] !== 'undefined' && dataParams[key.substring(1)]['count'] !== '') {
                                            textItemRow = dataParams[key.substring(1)]['value']  + ' ('+dataParams[key.substring(1)]['count']+')';
                                        } else {
                                            textItemRow = dataParams[key.substring(1)]['value'];
                                        }
                                        text += "<td  style='text-align:center;' class='value'>" + textItemRow + "</td>";

                                    } else {
                                        text += "<td  style='text-align:center;' class='value'>" + 0 + "</td>";
                                    }
                                    if (typeof dataParams[key]['count'] !== 'undefined' && dataParams[key]['count'] !== '') {
                                        textItemRow = dataParams[key]['value'] + ' ('+ dataParams[key]['count']+')';
                                    } else {
                                        textItemRow =  dataParams[key]['value'];
                                    }
                                    text += "<td  style='text-align:center;' class='value'>"+ textItemRow + "</td>";
                                } else if (compare === true){
                                    if (typeof dataParams[key]['count'] !== 'undefined' && dataParams[key]['count'] !== '') {
                                        textItemRow = dataParams[key]['value'] + ' ('+ dataParams[key]['count']+ ')';
                                    } else {
                                        textItemRow = dataParams[key]['value'];
                                    }
                                    text += "<td  style='text-align:center;'  class='value'>"+ textItemRow + "</td>";
                                    if (typeof dataParams['*'+key] !== 'undefined') {
                                        if (typeof dataParams['*'+key]['count'] !== 'undefined' && dataParams['*'+key]['count'] !== '') {
                                            textItemRow = dataParams['*'+key]['value'] + ' ('+ dataParams['*'+key]['count']+ ')';
                                        } else {
                                            textItemRow = dataParams['*'+key]['value'];
                                        }
                                        text += "<td  style='text-align:center;' class='value'>" + textItemRow + "</td>";
                                    } else {
                                        text += "<td  style='text-align:center;' class='value'>" + 0 + "</td>";
                                    }
                                } else {
                                    if (typeof dataParams[key]['count'] !== 'undefined' && dataParams[key]['count'] !== '') {
                                        textItemRow =  dataParams[key]['value'] + ' ('+dataParams[key]['count']+')';
                                    } else {
                                        textItemRow = dataParams[key]['value'];
                                    }
                                    text += "<td  style='text-align:center;' class='value'>" + textItemRow + "</td>";
                                }


                                text += "</tr>";

                                usedParams[key] = true;
                            }

                            return text + "</table>";
                        }
                    }
                }

                if (typeof customParamsData.greaterThanLimit !== 'undefined') {
                    showSubchart = customParamsData.greaterThanLimit;
                }
            }

            var chart = c3.generate({
                bindto: chartEl,
                size: {
                    width: barWidth,
                    height: barWidth/2.5
                },
                onresize: function(){
                    if (typeof window.device !== 'undefined') {
                        if (window.device.tablet() || window.device.mobile()) {
                            var koef = 1.1;
                            if (window.device.mobile()) {
                                if (!window.device.landscape()) {
                                    koef = 1.6;
                                }
                            }
                            chart.resize({
                                width: self.processWidth()/koef,
                                height: self.processWidth() / 2.5
                            });
                        }
                    } else {
                        chart.resize({
                            width: barWidth,
                            height: barWidth / 2.5
                        });
                    }
                },
                data: {
                    x: 'x',
                    columns:chartData,
                    type: 'bar',
                    labels: labels,
                    onclick: function () {
                        if (typeof customParamsData  !== 'undefined' &&  typeof customParamsData.axesAdditionalInfo !== 'undefined') {
                            var id = arguments[0]['id'],
                                axeXValue = arguments[0]['x'],
                                leadReportsCompare = 0,
                                leadReportsFilterStartDate = ($('#lead-reports-filter-start-date').val()) ? $.datepicker.formatDate('yy-mm-dd', $('#lead-reports-filter-start-date').datepicker("getDate")): '',
                                leadReportsFilterEndDate =  ($('#lead-reports-filter-end-date').val()) ? $.datepicker.formatDate('yy-mm-dd', $('#lead-reports-filter-end-date').datepicker("getDate")): '',
                                leadReportsCompareFilterStartDate = ($('#lead-reports-filter-compare-start-date').val()) ? $.datepicker.formatDate('yy-mm-dd', $('#lead-reports-filter-compare-start-date').datepicker("getDate")): '',
                                leadReportsCompareFilterEndDate = ($('#lead-reports-filter-compare-end-date').val()) ? $.datepicker.formatDate('yy-mm-dd', $('#lead-reports-filter-compare-end-date').datepicker("getDate")): '',
                                leadReportsFilterStartDateLabel = ($('#lead-reports-filter-start-date').val()) ? $.datepicker.formatDate('dd-M-yy', $('#lead-reports-filter-start-date').datepicker("getDate")): '',
                                leadReportsFilterEndDateLabel =  ($('#lead-reports-filter-end-date').val()) ? $.datepicker.formatDate('dd-M-yy', $('#lead-reports-filter-end-date').datepicker("getDate")): '',
                                leadReportsCompareFilterStartDateLabel = ($('#lead-reports-filter-compare-start-date').val()) ? $.datepicker.formatDate('dd-M-yy', $('#lead-reports-filter-compare-start-date').datepicker("getDate")): '',
                                leadReportsCompareFilterEndDateLabel = ($('#lead-reports-filter-compare-end-date').val()) ? $.datepicker.formatDate('dd-M-yy', $('#lead-reports-filter-compare-end-date').datepicker("getDate")): '',
                                filterFromDate = '',
                                filterToDate = '',

                                filterType = $(chartEl).data('lead-grid-filter-data-type'),
                                customTabUrl = $(chartEl).data('custom-tab-url'),
                                filterFromDateNameAlternative = $(chartEl).data('lead-grid-filter-from-date-name'),
                                filterToDateNameAlternative = $(chartEl).data('lead-grid-filter-to-date-name'),
                                predefinedFilterParams = $(chartEl).data('lead-grid-filter-predefined-params'),
                                filterTypeId = customParamsData.axesAdditionalInfo[axeXValue+1],
                                defaultFilterFromDateNameField = 'created_at_from',
                                defaultFilterToDateNameField = 'created_at_to',
                                additionalFilter = '',
                                rangeOptions = $('.rangeOptions').val(),
                                filterFromToDateDisabled = $(chartEl).data('lead-grid-filter-from-to-date-disabled');

                            if(typeof customParamsData.additionalFilterPreset !== 'undefined') {
                                additionalFilter = customParamsData.additionalFilterPreset[axeXValue+1];
                            }

                            if ($('#lead-reports-compare').is(':checked')) {
                                leadReportsCompare = 1;
                            }

                            if (typeof filterFromDateNameAlternative !== 'undefined' && filterFromDateNameAlternative !== '') {
                                defaultFilterFromDateNameField = filterFromDateNameAlternative;
                            }

                            if (typeof filterToDateNameAlternative !== 'undefined' && filterToDateNameAlternative !== '') {
                                defaultFilterToDateNameField = filterToDateNameAlternative;
                            }

                            console.log(axeXValue);
                            console.log(id);
                            if (leadReportsCompareFilterStartDateLabel == '') {
                                leadReportsCompareFilterStartDateLabel = $.datepicker.formatDate('dd-M-yy', new Date());
                            }

                            if (leadReportsCompareFilterEndDateLabel == '') {
                                leadReportsCompareFilterEndDateLabel = $.datepicker.formatDate('dd-M-yy', new Date());
                            }

                            var isComparisonRow = 0;
                            if (id.match(/\*/) !== null && leadReportsCompare  === 1) {
                                filterFromDate  = leadReportsCompareFilterStartDateLabel;
                                filterToDate  = leadReportsCompareFilterEndDateLabel;
                                console.log('comparison');
                                isComparisonRow = 1;
                            } else if(leadReportsCompare  === 1) {
                                var startEndDateLabel = leadReportsCompareFilterStartDateLabel + ' to '+ leadReportsCompareFilterEndDateLabel;
                                console.log(startEndDateLabel);
                                console.log(id);
                                if (startEndDateLabel == id) {
                                    filterFromDate  = leadReportsCompareFilterStartDateLabel;
                                    filterToDate  = leadReportsCompareFilterEndDateLabel;
                                    console.log('comparison');
                                    isComparisonRow = 1;
                                } else {
                                    filterFromDate  = leadReportsFilterStartDateLabel;
                                    filterToDate  = leadReportsFilterEndDateLabel;
                                    console.log('original');
                                }
                            }  else {
                                filterFromDate  = leadReportsFilterStartDateLabel;
                                filterToDate  = leadReportsFilterEndDateLabel;
                                console.log('original');
                            }

                            if (typeof filterType !== 'undefined' && filterType !== '') {
                                var additionalFilterParams = '';

                                if(typeof additionalFilter !== 'undefined') {
                                    additionalFilterParams = additionalFilter;
                                }

                                console.log(filterType);

                                var filterFinalUrl = $('#website_url').val() + 'dashboard/leads/?filter=1&'+defaultFilterFromDateNameField+'='+filterFromDate+'&'+defaultFilterToDateNameField+'='+filterToDate+'&'+filterType+'=' + filterTypeId + '&range_options=' + rangeOptions + additionalFilterParams;

                                if(typeof filterFromToDateDisabled !== 'undefined' && filterFromToDateDisabled == '1') {
                                    var nextSequenceFrom = 'next_sequence_from='+filterFromDate;
                                    var nextSequenceTo = 'next_sequence_to='+filterToDate;

                                    filterFinalUrl = $('#website_url').val() + 'dashboard/leads/?filter=1&'+filterType+'=' + filterTypeId + '&' + nextSequenceFrom + '&' + nextSequenceTo;
                                }

                                if (typeof predefinedFilterParams !== 'undefined' && predefinedFilterParams !== '') {
                                    filterFinalUrl = filterFinalUrl+'&'+predefinedFilterParams;
                                }

                                console.log(filterFinalUrl);
                                window.open(filterFinalUrl, '_blank');
                            }

                            console.log(filterTypeId);
                            console.log(filterFromDate);
                            console.log(filterToDate);
                            console.log(chartData);
                            console.log(chartEl);

                        }
                    }
                },
                // subchart: {
                //     show: showSubchart,
                //     axis:{
                //         x: {
                //             show:false
                //         }
                //     },
                //     size: {
                //         height: 30
                //     }
                // },
                color: {
                    pattern: colorPattern
                },
                axis: {
                    //rotated: true,
                    x: {
                        type: 'category',
                        show: true,
                        tick: {
                            centered: true,
                            multiline:true,
                            rotate: 75,
                            width: 150

                        }
                    },
                    y: {
                        show: true,
                        tick: {
                            format: function (d) {
                                return (parseInt(d) == d) ? d : null;
                            }
                        }
                    }
                },
                bar: {
                    width: {
                        ratio: 0.5
                    }
                },
                grid: {
                    x: {
                        show: true
                    }
                },
                legend: {
                    show: showLegend,
                    position: 'bottom'
                },
                tooltip: tooltip

            });

            $(chartEl).data('c3-chart', chart);
        },

    });

    return LeadReportsView;
});
